/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.client.model.monster;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import io.github.flemmli97.runecraftory.client.ClientHandlers;
import io.github.flemmli97.runecraftory.client.model.SittingModel;
import io.github.flemmli97.runecraftory.common.entities.BaseMonster;
import io.github.flemmli97.runecraftory.common.entities.monster.EntityBuffamoo;
import io.github.flemmli97.tenshilib.client.AnimationManager;
import io.github.flemmli97.tenshilib.client.model.BlockBenchAnimations;
import io.github.flemmli97.tenshilib.client.model.ExtendedModel;
import io.github.flemmli97.tenshilib.client.model.ModelPartHandler;
import io.github.flemmli97.tenshilib.client.model.RideableModel;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.IllagerModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;

public class ModelBuffamoo<T extends EntityBuffamoo>
extends EntityModel<T>
implements ExtendedModel,
RideableModel<T> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(new ResourceLocation("runecraftory", "buffamoo"), "main");
    protected final ModelPartHandler model;
    protected final BlockBenchAnimations anim;
    public ModelPartHandler.ModelPartExtended body;
    public ModelPartHandler.ModelPartExtended head;
    public ModelPartHandler.ModelPartExtended ridingPosition;

    public ModelBuffamoo(ModelPart root) {
        this.model = new ModelPartHandler(root, "root");
        this.anim = AnimationManager.getInstance().getAnimation(new ResourceLocation("runecraftory", "buffamoo"));
        this.body = this.model.getPart("body");
        this.head = this.model.getPart("head");
        this.ridingPosition = this.model.getPart("ridingPos");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition body = partdefinition.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-6.0f, -3.0f, -7.0f, 12.0f, 13.0f, 20.0f, new CubeDeformation(0.0f)).m_171514_(64, 0).m_171488_(-1.5f, -3.5f, -6.0f, 3.0f, 1.0f, 16.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)4.0f, (float)-1.0f));
        PartDefinition head = body.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(0, 33).m_171488_(-5.5f, -4.0f, -4.0f, 11.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)-6.0f));
        PartDefinition headFront = head.m_171599_("headFront", CubeListBuilder.m_171558_().m_171514_(58, 33).m_171488_(-5.0f, -3.5f, -2.0f, 10.0f, 11.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(30, 33).m_171488_(-4.0f, -3.0f, -8.0f, 8.0f, 10.0f, 6.0f, new CubeDeformation(0.0f)).m_171514_(16, 69).m_171488_(-3.0f, 3.0f, -10.0f, 6.0f, 4.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)-3.0f));
        PartDefinition hornLeft = head.m_171599_("hornLeft", CubeListBuilder.m_171558_().m_171514_(32, 69).m_171488_(0.2588f, -2.9659f, -0.5f, 4.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)4.0f, (float)0.0f, (float)-4.75f, (float)0.0f, (float)0.0f, (float)-0.2618f));
        PartDefinition hornLeftTip = hornLeft.m_171599_("hornLeftTip", CubeListBuilder.m_171558_().m_171514_(32, 73).m_171488_(0.9397f, -2.342f, -1.0f, 5.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)4.0f, (float)0.0f, (float)1.0f, (float)0.0f, (float)0.0f, (float)-0.9599f));
        PartDefinition hornRight = head.m_171599_("hornRight", CubeListBuilder.m_171558_().m_171514_(32, 69).m_171480_().m_171488_(-4.2588f, -2.9659f, -0.5f, 4.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)-4.0f, (float)0.0f, (float)-4.75f, (float)0.0f, (float)0.0f, (float)0.2618f));
        PartDefinition hornRight2 = hornRight.m_171599_("hornRight2", CubeListBuilder.m_171558_().m_171514_(32, 73).m_171480_().m_171488_(-5.9397f, -2.342f, 0.0f, 5.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)-4.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.9599f));
        PartDefinition udder = body.m_171599_("udder", CubeListBuilder.m_171558_().m_171514_(0, 49).m_171488_(-2.0f, -19.0f, -4.0f, 4.0f, 1.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)29.0f, (float)10.0f));
        PartDefinition frontLegLeftUp = body.m_171599_("frontLegLeftUp", CubeListBuilder.m_171558_().m_171514_(0, 69).m_171488_(-2.0f, -1.0f, -2.0f, 4.0f, 5.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)3.9f, (float)10.0f, (float)-4.0f));
        PartDefinition frontLegLeftDown = frontLegLeftUp.m_171599_("frontLegLeftDown", CubeListBuilder.m_171558_().m_171514_(0, 59).m_171488_(-2.0f, 0.0f, 0.0f, 4.0f, 6.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)4.0f, (float)-2.0f));
        PartDefinition frontLegRightUp = body.m_171599_("frontLegRightUp", CubeListBuilder.m_171558_().m_171514_(48, 59).m_171488_(-2.0f, -1.0f, -2.0f, 4.0f, 5.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-3.9f, (float)10.0f, (float)-4.0f));
        PartDefinition frontLegRightDown = frontLegRightUp.m_171599_("frontLegRightDown", CubeListBuilder.m_171558_().m_171514_(52, 49).m_171488_(-2.0f, 0.0f, 0.0f, 4.0f, 6.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)4.0f, (float)-2.0f));
        PartDefinition backLegLeftUp = body.m_171599_("backLegLeftUp", CubeListBuilder.m_171558_().m_171514_(32, 59).m_171488_(-2.0f, -1.0f, -2.0f, 4.0f, 5.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)3.9f, (float)10.0f, (float)9.0f));
        PartDefinition backLegLeftDown = backLegLeftUp.m_171599_("backLegLeftDown", CubeListBuilder.m_171558_().m_171514_(36, 49).m_171488_(-2.0f, 0.0f, 0.0f, 4.0f, 6.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)4.0f, (float)-2.0f));
        PartDefinition backLegRightUp = body.m_171599_("backLegRightUp", CubeListBuilder.m_171558_().m_171514_(16, 59).m_171488_(-2.0f, -1.0f, -2.0f, 4.0f, 5.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-3.9f, (float)10.0f, (float)9.0f));
        PartDefinition backLegRightDown = backLegRightUp.m_171599_("backLegRightDown", CubeListBuilder.m_171558_().m_171514_(20, 49).m_171488_(-2.0f, 0.0f, 0.0f, 4.0f, 6.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)4.0f, (float)-2.0f));
        PartDefinition tail = body.m_171599_("tail", CubeListBuilder.m_171558_().m_171514_(4, 78).m_171488_(-0.5f, 0.0f, 0.0f, 1.0f, 4.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)12.0f, (float)0.7854f, (float)0.0f, (float)0.0f));
        PartDefinition tail2 = tail.m_171599_("tail2", CubeListBuilder.m_171558_().m_171514_(0, 78).m_171488_(-0.5f, -0.3f, -0.5f, 1.0f, 4.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)4.0f, (float)0.5f, (float)-0.1745f, (float)0.0f, (float)0.0f));
        PartDefinition tail3 = tail2.m_171599_("tail3", CubeListBuilder.m_171558_().m_171514_(52, 69).m_171488_(-0.5f, -0.3f, -0.5f, 1.0f, 5.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)3.7f, (float)0.0f, (float)-0.5236f, (float)0.0f, (float)0.0f));
        PartDefinition tailTip = tail3.m_171599_("tailTip", CubeListBuilder.m_171558_().m_171514_(44, 69).m_171488_(-1.0f, -0.2f, -1.0f, 2.0f, 3.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)4.3f, (float)0.0f));
        PartDefinition ridingPos = body.m_171599_("ridingPos", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)-3.0f, (float)3.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)128, (int)128);
    }

    public void m_7695_(PoseStack poseStack, VertexConsumer buffer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.model.getMainPart().render(poseStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.model.resetPoses();
        this.head.yRot += netHeadYaw % 360.0f * ((float)Math.PI / 180) * 0.5f;
        this.head.xRot += headPitch * ((float)Math.PI / 180) * 0.5f;
        float partialTicks = ClientHandlers.getPartialTicks();
        if (((EntityBuffamoo)entity).f_20919_ <= 0 && !((BaseMonster)entity).playDeath()) {
            this.anim.doAnimation((ExtendedModel)this, "idle", ((EntityBuffamoo)entity).f_19797_, partialTicks);
            if (((BaseMonster)entity).moveTick() > 0) {
                this.anim.doAnimation((ExtendedModel)this, "walk", ((EntityBuffamoo)entity).f_19797_, partialTicks, ((BaseMonster)entity).interpolatedMoveTick(partialTicks));
            }
        }
        this.anim.doAnimation((ExtendedModel)this, ((EntityBuffamoo)entity).getAnimationHandler(), partialTicks);
    }

    public ModelPartHandler getHandler() {
        return this.model;
    }

    public boolean transform(T entity, EntityRenderer<T> entityRenderer, Entity rider, EntityRenderer<?> ridingEntityRenderer, PoseStack poseStack, int riderNum) {
        LivingEntityRenderer lR;
        EntityModel model;
        if (ridingEntityRenderer instanceof LivingEntityRenderer && ((model = (lR = (LivingEntityRenderer)ridingEntityRenderer).m_7200_()) instanceof HumanoidModel || model instanceof IllagerModel || model instanceof SittingModel)) {
            this.body.translateAndRotate(poseStack);
            this.ridingPosition.translateAndRotate(poseStack);
            ClientHandlers.translateRider(entityRenderer, rider, model, poseStack);
            return true;
        }
        return false;
    }
}

