/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.client.model.monster;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import io.github.flemmli97.runecraftory.client.ClientHandlers;
import io.github.flemmli97.runecraftory.client.model.SittingModel;
import io.github.flemmli97.runecraftory.common.entities.BaseMonster;
import io.github.flemmli97.runecraftory.common.entities.monster.boss.EntityChimera;
import io.github.flemmli97.tenshilib.client.AnimationManager;
import io.github.flemmli97.tenshilib.client.model.BlockBenchAnimations;
import io.github.flemmli97.tenshilib.client.model.ExtendedModel;
import io.github.flemmli97.tenshilib.client.model.ModelPartHandler;
import io.github.flemmli97.tenshilib.client.model.RideableModel;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.IllagerModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;

public class ModelChimera<T extends EntityChimera>
extends EntityModel<T>
implements ExtendedModel,
RideableModel<T> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(new ResourceLocation("runecraftory", "chimera"), "main");
    protected final ModelPartHandler model;
    protected final BlockBenchAnimations anim;
    public ModelPartHandler.ModelPartExtended body;
    public ModelPartHandler.ModelPartExtended upperBody;
    public ModelPartHandler.ModelPartExtended ridingPosition;

    public ModelChimera(ModelPart root) {
        this.model = new ModelPartHandler(root, "root");
        this.anim = AnimationManager.getInstance().getAnimation(new ResourceLocation("runecraftory", "chimera"));
        this.body = this.model.getPart("body");
        this.upperBody = this.model.getPart("upperBody");
        this.ridingPosition = this.model.getPart("ridingPos");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition body = partdefinition.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-6.5f, -7.0f, -7.0f, 13.0f, 12.0f, 18.0f, new CubeDeformation(0.0f)).m_171514_(56, 52).m_171488_(-1.0f, -8.0f, -7.0f, 2.0f, 1.0f, 10.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)8.25f, (float)0.0f));
        PartDefinition wingLeftBase = body.m_171599_("wingLeftBase", CubeListBuilder.m_171558_().m_171514_(8, 0).m_171488_(0.0f, 0.0f, -3.5f, 2.0f, 0.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)6.5f, (float)-6.0f, (float)0.5f));
        PartDefinition wingLeft = wingLeftBase.m_171599_("wingLeft", CubeListBuilder.m_171558_().m_171514_(0, 30).m_171488_(0.0f, 0.0f, -3.0f, 18.0f, 0.0f, 15.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)2.0f, (float)0.0f, (float)-3.5f));
        PartDefinition wingRightBase = body.m_171599_("wingRightBase", CubeListBuilder.m_171558_().m_171514_(8, 0).m_171480_().m_171488_(-2.0f, 0.0f, -3.5f, 2.0f, 0.0f, 5.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)-6.5f, (float)-6.0f, (float)0.5f));
        PartDefinition wingRight = wingRightBase.m_171599_("wingRight", CubeListBuilder.m_171558_().m_171514_(29, 0).m_171488_(-18.0f, 0.0f, -3.0f, 18.0f, 0.0f, 15.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-2.0f, (float)0.0f, (float)-3.5f));
        PartDefinition upperBody = body.m_171599_("upperBody", CubeListBuilder.m_171558_().m_171514_(0, 45).m_171488_(-5.5f, -5.0f, -5.0f, 12.0f, 12.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-0.5f, (float)-4.0f, (float)-7.0f));
        PartDefinition hornMiddleLeft = upperBody.m_171599_("hornMiddleLeft", CubeListBuilder.m_171558_().m_171514_(51, 63).m_171488_(-1.0f, -4.0f, -2.0f, 2.0f, 4.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)4.5f, (float)-4.5f, (float)-2.75f, (float)0.0f, (float)0.0f, (float)0.5236f));
        PartDefinition hornBackLeft = upperBody.m_171599_("hornBackLeft", CubeListBuilder.m_171558_().m_171514_(80, 0).m_171488_(-1.0f, -3.0f, -1.0f, 2.0f, 5.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)4.5f, (float)-5.0f, (float)0.0f, (float)-0.2618f, (float)0.0f, (float)0.0f));
        PartDefinition hornMiddleRight = upperBody.m_171599_("hornMiddleRight", CubeListBuilder.m_171558_().m_171514_(51, 39).m_171488_(-1.0f, -4.0f, -2.0f, 2.0f, 4.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-3.5f, (float)-4.5f, (float)-2.75f, (float)0.0f, (float)0.0f, (float)-0.5236f));
        PartDefinition hornBackRight = upperBody.m_171599_("hornBackRight", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)-3.5f, (float)-5.0f, (float)0.0f));
        PartDefinition hornBackRight_r1 = hornBackRight.m_171599_("hornBackRight_r1", CubeListBuilder.m_171558_().m_171514_(78, 74).m_171488_(-1.0f, -5.0f, 0.0f, 2.0f, 5.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)2.0f, (float)-1.0f, (float)-0.2618f, (float)0.0f, (float)0.0f));
        PartDefinition head = upperBody.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(34, 45).m_171488_(-4.5f, -4.0f, -6.0f, 10.0f, 11.0f, 6.0f, new CubeDeformation(0.0f)).m_171514_(51, 30).m_171488_(-5.5f, -4.75f, -4.5f, 12.0f, 5.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.75f, (float)-4.5f));
        PartDefinition hornFront = head.m_171599_("hornFront", CubeListBuilder.m_171558_().m_171514_(62, 22).m_171488_(-1.0f, -6.0f, -2.0f, 2.0f, 6.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.5f, (float)-5.0f, (float)-1.0f, (float)0.6981f, (float)0.0f, (float)0.0f));
        PartDefinition snout = head.m_171599_("snout", CubeListBuilder.m_171558_().m_171514_(70, 53).m_171488_(-2.5f, -2.5f, -3.0f, 6.0f, 4.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)3.5f, (float)-6.0f));
        PartDefinition mouth = snout.m_171599_("mouth", CubeListBuilder.m_171558_().m_171514_(71, 63).m_171488_(-2.5f, 0.0f, -3.0f, 6.0f, 1.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)1.5f, (float)0.0f, (float)0.5236f, (float)0.0f, (float)0.0f));
        PartDefinition tongue = mouth.m_171599_("tongue", CubeListBuilder.m_171558_().m_171514_(0, 12).m_171488_(-2.0f, 0.0f, -5.5f, 4.0f, 0.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.5f, (float)-0.025f, (float)0.5f));
        PartDefinition tail = body.m_171599_("tail", CubeListBuilder.m_171558_().m_171514_(58, 63).m_171488_(-1.5f, -2.5f, 0.0f, 3.0f, 3.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-0.5f, (float)-2.5f, (float)10.5f));
        PartDefinition tail2 = tail.m_171599_("tail2", CubeListBuilder.m_171558_().m_171514_(38, 62).m_171488_(-1.5f, -1.5f, 0.0f, 3.0f, 3.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-1.0f, (float)7.0f));
        PartDefinition tailTip = tail2.m_171599_("tailTip", CubeListBuilder.m_171558_().m_171514_(18, 62).m_171488_(-2.5f, -2.5f, -0.5f, 5.0f, 5.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)7.0f));
        PartDefinition tailWingLeft = tailTip.m_171599_("tailWingLeft", CubeListBuilder.m_171558_().m_171514_(55, 15).m_171488_(0.0f, 0.0f, -3.5f, 7.0f, 0.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)2.25f, (float)-0.5f, (float)2.0f));
        PartDefinition tailWingRight = tailTip.m_171599_("tailWingRight", CubeListBuilder.m_171558_().m_171514_(53, 39).m_171488_(-7.0f, 0.0f, -3.5f, 7.0f, 0.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-2.25f, (float)-0.5f, (float)2.0f));
        PartDefinition leftFrontLegBase = body.m_171599_("leftFrontLegBase", CubeListBuilder.m_171558_().m_171514_(14, 72).m_171488_(-1.5f, 0.0f, -2.5f, 4.0f, 7.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)2.5f, (float)4.0f, (float)-4.5f, (float)0.4363f, (float)0.0f, (float)0.0f));
        PartDefinition leftFrontLeg = leftFrontLegBase.m_171599_("leftFrontLeg", CubeListBuilder.m_171558_().m_171514_(62, 73).m_171488_(-1.5f, 0.0f, -2.0f, 4.0f, 6.0f, 4.0f, new CubeDeformation(-0.001f)), PartPose.m_171423_((float)0.0f, (float)6.0f, (float)0.0f, (float)-0.7418f, (float)0.0f, (float)0.0f));
        PartDefinition leftFrontPaw = leftFrontLeg.m_171599_("leftFrontPaw", CubeListBuilder.m_171558_().m_171514_(78, 67).m_171488_(-3.0f, 0.0f, -2.0f, 4.0f, 5.0f, 2.0f, new CubeDeformation(-0.001f)), PartPose.m_171423_((float)1.5f, (float)6.0f, (float)2.0f, (float)-1.2654f, (float)0.0f, (float)0.0f));
        PartDefinition rightFrontLegBase = body.m_171599_("rightFrontLegBase", CubeListBuilder.m_171558_().m_171514_(70, 42).m_171488_(-1.5f, 0.0f, -2.5f, 4.0f, 7.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-3.5f, (float)4.0f, (float)-4.5f, (float)0.4363f, (float)0.0f, (float)0.0f));
        PartDefinition rightFrontLeg = rightFrontLegBase.m_171599_("rightFrontLeg", CubeListBuilder.m_171558_().m_171514_(46, 72).m_171488_(-1.25f, 0.0f, -2.0f, 4.0f, 6.0f, 4.0f, new CubeDeformation(-0.001f)), PartPose.m_171423_((float)-0.25f, (float)6.0f, (float)0.0f, (float)-0.7418f, (float)0.0f, (float)0.0f));
        PartDefinition rightFrontPaw = rightFrontLeg.m_171599_("rightFrontPaw", CubeListBuilder.m_171558_().m_171514_(0, 74).m_171488_(-3.0f, 0.0f, -2.0f, 4.0f, 5.0f, 2.0f, new CubeDeformation(-0.001f)), PartPose.m_171423_((float)1.75f, (float)6.0f, (float)2.0f, (float)-1.2654f, (float)0.0f, (float)0.0f));
        PartDefinition leftHindLegBase = body.m_171599_("leftHindLegBase", CubeListBuilder.m_171558_().m_171514_(0, 62).m_171488_(-1.5f, 0.0f, -3.0f, 4.0f, 7.0f, 5.0f, new CubeDeformation(0.025f)), PartPose.m_171423_((float)2.5f, (float)3.25f, (float)6.0f, (float)0.4363f, (float)0.0f, (float)0.0f));
        PartDefinition leftHindLeg = leftHindLegBase.m_171599_("leftHindLeg", CubeListBuilder.m_171558_().m_171514_(30, 72).m_171488_(-1.5f, 0.0f, -3.0f, 4.0f, 6.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)6.5f, (float)1.0f, (float)-0.7418f, (float)0.0f, (float)0.0f));
        PartDefinition leftHindPaw = leftHindLeg.m_171599_("leftHindPaw", CubeListBuilder.m_171558_().m_171514_(0, 37).m_171488_(-3.0f, 0.0f, -3.0f, 4.0f, 4.0f, 3.0f, new CubeDeformation(-0.025f)), PartPose.m_171423_((float)1.5f, (float)7.0f, (float)1.0f, (float)-1.2654f, (float)0.0f, (float)0.0f));
        PartDefinition rightHindLegBase = body.m_171599_("rightHindLegBase", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-1.5f, 0.0f, -3.0f, 4.0f, 7.0f, 5.0f, new CubeDeformation(0.025f)), PartPose.m_171423_((float)-3.5f, (float)3.25f, (float)6.0f, (float)0.4363f, (float)0.0f, (float)0.0f));
        PartDefinition rightHindLeg = rightHindLegBase.m_171599_("rightHindLeg", CubeListBuilder.m_171558_().m_171514_(72, 18).m_171488_(-1.5f, 0.0f, -3.0f, 4.0f, 6.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)6.5f, (float)1.0f, (float)-0.7418f, (float)0.0f, (float)0.0f));
        PartDefinition rightHindPaw = rightHindLeg.m_171599_("rightHindPaw", CubeListBuilder.m_171558_().m_171514_(0, 30).m_171488_(-3.0f, 0.0f, -3.0f, 4.0f, 4.0f, 3.0f, new CubeDeformation(-0.025f)), PartPose.m_171423_((float)1.5f, (float)7.0f, (float)1.0f, (float)-1.2654f, (float)0.0f, (float)0.0f));
        PartDefinition ridingPos = body.m_171599_("ridingPos", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)-7.0f, (float)5.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)128, (int)128);
    }

    public void m_7695_(PoseStack poseStack, VertexConsumer buffer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.model.getMainPart().render(poseStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.model.resetPoses();
        float partialTicks = ClientHandlers.getPartialTicks();
        if (((EntityChimera)entity).f_20919_ <= 0 && !((BaseMonster)entity).playDeath()) {
            this.upperBody.yRot = (float)((double)this.upperBody.yRot + (double)(netHeadYaw % 360.0f * ((float)Math.PI / 180)) * 0.8);
            this.upperBody.xRot += headPitch * ((float)Math.PI / 180);
            this.anim.doAnimation((ExtendedModel)this, "idle", ((EntityChimera)entity).f_19797_, partialTicks);
            if (((BaseMonster)entity).moveTick() > 0) {
                if (((BaseMonster)entity).getMoveFlag() == BaseMonster.MoveType.RUN) {
                    this.anim.doAnimation((ExtendedModel)this, "run", ((EntityChimera)entity).f_19797_, partialTicks, ((BaseMonster)entity).interpolatedMoveTick(partialTicks));
                } else {
                    this.anim.doAnimation((ExtendedModel)this, "walk", ((EntityChimera)entity).f_19797_, partialTicks, ((BaseMonster)entity).interpolatedMoveTick(partialTicks));
                }
            }
        }
        this.anim.doAnimation((ExtendedModel)this, ((EntityChimera)entity).getAnimationHandler(), partialTicks);
    }

    public ModelPartHandler getHandler() {
        return this.model;
    }

    public boolean transform(T entity, EntityRenderer<T> entityRenderer, Entity rider, EntityRenderer<?> ridingEntityRenderer, PoseStack poseStack, int riderNum) {
        LivingEntityRenderer lR;
        EntityModel model;
        if (ridingEntityRenderer instanceof LivingEntityRenderer && ((model = (lR = (LivingEntityRenderer)ridingEntityRenderer).m_7200_()) instanceof HumanoidModel || model instanceof IllagerModel || model instanceof SittingModel)) {
            this.body.translateAndRotate(poseStack);
            this.ridingPosition.translateAndRotate(poseStack);
            ClientHandlers.translateRider(entityRenderer, rider, model, poseStack);
            return true;
        }
        return false;
    }
}

