/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.client.model.monster;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import io.github.flemmli97.runecraftory.client.ClientHandlers;
import io.github.flemmli97.runecraftory.client.model.SittingModel;
import io.github.flemmli97.runecraftory.common.entities.BaseMonster;
import io.github.flemmli97.runecraftory.common.entities.monster.EntityChipsqueek;
import io.github.flemmli97.tenshilib.client.AnimationManager;
import io.github.flemmli97.tenshilib.client.model.BlockBenchAnimations;
import io.github.flemmli97.tenshilib.client.model.ExtendedModel;
import io.github.flemmli97.tenshilib.client.model.ModelPartHandler;
import io.github.flemmli97.tenshilib.client.model.RideableModel;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.IllagerModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;

public class ModelChipsqueek<T extends EntityChipsqueek>
extends EntityModel<T>
implements ExtendedModel,
RideableModel<T> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(new ResourceLocation("runecraftory", "chipsqueek"), "main");
    protected final ModelPartHandler model;
    protected final BlockBenchAnimations anim;
    public ModelPartHandler.ModelPartExtended body;
    public ModelPartHandler.ModelPartExtended head;
    public ModelPartHandler.ModelPartExtended ridingPosition;

    public ModelChipsqueek(ModelPart root) {
        this.model = new ModelPartHandler(root, "root");
        this.anim = AnimationManager.getInstance().getAnimation(new ResourceLocation("runecraftory", "chipsqueek"));
        this.body = this.model.getPart("body");
        this.head = this.model.getPart("head");
        this.ridingPosition = this.model.getPart("ridingPos");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition body = partdefinition.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(0, 12).m_171488_(-3.5f, -4.0f, -4.5f, 7.0f, 7.0f, 9.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)16.8f, (float)1.5f, (float)-0.5236f, (float)0.0f, (float)0.0f));
        PartDefinition head = body.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-3.0f, -4.0f, -5.5f, 6.0f, 6.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-2.5f, (float)-4.0f, (float)0.6109f, (float)0.0f, (float)0.0f));
        PartDefinition earLeft = head.m_171599_("earLeft", CubeListBuilder.m_171558_().m_171514_(24, 0).m_171488_(-0.5f, -3.5f, -0.5f, 1.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)1.5f, (float)-2.5f, (float)-2.0f));
        PartDefinition earRight = head.m_171599_("earRight", CubeListBuilder.m_171558_().m_171514_(24, 0).m_171480_().m_171488_(-0.5f, -3.5f, -0.5f, 1.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)-1.5f, (float)-2.5f, (float)-2.0f));
        PartDefinition tail = body.m_171599_("tail", CubeListBuilder.m_171558_().m_171514_(32, 0).m_171488_(-2.5f, -10.5f, 0.0f, 5.0f, 12.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-1.0f, (float)4.5f, (float)-0.1745f, (float)0.0f, (float)0.0f));
        PartDefinition armLeft = body.m_171599_("armLeft", CubeListBuilder.m_171558_().m_171514_(32, 14).m_171488_(-0.5f, 0.0f, -1.0f, 1.0f, 3.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)3.5f, (float)0.5f, (float)-2.5f, (float)0.0f, (float)0.0f, (float)0.1745f));
        PartDefinition armLeftDown = armLeft.m_171599_("armLeftDown", CubeListBuilder.m_171558_().m_171514_(32, 20).m_171488_(-0.5f, 0.5f, -2.0f, 1.0f, 3.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)2.5f, (float)1.0f, (float)0.0f, (float)0.0f, (float)0.5236f));
        PartDefinition armRight = body.m_171599_("armRight", CubeListBuilder.m_171558_().m_171514_(32, 14).m_171480_().m_171488_(-0.5f, 0.0f, -1.0f, 1.0f, 3.0f, 2.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)-3.5f, (float)0.5f, (float)-2.5f, (float)0.0f, (float)0.0f, (float)-0.1745f));
        PartDefinition armRightDown = armRight.m_171599_("armRightDown", CubeListBuilder.m_171558_().m_171514_(32, 20).m_171480_().m_171488_(-0.5f, 0.5f, -2.0f, 1.0f, 3.0f, 2.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)0.0f, (float)2.5f, (float)1.0f, (float)0.0f, (float)0.0f, (float)-0.5236f));
        PartDefinition legLeftBase = body.m_171599_("legLeftBase", CubeListBuilder.m_171558_().m_171514_(46, 0).m_171488_(0.0f, -1.75f, -1.25f, 2.0f, 4.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)2.0f, (float)1.75f, (float)2.75f, (float)0.5236f, (float)0.0f, (float)0.0f));
        PartDefinition legLeft = legLeftBase.m_171599_("legLeft", CubeListBuilder.m_171558_().m_171514_(46, 7).m_171488_(-1.0f, -0.5f, -2.0f, 2.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)1.0f, (float)2.75f, (float)1.75f));
        PartDefinition feetLeft = legLeft.m_171599_("feetLeft", CubeListBuilder.m_171558_().m_171514_(46, 11).m_171488_(-1.0f, -0.5f, -1.0f, 2.0f, 0.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)2.0f, (float)-2.0f));
        PartDefinition legRightBase = body.m_171599_("legRightBase", CubeListBuilder.m_171558_().m_171514_(46, 0).m_171480_().m_171488_(0.0f, -1.75f, -1.25f, 2.0f, 4.0f, 3.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)-4.0f, (float)1.75f, (float)2.75f, (float)0.5236f, (float)0.0f, (float)0.0f));
        PartDefinition legRight = legRightBase.m_171599_("legRight", CubeListBuilder.m_171558_().m_171514_(46, 7).m_171480_().m_171488_(-1.0f, -0.5f, -2.0f, 2.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)1.0f, (float)2.75f, (float)1.75f));
        PartDefinition feetRight = legRight.m_171599_("feetRight", CubeListBuilder.m_171558_().m_171514_(46, 11).m_171488_(-1.0f, -0.5f, -1.0f, 2.0f, 0.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)2.0f, (float)-2.0f));
        PartDefinition ridingPos = body.m_171599_("ridingPos", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)-4.0f, (float)2.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)64, (int)28);
    }

    public void m_7695_(PoseStack poseStack, VertexConsumer buffer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.model.getMainPart().render(poseStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.model.resetPoses();
        this.head.yRot += netHeadYaw % 360.0f * ((float)Math.PI / 180) * 0.5f;
        this.head.xRot += headPitch * ((float)Math.PI / 180) * 0.5f;
        float partialTicks = ClientHandlers.getPartialTicks();
        if (((EntityChipsqueek)entity).f_20919_ <= 0 && !((BaseMonster)entity).playDeath()) {
            this.anim.doAnimation((ExtendedModel)this, "idle", ((EntityChipsqueek)entity).f_19797_, partialTicks);
            if (((BaseMonster)entity).moveTick() > 0) {
                this.anim.doAnimation((ExtendedModel)this, "walk", ((EntityChipsqueek)entity).f_19797_, partialTicks, ((BaseMonster)entity).interpolatedMoveTick(partialTicks));
            }
            if (((BaseMonster)entity).moveTick() < 1) {
                float lerp = Mth.m_14036_((float)(((float)((BaseMonster)entity).moveTick() + (((BaseMonster)entity).getMoveFlag() != BaseMonster.MoveType.NONE ? partialTicks : -partialTicks)) / 3.0f), (float)0.0f, (float)1.0f);
                this.ridingPosition.xRot = (1.0f - lerp) * 20.0f * ((float)Math.PI / 180);
            }
        }
        this.anim.doAnimation((ExtendedModel)this, ((EntityChipsqueek)entity).getAnimationHandler(), partialTicks);
    }

    public ModelPartHandler getHandler() {
        return this.model;
    }

    public boolean transform(T entity, EntityRenderer<T> entityRenderer, Entity rider, EntityRenderer<?> ridingEntityRenderer, PoseStack poseStack, int riderNum) {
        LivingEntityRenderer lR;
        EntityModel model;
        if (ridingEntityRenderer instanceof LivingEntityRenderer && ((model = (lR = (LivingEntityRenderer)ridingEntityRenderer).m_7200_()) instanceof HumanoidModel || model instanceof IllagerModel || model instanceof SittingModel)) {
            this.body.translateAndRotate(poseStack);
            this.ridingPosition.translateAndRotate(poseStack);
            ClientHandlers.translateRider(entityRenderer, rider, model, poseStack);
            return true;
        }
        return false;
    }
}

