/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.client.model.monster;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import io.github.flemmli97.runecraftory.client.ClientHandlers;
import io.github.flemmli97.runecraftory.client.model.SittingModel;
import io.github.flemmli97.runecraftory.common.entities.BaseMonster;
import io.github.flemmli97.runecraftory.common.entities.monster.EntityCluckadoodle;
import io.github.flemmli97.tenshilib.client.AnimationManager;
import io.github.flemmli97.tenshilib.client.model.BlockBenchAnimations;
import io.github.flemmli97.tenshilib.client.model.ExtendedModel;
import io.github.flemmli97.tenshilib.client.model.ModelPartHandler;
import io.github.flemmli97.tenshilib.client.model.RideableModel;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.IllagerModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;

public class ModelCluckadoodle<T extends EntityCluckadoodle>
extends EntityModel<T>
implements ExtendedModel,
RideableModel<T> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(new ResourceLocation("runecraftory", "cluckadoodle"), "main");
    protected final ModelPartHandler model;
    protected final BlockBenchAnimations anim;
    public ModelPartHandler.ModelPartExtended body;
    public ModelPartHandler.ModelPartExtended head;
    public ModelPartHandler.ModelPartExtended neck;
    public ModelPartHandler.ModelPartExtended ridingPosition;

    public ModelCluckadoodle(ModelPart root) {
        this.model = new ModelPartHandler(root, "root");
        this.anim = AnimationManager.getInstance().getAnimation(new ResourceLocation("runecraftory", "cluckadoodle"));
        this.body = this.model.getPart("body");
        this.head = this.model.getPart("head");
        this.neck = this.model.getPart("neck");
        this.ridingPosition = this.model.getPart("ridingPos");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition body = partdefinition.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(32, 15).m_171488_(-3.5f, -3.5f, -4.0f, 7.0f, 7.0f, 10.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)15.5f, (float)0.0f));
        PartDefinition neck = body.m_171599_("neck", CubeListBuilder.m_171558_().m_171514_(0, 16).m_171488_(-2.0f, 0.0f, -1.0f, 4.0f, 3.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-2.5f, (float)-4.0f));
        PartDefinition head = neck.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-2.0f, -6.0f, -2.0f, 4.0f, 6.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition comb = head.m_171599_("comb", CubeListBuilder.m_171558_().m_171514_(20, 11).m_171488_(0.0f, -21.0f, -7.0f, 0.0f, 7.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)9.0f, (float)4.0f));
        PartDefinition beak = head.m_171599_("beak", CubeListBuilder.m_171558_().m_171514_(12, 14).m_171488_(-1.0f, -4.0f, -4.0f, 2.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)).m_171514_(12, 18).m_171488_(-1.0f, -3.5f, -4.5f, 2.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition backFeathersLeft = body.m_171599_("backFeathersLeft", CubeListBuilder.m_171558_().m_171514_(0, 21).m_171488_(0.0f, -8.5f, 0.0f, 6.0f, 9.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-3.0f, (float)5.0f, (float)-0.4363f, (float)-0.0873f, (float)1.1345f));
        PartDefinition backFeathersLeftUp = backFeathersLeft.m_171599_("backFeathersLeftUp", CubeListBuilder.m_171558_().m_171514_(12, 21).m_171488_(0.0f, -10.5f, 0.0f, 6.0f, 11.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)-0.1745f, (float)0.0f, (float)-1.0472f));
        PartDefinition backFeathersRight = body.m_171599_("backFeathersRight", CubeListBuilder.m_171558_().m_171514_(0, 21).m_171480_().m_171488_(-6.0f, -9.5f, 0.0f, 6.0f, 10.0f, 0.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)0.0f, (float)-3.0f, (float)5.0f, (float)-0.4363f, (float)0.0873f, (float)-1.1345f));
        PartDefinition backFeathersRightUp = backFeathersRight.m_171599_("backFeathersRightUp", CubeListBuilder.m_171558_().m_171514_(12, 21).m_171480_().m_171488_(-6.0f, -10.5f, 0.0f, 6.0f, 11.0f, 0.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)-0.1745f, (float)0.0f, (float)1.0472f));
        PartDefinition legLeft = body.m_171599_("legLeft", CubeListBuilder.m_171558_().m_171514_(26, 0).m_171488_(-0.5f, -1.0f, -0.5f, 1.0f, 6.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(26, 7).m_171488_(-1.5f, 5.0f, -2.5f, 3.0f, 0.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)1.5f, (float)3.5f, (float)0.5f));
        PartDefinition legRight = body.m_171599_("legRight", CubeListBuilder.m_171558_().m_171514_(26, 0).m_171488_(-0.5f, -1.0f, -0.5f, 1.0f, 6.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(26, 7).m_171488_(-1.5f, 5.0f, -2.5f, 3.0f, 0.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-1.5f, (float)3.5f, (float)0.5f));
        PartDefinition wingLeft = body.m_171599_("wingLeft", CubeListBuilder.m_171558_().m_171514_(40, 0).m_171488_(0.0f, -2.0f, -0.5f, 1.0f, 5.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)3.5f, (float)-1.5f, (float)-2.5f, (float)0.4363f, (float)0.0f, (float)0.0f));
        PartDefinition wingRight = body.m_171599_("wingRight", CubeListBuilder.m_171558_().m_171514_(40, 0).m_171480_().m_171488_(-1.0f, -2.0603f, -0.842f, 1.0f, 5.0f, 8.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)-3.5f, (float)-1.4397f, (float)-2.158f, (float)0.4363f, (float)0.0f, (float)0.0f));
        PartDefinition ridingPos = body.m_171599_("ridingPos", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)-3.0f, (float)2.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)66, (int)32);
    }

    public void m_7695_(PoseStack poseStack, VertexConsumer buffer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.model.getMainPart().render(poseStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.model.resetPoses();
        this.head.yRot += netHeadYaw % 360.0f * ((float)Math.PI / 180) * 0.25f;
        this.head.xRot += headPitch * ((float)Math.PI / 180) * 0.25f;
        this.neck.yRot += netHeadYaw % 360.0f * ((float)Math.PI / 180) * 0.25f;
        this.neck.xRot += headPitch * ((float)Math.PI / 180) * 0.25f;
        float partialTicks = ClientHandlers.getPartialTicks();
        if (((EntityCluckadoodle)entity).f_20919_ <= 0 && !((BaseMonster)entity).playDeath()) {
            this.anim.doAnimation((ExtendedModel)this, "idle", ((EntityCluckadoodle)entity).f_19797_, partialTicks);
            if (((BaseMonster)entity).moveTick() > 0) {
                this.anim.doAnimation((ExtendedModel)this, "walk", ((EntityCluckadoodle)entity).f_19797_, partialTicks, ((BaseMonster)entity).interpolatedMoveTick(partialTicks));
            }
        }
        this.anim.doAnimation((ExtendedModel)this, ((EntityCluckadoodle)entity).getAnimationHandler(), partialTicks);
    }

    public ModelPartHandler getHandler() {
        return this.model;
    }

    public boolean transform(T entity, EntityRenderer<T> entityRenderer, Entity rider, EntityRenderer<?> ridingEntityRenderer, PoseStack poseStack, int riderNum) {
        LivingEntityRenderer lR;
        EntityModel model;
        if (ridingEntityRenderer instanceof LivingEntityRenderer && ((model = (lR = (LivingEntityRenderer)ridingEntityRenderer).m_7200_()) instanceof HumanoidModel || model instanceof IllagerModel || model instanceof SittingModel)) {
            this.body.translateAndRotate(poseStack);
            this.ridingPosition.translateAndRotate(poseStack);
            ClientHandlers.translateRider(entityRenderer, rider, model, poseStack);
            return true;
        }
        return false;
    }
}

