/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.client.model.monster;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import io.github.flemmli97.runecraftory.client.ClientHandlers;
import io.github.flemmli97.runecraftory.client.model.SittingModel;
import io.github.flemmli97.runecraftory.common.entities.BaseMonster;
import io.github.flemmli97.runecraftory.common.entities.monster.boss.EntityDeadTree;
import io.github.flemmli97.tenshilib.client.AnimationManager;
import io.github.flemmli97.tenshilib.client.model.BlockBenchAnimations;
import io.github.flemmli97.tenshilib.client.model.ExtendedModel;
import io.github.flemmli97.tenshilib.client.model.ModelPartHandler;
import io.github.flemmli97.tenshilib.client.model.RideableModel;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.IllagerModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;

public class ModelDeadTree<T extends EntityDeadTree>
extends EntityModel<T>
implements ExtendedModel,
RideableModel<T> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(new ResourceLocation("runecraftory", "dead_tree"), "main");
    protected final ModelPartHandler model;
    protected final BlockBenchAnimations anim;
    public ModelPartHandler.ModelPartExtended body;
    public ModelPartHandler.ModelPartExtended leafs;
    public ModelPartHandler.ModelPartExtended ridingPosition;

    public ModelDeadTree(ModelPart root) {
        this.model = new ModelPartHandler(root, "root");
        this.anim = AnimationManager.getInstance().getAnimation(new ResourceLocation("runecraftory", "dead_tree"));
        this.body = this.model.getPart("body");
        this.leafs = this.model.getPart("leafs");
        this.ridingPosition = this.model.getPart("ridingPos");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition body = partdefinition.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(64, 56).m_171488_(-6.0f, -19.0f, -6.0f, 12.0f, 28.0f, 12.0f, new CubeDeformation(0.0f)).m_171514_(0, 88).m_171488_(-7.0f, 8.0f, -7.0f, 14.0f, 2.0f, 14.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)14.0f, (float)0.0f));
        PartDefinition root1 = body.m_171599_("root1", CubeListBuilder.m_171558_().m_171514_(97, 102).m_171488_(-6.0f, -1.75f, -1.25f, 6.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)).m_171514_(6, 6).m_171488_(-8.0f, -0.75f, -0.75f, 2.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-5.0f, (float)8.75f, (float)5.0f, (float)0.0f, (float)0.7854f, (float)0.0f));
        PartDefinition root2 = body.m_171599_("root2", CubeListBuilder.m_171558_().m_171514_(100, 96).m_171488_(0.0f, -1.75f, -1.5f, 6.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)).m_171514_(0, 20).m_171488_(6.0f, -0.75f, -1.0f, 2.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)5.0f, (float)8.75f, (float)-5.0f, (float)0.0f, (float)0.7854f, (float)0.0f));
        PartDefinition root3 = body.m_171599_("root3", CubeListBuilder.m_171558_().m_171514_(100, 62).m_171488_(0.0f, -1.75f, -1.5f, 6.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)).m_171514_(0, 10).m_171488_(6.0f, -0.75f, -1.0f, 2.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)).m_171514_(8, 10).m_171488_(2.0f, -5.75f, 0.0f, 3.0f, 4.0f, 0.0f, new CubeDeformation(0.0f)).m_171514_(0, 3).m_171488_(3.5f, -5.75f, -1.5f, 0.0f, 4.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)5.0f, (float)8.75f, (float)5.0f, (float)0.0f, (float)-0.7854f, (float)0.0f));
        PartDefinition root4 = body.m_171599_("root4", CubeListBuilder.m_171558_().m_171514_(100, 56).m_171488_(-6.0f, -1.75f, -1.5f, 6.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)).m_171514_(6, 22).m_171488_(-8.0f, -0.75f, -1.0f, 2.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-5.0f, (float)8.75f, (float)-5.0f, (float)0.0f, (float)-0.7854f, (float)0.0f));
        PartDefinition leafs = body.m_171599_("leafs", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-20.0f, -16.0f, -20.0f, 40.0f, 16.0f, 40.0f, new CubeDeformation(0.0f)).m_171514_(0, 56).m_171488_(-8.0f, -31.9f, -8.0f, 16.0f, 16.0f, 16.0f, new CubeDeformation(0.0f)).m_171514_(0, 0).m_171488_(14.0f, 0.0f, -19.0f, 3.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)).m_171514_(0, 0).m_171488_(13.0f, 0.0f, -2.0f, 3.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)).m_171514_(0, 0).m_171488_(10.0f, 0.0f, 10.0f, 3.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)).m_171514_(0, 0).m_171488_(7.0f, 0.0f, 15.0f, 3.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)).m_171514_(0, 0).m_171488_(-13.0f, 0.0f, 13.0f, 3.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)).m_171514_(0, 0).m_171488_(-17.0f, 0.0f, 3.0f, 3.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)).m_171514_(0, 0).m_171488_(-2.0f, 0.0f, 16.0f, 3.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)).m_171514_(0, 0).m_171488_(-5.0f, 0.0f, 10.0f, 3.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)).m_171514_(0, 0).m_171488_(-17.0f, 0.0f, -19.0f, 3.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)).m_171514_(0, 0).m_171488_(-21.0f, 0.0f, -10.0f, 3.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)).m_171514_(0, 0).m_171488_(-22.0f, -9.0f, -10.0f, 3.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)).m_171514_(0, 0).m_171488_(-22.0f, -13.0f, 12.0f, 3.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)).m_171514_(0, 0).m_171488_(11.0f, -9.0f, -22.0f, 3.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)).m_171514_(0, 0).m_171488_(19.0f, -12.0f, -11.0f, 3.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)).m_171514_(0, 0).m_171488_(19.0f, -7.0f, 7.0f, 3.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)).m_171514_(0, 0).m_171488_(-2.0f, -11.0f, 19.0f, 3.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-15.0f, (float)0.0f));
        PartDefinition ridingPos = leafs.m_171599_("ridingPos", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)-32.0f, (float)3.0f));
        PartDefinition armLeft = body.m_171599_("armLeft", CubeListBuilder.m_171558_().m_171514_(0, 20).m_171488_(0.0f, -3.0f, -10.0f, 6.0f, 6.0f, 14.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)6.0f, (float)-11.0f, (float)2.0f, (float)0.0698f, (float)-0.8727f, (float)0.1745f));
        PartDefinition armLeftMiddle = armLeft.m_171599_("armLeftMiddle", CubeListBuilder.m_171558_().m_171514_(62, 96).m_171488_(-1.5f, -1.5f, -14.0f, 3.0f, 3.0f, 14.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)3.0f, (float)0.0f, (float)-10.0f, (float)0.3491f, (float)0.5236f, (float)0.0f));
        PartDefinition handLeft = armLeftMiddle.m_171599_("handLeft", CubeListBuilder.m_171558_().m_171514_(82, 96).m_171488_(-2.5f, -2.5f, -4.0f, 5.0f, 5.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)-13.9f));
        PartDefinition armRight = body.m_171599_("armRight", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-6.0f, -3.0f, -10.0f, 6.0f, 6.0f, 14.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-6.0f, (float)-11.0f, (float)2.0f, (float)0.0698f, (float)0.8727f, (float)-0.1745f));
        PartDefinition armRightMiddle = armRight.m_171599_("armRightMiddle", CubeListBuilder.m_171558_().m_171514_(42, 90).m_171488_(-1.5f, -1.5f, -14.0f, 3.0f, 3.0f, 14.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-3.0f, (float)0.0f, (float)-10.0f, (float)0.3491f, (float)-0.5236f, (float)0.0f));
        PartDefinition handRight = armRightMiddle.m_171599_("handRight", CubeListBuilder.m_171558_().m_171514_(48, 56).m_171488_(-2.5f, -2.5f, -4.0f, 5.0f, 5.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)-13.9f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)256, (int)256);
    }

    public void m_7695_(PoseStack poseStack, VertexConsumer buffer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.model.getMainPart().render(poseStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.model.resetPoses();
        float partialTicks = ClientHandlers.getPartialTicks();
        if (((EntityDeadTree)entity).f_20919_ <= 0 && !((BaseMonster)entity).playDeath()) {
            this.anim.doAnimation((ExtendedModel)this, "idle", ((EntityDeadTree)entity).f_19797_, partialTicks);
            if (((BaseMonster)entity).moveTick() > 0) {
                this.anim.doAnimation((ExtendedModel)this, "walk", ((EntityDeadTree)entity).f_19797_, partialTicks, ((BaseMonster)entity).interpolatedMoveTick(partialTicks));
            }
        }
        this.anim.doAnimation((ExtendedModel)this, ((EntityDeadTree)entity).getAnimationHandler(), partialTicks);
    }

    public ModelPartHandler getHandler() {
        return this.model;
    }

    public boolean transform(T entity, EntityRenderer<T> entityRenderer, Entity rider, EntityRenderer<?> ridingEntityRenderer, PoseStack poseStack, int riderNum) {
        LivingEntityRenderer lR;
        EntityModel model;
        if (ridingEntityRenderer instanceof LivingEntityRenderer && ((model = (lR = (LivingEntityRenderer)ridingEntityRenderer).m_7200_()) instanceof HumanoidModel || model instanceof IllagerModel || model instanceof SittingModel)) {
            this.body.translateAndRotate(poseStack);
            this.leafs.translateAndRotate(poseStack);
            this.ridingPosition.translateAndRotate(poseStack);
            ClientHandlers.translateRider(entityRenderer, rider, model, poseStack);
            return true;
        }
        return false;
    }
}

