/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.client.model.monster;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import io.github.flemmli97.runecraftory.client.ClientHandlers;
import io.github.flemmli97.runecraftory.client.model.SittingModel;
import io.github.flemmli97.runecraftory.common.entities.BaseMonster;
import io.github.flemmli97.runecraftory.common.entities.monster.EntityDemon;
import io.github.flemmli97.tenshilib.client.AnimationManager;
import io.github.flemmli97.tenshilib.client.model.BlockBenchAnimations;
import io.github.flemmli97.tenshilib.client.model.ExtendedModel;
import io.github.flemmli97.tenshilib.client.model.ModelPartHandler;
import io.github.flemmli97.tenshilib.client.model.RideableModel;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.IllagerModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;

public class ModelDemon<T extends EntityDemon>
extends EntityModel<T>
implements ExtendedModel,
RideableModel<T> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(new ResourceLocation("runecraftory", "demon"), "main");
    protected final ModelPartHandler model;
    protected final BlockBenchAnimations anim;
    public ModelPartHandler.ModelPartExtended body;
    public ModelPartHandler.ModelPartExtended head;
    public ModelPartHandler.ModelPartExtended ridingPosition;

    public ModelDemon(ModelPart root) {
        this.model = new ModelPartHandler(root, "root");
        this.anim = AnimationManager.getInstance().getAnimation(new ResourceLocation("runecraftory", "demon"));
        this.body = this.model.getPart("body");
        this.head = this.model.getPart("head");
        this.ridingPosition = this.model.getPart("ridingPos");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition body = partdefinition.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(21, 0).m_171488_(-4.0f, -6.5f, -2.5f, 8.0f, 13.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)5.5f, (float)0.0f));
        PartDefinition leftWingBase = body.m_171599_("leftWingBase", CubeListBuilder.m_171558_().m_171514_(44, 24).m_171488_(0.0f, -0.5f, -1.0f, 8.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(32, 48).m_171488_(0.0f, -1.5f, -0.5f, 8.0f, 9.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-0.5f, (float)-2.0f, (float)2.5f, (float)0.4363f, (float)-0.5236f, (float)-0.6981f));
        PartDefinition leftWing = leftWingBase.m_171599_("leftWing", CubeListBuilder.m_171558_().m_171514_(36, 28).m_171488_(0.0f, 0.0f, -0.5f, 12.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(16, 43).m_171488_(0.0f, 1.0f, -0.5f, 1.0f, 7.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(0, 36).m_171488_(1.0f, 1.0f, 0.025f, 11.0f, 7.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)8.0f, (float)-0.5f, (float)-0.5f, (float)0.0f, (float)0.0f, (float)0.3927f));
        PartDefinition rightWingBase = body.m_171599_("rightWingBase", CubeListBuilder.m_171558_().m_171514_(44, 24).m_171480_().m_171488_(-8.0f, -0.5f, -1.0f, 8.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).m_171555_(false).m_171514_(32, 48).m_171480_().m_171488_(-8.0f, -1.5f, -0.5f, 8.0f, 9.0f, 0.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)0.5f, (float)-2.0f, (float)2.5f, (float)0.4363f, (float)0.5236f, (float)0.6981f));
        PartDefinition rightWing = rightWingBase.m_171599_("rightWing", CubeListBuilder.m_171558_().m_171514_(36, 28).m_171480_().m_171488_(-12.0f, 0.0f, -0.5f, 12.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).m_171555_(false).m_171514_(16, 43).m_171480_().m_171488_(-1.0f, 1.0f, -0.5f, 1.0f, 7.0f, 1.0f, new CubeDeformation(0.0f)).m_171555_(false).m_171514_(0, 36).m_171480_().m_171488_(-12.0f, 1.0f, 0.025f, 11.0f, 7.0f, 0.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)-8.0f, (float)-0.5f, (float)-0.5f, (float)0.0f, (float)0.0f, (float)-0.3927f));
        PartDefinition tailBase = body.m_171599_("tailBase", CubeListBuilder.m_171558_().m_171514_(32, 18).m_171488_(-1.0f, 0.0f, 0.0f, 2.0f, 2.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-0.5f, (float)4.5f, (float)2.5f, (float)-0.5672f, (float)0.0f, (float)0.0f));
        PartDefinition tail = tailBase.m_171599_("tail", CubeListBuilder.m_171558_().m_171514_(24, 28).m_171488_(-1.0f, -2.0f, 0.0f, 2.0f, 2.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)2.0f, (float)8.0f, (float)0.48f, (float)0.0f, (float)0.0f));
        PartDefinition head = body.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(0, 20).m_171488_(-4.0f, -8.0f, -4.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-6.5f, (float)0.0f));
        PartDefinition leftHorn = head.m_171599_("leftHorn", CubeListBuilder.m_171558_().m_171514_(36, 30).m_171488_(-1.0f, -2.0f, 0.0f, 1.0f, 2.0f, 4.0f, new CubeDeformation(0.0f)).m_171514_(50, 37).m_171488_(-1.0f, -1.5f, 4.0f, 1.0f, 1.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)4.25f, (float)-6.0f, (float)-3.25f, (float)0.5672f, (float)0.829f, (float)0.0f));
        PartDefinition rightHorn = head.m_171599_("rightHorn", CubeListBuilder.m_171558_().m_171514_(24, 20).m_171488_(0.0f, -2.0f, 0.0f, 1.0f, 2.0f, 4.0f, new CubeDeformation(0.0f)).m_171514_(48, 48).m_171488_(0.0f, -1.5f, 4.0f, 1.0f, 1.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-3.25f, (float)-6.0f, (float)-3.25f, (float)0.5672f, (float)-0.829f, (float)0.0f));
        PartDefinition leftArm = body.m_171599_("leftArm", CubeListBuilder.m_171558_().m_171514_(47, 0).m_171488_(0.0f, -1.5f, -3.0f, 4.0f, 6.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)4.0f, (float)-4.0f, (float)0.5f));
        PartDefinition leftArmDown = leftArm.m_171599_("leftArmDown", CubeListBuilder.m_171558_().m_171514_(16, 48).m_171488_(-2.0f, 0.0f, -4.0f, 4.0f, 5.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)2.0f, (float)4.5f, (float)1.0f));
        PartDefinition rightArm = body.m_171599_("rightArm", CubeListBuilder.m_171558_().m_171514_(44, 14).m_171488_(-4.0f, -1.5f, -3.0f, 4.0f, 6.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-4.0f, (float)-4.0f, (float)0.5f));
        PartDefinition rightArmDown = rightArm.m_171599_("rightArmDown", CubeListBuilder.m_171558_().m_171514_(0, 10).m_171488_(-2.0f, 0.0f, -4.0f, 4.0f, 5.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-2.0f, (float)4.5f, (float)1.0f));
        PartDefinition trident = rightArmDown.m_171599_("trident", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-0.5f, -0.5f, -15.0f, 1.0f, 1.0f, 19.0f, new CubeDeformation(0.0f)).m_171514_(47, 10).m_171488_(-2.5f, -0.5f, -16.0f, 5.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(0, 20).m_171488_(1.5f, -0.5f, -19.0f, 1.0f, 1.0f, 3.0f, new CubeDeformation(0.0f)).m_171514_(0, 20).m_171488_(-2.5f, -0.5f, -19.0f, 1.0f, 1.0f, 3.0f, new CubeDeformation(0.0f)).m_171514_(44, 30).m_171488_(-0.5f, -0.5f, -22.0f, 1.0f, 1.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)3.0f, (float)-2.0f));
        PartDefinition leftLeg = body.m_171599_("leftLeg", CubeListBuilder.m_171558_().m_171514_(0, 43).m_171488_(-2.0f, 0.0f, -2.0f, 4.0f, 6.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)2.0f, (float)6.5f, (float)-0.5f));
        PartDefinition leftLeg2 = leftLeg.m_171599_("leftLeg2", CubeListBuilder.m_171558_().m_171514_(38, 38).m_171488_(-2.0f, 0.0f, 0.0f, 4.0f, 6.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)6.0f, (float)-2.0f));
        PartDefinition rightLeg = body.m_171599_("rightLeg", CubeListBuilder.m_171558_().m_171514_(22, 38).m_171488_(-2.0f, 0.0f, -2.0f, 4.0f, 6.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-2.0f, (float)6.5f, (float)-0.5f));
        PartDefinition rightLeg2 = rightLeg.m_171599_("rightLeg2", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-2.0f, 0.0f, 0.0f, 4.0f, 6.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)6.0f, (float)-2.0f));
        PartDefinition ridingPos = body.m_171599_("ridingPos", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)3.0f, (float)5.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public void m_7695_(PoseStack poseStack, VertexConsumer buffer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.model.getMainPart().render(poseStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.model.resetPoses();
        this.head.yRot += netHeadYaw % 360.0f * ((float)Math.PI / 180) * 0.5f;
        this.head.xRot += headPitch * ((float)Math.PI / 180) * 0.5f;
        float partialTicks = ClientHandlers.getPartialTicks();
        if (((EntityDemon)entity).f_20919_ <= 0 && !((BaseMonster)entity).playDeath()) {
            this.anim.doAnimation((ExtendedModel)this, "idle", ((EntityDemon)entity).f_19797_, partialTicks);
            if (((BaseMonster)entity).moveTick() > 0) {
                this.anim.doAnimation((ExtendedModel)this, "walk", ((EntityDemon)entity).f_19797_, partialTicks, ((BaseMonster)entity).interpolatedMoveTick(partialTicks));
            }
        }
        this.anim.doAnimation((ExtendedModel)this, ((EntityDemon)entity).getAnimationHandler(), partialTicks);
    }

    public ModelPartHandler getHandler() {
        return this.model;
    }

    public boolean transform(T entity, EntityRenderer<T> entityRenderer, Entity rider, EntityRenderer<?> ridingEntityRenderer, PoseStack poseStack, int riderNum) {
        LivingEntityRenderer lR;
        EntityModel model;
        if (ridingEntityRenderer instanceof LivingEntityRenderer && ((model = (lR = (LivingEntityRenderer)ridingEntityRenderer).m_7200_()) instanceof HumanoidModel || model instanceof IllagerModel || model instanceof SittingModel)) {
            this.body.translateAndRotate(poseStack);
            this.ridingPosition.translateAndRotate(poseStack);
            ClientHandlers.translateRider(entityRenderer, rider, model, poseStack);
            return true;
        }
        return false;
    }
}

