/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.client.model.monster;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import io.github.flemmli97.runecraftory.client.ClientHandlers;
import io.github.flemmli97.runecraftory.client.model.SittingModel;
import io.github.flemmli97.runecraftory.common.entities.BaseMonster;
import io.github.flemmli97.runecraftory.common.entities.monster.EntityDuck;
import io.github.flemmli97.tenshilib.client.AnimationManager;
import io.github.flemmli97.tenshilib.client.model.BlockBenchAnimations;
import io.github.flemmli97.tenshilib.client.model.ExtendedModel;
import io.github.flemmli97.tenshilib.client.model.ModelPartHandler;
import io.github.flemmli97.tenshilib.client.model.RideableModel;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.IllagerModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;

public class ModelDuck<T extends EntityDuck>
extends EntityModel<T>
implements ExtendedModel,
RideableModel<T> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(new ResourceLocation("runecraftory", "duck"), "main");
    protected final ModelPartHandler model;
    protected final BlockBenchAnimations anim;
    public ModelPartHandler.ModelPartExtended body;
    public ModelPartHandler.ModelPartExtended ridingPosition;

    public ModelDuck(ModelPart root) {
        this.model = new ModelPartHandler(root, "root");
        this.anim = AnimationManager.getInstance().getAnimation(new ResourceLocation("runecraftory", "duck"));
        this.body = this.model.getPart("body");
        this.ridingPosition = this.model.getPart("ridingPos");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition body = partdefinition.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-6.5f, -11.0f, -6.5f, 13.0f, 23.0f, 13.0f, new CubeDeformation(0.0f)).m_171514_(28, 36).m_171488_(-7.01f, -5.01f, -6.5f, 1.0f, 3.0f, 13.0f, new CubeDeformation(0.0f)).m_171514_(0, 36).m_171488_(6.01f, -5.01f, -6.5f, 1.0f, 3.0f, 13.0f, new CubeDeformation(0.0f)).m_171514_(28, 58).m_171488_(-7.0f, -5.0f, 6.0f, 14.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(52, 0).m_171488_(-4.5f, -13.0f, -4.5f, 9.0f, 2.0f, 9.0f, new CubeDeformation(0.0f)).m_171514_(46, 69).m_171488_(-3.5f, -5.0f, -10.5f, 7.0f, 1.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)11.5f, (float)0.0f));
        PartDefinition tailBase = body.m_171599_("tailBase", CubeListBuilder.m_171558_().m_171514_(0, 58).m_171488_(-5.5f, -8.0f, 0.0f, 11.0f, 8.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)11.0f, (float)6.5f, (float)0.0436f, (float)0.0f, (float)0.0f));
        PartDefinition tailMiddle = tailBase.m_171599_("tailMiddle", CubeListBuilder.m_171558_().m_171514_(24, 69).m_171488_(-4.5f, -6.0f, 0.0f, 9.0f, 6.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-2.0f, (float)3.0f, (float)0.0436f, (float)0.0f, (float)0.0f));
        PartDefinition tailTip = tailMiddle.m_171599_("tailTip", CubeListBuilder.m_171558_().m_171514_(0, 78).m_171488_(-3.5f, -7.0f, 0.0f, 7.0f, 7.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-6.0f, (float)2.0f, (float)-0.6981f, (float)0.0f, (float)0.0f));
        PartDefinition hair = body.m_171599_("hair", CubeListBuilder.m_171558_().m_171514_(68, 69).m_171488_(-4.5f, -7.0f, 0.0f, 9.0f, 7.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-13.0f, (float)-4.5f, (float)-0.6545f, (float)0.0f, (float)0.0f));
        PartDefinition leftWing = body.m_171599_("leftWing", CubeListBuilder.m_171558_().m_171514_(56, 36).m_171488_(0.0f, 0.0f, -4.5f, 1.0f, 13.0f, 9.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)6.5f, (float)-2.0f, (float)0.0f));
        PartDefinition rightWing = body.m_171599_("rightWing", CubeListBuilder.m_171558_().m_171514_(56, 36).m_171480_().m_171488_(-1.0f, 0.0f, -4.5f, 1.0f, 13.0f, 9.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)-6.5f, (float)-2.0f, (float)0.0f));
        PartDefinition leftFeet = body.m_171599_("leftFeet", CubeListBuilder.m_171558_().m_171514_(0, 69).m_171488_(-2.0f, -0.5f, -8.0f, 4.0f, 1.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)3.25f, (float)12.0f, (float)-2.5f));
        PartDefinition rightFeet = body.m_171599_("rightFeet", CubeListBuilder.m_171558_().m_171514_(58, 58).m_171488_(-2.0f, -0.5f, -8.0f, 4.0f, 1.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-3.25f, (float)12.0f, (float)-2.5f));
        PartDefinition ridingPos = body.m_171599_("ridingPos", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)-12.0f, (float)6.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)128, (int)128);
    }

    public void m_7695_(PoseStack poseStack, VertexConsumer buffer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.model.getMainPart().render(poseStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.model.resetPoses();
        float partialTicks = ClientHandlers.getPartialTicks();
        if (((EntityDuck)entity).f_20919_ <= 0 && !((BaseMonster)entity).playDeath()) {
            this.anim.doAnimation((ExtendedModel)this, "idle", ((EntityDuck)entity).f_19797_, partialTicks);
            if (((BaseMonster)entity).moveTick() > 0) {
                this.anim.doAnimation((ExtendedModel)this, "walk", ((EntityDuck)entity).f_19797_, partialTicks, ((BaseMonster)entity).interpolatedMoveTick(partialTicks));
            }
        }
        this.anim.doAnimation((ExtendedModel)this, ((EntityDuck)entity).getAnimationHandler(), partialTicks);
    }

    public ModelPartHandler getHandler() {
        return this.model;
    }

    public boolean transform(T entity, EntityRenderer<T> entityRenderer, Entity rider, EntityRenderer<?> ridingEntityRenderer, PoseStack poseStack, int riderNum) {
        LivingEntityRenderer lR;
        EntityModel model;
        if (ridingEntityRenderer instanceof LivingEntityRenderer && ((model = (lR = (LivingEntityRenderer)ridingEntityRenderer).m_7200_()) instanceof HumanoidModel || model instanceof IllagerModel || model instanceof SittingModel)) {
            this.body.translateAndRotate(poseStack);
            this.ridingPosition.translateAndRotate(poseStack);
            ClientHandlers.translateRider(entityRenderer, rider, model, poseStack);
            return true;
        }
        return false;
    }
}

