/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.client.model.monster;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import io.github.flemmli97.runecraftory.client.ClientHandlers;
import io.github.flemmli97.runecraftory.client.model.SittingModel;
import io.github.flemmli97.runecraftory.common.entities.BaseMonster;
import io.github.flemmli97.runecraftory.common.entities.monster.EntityFlowerLily;
import io.github.flemmli97.tenshilib.api.entity.AnimatedAction;
import io.github.flemmli97.tenshilib.client.AnimationManager;
import io.github.flemmli97.tenshilib.client.model.BlockBenchAnimations;
import io.github.flemmli97.tenshilib.client.model.ExtendedModel;
import io.github.flemmli97.tenshilib.client.model.ModelPartHandler;
import io.github.flemmli97.tenshilib.client.model.RideableModel;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.IllagerModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;

public class ModelFlowerLily<T extends EntityFlowerLily>
extends EntityModel<T>
implements ExtendedModel,
RideableModel<T> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(new ResourceLocation("runecraftory", "flower_lily"), "main");
    protected final ModelPartHandler model;
    protected final BlockBenchAnimations anim;
    public ModelPartHandler.ModelPartExtended body;
    public ModelPartHandler.ModelPartExtended ridingPosition;

    public ModelFlowerLily(ModelPart root) {
        this.model = new ModelPartHandler(root, "root");
        this.anim = AnimationManager.getInstance().getAnimation(new ResourceLocation("runecraftory", "flower_lily"));
        this.body = this.model.getPart("body");
        this.ridingPosition = this.model.getPart("ridingPos");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition body = partdefinition.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(48, 26).m_171488_(-2.0f, 6.0f, -2.0f, 4.0f, 1.0f, 4.0f, new CubeDeformation(0.0f)).m_171514_(0, 0).m_171488_(-4.0f, -4.0f, -4.0f, 8.0f, 10.0f, 8.0f, new CubeDeformation(0.0f)).m_171514_(0, 18).m_171488_(-4.5f, 0.0f, -4.5f, 9.0f, 4.0f, 9.0f, new CubeDeformation(0.0f)).m_171514_(32, 8).m_171488_(-3.0f, -7.0f, -3.0f, 6.0f, 3.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)17.0f, (float)0.0f));
        PartDefinition stem = body.m_171599_("stem", CubeListBuilder.m_171558_().m_171514_(0, 50).m_171488_(-1.0f, -10.0f, -1.0f, 2.0f, 11.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-7.0f, (float)0.0f));
        PartDefinition head = stem.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(30, 26).m_171488_(-3.0f, -3.0f, -7.0f, 6.0f, 6.0f, 6.0f, new CubeDeformation(0.0f)).m_171514_(48, 48).m_171488_(-2.0f, -2.0f, -11.0f, 4.0f, 4.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-9.0f, (float)-0.5f));
        PartDefinition flowerBase = head.m_171599_("flowerBase", CubeListBuilder.m_171558_(), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.7854f));
        PartDefinition flower1 = flowerBase.m_171599_("flower1", CubeListBuilder.m_171558_().m_171514_(27, 18).m_171488_(-7.0f, -8.0f, 0.0f, 14.0f, 8.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)0.2618f, (float)0.0f, (float)0.0f));
        PartDefinition flower2 = flowerBase.m_171599_("flower2", CubeListBuilder.m_171558_().m_171514_(36, 38).m_171488_(0.0f, -7.0f, 0.0f, 8.0f, 14.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.2618f, (float)0.0f));
        PartDefinition flower3 = flowerBase.m_171599_("flower3", CubeListBuilder.m_171558_().m_171514_(20, 38).m_171488_(-8.0f, -7.0f, 0.0f, 8.0f, 14.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.2618f, (float)0.0f));
        PartDefinition flower4 = flowerBase.m_171599_("flower4", CubeListBuilder.m_171558_().m_171514_(24, 0).m_171488_(-7.0f, 0.0f, 0.0f, 14.0f, 8.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)-0.2618f, (float)0.0f, (float)0.0f));
        PartDefinition leaf1 = stem.m_171599_("leaf1", CubeListBuilder.m_171558_().m_171514_(0, 41).m_171488_(0.0f, -8.0f, 0.0f, 8.0f, 9.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-2.0f, (float)1.0f, (float)0.0f, (float)-0.3491f, (float)0.3054f));
        PartDefinition leaf2 = stem.m_171599_("leaf2", CubeListBuilder.m_171558_().m_171514_(0, 41).m_171480_().m_171488_(-8.0f, -8.0f, 1.0f, 8.0f, 9.0f, 0.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)0.0f, (float)-2.0f, (float)0.0f, (float)0.0f, (float)0.3491f, (float)-0.3054f));
        PartDefinition tail = body.m_171599_("tail", CubeListBuilder.m_171558_().m_171514_(0, 21).m_171488_(0.0f, -10.0f, 0.0f, 0.0f, 10.0f, 10.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)7.0f, (float)2.0f));
        PartDefinition ridingPos = body.m_171599_("ridingPos", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)-7.0f, (float)4.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public void m_7695_(PoseStack poseStack, VertexConsumer buffer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.model.getMainPart().render(poseStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.model.resetPoses();
        AnimatedAction anim = ((EntityFlowerLily)entity).getAnimationHandler().getAnimation();
        float partialTicks = ClientHandlers.getPartialTicks();
        if (((EntityFlowerLily)entity).f_20919_ <= 0 && !((BaseMonster)entity).playDeath()) {
            if (!EntityFlowerLily.SLEEP.is(new AnimatedAction[]{anim})) {
                this.anim.doAnimation((ExtendedModel)this, "idle", ((EntityFlowerLily)entity).f_19797_, partialTicks);
            }
            if (((BaseMonster)entity).moveTick() > 0) {
                this.anim.doAnimation((ExtendedModel)this, "move", ((EntityFlowerLily)entity).f_19797_, partialTicks, ((BaseMonster)entity).interpolatedMoveTick(partialTicks));
            }
        }
        this.anim.doAnimation((ExtendedModel)this, ((EntityFlowerLily)entity).getAnimationHandler(), partialTicks);
    }

    public ModelPartHandler getHandler() {
        return this.model;
    }

    public boolean transform(T entity, EntityRenderer<T> entityRenderer, Entity rider, EntityRenderer<?> ridingEntityRenderer, PoseStack poseStack, int riderNum) {
        LivingEntityRenderer lR;
        EntityModel model;
        if (ridingEntityRenderer instanceof LivingEntityRenderer && ((model = (lR = (LivingEntityRenderer)ridingEntityRenderer).m_7200_()) instanceof HumanoidModel || model instanceof IllagerModel || model instanceof SittingModel)) {
            this.body.translateAndRotate(poseStack);
            this.ridingPosition.translateAndRotate(poseStack);
            ClientHandlers.translateRider(entityRenderer, rider, model, poseStack);
            return true;
        }
        return false;
    }
}

