/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.client.model.monster;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import io.github.flemmli97.runecraftory.client.ClientHandlers;
import io.github.flemmli97.runecraftory.client.model.SittingModel;
import io.github.flemmli97.runecraftory.common.entities.BaseMonster;
import io.github.flemmli97.runecraftory.common.entities.monster.EntityGhost;
import io.github.flemmli97.tenshilib.client.AnimationManager;
import io.github.flemmli97.tenshilib.client.model.BlockBenchAnimations;
import io.github.flemmli97.tenshilib.client.model.ExtendedModel;
import io.github.flemmli97.tenshilib.client.model.ModelPartHandler;
import io.github.flemmli97.tenshilib.client.model.RideableModel;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.IllagerModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;

public class ModelGhost<T extends EntityGhost>
extends EntityModel<T>
implements ExtendedModel,
RideableModel<T> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(new ResourceLocation("runecraftory", "ghost"), "main");
    protected final ModelPartHandler model;
    protected final BlockBenchAnimations anim;
    public ModelPartHandler.ModelPartExtended body;
    public ModelPartHandler.ModelPartExtended ridingPosition;

    public ModelGhost(ModelPart root) {
        super(RenderType::m_110470_);
        this.model = new ModelPartHandler(root, "root");
        this.anim = AnimationManager.getInstance().getAnimation(new ResourceLocation("runecraftory", "ghost"));
        this.body = this.model.getPart("body");
        this.ridingPosition = this.model.getPart("ridingPos");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition body = partdefinition.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-7.0f, -14.5f, -7.0f, 14.0f, 29.0f, 14.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)8.5f, (float)0.0f));
        PartDefinition hat = body.m_171599_("hat", CubeListBuilder.m_171558_().m_171514_(43, 30).m_171488_(-7.0f, -7.0f, 0.0f, 14.0f, 7.0f, 14.0f, new CubeDeformation(0.0f)).m_171514_(0, 96).m_171488_(-7.0f, -6.0f, 0.0f, 14.0f, 0.0f, 14.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-14.5f, (float)-7.0f, (float)-0.0873f, (float)0.0f, (float)0.0f));
        PartDefinition hat2 = hat.m_171599_("hat2", CubeListBuilder.m_171558_().m_171514_(0, 44).m_171488_(-6.0f, -4.0f, 0.0f, 12.0f, 4.0f, 12.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-7.0f, (float)1.0f, (float)-0.1745f, (float)0.0f, (float)0.0f));
        PartDefinition hat3 = hat2.m_171599_("hat3", CubeListBuilder.m_171558_().m_171514_(39, 52).m_171488_(-5.0f, -4.0f, 0.0f, 10.0f, 4.0f, 10.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-4.0f, (float)1.0f, (float)-0.2182f, (float)0.0f, (float)0.0f));
        PartDefinition hat4 = hat3.m_171599_("hat4", CubeListBuilder.m_171558_().m_171514_(43, 0).m_171488_(-4.0f, -4.0f, 0.0f, 8.0f, 5.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-4.0f, (float)1.0f, (float)-0.3054f, (float)0.0f, (float)0.0f));
        PartDefinition hat5 = hat4.m_171599_("hat5", CubeListBuilder.m_171558_().m_171514_(60, 67).m_171488_(-2.0f, -6.0f, 0.0f, 4.0f, 6.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-4.0f, (float)2.0f, (float)-0.3927f, (float)0.0f, (float)0.0f));
        PartDefinition hat6 = hat5.m_171599_("hat6", CubeListBuilder.m_171558_().m_171514_(0, 44).m_171488_(-1.0f, -7.0f, 0.0f, 2.0f, 7.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-6.0f, (float)1.0f, (float)-0.5236f, (float)0.0f, (float)0.0f));
        PartDefinition armLeftUp = body.m_171599_("armLeftUp", CubeListBuilder.m_171558_().m_171514_(43, 67).m_171488_(0.0f, -2.5f, -2.0f, 4.0f, 8.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)7.0f, (float)-6.0f, (float)0.0f));
        PartDefinition armLeftDown = armLeftUp.m_171599_("armLeftDown", CubeListBuilder.m_171558_().m_171514_(26, 63).m_171488_(-2.0f, 0.0f, -4.0f, 4.0f, 8.0f, 4.0f, new CubeDeformation(0.0f)).m_171514_(0, 0).m_171488_(-1.5f, 8.0f, -3.5f, 3.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)2.0f, (float)5.5f, (float)2.0f));
        PartDefinition armRightUp = body.m_171599_("armRightUp", CubeListBuilder.m_171558_().m_171514_(43, 67).m_171480_().m_171488_(-4.0f, -2.5f, -2.0f, 4.0f, 8.0f, 4.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)-7.0f, (float)-6.0f, (float)0.0f));
        PartDefinition armRightDown = armRightUp.m_171599_("armRightDown", CubeListBuilder.m_171558_().m_171514_(26, 63).m_171488_(-2.0f, 0.0f, -4.0f, 4.0f, 8.0f, 4.0f, new CubeDeformation(0.0f)).m_171514_(0, 0).m_171480_().m_171488_(-1.5f, 8.0f, -3.5f, 3.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)-2.0f, (float)5.5f, (float)2.0f));
        PartDefinition scythe = armRightDown.m_171599_("scythe", CubeListBuilder.m_171558_().m_171514_(0, 61).m_171488_(-1.0f, -30.0f, -1.0f, 2.0f, 33.0f, 2.0f, new CubeDeformation(0.0f)).m_171514_(57, 14).m_171488_(-0.5f, -29.0f, -9.0f, 1.0f, 7.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)10.0f, (float)-3.0f, (float)0.6109f, (float)0.0f, (float)0.0f));
        PartDefinition blade2 = scythe.m_171599_("blade2", CubeListBuilder.m_171558_().m_171514_(9, 61).m_171488_(-0.5f, 3.0f, -7.0f, 1.0f, 6.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-31.0f, (float)-9.0f, (float)0.1309f, (float)0.0f, (float)0.0f));
        PartDefinition blade3 = blade2.m_171599_("blade3", CubeListBuilder.m_171558_().m_171514_(70, 8).m_171488_(-0.5f, 3.0f, -6.0f, 1.0f, 5.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)1.0f, (float)-7.0f, (float)0.1309f, (float)0.0f, (float)0.0f));
        PartDefinition blade4 = blade3.m_171599_("blade4", CubeListBuilder.m_171558_().m_171514_(71, 72).m_171488_(-0.5f, 3.0f, -6.0f, 1.0f, 4.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)1.0f, (float)-6.0f, (float)0.1745f, (float)0.0f, (float)0.0f));
        PartDefinition blade5 = blade4.m_171599_("blade5", CubeListBuilder.m_171558_().m_171514_(70, 52).m_171488_(-0.5f, 3.0f, -6.0f, 1.0f, 2.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)2.0f, (float)-6.0f, (float)0.3491f, (float)0.0f, (float)0.0f));
        PartDefinition ridingPos = body.m_171599_("ridingPos", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)4.0f, (float)10.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)128, (int)128);
    }

    public void m_7695_(PoseStack poseStack, VertexConsumer buffer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.model.getMainPart().render(poseStack, buffer, packedLight, packedOverlay, red, green, blue, 0.85f);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.model.resetPoses();
        this.model.getMainPart().visible = true;
        float partialTicks = ClientHandlers.getPartialTicks();
        if (((EntityGhost)entity).f_20919_ <= 0 && !((BaseMonster)entity).playDeath()) {
            this.anim.doAnimation((ExtendedModel)this, "idle", ((EntityGhost)entity).f_19797_, partialTicks);
        }
        this.anim.doAnimation((ExtendedModel)this, ((EntityGhost)entity).getAnimationHandler(), partialTicks);
    }

    public ModelPartHandler getHandler() {
        return this.model;
    }

    public boolean transform(T entity, EntityRenderer<T> entityRenderer, Entity rider, EntityRenderer<?> ridingEntityRenderer, PoseStack poseStack, int riderNum) {
        LivingEntityRenderer lR;
        EntityModel model;
        if (ridingEntityRenderer instanceof LivingEntityRenderer && ((model = (lR = (LivingEntityRenderer)ridingEntityRenderer).m_7200_()) instanceof HumanoidModel || model instanceof IllagerModel || model instanceof SittingModel)) {
            this.body.translateAndRotate(poseStack);
            this.ridingPosition.translateAndRotate(poseStack);
            ClientHandlers.translateRider(entityRenderer, rider, model, poseStack);
            return true;
        }
        return false;
    }
}

