/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.client.model.monster;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import io.github.flemmli97.runecraftory.client.ClientHandlers;
import io.github.flemmli97.runecraftory.client.model.SittingModel;
import io.github.flemmli97.runecraftory.common.entities.BaseMonster;
import io.github.flemmli97.runecraftory.common.entities.monster.EntityGoblin;
import io.github.flemmli97.tenshilib.client.AnimationManager;
import io.github.flemmli97.tenshilib.client.model.BlockBenchAnimations;
import io.github.flemmli97.tenshilib.client.model.ExtendedModel;
import io.github.flemmli97.tenshilib.client.model.IItemArmModel;
import io.github.flemmli97.tenshilib.client.model.ModelPartHandler;
import io.github.flemmli97.tenshilib.client.model.RideableModel;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.IllagerModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.HumanoidArm;

public class ModelGoblin<T extends EntityGoblin>
extends EntityModel<T>
implements ExtendedModel,
RideableModel<T>,
IItemArmModel,
SittingModel {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(new ResourceLocation("runecraftory", "goblin"), "main");
    protected final ModelPartHandler model;
    protected final BlockBenchAnimations anim;
    public ModelPartHandler.ModelPartExtended body;
    public ModelPartHandler.ModelPartExtended head;
    public ModelPartHandler.ModelPartExtended leftArm;
    public ModelPartHandler.ModelPartExtended leftArmDown;
    public ModelPartHandler.ModelPartExtended rightArm;
    public ModelPartHandler.ModelPartExtended rightArmDown;
    public ModelPartHandler.ModelPartExtended ridingPosition;
    public ModelPartHandler.ModelPartExtended leftItem;
    public ModelPartHandler.ModelPartExtended rightItem;

    public ModelGoblin(ModelPart root) {
        this.model = new ModelPartHandler(root, "root");
        this.anim = AnimationManager.getInstance().getAnimation(new ResourceLocation("runecraftory", "goblin"));
        this.body = this.model.getPart("body");
        this.head = this.model.getPart("head");
        this.leftArm = this.model.getPart("leftArm");
        this.leftArmDown = this.model.getPart("leftArmDown");
        this.leftItem = this.model.getPart("leftItem");
        this.rightArm = this.model.getPart("rightArm");
        this.rightArmDown = this.model.getPart("rightArmDown");
        this.rightItem = this.model.getPart("rightItem");
        this.ridingPosition = this.model.getPart("ridingPos");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition body = partdefinition.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(32, 0).m_171488_(-4.5f, -5.0f, -2.5f, 9.0f, 12.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)11.0f, (float)0.0f));
        PartDefinition head = body.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-4.0f, -7.0f, -4.0f, 8.0f, 7.0f, 8.0f, new CubeDeformation(0.0f)).m_171514_(0, 49).m_171488_(-1.0f, -3.0f, -5.0f, 2.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(28, 42).m_171488_(-1.0f, -2.0f, -5.75f, 2.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-5.0f, (float)0.0f));
        PartDefinition horn = head.m_171599_("horn", CubeListBuilder.m_171558_().m_171514_(42, 42).m_171488_(-0.5f, -3.0f, 0.0f, 1.0f, 4.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-7.0f, (float)-4.6f, (float)0.6545f, (float)0.0f, (float)0.0f));
        PartDefinition leftEar = head.m_171599_("leftEar", CubeListBuilder.m_171558_().m_171514_(12, 42).m_171488_(-1.0f, -3.0f, -0.5f, 1.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)).m_171514_(36, 42).m_171488_(-1.0f, -3.0f, 2.5f, 1.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)).m_171514_(20, 42).m_171488_(-1.0f, -3.0f, 4.5f, 1.0f, 1.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)4.0f, (float)-2.0f, (float)-1.5f, (float)0.2182f, (float)0.829f, (float)0.0f));
        PartDefinition rightEar = head.m_171599_("rightEar", CubeListBuilder.m_171558_().m_171514_(12, 42).m_171480_().m_171488_(0.0f, -3.0f, -0.5f, 1.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)).m_171555_(false).m_171514_(36, 42).m_171488_(0.0f, -3.0f, 2.5f, 1.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)).m_171514_(20, 42).m_171488_(0.0f, -3.0f, 4.5f, 1.0f, 1.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-4.0f, (float)-2.0f, (float)-1.5f, (float)0.2182f, (float)-0.829f, (float)0.0f));
        PartDefinition leftArm = body.m_171599_("leftArm", CubeListBuilder.m_171558_().m_171514_(0, 42).m_171488_(0.0f, -1.5f, -2.0f, 3.0f, 4.0f, 3.0f, new CubeDeformation(0.0f)).m_171514_(16, 17).m_171488_(-0.5f, -2.0f, -2.5f, 4.0f, 4.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)4.5f, (float)-1.5f, (float)0.5f));
        PartDefinition leftArmDown = leftArm.m_171599_("leftArmDown", CubeListBuilder.m_171558_().m_171514_(28, 34).m_171488_(-3.0f, 0.0f, -3.0f, 3.0f, 5.0f, 3.0f, new CubeDeformation(0.0f)).m_171514_(0, 34).m_171488_(-3.5f, 1.0f, -3.5f, 4.0f, 1.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)3.0f, (float)2.5f, (float)1.0f));
        PartDefinition leftItem = leftArmDown.m_171599_("leftItem", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)-1.5f, (float)4.0f, (float)-2.0f));
        PartDefinition rightArm = body.m_171599_("rightArm", CubeListBuilder.m_171558_().m_171514_(40, 34).m_171488_(-3.0f, -1.5f, -1.5f, 3.0f, 4.0f, 3.0f, new CubeDeformation(0.0f)).m_171514_(0, 17).m_171488_(-3.5f, -2.0f, -2.0f, 4.0f, 4.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-4.5f, (float)-1.5f, (float)0.0f));
        PartDefinition rightArmDown = rightArm.m_171599_("rightArmDown", CubeListBuilder.m_171558_().m_171514_(16, 34).m_171488_(0.0f, 0.0f, -3.0f, 3.0f, 5.0f, 3.0f, new CubeDeformation(0.0f)).m_171514_(40, 25).m_171488_(-0.5f, 1.0f, -3.5f, 4.0f, 1.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-3.0f, (float)2.5f, (float)1.5f));
        PartDefinition rightItem = rightArmDown.m_171599_("rightItem", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)1.5f, (float)4.0f, (float)-2.0f));
        PartDefinition rightLeg = body.m_171599_("rightLeg", CubeListBuilder.m_171558_().m_171514_(28, 25).m_171488_(-1.5f, -0.5f, -2.0f, 3.0f, 6.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-2.0f, (float)7.0f, (float)0.5f));
        PartDefinition rightFoot = rightLeg.m_171599_("rightFoot", CubeListBuilder.m_171558_().m_171514_(0, 25).m_171488_(-1.5f, 0.0f, -5.0f, 3.0f, 1.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)5.0f, (float)1.0f));
        PartDefinition leftLeg = body.m_171599_("leftLeg", CubeListBuilder.m_171558_().m_171514_(16, 25).m_171488_(-1.0f, -0.5f, -2.0f, 3.0f, 6.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)1.5f, (float)7.0f, (float)0.5f));
        PartDefinition leftFoot = leftLeg.m_171599_("leftFoot", CubeListBuilder.m_171558_().m_171514_(32, 17).m_171488_(-1.0f, 0.0f, -5.0f, 3.0f, 1.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)5.0f, (float)1.0f));
        PartDefinition ridingPos = body.m_171599_("ridingPos", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)-5.0f, (float)5.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public void m_7695_(PoseStack poseStack, VertexConsumer buffer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.model.getMainPart().render(poseStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.model.resetPoses();
        this.head.yRot += netHeadYaw * ((float)Math.PI / 180);
        this.head.xRot += headPitch * ((float)Math.PI / 180);
        float partialTicks = ClientHandlers.getPartialTicks();
        if (((EntityGoblin)entity).f_20919_ <= 0 && !((BaseMonster)entity).playDeath()) {
            this.anim.doAnimation((ExtendedModel)this, "idle", ((EntityGoblin)entity).f_19797_, partialTicks);
            if (((BaseMonster)entity).moveTick() > 0) {
                this.anim.doAnimation((ExtendedModel)this, "walk", ((EntityGoblin)entity).f_19797_, partialTicks, ((BaseMonster)entity).interpolatedMoveTick(partialTicks));
            }
        }
        if (this.f_102609_) {
            this.anim.doAnimation((ExtendedModel)this, "sit", ((EntityGoblin)entity).f_19797_, partialTicks);
        }
        this.anim.doAnimation((ExtendedModel)this, ((EntityGoblin)entity).getAnimationHandler(), partialTicks);
    }

    public ModelPartHandler getHandler() {
        return this.model;
    }

    public void transform(HumanoidArm humanoidArm, PoseStack poseStack) {
        this.body.translateAndRotate(poseStack);
        if (humanoidArm == HumanoidArm.LEFT) {
            this.leftArmDown.translateAndRotate(poseStack);
            this.leftArm.translateAndRotate(poseStack);
            this.leftItem.translateAndRotate(poseStack);
        } else {
            this.rightArmDown.translateAndRotate(poseStack);
            this.rightArm.translateAndRotate(poseStack);
            this.rightItem.translateAndRotate(poseStack);
        }
        poseStack.m_85841_(0.7f, 0.7f, 0.7f);
    }

    public void postTransform(boolean leftSide, PoseStack stack) {
    }

    public boolean transform(T entity, EntityRenderer<T> entityRenderer, Entity rider, EntityRenderer<?> ridingEntityRenderer, PoseStack poseStack, int riderNum) {
        LivingEntityRenderer lR;
        EntityModel model;
        if (ridingEntityRenderer instanceof LivingEntityRenderer && ((model = (lR = (LivingEntityRenderer)ridingEntityRenderer).m_7200_()) instanceof HumanoidModel || model instanceof IllagerModel || model instanceof SittingModel)) {
            this.body.translateAndRotate(poseStack);
            this.ridingPosition.translateAndRotate(poseStack);
            ClientHandlers.translateRider(entityRenderer, rider, model, poseStack);
            return true;
        }
        return false;
    }

    @Override
    public void translateSittingPosition(PoseStack stack) {
        stack.m_85837_(0.0, 0.25, 0.0);
    }
}

