/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.client.model.monster;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import io.github.flemmli97.runecraftory.client.ClientHandlers;
import io.github.flemmli97.runecraftory.client.model.SittingModel;
import io.github.flemmli97.runecraftory.common.entities.BaseMonster;
import io.github.flemmli97.runecraftory.common.entities.monster.boss.EntityHandonetta;
import io.github.flemmli97.tenshilib.client.AnimationManager;
import io.github.flemmli97.tenshilib.client.model.BlockBenchAnimations;
import io.github.flemmli97.tenshilib.client.model.ExtendedModel;
import io.github.flemmli97.tenshilib.client.model.ModelPartHandler;
import io.github.flemmli97.tenshilib.client.model.RideableModel;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.IllagerModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;

public class ModelHandonetta<T extends EntityHandonetta>
extends EntityModel<T>
implements ExtendedModel,
RideableModel<T> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(new ResourceLocation("runecraftory", "handonetta"), "main");
    protected final ModelPartHandler model;
    protected final BlockBenchAnimations anim;
    public ModelPartHandler.ModelPartExtended palm;
    public ModelPartHandler.ModelPartExtended ridingPosition;

    public ModelHandonetta(ModelPart root) {
        this.model = new ModelPartHandler(root, "root");
        this.anim = AnimationManager.getInstance().getAnimation(new ResourceLocation("runecraftory", "handonetta"));
        this.palm = this.model.getPart("palm");
        this.ridingPosition = this.model.getPart("ridingPos");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition palm = partdefinition.m_171599_("palm", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-15.5f, -5.0f, -4.0f, 31.0f, 14.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)3.0f, (float)4.0f, (float)0.1745f, (float)0.0f, (float)0.0f));
        PartDefinition palmLower = palm.m_171599_("palmLower", CubeListBuilder.m_171558_().m_171514_(0, 40).m_171488_(-10.5f, -0.25f, -4.0f, 20.0f, 10.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)9.25f, (float)0.0f));
        PartDefinition palm2 = palmLower.m_171599_("palm2", CubeListBuilder.m_171558_().m_171514_(86, 60).m_171488_(0.0f, 0.0f, -3.99f, 5.0f, 9.0f, 7.98f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-15.5f, (float)-0.25f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.6109f));
        PartDefinition palm3 = palmLower.m_171599_("palm3", CubeListBuilder.m_171558_().m_171514_(86, 77).m_171488_(-5.0f, 0.0f, -3.99f, 5.0f, 9.0f, 7.98f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)15.5f, (float)-0.25f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.7418f));
        PartDefinition fingerBase = palm.m_171599_("fingerBase", CubeListBuilder.m_171558_().m_171514_(0, 22).m_171488_(-15.5f, -10.0f, -8.0f, 31.0f, 10.0f, 8.0f, new CubeDeformation(-0.001f)), PartPose.m_171423_((float)0.0f, (float)-5.0f, (float)4.0f, (float)0.3927f, (float)0.0f, (float)0.0f));
        PartDefinition index = fingerBase.m_171599_("index", CubeListBuilder.m_171558_().m_171514_(78, 15).m_171488_(-3.5f, -8.0f, -3.5f, 7.0f, 8.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)12.0f, (float)-10.0f, (float)-4.0f, (float)0.2182f, (float)0.0f, (float)0.0f));
        PartDefinition index2 = index.m_171599_("index2", CubeListBuilder.m_171558_().m_171514_(78, 0).m_171488_(-3.5f, -8.0f, -3.5f, 7.0f, 8.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-8.0f, (float)0.0f, (float)0.2618f, (float)0.0f, (float)0.0f));
        PartDefinition index3 = index2.m_171599_("index3", CubeListBuilder.m_171558_().m_171514_(58, 78).m_171488_(-3.5f, -8.0f, -3.5f, 7.0f, 8.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-8.0f, (float)0.0f, (float)0.48f, (float)0.0f, (float)0.0f));
        PartDefinition middle = fingerBase.m_171599_("middle", CubeListBuilder.m_171558_().m_171514_(30, 62).m_171488_(-3.5f, -10.0f, -3.5f, 7.0f, 10.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)4.0f, (float)-10.0f, (float)-4.0f, (float)0.2182f, (float)0.0f, (float)0.0f));
        PartDefinition middle2 = middle.m_171599_("middle2", CubeListBuilder.m_171558_().m_171514_(58, 62).m_171488_(-3.5f, -9.0f, -3.5f, 7.0f, 9.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-10.0f, (float)0.0f, (float)0.3054f, (float)0.0f, (float)0.0f));
        PartDefinition middle3 = middle2.m_171599_("middle3", CubeListBuilder.m_171558_().m_171514_(28, 79).m_171488_(-3.5f, -8.0f, -3.5f, 7.0f, 8.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-9.0f, (float)0.0f, (float)0.3927f, (float)0.0f, (float)0.0f));
        PartDefinition ring = fingerBase.m_171599_("ring", CubeListBuilder.m_171558_().m_171514_(0, 78).m_171488_(-3.5f, -9.0f, -3.5f, 7.0f, 9.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-4.0f, (float)-10.0f, (float)-4.0f, (float)0.3491f, (float)0.0f, (float)0.0f));
        PartDefinition ring2 = ring.m_171599_("ring2", CubeListBuilder.m_171558_().m_171514_(86, 30).m_171488_(-3.5f, -8.0f, -3.5f, 7.0f, 8.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-9.0f, (float)0.0f, (float)0.2618f, (float)0.0f, (float)0.0f));
        PartDefinition ring3 = ring2.m_171599_("ring3", CubeListBuilder.m_171558_().m_171514_(86, 45).m_171488_(-3.5f, -8.0f, -3.5f, 7.0f, 8.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-8.0f, (float)0.0f, (float)0.3927f, (float)0.0f, (float)0.0f));
        PartDefinition pinky = fingerBase.m_171599_("pinky", CubeListBuilder.m_171558_().m_171514_(56, 93).m_171488_(-3.5f, -7.0f, -3.5f, 7.0f, 7.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-12.0f, (float)-10.0f, (float)-4.0f, (float)0.2182f, (float)0.0f, (float)0.0f));
        PartDefinition pinky2 = pinky.m_171599_("pinky2", CubeListBuilder.m_171558_().m_171514_(0, 94).m_171488_(-3.5f, -7.0f, -3.5f, 7.0f, 7.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-7.0f, (float)0.0f, (float)0.3054f, (float)0.0f, (float)0.0f));
        PartDefinition pinky3 = pinky2.m_171599_("pinky3", CubeListBuilder.m_171558_().m_171514_(28, 94).m_171488_(-3.5f, -7.0f, -3.5f, 7.0f, 7.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-7.0f, (float)0.0f, (float)0.6545f, (float)0.0f, (float)0.0f));
        PartDefinition thumb = palm.m_171599_("thumb", CubeListBuilder.m_171558_().m_171514_(56, 40).m_171488_(-8.0f, -15.0f, -3.5f, 8.0f, 15.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)15.5f, (float)7.0f, (float)0.0f, (float)0.48f, (float)0.0f, (float)0.9599f));
        PartDefinition thumb2 = thumb.m_171599_("thumb2", CubeListBuilder.m_171558_().m_171514_(0, 58).m_171488_(-8.0f, -13.0f, -3.5f, 8.0f, 13.0f, 7.0f, new CubeDeformation(-0.001f)), PartPose.m_171423_((float)0.0f, (float)-15.0f, (float)0.0f, (float)0.3491f, (float)0.0f, (float)-0.5236f));
        PartDefinition ridingPos = palm.m_171599_("ridingPos", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)-5.0f, (float)4.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)128, (int)128);
    }

    public void m_7695_(PoseStack poseStack, VertexConsumer buffer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.model.getMainPart().render(poseStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.model.resetPoses();
        float partialTicks = ClientHandlers.getPartialTicks();
        this.anim.setVariable("head_x_rotation", () -> entity.m_146909_());
        if (((EntityHandonetta)entity).f_20919_ <= 0 && !((BaseMonster)entity).playDeath()) {
            this.anim.doAnimation((ExtendedModel)this, "idle", ((EntityHandonetta)entity).f_19797_, partialTicks);
        }
        this.anim.doAnimation((ExtendedModel)this, ((EntityHandonetta)entity).getAnimationHandler(), partialTicks);
    }

    public ModelPartHandler getHandler() {
        return this.model;
    }

    public boolean transform(T entity, EntityRenderer<T> entityRenderer, Entity rider, EntityRenderer<?> ridingEntityRenderer, PoseStack poseStack, int riderNum) {
        LivingEntityRenderer lR;
        EntityModel model;
        if (ridingEntityRenderer instanceof LivingEntityRenderer && ((model = (lR = (LivingEntityRenderer)ridingEntityRenderer).m_7200_()) instanceof HumanoidModel || model instanceof IllagerModel || model instanceof SittingModel)) {
            this.palm.translateAndRotate(poseStack);
            this.ridingPosition.translateAndRotate(poseStack);
            ClientHandlers.translateRider(entityRenderer, rider, model, poseStack);
            return true;
        }
        return false;
    }
}

