/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.client.model.monster;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import io.github.flemmli97.runecraftory.client.ClientHandlers;
import io.github.flemmli97.runecraftory.client.model.SittingModel;
import io.github.flemmli97.runecraftory.common.entities.BaseMonster;
import io.github.flemmli97.runecraftory.common.entities.monster.EntityHornet;
import io.github.flemmli97.tenshilib.api.entity.AnimatedAction;
import io.github.flemmli97.tenshilib.client.AnimationManager;
import io.github.flemmli97.tenshilib.client.model.BlockBenchAnimations;
import io.github.flemmli97.tenshilib.client.model.ExtendedModel;
import io.github.flemmli97.tenshilib.client.model.ModelPartHandler;
import io.github.flemmli97.tenshilib.client.model.RideableModel;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.IllagerModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;

public class ModelHornet<T extends EntityHornet>
extends EntityModel<T>
implements ExtendedModel,
RideableModel<T> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(new ResourceLocation("runecraftory", "hornet"), "main");
    protected final ModelPartHandler model;
    protected final BlockBenchAnimations anim;
    public ModelPartHandler.ModelPartExtended body;
    public ModelPartHandler.ModelPartExtended ridingPosition;

    public ModelHornet(ModelPart root) {
        this.model = new ModelPartHandler(root, "root");
        this.anim = AnimationManager.getInstance().getAnimation(new ResourceLocation("runecraftory", "hornet"));
        this.body = this.model.getPart("body");
        this.ridingPosition = this.model.getPart("ridingPos");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition body = partdefinition.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(0, 16).m_171488_(-3.0f, -3.5f, -5.0f, 6.0f, 6.0f, 9.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)14.5f, (float)-2.0f));
        PartDefinition head = body.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(21, 16).m_171488_(-2.0f, 0.0f, -4.0f, 4.0f, 5.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-3.0f, (float)-5.0f, (float)0.2618f, (float)0.0f, (float)0.0f));
        PartDefinition jawLeft = head.m_171599_("jawLeft", CubeListBuilder.m_171558_().m_171514_(0, 9).m_171488_(-1.0f, 0.0f, -2.0f, 1.0f, 1.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)1.5f, (float)4.0f, (float)-4.0f, (float)0.3927f, (float)0.3491f, (float)0.0f));
        PartDefinition jawRight = head.m_171599_("jawRight", CubeListBuilder.m_171558_().m_171514_(0, 6).m_171488_(0.0f, 0.0f, -2.0f, 1.0f, 1.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-1.5f, (float)4.0f, (float)-4.0f, (float)0.3927f, (float)-0.3491f, (float)0.0f));
        PartDefinition leftWing = body.m_171599_("leftWing", CubeListBuilder.m_171558_().m_171514_(0, 8).m_171488_(0.0f, 0.0f, 0.0f, 12.0f, 0.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)2.0f, (float)-3.5f, (float)-4.0f));
        PartDefinition rightWing = body.m_171599_("rightWing", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-12.0f, 0.0f, 0.0f, 12.0f, 0.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-2.0f, (float)-3.5f, (float)-4.0f));
        PartDefinition connector = body.m_171599_("connector", CubeListBuilder.m_171558_().m_171514_(0, 3).m_171488_(-1.0f, 0.0f, 0.0f, 2.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-1.0f, (float)4.0f, (float)-0.3491f, (float)0.0f, (float)0.0f));
        PartDefinition back = connector.m_171599_("back", CubeListBuilder.m_171558_().m_171514_(25, 26).m_171488_(-3.0f, -2.0f, 0.0f, 6.0f, 6.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)1.0f, (float)-0.0436f, (float)0.0f, (float)0.0f));
        PartDefinition back2 = back.m_171599_("back2", CubeListBuilder.m_171558_().m_171514_(0, 31).m_171488_(-2.5f, 0.0f, -1.0f, 5.0f, 5.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-1.5f, (float)5.0f, (float)-0.1745f, (float)0.0f, (float)0.0f));
        PartDefinition back3 = back2.m_171599_("back3", CubeListBuilder.m_171558_().m_171514_(32, 0).m_171488_(-2.0f, 0.0f, -1.0f, 4.0f, 4.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)0.5f, (float)2.0f, (float)-0.1745f, (float)0.0f, (float)0.0f));
        PartDefinition stinger = back3.m_171599_("stinger", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-0.5f, 0.0f, 0.0f, 1.0f, 1.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)1.5f, (float)2.0f));
        PartDefinition leg = body.m_171599_("leg", CubeListBuilder.m_171558_().m_171514_(26, 37).m_171488_(0.0f, -2.0f, -2.0f, 4.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)3.0f, (float)2.5f, (float)-2.5f, (float)0.0f, (float)0.0f, (float)-0.2618f));
        PartDefinition legMiddle = leg.m_171599_("legMiddle", CubeListBuilder.m_171558_().m_171514_(9, 41).m_171488_(0.0f, -1.0f, -1.5f, 4.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)4.0f, (float)-1.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)1.9199f));
        PartDefinition feet = legMiddle.m_171599_("feet", CubeListBuilder.m_171558_().m_171514_(42, 28).m_171488_(0.0f, -1.0f, -1.5f, 4.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)4.0f, (float)0.5f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.3927f));
        PartDefinition leg2 = body.m_171599_("leg2", CubeListBuilder.m_171558_().m_171514_(37, 19).m_171488_(0.0f, -2.0f, -2.0f, 4.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)3.0f, (float)2.5f, (float)0.5f, (float)0.0f, (float)0.0f, (float)-0.2618f));
        PartDefinition legMiddle2 = leg2.m_171599_("legMiddle2", CubeListBuilder.m_171558_().m_171514_(37, 40).m_171488_(0.0f, -1.0f, -1.5f, 4.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)4.0f, (float)-1.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)1.9199f));
        PartDefinition feet2 = legMiddle2.m_171599_("feet2", CubeListBuilder.m_171558_().m_171514_(28, 42).m_171488_(0.0f, -1.0f, -1.5f, 4.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)4.0f, (float)0.5f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.3927f));
        PartDefinition leg3 = body.m_171599_("leg3", CubeListBuilder.m_171558_().m_171514_(14, 37).m_171488_(0.0f, -2.0f, -2.0f, 4.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)3.0f, (float)2.5f, (float)3.5f, (float)0.0f, (float)0.0f, (float)-0.2618f));
        PartDefinition legMiddle3 = leg3.m_171599_("legMiddle3", CubeListBuilder.m_171558_().m_171514_(0, 39).m_171488_(0.0f, -1.0f, -1.5f, 4.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)4.0f, (float)-1.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)1.9199f));
        PartDefinition feet3 = legMiddle3.m_171599_("feet3", CubeListBuilder.m_171558_().m_171514_(42, 26).m_171488_(0.0f, -1.0f, -1.5f, 4.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)4.0f, (float)0.5f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.3927f));
        PartDefinition leg4 = body.m_171599_("leg4", CubeListBuilder.m_171558_().m_171514_(33, 15).m_171488_(-4.0f, -2.0f, -2.0f, 4.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-3.0f, (float)2.5f, (float)-2.5f, (float)0.0f, (float)0.0f, (float)0.2618f));
        PartDefinition legMiddle4 = leg4.m_171599_("legMiddle4", CubeListBuilder.m_171558_().m_171514_(38, 37).m_171488_(-4.0f, -1.0f, -1.5f, 4.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-4.0f, (float)-1.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-1.9199f));
        PartDefinition feet4 = legMiddle4.m_171599_("feet4", CubeListBuilder.m_171558_().m_171514_(42, 11).m_171488_(-4.0f, -1.0f, -1.5f, 4.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-4.0f, (float)0.5f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.3927f));
        PartDefinition leg5 = body.m_171599_("leg5", CubeListBuilder.m_171558_().m_171514_(32, 11).m_171488_(-4.0f, -2.0f, -2.0f, 4.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-3.0f, (float)2.5f, (float)0.5f, (float)0.0f, (float)0.0f, (float)0.2618f));
        PartDefinition legMiddle5 = leg5.m_171599_("legMiddle5", CubeListBuilder.m_171558_().m_171514_(37, 23).m_171488_(-4.0f, -1.0f, -1.5f, 4.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-4.0f, (float)-1.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-1.9199f));
        PartDefinition feet5 = legMiddle5.m_171599_("feet5", CubeListBuilder.m_171558_().m_171514_(42, 7).m_171488_(-4.0f, -1.0f, -1.5f, 4.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-4.0f, (float)0.5f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.3927f));
        PartDefinition leg6 = body.m_171599_("leg6", CubeListBuilder.m_171558_().m_171514_(32, 7).m_171488_(-4.0f, -2.0f, -2.0f, 4.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-3.0f, (float)2.5f, (float)3.5f, (float)0.0f, (float)0.0f, (float)0.2618f));
        PartDefinition legMiddle6 = leg6.m_171599_("legMiddle6", CubeListBuilder.m_171558_().m_171514_(13, 31).m_171488_(-4.0f, -1.0f, -1.5f, 4.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-4.0f, (float)-1.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-1.9199f));
        PartDefinition feet6 = legMiddle6.m_171599_("feet6", CubeListBuilder.m_171558_().m_171514_(19, 41).m_171488_(-4.0f, -1.0f, -1.5f, 4.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-4.0f, (float)0.5f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.3927f));
        PartDefinition ridingPos = body.m_171599_("ridingPos", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)-4.0f, (float)6.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public void m_7695_(PoseStack poseStack, VertexConsumer buffer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.model.getMainPart().render(poseStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.model.resetPoses();
        float partialTicks = ClientHandlers.getPartialTicks();
        AnimatedAction anim = ((EntityHornet)entity).getAnimationHandler().getAnimation();
        if (!(anim != null && anim.is(new AnimatedAction[]{((EntityHornet)entity).getSleepAnimation()}) || ((EntityHornet)entity).f_20919_ > 0 || ((BaseMonster)entity).playDeath())) {
            this.anim.doAnimation((ExtendedModel)this, "idle", ((EntityHornet)entity).f_19797_, partialTicks);
        }
        this.anim.doAnimation((ExtendedModel)this, ((EntityHornet)entity).getAnimationHandler(), partialTicks);
    }

    public ModelPartHandler getHandler() {
        return this.model;
    }

    public boolean transform(T entity, EntityRenderer<T> entityRenderer, Entity rider, EntityRenderer<?> ridingEntityRenderer, PoseStack poseStack, int riderNum) {
        LivingEntityRenderer lR;
        EntityModel model;
        if (ridingEntityRenderer instanceof LivingEntityRenderer && ((model = (lR = (LivingEntityRenderer)ridingEntityRenderer).m_7200_()) instanceof HumanoidModel || model instanceof IllagerModel || model instanceof SittingModel)) {
            this.body.translateAndRotate(poseStack);
            this.ridingPosition.translateAndRotate(poseStack);
            ClientHandlers.translateRider(entityRenderer, rider, model, poseStack);
            return true;
        }
        return false;
    }
}

