/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.client.model.monster;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import io.github.flemmli97.runecraftory.client.ClientHandlers;
import io.github.flemmli97.runecraftory.client.model.SittingModel;
import io.github.flemmli97.runecraftory.common.entities.BaseMonster;
import io.github.flemmli97.runecraftory.common.entities.monster.boss.EntityMarionetta;
import io.github.flemmli97.tenshilib.api.entity.AnimatedAction;
import io.github.flemmli97.tenshilib.client.AnimationManager;
import io.github.flemmli97.tenshilib.client.model.BlockBenchAnimations;
import io.github.flemmli97.tenshilib.client.model.ExtendedModel;
import io.github.flemmli97.tenshilib.client.model.ModelPartHandler;
import io.github.flemmli97.tenshilib.client.model.RideableModel;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.IllagerModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;

public class ModelMarionetta<T extends EntityMarionetta>
extends EntityModel<T>
implements ExtendedModel,
RideableModel<T> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(new ResourceLocation("runecraftory", "marionetta"), "main");
    protected final ModelPartHandler model;
    protected final BlockBenchAnimations anim;
    public ModelPartHandler.ModelPartExtended body;
    public ModelPartHandler.ModelPartExtended ridingPosition;

    public ModelMarionetta(ModelPart root) {
        this.model = new ModelPartHandler(root, "root");
        this.anim = AnimationManager.getInstance().getAnimation(new ResourceLocation("runecraftory", "marionetta"));
        this.body = this.model.getPart("body");
        this.ridingPosition = this.model.getPart("ridingPos");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition body = partdefinition.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(29, 31).m_171488_(-4.0f, -6.0f, -2.0f, 8.0f, 9.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)3.75f, (float)0.0f));
        PartDefinition head = body.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(0, 15).m_171488_(-4.0f, -7.0f, -4.0f, 8.0f, 7.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-6.0f, (float)0.0f));
        PartDefinition hairLeft = head.m_171599_("hairLeft", CubeListBuilder.m_171558_().m_171514_(19, 67).m_171488_(0.0f, 0.0f, -1.0f, 7.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)).m_171514_(30, 80).m_171488_(6.75f, 0.5f, -0.5f, 2.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)4.0f, (float)-7.0f, (float)1.0f, (float)0.0f, (float)0.0f, (float)0.6109f));
        PartDefinition hairRight = head.m_171599_("hairRight", CubeListBuilder.m_171558_().m_171514_(0, 72).m_171488_(-7.0f, 0.0f, -1.0f, 7.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)).m_171514_(30, 77).m_171488_(-8.75f, 0.5f, -0.5f, 2.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-4.0f, (float)-7.0f, (float)1.0f, (float)0.0f, (float)0.0f, (float)-0.6109f));
        PartDefinition hat = head.m_171599_("hat", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-6.0f, -2.0f, -6.0f, 12.0f, 2.0f, 12.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-6.5f, (float)0.0f));
        PartDefinition hatMiddle = hat.m_171599_("hatMiddle", CubeListBuilder.m_171558_().m_171514_(49, 0).m_171488_(-5.0f, -4.0f, -4.0f, 9.0f, 4.0f, 9.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.5f, (float)-2.0f, (float)-0.5f));
        PartDefinition hatTop = hatMiddle.m_171599_("hatTop", CubeListBuilder.m_171558_().m_171514_(0, 31).m_171488_(-4.0f, -4.0f, -3.0f, 7.0f, 4.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-4.0f, (float)0.0f));
        PartDefinition hatTopLeft = hatTop.m_171599_("hatTopLeft", CubeListBuilder.m_171558_().m_171514_(0, 67).m_171488_(0.0f, -2.0f, 0.0f, 7.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)3.0f, (float)-2.0f, (float)0.0f, (float)0.0f, (float)-0.2618f, (float)-0.6109f));
        PartDefinition hatTopLeftTip = hatTopLeft.m_171599_("hatTopLeftTip", CubeListBuilder.m_171558_().m_171514_(13, 82).m_171488_(0.0f, 0.0f, -1.0f, 6.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)7.0f, (float)-2.0f, (float)1.0f, (float)0.0f, (float)0.0f, (float)1.1345f));
        PartDefinition hatTopRight = hatTop.m_171599_("hatTopRight", CubeListBuilder.m_171558_().m_171514_(60, 56).m_171488_(-7.0f, -2.0f, 0.0f, 7.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-4.0f, (float)-2.0f, (float)0.0f, (float)0.0f, (float)0.2618f, (float)0.6109f));
        PartDefinition hatTopRightTip = hatTopRight.m_171599_("hatTopRightTip", CubeListBuilder.m_171558_().m_171514_(13, 77).m_171488_(-6.0f, 0.0f, -2.0f, 6.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-7.0f, (float)-2.0f, (float)2.0f, (float)0.0f, (float)0.0f, (float)-1.1345f));
        PartDefinition leftArm = body.m_171599_("leftArm", CubeListBuilder.m_171558_().m_171514_(17, 56).m_171488_(-1.5f, -2.25f, -2.0f, 4.0f, 4.0f, 4.0f, new CubeDeformation(0.0f)).m_171514_(47, 56).m_171488_(-1.0f, -2.0f, -1.5f, 3.0f, 7.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)5.0f, (float)-3.25f, (float)0.0f));
        PartDefinition leftArmDown = leftArm.m_171599_("leftArmDown", CubeListBuilder.m_171558_().m_171514_(0, 77).m_171488_(-1.5f, 0.0f, -3.0f, 3.0f, 6.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.5f, (float)5.0f, (float)1.5f));
        PartDefinition rightArm = body.m_171599_("rightArm", CubeListBuilder.m_171558_().m_171514_(0, 56).m_171488_(-2.5f, -2.25f, -2.0f, 4.0f, 4.0f, 4.0f, new CubeDeformation(0.0f)).m_171514_(34, 56).m_171488_(-2.0f, -2.0f, -1.5f, 3.0f, 7.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-5.0f, (float)-3.25f, (float)0.0f));
        PartDefinition rightArmDown = rightArm.m_171599_("rightArmDown", CubeListBuilder.m_171558_().m_171514_(38, 67).m_171488_(-1.5f, 0.0f, -3.0f, 3.0f, 6.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-0.5f, (float)5.0f, (float)1.5f));
        PartDefinition dressUp = body.m_171599_("dressUp", CubeListBuilder.m_171558_().m_171514_(70, 15).m_171488_(-5.0f, -2.0f, -3.0f, 10.0f, 3.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)5.0f, (float)0.0f));
        PartDefinition dressDown = dressUp.m_171599_("dressDown", CubeListBuilder.m_171558_().m_171514_(33, 15).m_171488_(-5.5f, 0.0f, -3.5f, 11.0f, 3.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)1.0f, (float)0.0f));
        PartDefinition clothBack = dressDown.m_171599_("clothBack", CubeListBuilder.m_171558_().m_171514_(19, 72).m_171488_(-4.5f, 0.0f, 0.0f, 9.0f, 3.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-3.0f, (float)3.0f, (float)0.2182f, (float)0.0f, (float)0.0f));
        PartDefinition clothBack2 = clothBack.m_171599_("clothBack2", CubeListBuilder.m_171558_().m_171514_(51, 45).m_171488_(-5.5f, 0.0f, 0.0f, 9.0f, 7.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)1.0f, (float)3.0f, (float)0.0f, (float)-0.2182f, (float)0.0f, (float)0.0f));
        PartDefinition leftLeg = dressDown.m_171599_("leftLeg", CubeListBuilder.m_171558_().m_171514_(34, 45).m_171488_(-1.9f, 0.0f, -2.0f, 4.0f, 6.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)1.9f, (float)2.25f, (float)0.0f));
        PartDefinition leftLegDown = leftLeg.m_171599_("leftLegDown", CubeListBuilder.m_171558_().m_171514_(17, 45).m_171488_(-2.0f, 0.0f, 0.0f, 4.0f, 6.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.1f, (float)6.0f, (float)-2.0f));
        PartDefinition rightLeg = dressDown.m_171599_("rightLeg", CubeListBuilder.m_171558_().m_171514_(0, 45).m_171488_(-2.1f, 0.0f, -2.0f, 4.0f, 6.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-1.9f, (float)2.25f, (float)0.0f));
        PartDefinition rightLegDown = rightLeg.m_171599_("rightLegDown", CubeListBuilder.m_171558_().m_171514_(54, 31).m_171488_(-2.0f, 0.0f, 0.0f, 4.0f, 6.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-0.1f, (float)6.0f, (float)-2.0f));
        PartDefinition ridingPos = body.m_171599_("ridingPos", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)3.0f, (float)6.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)128, (int)128);
    }

    public void m_7695_(PoseStack poseStack, VertexConsumer buffer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.model.getMainPart().render(poseStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.model.resetPoses();
        float partialTicks = ClientHandlers.getPartialTicks();
        if (((EntityMarionetta)entity).f_20919_ <= 0 && !((BaseMonster)entity).playDeath()) {
            this.anim.doAnimation((ExtendedModel)this, "idle", ((EntityMarionetta)entity).f_19797_, partialTicks);
            if (((BaseMonster)entity).moveTick() > 0) {
                this.anim.doAnimation((ExtendedModel)this, "walk", ((EntityMarionetta)entity).f_19797_, partialTicks, ((BaseMonster)entity).interpolatedMoveTick(partialTicks));
            }
        }
        this.anim.doAnimation((ExtendedModel)this, ((EntityMarionetta)entity).getAnimationHandler(), partialTicks, a -> false, a -> a.is(new AnimatedAction[]{EntityMarionetta.CHEST_ATTACK}) && entity.caughtTarget() ? "chest_attack_hit" : a.getClientIdentifier());
    }

    public ModelPartHandler getHandler() {
        return this.model;
    }

    public boolean transform(T entity, EntityRenderer<T> entityRenderer, Entity rider, EntityRenderer<?> ridingEntityRenderer, PoseStack poseStack, int riderNum) {
        LivingEntityRenderer lR;
        EntityModel model;
        if (ridingEntityRenderer instanceof LivingEntityRenderer && ((model = (lR = (LivingEntityRenderer)ridingEntityRenderer).m_7200_()) instanceof HumanoidModel || model instanceof IllagerModel || model instanceof SittingModel)) {
            this.body.translateAndRotate(poseStack);
            this.ridingPosition.translateAndRotate(poseStack);
            ClientHandlers.translateRider(entityRenderer, rider, model, poseStack);
            return true;
        }
        return false;
    }
}

