/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.client.model.monster;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import io.github.flemmli97.runecraftory.client.ClientHandlers;
import io.github.flemmli97.runecraftory.client.model.SittingModel;
import io.github.flemmli97.runecraftory.common.entities.BaseMonster;
import io.github.flemmli97.runecraftory.common.entities.monster.EntityMinotaur;
import io.github.flemmli97.tenshilib.client.AnimationManager;
import io.github.flemmli97.tenshilib.client.model.BlockBenchAnimations;
import io.github.flemmli97.tenshilib.client.model.ExtendedModel;
import io.github.flemmli97.tenshilib.client.model.ModelPartHandler;
import io.github.flemmli97.tenshilib.client.model.RideableModel;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.IllagerModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;

public class ModelMinotaur<T extends EntityMinotaur>
extends EntityModel<T>
implements ExtendedModel,
RideableModel<T> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(new ResourceLocation("runecraftory", "minotaur"), "main");
    protected final ModelPartHandler model;
    protected final BlockBenchAnimations anim;
    public ModelPartHandler.ModelPartExtended body;
    public ModelPartHandler.ModelPartExtended head;
    public ModelPartHandler.ModelPartExtended ridingPosition;

    public ModelMinotaur(ModelPart root) {
        this.model = new ModelPartHandler(root, "root");
        this.anim = AnimationManager.getInstance().getAnimation(new ResourceLocation("runecraftory", "minotaur"));
        this.body = this.model.getPart("body");
        this.head = this.model.getPart("head");
        this.ridingPosition = this.model.getPart("ridingPos");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition body = partdefinition.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(0, 19).m_171488_(-6.0f, -3.75f, -4.5f, 12.0f, 10.0f, 9.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)0.75f, (float)1.0f, (float)0.1745f, (float)0.0f, (float)0.0f));
        PartDefinition bodyUpper = body.m_171599_("bodyUpper", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-7.0f, -10.0f, -4.5f, 14.0f, 10.0f, 9.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-3.75f, (float)0.0f));
        PartDefinition head = bodyUpper.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(33, 29).m_171488_(-4.5f, -9.0f, -5.5f, 9.0f, 9.0f, 9.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-10.0f, (float)0.0f));
        PartDefinition earLeft = head.m_171599_("earLeft", CubeListBuilder.m_171558_().m_171514_(0, 4).m_171488_(-2.5f, -1.0f, -1.0f, 2.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-4.0f, (float)-8.0f, (float)-3.5f, (float)0.0873f, (float)0.0f, (float)0.0f));
        PartDefinition earRight = head.m_171599_("earRight", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(0.5f, -1.0f, -1.0f, 2.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)4.0f, (float)-8.0f, (float)-3.5f, (float)0.0873f, (float)0.0f, (float)0.0f));
        PartDefinition headFront = head.m_171599_("headFront", CubeListBuilder.m_171558_().m_171514_(80, 61).m_171488_(-2.75f, -2.0f, -4.0f, 5.0f, 4.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.25f, (float)-2.0f, (float)-5.5f));
        PartDefinition leftHorn = head.m_171599_("leftHorn", CubeListBuilder.m_171558_().m_171514_(37, 0).m_171488_(-1.0f, -3.0f, -1.0f, 6.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)4.0f, (float)-7.0f, (float)-1.0f, (float)0.0f, (float)0.0f, (float)-0.6109f));
        PartDefinition leftHorn2 = leftHorn.m_171599_("leftHorn2", CubeListBuilder.m_171558_().m_171514_(65, 61).m_171488_(-1.0f, -1.0f, -1.0f, 6.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)5.0f, (float)-2.0f, (float)0.5f, (float)0.0f, (float)0.3054f, (float)-0.1309f));
        PartDefinition rightHorn = head.m_171599_("rightHorn", CubeListBuilder.m_171558_().m_171514_(33, 21).m_171488_(-5.0f, -3.0f, -1.0f, 6.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-4.0f, (float)-7.0f, (float)-1.0f, (float)0.0f, (float)0.0f, (float)0.6109f));
        PartDefinition rightHorn2 = rightHorn.m_171599_("rightHorn2", CubeListBuilder.m_171558_().m_171514_(43, 47).m_171488_(-5.0f, -1.0f, -1.0f, 6.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-5.0f, (float)-2.0f, (float)0.5f, (float)0.0f, (float)-0.3054f, (float)0.1309f));
        PartDefinition handLeftUp = bodyUpper.m_171599_("handLeftUp", CubeListBuilder.m_171558_().m_171514_(60, 16).m_171488_(0.0f, -2.0f, -4.5f, 5.0f, 10.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)7.0f, (float)-3.0f, (float)2.0f, (float)-0.2618f, (float)0.0f, (float)-0.48f));
        PartDefinition handLeftDown = handLeftUp.m_171599_("handLeftDown", CubeListBuilder.m_171558_().m_171514_(70, 31).m_171488_(-2.0f, 0.0f, -4.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)2.5f, (float)8.0f, (float)0.0f, (float)-0.4363f, (float)0.2618f, (float)0.2618f));
        PartDefinition handRightUp = bodyUpper.m_171599_("handRightUp", CubeListBuilder.m_171558_().m_171514_(8, 60).m_171488_(-5.0f, -2.0f, -4.5f, 5.0f, 10.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-7.0f, (float)-3.0f, (float)2.0f, (float)-0.2618f, (float)0.0f, (float)0.48f));
        PartDefinition handRightDown = handRightUp.m_171599_("handRightDown", CubeListBuilder.m_171558_().m_171514_(68, 67).m_171488_(-2.0f, 0.0f, -4.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-2.5f, (float)8.0f, (float)0.0f, (float)-0.4363f, (float)-0.2618f, (float)-0.2618f));
        PartDefinition axe = handRightDown.m_171599_("axe", CubeListBuilder.m_171558_().m_171514_(0, 38).m_171488_(-1.0f, -10.0f, -1.0f, 2.0f, 38.0f, 2.0f, new CubeDeformation(0.0f)).m_171514_(20, 38).m_171488_(-1.0f, 20.0f, -6.0f, 2.0f, 4.0f, 4.0f, new CubeDeformation(0.025f)).m_171514_(58, 78).m_171488_(-1.0f, 18.0f, -2.0f, 2.0f, 8.0f, 5.0f, new CubeDeformation(0.025f)).m_171514_(8, 38).m_171488_(-1.0f, 15.0f, 3.0f, 2.0f, 14.0f, 8.0f, new CubeDeformation(0.025f)).m_171514_(22, 81).m_171488_(-1.0f, 16.0f, 11.0f, 2.0f, 12.0f, 1.0f, new CubeDeformation(0.025f)).m_171514_(69, 51).m_171488_(-0.5f, 14.0f, 2.0f, 1.0f, 1.0f, 9.0f, new CubeDeformation(0.025f)).m_171514_(65, 4).m_171488_(-0.5f, 29.0f, 2.0f, 1.0f, 1.0f, 9.0f, new CubeDeformation(0.025f)).m_171514_(5, 7).m_171488_(-0.5f, 15.0f, 11.0f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.025f)).m_171514_(5, 3).m_171488_(-0.5f, 29.0f, 11.0f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.025f)).m_171514_(28, 81).m_171488_(-0.5f, 16.0f, 12.0f, 1.0f, 12.0f, 1.0f, new CubeDeformation(0.025f)), PartPose.m_171423_((float)0.0f, (float)10.0f, (float)-2.0f, (float)-1.5708f, (float)0.0f, (float)0.0f));
        PartDefinition ridingPos = bodyUpper.m_171599_("ridingPos", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)-10.0f, (float)6.0f));
        PartDefinition tailBase = body.m_171599_("tailBase", CubeListBuilder.m_171558_().m_171514_(28, 47).m_171488_(-1.0f, 0.0f, 0.0f, 2.0f, 2.0f, 11.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)2.25f, (float)4.5f, (float)-0.6981f, (float)0.0f, (float)0.0f));
        PartDefinition tailMiddle = tailBase.m_171599_("tailMiddle", CubeListBuilder.m_171558_().m_171514_(35, 8).m_171488_(-1.0f, -2.0f, 0.0f, 2.0f, 2.0f, 11.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)2.0f, (float)11.0f, (float)0.5672f, (float)0.0f, (float)0.0f));
        PartDefinition tailTip = tailMiddle.m_171599_("tailTip", CubeListBuilder.m_171558_().m_171514_(43, 60).m_171488_(-1.0f, -2.0f, 0.0f, 2.0f, 2.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)10.5f, (float)0.1745f, (float)0.0f, (float)0.0f));
        PartDefinition legLeftUp = body.m_171599_("legLeftUp", CubeListBuilder.m_171558_().m_171514_(54, 47).m_171488_(-2.0f, -2.0f, -3.0f, 6.0f, 7.0f, 6.0f, new CubeDeformation(0.0f)).m_171514_(43, 71).m_171488_(-1.5f, 5.0f, -2.5f, 5.0f, 5.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)3.5f, (float)4.25f, (float)0.0f, (float)-0.5236f, (float)0.0f, (float)0.0f));
        PartDefinition legLeftDown = legLeftUp.m_171599_("legLeftDown", CubeListBuilder.m_171558_().m_171514_(50, 60).m_171488_(-2.0f, 0.0f, 0.0f, 4.0f, 4.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)1.0f, (float)10.0f, (float)-2.0f));
        PartDefinition legLeftDown2 = legLeftDown.m_171599_("legLeftDown2", CubeListBuilder.m_171558_().m_171514_(80, 47).m_171488_(-2.0f, -1.0f, 0.0f, 4.0f, 7.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)1.0f, (float)7.0f));
        PartDefinition legLeftDown3 = legLeftDown2.m_171599_("legLeftDown3", CubeListBuilder.m_171558_().m_171514_(76, 0).m_171488_(-1.5f, 0.0f, -6.0f, 4.0f, 2.0f, 6.0f, new CubeDeformation(0.025f)), PartPose.m_171423_((float)-0.5f, (float)4.0f, (float)4.0f, (float)0.3491f, (float)0.0f, (float)0.0f));
        PartDefinition legRightUp = body.m_171599_("legRightUp", CubeListBuilder.m_171558_().m_171514_(50, 0).m_171488_(-4.0f, -2.0f, -3.0f, 6.0f, 7.0f, 6.0f, new CubeDeformation(0.0f)).m_171514_(23, 71).m_171488_(-3.5f, 5.0f, -2.5f, 5.0f, 5.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-3.5f, (float)4.25f, (float)0.0f, (float)-0.5236f, (float)0.0f, (float)0.0f));
        PartDefinition legRightDown = legRightUp.m_171599_("legRightDown", CubeListBuilder.m_171558_().m_171514_(28, 60).m_171488_(-2.0f, 0.0f, 0.0f, 4.0f, 4.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-1.0f, (float)10.0f, (float)-2.0f));
        PartDefinition legRightDown2 = legRightDown.m_171599_("legRightDown2", CubeListBuilder.m_171558_().m_171514_(80, 14).m_171488_(-2.0f, -1.0f, 0.0f, 4.0f, 7.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)1.0f, (float)7.0f));
        PartDefinition legRightDown3 = legRightDown2.m_171599_("legRightDown3", CubeListBuilder.m_171558_().m_171514_(2, 75).m_171488_(-2.5f, 0.0f, -6.0f, 4.0f, 2.0f, 6.0f, new CubeDeformation(0.025f)), PartPose.m_171423_((float)0.5f, (float)4.0f, (float)4.0f, (float)0.3491f, (float)0.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)128, (int)128);
    }

    public void m_7695_(PoseStack poseStack, VertexConsumer buffer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.model.getMainPart().render(poseStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.model.resetPoses();
        this.head.yRot += netHeadYaw % 360.0f * ((float)Math.PI / 180) * 0.5f;
        this.head.xRot += headPitch * ((float)Math.PI / 180) * 0.5f;
        float partialTicks = ClientHandlers.getPartialTicks();
        if (((EntityMinotaur)entity).f_20919_ <= 0 && !((BaseMonster)entity).playDeath()) {
            this.anim.doAnimation((ExtendedModel)this, "idle", ((EntityMinotaur)entity).f_19797_, partialTicks);
            if (((BaseMonster)entity).moveTick() > 0) {
                this.anim.doAnimation((ExtendedModel)this, "walk", ((EntityMinotaur)entity).f_19797_, partialTicks, ((BaseMonster)entity).interpolatedMoveTick(partialTicks));
            }
        }
        this.anim.doAnimation((ExtendedModel)this, ((EntityMinotaur)entity).getAnimationHandler(), partialTicks);
    }

    public ModelPartHandler getHandler() {
        return this.model;
    }

    public boolean transform(T entity, EntityRenderer<T> entityRenderer, Entity rider, EntityRenderer<?> ridingEntityRenderer, PoseStack poseStack, int riderNum) {
        LivingEntityRenderer lR;
        EntityModel model;
        if (ridingEntityRenderer instanceof LivingEntityRenderer && ((model = (lR = (LivingEntityRenderer)ridingEntityRenderer).m_7200_()) instanceof HumanoidModel || model instanceof IllagerModel || model instanceof SittingModel)) {
            this.body.translateAndRotate(poseStack);
            this.ridingPosition.translateAndRotate(poseStack);
            ClientHandlers.translateRider(entityRenderer, rider, model, poseStack);
            return true;
        }
        return false;
    }
}

