/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.client.model.monster;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import io.github.flemmli97.runecraftory.client.ClientHandlers;
import io.github.flemmli97.runecraftory.client.model.SittingModel;
import io.github.flemmli97.runecraftory.common.entities.BaseMonster;
import io.github.flemmli97.runecraftory.common.entities.monster.EntityOrc;
import io.github.flemmli97.tenshilib.client.AnimationManager;
import io.github.flemmli97.tenshilib.client.model.BlockBenchAnimations;
import io.github.flemmli97.tenshilib.client.model.ExtendedModel;
import io.github.flemmli97.tenshilib.client.model.IItemArmModel;
import io.github.flemmli97.tenshilib.client.model.ModelPartHandler;
import io.github.flemmli97.tenshilib.client.model.RideableModel;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.IllagerModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.HumanoidArm;

public class ModelOrc<T extends EntityOrc>
extends EntityModel<T>
implements ExtendedModel,
RideableModel<T>,
IItemArmModel,
SittingModel {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(new ResourceLocation("runecraftory", "orc"), "main");
    protected final ModelPartHandler model;
    protected final BlockBenchAnimations anim;
    public ModelPartHandler.ModelPartExtended body;
    public ModelPartHandler.ModelPartExtended head;
    public ModelPartHandler.ModelPartExtended handLeftUp;
    public ModelPartHandler.ModelPartExtended handLeftDown;
    public ModelPartHandler.ModelPartExtended handRightUp;
    public ModelPartHandler.ModelPartExtended handRightDown;
    public ModelPartHandler.ModelPartExtended ridingPosition;

    public ModelOrc(ModelPart root) {
        this.model = new ModelPartHandler(root, "root");
        this.anim = AnimationManager.getInstance().getAnimation(new ResourceLocation("runecraftory", "orc"));
        this.body = this.model.getPart("body");
        this.head = this.model.getPart("head");
        this.handLeftUp = this.model.getPart("handLeftUp");
        this.handLeftDown = this.model.getPart("handLeftDown");
        this.handRightUp = this.model.getPart("handRightUp");
        this.handRightDown = this.model.getPart("handRightDown");
        this.ridingPosition = this.model.getPart("ridingPos");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition body = partdefinition.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(34, 0).m_171488_(-5.0f, -11.0f, -4.0f, 10.0f, 18.0f, 7.0f, new CubeDeformation(0.0f)).m_171514_(0, 0).m_171488_(-5.0f, -11.0f, -4.0f, 10.0f, 18.0f, 7.0f, new CubeDeformation(0.2f)), PartPose.m_171423_((float)0.5f, (float)6.5f, (float)1.0f, (float)0.1745f, (float)0.0f, (float)0.0f));
        PartDefinition head = body.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(0, 25).m_171488_(-4.5f, -9.0f, -4.5f, 9.0f, 9.0f, 9.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-10.0f, (float)-0.5f));
        PartDefinition earLeft = head.m_171599_("earLeft", CubeListBuilder.m_171558_().m_171514_(8, 64).m_171480_().m_171488_(-1.5f, -3.0f, -1.0f, 3.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)-3.0f, (float)-9.0f, (float)-2.5f, (float)0.0873f, (float)0.0f, (float)0.0f));
        PartDefinition earRight = head.m_171599_("earRight", CubeListBuilder.m_171558_().m_171514_(8, 64).m_171488_(-1.5f, -3.0f, -1.0f, 3.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)3.0f, (float)-9.0f, (float)-2.5f, (float)0.0873f, (float)0.0f, (float)0.0f));
        PartDefinition headFront = head.m_171599_("headFront", CubeListBuilder.m_171558_().m_171514_(32, 54).m_171488_(-2.75f, -2.25f, -4.0f, 5.0f, 4.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.25f, (float)-1.75f, (float)-2.5f));
        PartDefinition handLeftUp = body.m_171599_("handLeftUp", CubeListBuilder.m_171558_().m_171514_(16, 43).m_171488_(0.0f, -2.0f, -3.0f, 4.0f, 7.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)5.0f, (float)-4.0f, (float)0.5f, (float)-1.0472f, (float)-0.5236f, (float)-0.0873f));
        PartDefinition handLeftDown = handLeftUp.m_171599_("handLeftDown", CubeListBuilder.m_171558_().m_171514_(52, 25).m_171488_(-4.0f, 0.0f, -4.0f, 4.0f, 9.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)4.0f, (float)5.0f, (float)1.0f, (float)-0.4363f, (float)0.2618f, (float)0.2618f));
        PartDefinition leftItem = handLeftDown.m_171599_("leftItem", CubeListBuilder.m_171558_(), PartPose.m_171423_((float)-1.5f, (float)9.0f, (float)-3.0f, (float)-1.5708f, (float)0.0f, (float)0.0f));
        PartDefinition handRightUp = body.m_171599_("handRightUp", CubeListBuilder.m_171558_().m_171514_(0, 43).m_171488_(-4.0f, -2.0f, -3.0f, 4.0f, 7.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-5.0f, (float)-4.0f, (float)0.5f, (float)-1.0472f, (float)0.5236f, (float)0.0873f));
        PartDefinition handRightDown = handRightUp.m_171599_("handRightDown", CubeListBuilder.m_171558_().m_171514_(36, 25).m_171488_(0.0f, 0.0f, -4.0f, 4.0f, 9.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-4.0f, (float)5.0f, (float)1.0f, (float)-0.4363f, (float)-0.2618f, (float)-0.2618f));
        PartDefinition rightItem = handRightDown.m_171599_("rightItem", CubeListBuilder.m_171558_(), PartPose.m_171423_((float)2.5f, (float)9.0f, (float)-3.0f, (float)-1.5708f, (float)0.0f, (float)0.0f));
        PartDefinition legLeftUp = body.m_171599_("legLeftUp", CubeListBuilder.m_171558_().m_171514_(16, 54).m_171488_(-2.0f, 0.0f, -3.0f, 4.0f, 6.0f, 4.0f, new CubeDeformation(0.0f)).m_171514_(0, 64).m_171488_(-2.0f, 2.0f, -3.25f, 4.0f, 4.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)2.5f, (float)7.0f, (float)0.5f, (float)-0.5236f, (float)0.0f, (float)0.0f));
        PartDefinition legLeftDown = legLeftUp.m_171599_("legLeftDown", CubeListBuilder.m_171558_().m_171514_(0, 54).m_171488_(-2.6f, 0.0f, 0.0f, 4.0f, 6.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.6f, (float)6.0f, (float)-3.0f, (float)0.3491f, (float)0.0f, (float)0.0f));
        PartDefinition legRightUp = body.m_171599_("legRightUp", CubeListBuilder.m_171558_().m_171514_(48, 43).m_171488_(-1.8f, 0.0f, -3.0f, 4.0f, 6.0f, 4.0f, new CubeDeformation(0.0f)).m_171514_(32, 60).m_171488_(-1.8f, 2.0f, -3.25f, 4.0f, 4.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-2.7f, (float)7.0f, (float)0.5f, (float)-0.5236f, (float)0.0f, (float)0.0f));
        PartDefinition legRightDown = legRightUp.m_171599_("legRightDown", CubeListBuilder.m_171558_().m_171514_(32, 43).m_171488_(-1.4f, 0.0f, 0.0f, 4.0f, 6.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-0.4f, (float)6.0f, (float)-3.0f, (float)0.3491f, (float)0.0f, (float)0.0f));
        PartDefinition ridingPos = body.m_171599_("ridingPos", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)6.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)128, (int)128);
    }

    public void m_7695_(PoseStack poseStack, VertexConsumer buffer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.model.getMainPart().render(poseStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.model.resetPoses();
        this.head.yRot += netHeadYaw % 360.0f * ((float)Math.PI / 180) * 0.5f;
        this.head.xRot += headPitch * ((float)Math.PI / 180) * 0.5f;
        float partialTicks = ClientHandlers.getPartialTicks();
        if (((EntityOrc)entity).f_20919_ <= 0 && !((BaseMonster)entity).playDeath()) {
            this.anim.doAnimation((ExtendedModel)this, "idle", ((EntityOrc)entity).f_19797_, partialTicks);
            if (((BaseMonster)entity).moveTick() > 0) {
                this.anim.doAnimation((ExtendedModel)this, "walk", ((EntityOrc)entity).f_19797_, partialTicks, ((BaseMonster)entity).interpolatedMoveTick(partialTicks));
            }
        }
        if (this.f_102609_) {
            this.anim.doAnimation((ExtendedModel)this, "sit", ((EntityOrc)entity).f_19797_, partialTicks);
        }
        this.anim.doAnimation((ExtendedModel)this, ((EntityOrc)entity).getAnimationHandler(), partialTicks);
    }

    public ModelPartHandler getHandler() {
        return this.model;
    }

    public void transform(HumanoidArm humanoidArm, PoseStack poseStack) {
        this.body.translateAndRotate(poseStack);
        if (humanoidArm == HumanoidArm.LEFT) {
            this.handLeftUp.translateAndRotate(poseStack);
            this.handLeftDown.translateAndRotate(poseStack);
            poseStack.m_85837_(-0.125, 0.5, -0.25);
        } else {
            this.handRightUp.translateAndRotate(poseStack);
            this.handRightDown.translateAndRotate(poseStack);
            poseStack.m_85837_(0.125, 0.5, -0.25);
        }
    }

    public void postTransform(boolean leftSide, PoseStack stack) {
    }

    public boolean transform(T entity, EntityRenderer<T> entityRenderer, Entity rider, EntityRenderer<?> ridingEntityRenderer, PoseStack poseStack, int riderNum) {
        LivingEntityRenderer lR;
        EntityModel model;
        if (ridingEntityRenderer instanceof LivingEntityRenderer && ((model = (lR = (LivingEntityRenderer)ridingEntityRenderer).m_7200_()) instanceof HumanoidModel || model instanceof IllagerModel || model instanceof SittingModel)) {
            this.body.translateAndRotate(poseStack);
            this.ridingPosition.translateAndRotate(poseStack);
            ClientHandlers.translateRider(entityRenderer, rider, model, poseStack);
            return true;
        }
        return false;
    }

    @Override
    public void translateSittingPosition(PoseStack stack) {
        stack.m_85837_(0.0, 0.25, 0.0);
    }
}

