/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.client.model.monster;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import io.github.flemmli97.runecraftory.client.ClientHandlers;
import io.github.flemmli97.runecraftory.client.model.SittingModel;
import io.github.flemmli97.runecraftory.common.entities.BaseMonster;
import io.github.flemmli97.runecraftory.common.entities.monster.EntityPalmCat;
import io.github.flemmli97.tenshilib.client.AnimationManager;
import io.github.flemmli97.tenshilib.client.model.BlockBenchAnimations;
import io.github.flemmli97.tenshilib.client.model.ExtendedModel;
import io.github.flemmli97.tenshilib.client.model.ModelPartHandler;
import io.github.flemmli97.tenshilib.client.model.RideableModel;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.IllagerModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;

public class ModelPalmCat<T extends EntityPalmCat>
extends EntityModel<T>
implements ExtendedModel,
RideableModel<T> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(new ResourceLocation("runecraftory", "palm_cat"), "main");
    protected final ModelPartHandler model;
    protected final BlockBenchAnimations anim;
    public ModelPartHandler.ModelPartExtended body;
    public ModelPartHandler.ModelPartExtended head;
    public ModelPartHandler.ModelPartExtended ridingPosition;

    public ModelPalmCat(ModelPart root) {
        this.model = new ModelPartHandler(root, "root");
        this.anim = AnimationManager.getInstance().getAnimation(new ResourceLocation("runecraftory", "palm_cat"));
        this.body = this.model.getPart("body");
        this.head = this.model.getPart("head");
        this.ridingPosition = this.model.getPart("ridingPos");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition body = partdefinition.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(21, 0).m_171488_(-4.0f, -3.25f, -2.0f, 8.0f, 1.0f, 4.0f, new CubeDeformation(0.25f)).m_171514_(24, 24).m_171488_(-4.0f, -3.25f, -2.0f, 8.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)4.25f, (float)0.0f));
        PartDefinition tail = body.m_171599_("tail", CubeListBuilder.m_171558_().m_171514_(0, 38).m_171488_(-1.5f, -1.5f, 0.0f, 3.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)6.75f, (float)2.0f));
        PartDefinition head = body.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(0, 14).m_171488_(-3.5f, -7.0f, -3.5f, 7.0f, 7.0f, 7.0f, new CubeDeformation(0.0f)).m_171514_(0, 0).m_171488_(-3.5f, -7.0f, -3.5f, 7.0f, 7.0f, 7.0f, new CubeDeformation(0.25f)), PartPose.m_171419_((float)0.0f, (float)-3.25f, (float)0.0f));
        PartDefinition earsLeft = head.m_171599_("earsLeft", CubeListBuilder.m_171558_().m_171514_(0, 44).m_171488_(-0.5f, 0.0f, -2.0f, 5.0f, 2.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)3.5f, (float)-5.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.5236f));
        PartDefinition earsLeft2 = earsLeft.m_171599_("earsLeft2", CubeListBuilder.m_171558_().m_171514_(38, 42).m_171488_(0.0f, -2.0f, -2.0f, 5.0f, 2.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)4.5f, (float)2.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.2182f));
        PartDefinition earsRight = head.m_171599_("earsRight", CubeListBuilder.m_171558_().m_171514_(24, 40).m_171488_(-5.0f, 0.0f, -2.0f, 5.0f, 2.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-3.5f, (float)-5.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.5236f));
        PartDefinition earsRight2 = earsRight.m_171599_("earsRight2", CubeListBuilder.m_171558_().m_171514_(36, 16).m_171488_(-5.0f, -2.0f, -2.0f, 5.0f, 2.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-5.0f, (float)2.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.2182f));
        PartDefinition leftArm = body.m_171599_("leftArm", CubeListBuilder.m_171558_().m_171514_(48, 0).m_171488_(0.0f, -2.0f, -1.5f, 3.0f, 6.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)4.0f, (float)-0.25f, (float)0.0f));
        PartDefinition leftArm2 = leftArm.m_171599_("leftArm2", CubeListBuilder.m_171558_().m_171514_(12, 36).m_171488_(-2.0f, 0.0f, -2.0f, 4.0f, 4.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)1.5f, (float)4.0f, (float)0.0f));
        PartDefinition leftClaws = leftArm2.m_171599_("leftClaws", CubeListBuilder.m_171558_().m_171514_(27, 46).m_171488_(-2.0f, 0.0f, -2.0f, 2.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(46, 13).m_171488_(-2.0f, 0.0f, 1.0f, 2.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(44, 22).m_171488_(-2.0f, 0.0f, -0.5f, 2.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)2.0f, (float)4.0f, (float)0.0f));
        PartDefinition rightArm = body.m_171599_("rightArm", CubeListBuilder.m_171558_().m_171514_(18, 46).m_171488_(-3.0f, -2.0f, -1.5f, 3.0f, 6.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-4.0f, (float)-0.25f, (float)0.0f));
        PartDefinition rightArm2 = rightArm.m_171599_("rightArm2", CubeListBuilder.m_171558_().m_171514_(36, 5).m_171488_(-2.0f, 0.0f, -2.0f, 4.0f, 4.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-1.5f, (float)4.0f, (float)0.0f));
        PartDefinition rightClaws = rightArm2.m_171599_("rightClaws", CubeListBuilder.m_171558_().m_171514_(40, 13).m_171488_(0.0f, 0.0f, -2.0f, 2.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(0, 18).m_171488_(0.0f, 0.0f, 1.0f, 2.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(0, 4).m_171488_(0.0f, 0.0f, -0.5f, 2.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-2.0f, (float)4.0f, (float)0.0f));
        PartDefinition leftLeg = body.m_171599_("leftLeg", CubeListBuilder.m_171558_().m_171514_(30, 48).m_171488_(-1.5f, 0.0f, -1.5f, 3.0f, 5.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)2.0f, (float)8.75f, (float)0.0f));
        PartDefinition leftLegDown = leftLeg.m_171599_("leftLegDown", CubeListBuilder.m_171558_().m_171514_(0, 28).m_171488_(-2.0f, 0.0f, -0.5f, 4.0f, 6.0f, 4.0f, new CubeDeformation(0.0f)).m_171514_(12, 28).m_171488_(-2.0f, 0.0f, -1.5f, 4.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(14, 44).m_171488_(1.0f, 4.0f, -2.5f, 1.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)).m_171514_(41, 0).m_171488_(-0.5f, 4.0f, -2.5f, 1.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)).m_171514_(16, 31).m_171488_(-2.0f, 4.0f, -2.5f, 1.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)5.0f, (float)-1.5f));
        PartDefinition rightLeg = body.m_171599_("rightLeg", CubeListBuilder.m_171558_().m_171514_(48, 22).m_171488_(-1.5f, 0.0f, -1.5f, 3.0f, 5.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-2.0f, (float)8.75f, (float)0.0f));
        PartDefinition rightLegDown = rightLeg.m_171599_("rightLegDown", CubeListBuilder.m_171558_().m_171514_(24, 10).m_171488_(-2.0f, 0.0f, -0.5f, 4.0f, 6.0f, 4.0f, new CubeDeformation(0.0f)).m_171514_(28, 5).m_171488_(-2.0f, 0.0f, -1.5f, 4.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(28, 20).m_171488_(1.05f, 4.0f, -2.5f, 1.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)).m_171514_(0, 14).m_171488_(-0.45f, 4.0f, -2.5f, 1.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)).m_171514_(0, 0).m_171488_(-1.95f, 4.0f, -2.5f, 1.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)5.0f, (float)-1.5f));
        PartDefinition ridingPos = body.m_171599_("ridingPos", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)4.0f, (float)4.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public void m_7695_(PoseStack poseStack, VertexConsumer buffer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.model.getMainPart().render(poseStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.model.resetPoses();
        this.head.yRot += netHeadYaw % 360.0f * ((float)Math.PI / 180) * 0.5f;
        this.head.xRot += headPitch * ((float)Math.PI / 180) * 0.5f;
        float partialTicks = ClientHandlers.getPartialTicks();
        if (((EntityPalmCat)entity).f_20919_ <= 0 && !((BaseMonster)entity).playDeath()) {
            this.anim.doAnimation((ExtendedModel)this, "idle", ((EntityPalmCat)entity).f_19797_, partialTicks);
            if (((BaseMonster)entity).moveTick() > 0) {
                if (((BaseMonster)entity).getMoveFlag() == BaseMonster.MoveType.RUN) {
                    this.anim.doAnimation((ExtendedModel)this, "run", ((EntityPalmCat)entity).f_19797_, partialTicks, ((BaseMonster)entity).interpolatedMoveTick(partialTicks));
                } else {
                    this.anim.doAnimation((ExtendedModel)this, "walk", ((EntityPalmCat)entity).f_19797_, partialTicks, ((BaseMonster)entity).interpolatedMoveTick(partialTicks));
                }
            }
        }
        this.anim.doAnimation((ExtendedModel)this, ((EntityPalmCat)entity).getAnimationHandler(), partialTicks);
    }

    public ModelPartHandler getHandler() {
        return this.model;
    }

    public boolean transform(T entity, EntityRenderer<T> entityRenderer, Entity rider, EntityRenderer<?> ridingEntityRenderer, PoseStack poseStack, int riderNum) {
        LivingEntityRenderer lR;
        EntityModel model;
        if (ridingEntityRenderer instanceof LivingEntityRenderer && ((model = (lR = (LivingEntityRenderer)ridingEntityRenderer).m_7200_()) instanceof HumanoidModel || model instanceof IllagerModel || model instanceof SittingModel)) {
            this.body.translateAndRotate(poseStack);
            this.ridingPosition.translateAndRotate(poseStack);
            ClientHandlers.translateRider(entityRenderer, rider, model, poseStack);
            return true;
        }
        return false;
    }
}

