/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.client.model.monster;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import io.github.flemmli97.runecraftory.client.ClientHandlers;
import io.github.flemmli97.runecraftory.client.model.SittingModel;
import io.github.flemmli97.runecraftory.common.entities.BaseMonster;
import io.github.flemmli97.runecraftory.common.entities.monster.EntityPanther;
import io.github.flemmli97.tenshilib.client.AnimationManager;
import io.github.flemmli97.tenshilib.client.model.BlockBenchAnimations;
import io.github.flemmli97.tenshilib.client.model.ExtendedModel;
import io.github.flemmli97.tenshilib.client.model.ModelPartHandler;
import io.github.flemmli97.tenshilib.client.model.RideableModel;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.IllagerModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;

public class ModelPanther<T extends EntityPanther>
extends EntityModel<T>
implements ExtendedModel,
RideableModel<T> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(new ResourceLocation("runecraftory", "panther"), "main");
    protected final ModelPartHandler model;
    protected final BlockBenchAnimations anim;
    public ModelPartHandler.ModelPartExtended body;
    public ModelPartHandler.ModelPartExtended ridingPosition;

    public ModelPanther(ModelPart root) {
        this.model = new ModelPartHandler(root, "root");
        this.anim = AnimationManager.getInstance().getAnimation(new ResourceLocation("runecraftory", "panther"));
        this.body = this.model.getPart("body");
        this.ridingPosition = this.model.getPart("ridingPos");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition body = partdefinition.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-6.0f, -7.0f, -11.0f, 12.0f, 13.0f, 25.0f, new CubeDeformation(0.0f)).m_171514_(12, 103).m_171488_(0.0f, -10.0f, -9.0f, 0.0f, 3.0f, 6.0f, new CubeDeformation(0.0f)).m_171514_(0, 103).m_171488_(0.0f, -10.0f, -1.0f, 0.0f, 3.0f, 6.0f, new CubeDeformation(0.0f)).m_171514_(84, 94).m_171488_(0.0f, -10.0f, 8.0f, 0.0f, 3.0f, 6.0f, new CubeDeformation(0.0f)).m_171514_(48, 53).m_171488_(-5.0f, -6.0f, 14.0f, 10.0f, 11.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)3.5f, (float)0.0f, (float)-0.5236f, (float)0.0f, (float)0.0f));
        PartDefinition head = body.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(74, 0).m_171488_(-2.5f, -6.0f, -12.0f, 11.0f, 12.0f, 13.0f, new CubeDeformation(0.0f)).m_171514_(66, 69).m_171488_(-1.0f, 3.75f, -15.5f, 8.0f, 2.0f, 5.0f, new CubeDeformation(0.0f)).m_171514_(74, 53).m_171488_(-1.0f, -1.0f, -16.0f, 8.0f, 5.0f, 5.0f, new CubeDeformation(0.0f)).m_171514_(72, 94).m_171488_(3.0f, -9.0f, -6.0f, 0.0f, 3.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-3.0f, (float)-5.0f, (float)-10.0f, (float)0.6109f, (float)0.0f, (float)0.0f));
        PartDefinition earRight = head.m_171599_("earRight", CubeListBuilder.m_171558_().m_171514_(34, 103).m_171488_(-1.5f, -2.75f, -2.0f, 3.0f, 3.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-1.0f, (float)-6.0f, (float)-3.0f));
        PartDefinition earLeft = head.m_171599_("earLeft", CubeListBuilder.m_171558_().m_171514_(24, 103).m_171488_(-1.5f, -2.75f, -2.0f, 3.0f, 3.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)7.0f, (float)-6.0f, (float)-3.0f));
        PartDefinition leftFrontLeg = body.m_171599_("leftFrontLeg", CubeListBuilder.m_171558_().m_171514_(54, 38).m_171488_(-1.5f, -4.0f, -4.0f, 6.0f, 8.0f, 7.0f, new CubeDeformation(0.0f)).m_171514_(52, 103).m_171488_(4.5f, -4.0f, -0.5f, 3.0f, 4.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)3.5f, (float)4.0f, (float)-6.5f, (float)0.1396f, (float)-0.0873f, (float)-0.3491f));
        PartDefinition leftFrontUpper = leftFrontLeg.m_171599_("leftFrontUpper", CubeListBuilder.m_171558_().m_171514_(22, 69).m_171488_(-2.0f, 0.0f, -6.0f, 5.0f, 7.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)2.0f, (float)4.0f, (float)2.5f, (float)-0.9163f, (float)0.0f, (float)0.0873f));
        PartDefinition leftFrontDown = leftFrontUpper.m_171599_("leftFrontDown", CubeListBuilder.m_171558_().m_171514_(38, 82).m_171488_(-1.5f, -1.0f, -5.0f, 4.0f, 7.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)8.0f, (float)-0.5f, (float)-0.2618f, (float)0.0f, (float)0.1745f));
        PartDefinition leftFrontPaw = leftFrontDown.m_171599_("leftFrontPaw", CubeListBuilder.m_171558_().m_171514_(18, 94).m_171488_(-2.0f, -0.25f, -4.0f, 4.0f, 3.0f, 5.0f, new CubeDeformation(0.0f)).m_171514_(44, 103).m_171488_(0.75f, -0.25f, -7.0f, 1.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)).m_171514_(44, 103).m_171488_(-1.75f, -0.25f, -7.0f, 1.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)).m_171514_(44, 103).m_171488_(-0.5f, -0.25f, -7.0f, 1.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-0.75f, (float)6.25f, (float)-2.0f, (float)-1.9356f, (float)1.0624f, (float)2.8196f));
        PartDefinition rightFrontLeg = body.m_171599_("rightFrontLeg", CubeListBuilder.m_171558_().m_171514_(28, 38).m_171488_(-4.5f, -4.0f, -4.0f, 6.0f, 8.0f, 7.0f, new CubeDeformation(0.0f)).m_171514_(52, 103).m_171480_().m_171488_(-7.5f, -4.0f, -0.5f, 3.0f, 4.0f, 0.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)-3.5f, (float)4.0f, (float)-6.5f, (float)0.1396f, (float)0.0873f, (float)0.3491f));
        PartDefinition rightFrontUpper = rightFrontLeg.m_171599_("rightFrontUpper", CubeListBuilder.m_171558_().m_171514_(0, 69).m_171488_(-3.0f, 0.0f, -6.0f, 5.0f, 7.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-2.0f, (float)4.0f, (float)2.5f, (float)-0.9163f, (float)0.0f, (float)-0.0873f));
        PartDefinition rightFrontDown = rightFrontUpper.m_171599_("rightFrontDown", CubeListBuilder.m_171558_().m_171514_(20, 82).m_171488_(-2.5f, -1.0f, -5.0f, 4.0f, 7.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)8.0f, (float)-0.5f, (float)-0.2618f, (float)0.0f, (float)-0.1745f));
        PartDefinition rightFrontPaw = rightFrontDown.m_171599_("rightFrontPaw", CubeListBuilder.m_171558_().m_171514_(0, 94).m_171488_(-2.0f, 0.0f, -3.5f, 4.0f, 3.0f, 5.0f, new CubeDeformation(0.0f)).m_171514_(44, 103).m_171488_(-0.5f, 0.0f, -6.5f, 1.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)).m_171514_(44, 103).m_171488_(0.75f, 0.0f, -6.5f, 1.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)).m_171514_(44, 103).m_171488_(-1.75f, 0.0f, -6.5f, 1.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.75f, (float)6.0f, (float)-2.0f, (float)-1.9356f, (float)-1.0624f, (float)-2.8196f));
        PartDefinition leftHindLeg = body.m_171599_("leftHindLeg", CubeListBuilder.m_171558_().m_171514_(24, 53).m_171488_(-1.5f, -3.0f, -3.5f, 5.0f, 9.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)5.5f, (float)2.0f, (float)9.5f, (float)-0.3054f, (float)0.0f, (float)0.0f));
        PartDefinition leftHindUpper = leftHindLeg.m_171599_("leftHindUpper", CubeListBuilder.m_171558_().m_171514_(0, 82).m_171488_(-2.5f, 0.0f, 0.0f, 5.0f, 7.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)2.0f, (float)6.0f, (float)-2.0f, (float)1.1345f, (float)0.0f, (float)0.0f));
        PartDefinition leftHindDown = leftHindUpper.m_171599_("leftHindDown", CubeListBuilder.m_171558_().m_171514_(72, 82).m_171488_(-2.0f, 0.0f, -4.0f, 4.0f, 6.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)7.0f, (float)4.5f, (float)-0.6981f, (float)0.0f, (float)0.0f));
        PartDefinition leftHindPaw = leftHindDown.m_171599_("leftHindPaw", CubeListBuilder.m_171558_().m_171514_(54, 94).m_171488_(-2.0f, -1.0f, -5.0f, 4.0f, 2.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)6.25f, (float)-1.5f, (float)0.3927f, (float)0.0f, (float)0.0f));
        PartDefinition rightHindLeg = body.m_171599_("rightHindLeg", CubeListBuilder.m_171558_().m_171514_(0, 53).m_171488_(-3.5f, -3.0f, -3.5f, 5.0f, 9.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-5.5f, (float)2.0f, (float)9.5f, (float)-0.3054f, (float)0.0f, (float)0.0f));
        PartDefinition rightHindUpper = rightHindLeg.m_171599_("rightHindUpper", CubeListBuilder.m_171558_().m_171514_(92, 69).m_171488_(-2.5f, 0.0f, 0.0f, 5.0f, 7.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-2.0f, (float)6.0f, (float)-2.0f, (float)1.1345f, (float)0.0f, (float)0.0f));
        PartDefinition rightHindDown = rightHindUpper.m_171599_("rightHindDown", CubeListBuilder.m_171558_().m_171514_(56, 82).m_171488_(-2.0f, 0.0f, -4.0f, 4.0f, 6.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)7.0f, (float)4.5f, (float)-0.6981f, (float)0.0f, (float)0.0f));
        PartDefinition rightHindPaw = rightHindDown.m_171599_("rightHindPaw", CubeListBuilder.m_171558_().m_171514_(36, 94).m_171488_(-2.0f, -1.0f, -5.0f, 4.0f, 2.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)6.25f, (float)-1.5f, (float)0.3927f, (float)0.0f, (float)0.0f));
        PartDefinition tailBase = body.m_171599_("tailBase", CubeListBuilder.m_171558_().m_171514_(44, 69).m_171488_(-2.0f, 0.0f, 0.0f, 4.0f, 4.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-4.5f, (float)17.0f));
        PartDefinition tailMiddle = tailBase.m_171599_("tailMiddle", CubeListBuilder.m_171558_().m_171514_(80, 38).m_171488_(-1.0f, 0.0f, 0.0f, 2.0f, 3.0f, 11.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)0.5f, (float)7.0f, (float)-0.0873f, (float)0.0f, (float)0.0f));
        PartDefinition tailTip = tailMiddle.m_171599_("tailTip", CubeListBuilder.m_171558_().m_171514_(0, 38).m_171488_(-1.0f, -2.0f, 0.0f, 2.0f, 2.0f, 12.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)2.0f, (float)11.0f, (float)0.48f, (float)0.0f, (float)0.0f));
        PartDefinition ridingPos = body.m_171599_("ridingPos", CubeListBuilder.m_171558_(), PartPose.m_171423_((float)0.0f, (float)-7.0f, (float)11.0f, (float)0.7854f, (float)0.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)128, (int)128);
    }

    public void m_7695_(PoseStack poseStack, VertexConsumer buffer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.model.getMainPart().render(poseStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.model.resetPoses();
        float partialTicks = ClientHandlers.getPartialTicks();
        if (((EntityPanther)entity).f_20919_ <= 0 && !((BaseMonster)entity).playDeath()) {
            this.anim.doAnimation((ExtendedModel)this, "idle", ((EntityPanther)entity).f_19797_, partialTicks);
            if (((BaseMonster)entity).moveTick() > 0) {
                this.anim.doAnimation((ExtendedModel)this, "walk", ((EntityPanther)entity).f_19797_, partialTicks, ((BaseMonster)entity).interpolatedMoveTick(partialTicks));
            }
        }
        this.anim.doAnimation((ExtendedModel)this, ((EntityPanther)entity).getAnimationHandler(), partialTicks);
    }

    public ModelPartHandler getHandler() {
        return this.model;
    }

    public boolean transform(T entity, EntityRenderer<T> entityRenderer, Entity rider, EntityRenderer<?> ridingEntityRenderer, PoseStack poseStack, int riderNum) {
        LivingEntityRenderer lR;
        EntityModel model;
        if (ridingEntityRenderer instanceof LivingEntityRenderer && ((model = (lR = (LivingEntityRenderer)ridingEntityRenderer).m_7200_()) instanceof HumanoidModel || model instanceof IllagerModel || model instanceof SittingModel)) {
            this.body.translateAndRotate(poseStack);
            this.ridingPosition.translateAndRotate(poseStack);
            ClientHandlers.translateRider(entityRenderer, rider, model, poseStack);
            return true;
        }
        return false;
    }
}

