/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.client.model.monster;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import io.github.flemmli97.runecraftory.client.ClientHandlers;
import io.github.flemmli97.runecraftory.client.model.SittingModel;
import io.github.flemmli97.runecraftory.client.model.monster.ModelRaccoonBase;
import io.github.flemmli97.runecraftory.common.entities.BaseMonster;
import io.github.flemmli97.runecraftory.common.entities.monster.boss.EntityRaccoon;
import io.github.flemmli97.tenshilib.client.AnimationManager;
import io.github.flemmli97.tenshilib.client.model.BlockBenchAnimations;
import io.github.flemmli97.tenshilib.client.model.ExtendedModel;
import io.github.flemmli97.tenshilib.client.model.ModelPartHandler;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.IllagerModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;

public class ModelRaccoonBerserk<T extends EntityRaccoon>
extends ModelRaccoonBase<T> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(new ResourceLocation("runecraftory", "raccoon_berserk"), "main");
    protected final ModelPartHandler model;
    protected final BlockBenchAnimations anim;
    public ModelPartHandler.ModelPartExtended body;
    public ModelPartHandler.ModelPartExtended head;
    public ModelPartHandler.ModelPartExtended ridingPosition;

    public ModelRaccoonBerserk(ModelPart root) {
        this.model = new ModelPartHandler(root, "root");
        this.anim = AnimationManager.getInstance().getAnimation(new ResourceLocation("runecraftory", "raccoon_berserk"));
        this.body = this.model.getPart("body");
        this.head = this.model.getPart("head");
        this.ridingPosition = this.model.getPart("ridingPos");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition body = partdefinition.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-6.0f, 0.0f, -5.5f, 12.0f, 7.0f, 11.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)7.75f, (float)3.5f, (float)0.0436f, (float)0.0f, (float)0.0f));
        PartDefinition bodyMiddle = body.m_171599_("bodyMiddle", CubeListBuilder.m_171558_().m_171514_(31, 28).m_171488_(-5.0f, -8.0f, -4.5f, 10.0f, 8.0f, 9.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)0.5f, (float)0.0f, (float)0.1309f, (float)0.0f, (float)0.0f));
        PartDefinition bodyUpper = bodyMiddle.m_171599_("bodyUpper", CubeListBuilder.m_171558_().m_171514_(38, 10).m_171488_(-6.0f, -6.0f, -4.0f, 12.0f, 6.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-8.0f, (float)0.0f, (float)-0.0873f, (float)0.0f, (float)0.0f));
        PartDefinition head = bodyUpper.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(0, 18).m_171488_(-5.0f, -8.0f, -5.0f, 10.0f, 9.0f, 10.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-7.0f, (float)0.0f, (float)0.1309f, (float)0.0f, (float)0.0f));
        PartDefinition leaf = head.m_171599_("leaf", CubeListBuilder.m_171558_().m_171514_(27, 0).m_171488_(-1.5f, -0.05f, -6.75f, 5.0f, 0.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-1.0f, (float)-8.0f, (float)0.5f));
        PartDefinition snout = head.m_171599_("snout", CubeListBuilder.m_171558_().m_171514_(70, 10).m_171488_(-2.5f, -1.255f, -2.375f, 5.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)).m_171514_(0, 0).m_171488_(-1.0f, -1.245f, -4.125f, 2.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-2.245f, (float)-5.125f));
        PartDefinition earLeft = head.m_171599_("earLeft", CubeListBuilder.m_171558_().m_171514_(5, 6).m_171488_(-1.0f, -2.0f, 0.0f, 2.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)3.0f, (float)-8.0f, (float)-2.0f));
        PartDefinition earRight = head.m_171599_("earRight", CubeListBuilder.m_171558_().m_171514_(0, 4).m_171488_(-1.0f, -2.0f, 0.0f, 2.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-3.0f, (float)-8.0f, (float)-2.0f));
        PartDefinition leftArm = bodyUpper.m_171599_("leftArm", CubeListBuilder.m_171558_().m_171514_(0, 63).m_171488_(0.0f, -2.5f, -2.0f, 5.0f, 7.0f, 5.0f, new CubeDeformation(0.0f)).m_171514_(15, 70).m_171488_(2.0f, -2.5f, -2.0f, 3.0f, 5.0f, 5.0f, new CubeDeformation(0.25f)), PartPose.m_171423_((float)6.0f, (float)-2.5f, (float)-0.5f, (float)-0.4363f, (float)-0.3491f, (float)0.0f));
        PartDefinition leftArmDown = leftArm.m_171599_("leftArmDown", CubeListBuilder.m_171558_().m_171514_(44, 57).m_171488_(-2.5f, 0.0f, -2.5f, 5.0f, 8.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)2.5f, (float)4.5f, (float)0.5f, (float)-0.6545f, (float)0.3491f, (float)0.0f));
        PartDefinition rightArm = bodyUpper.m_171599_("rightArm", CubeListBuilder.m_171558_().m_171514_(60, 24).m_171488_(-5.0f, -2.5f, -2.0f, 5.0f, 7.0f, 5.0f, new CubeDeformation(0.0f)).m_171514_(59, 68).m_171488_(-5.0f, -2.5f, -2.0f, 3.0f, 5.0f, 5.0f, new CubeDeformation(0.25f)), PartPose.m_171423_((float)-6.0f, (float)-2.5f, (float)-0.5f, (float)-0.4363f, (float)0.3491f, (float)0.0f));
        PartDefinition rightArmDown = rightArm.m_171599_("rightArmDown", CubeListBuilder.m_171558_().m_171514_(24, 57).m_171488_(-2.5f, 0.0f, -2.5f, 5.0f, 8.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-2.5f, (float)4.5f, (float)0.5f, (float)-0.6545f, (float)-0.3491f, (float)0.0f));
        PartDefinition tail = body.m_171599_("tail", CubeListBuilder.m_171558_().m_171514_(0, 37).m_171488_(-2.0f, -3.0f, -1.0f, 5.0f, 5.0f, 9.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-0.5f, (float)3.5f, (float)5.25f));
        PartDefinition tail2 = tail.m_171599_("tail2", CubeListBuilder.m_171558_().m_171514_(0, 51).m_171488_(-2.0f, -2.0f, 0.0f, 4.0f, 4.0f, 8.0f, new CubeDeformation(-0.01f)), PartPose.m_171419_((float)0.5f, (float)-0.5f, (float)7.75f));
        PartDefinition leftLegBase = body.m_171599_("leftLegBase", CubeListBuilder.m_171558_().m_171514_(46, 45).m_171488_(-0.5f, -3.0f, -3.0f, 6.0f, 6.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)6.0f, (float)4.5f, (float)0.0f, (float)-0.6109f, (float)0.0f, (float)0.0f));
        PartDefinition leftLeg = leftLegBase.m_171599_("leftLeg", CubeListBuilder.m_171558_().m_171514_(65, 0).m_171488_(-2.5f, -1.0f, -2.5f, 5.0f, 5.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)2.5f, (float)3.0f, (float)0.0f, (float)0.1745f, (float)0.0f, (float)0.0f));
        PartDefinition leftLegDown = leftLeg.m_171599_("leftLegDown", CubeListBuilder.m_171558_().m_171514_(64, 57).m_171488_(-2.5f, 0.0f, -1.5f, 5.0f, 6.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)4.0f, (float)-1.0f, (float)0.3927f, (float)0.0f, (float)0.0f));
        PartDefinition rightLegBase = body.m_171599_("rightLegBase", CubeListBuilder.m_171558_().m_171514_(22, 45).m_171488_(-5.5f, -3.0f, -3.0f, 6.0f, 6.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-6.0f, (float)4.5f, (float)0.0f, (float)-0.6109f, (float)0.0f, (float)0.0f));
        PartDefinition rightLeg = rightLegBase.m_171599_("rightLeg", CubeListBuilder.m_171558_().m_171514_(45, 0).m_171488_(-2.5f, -1.0f, -2.5f, 5.0f, 5.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-2.5f, (float)3.0f, (float)0.0f, (float)0.1745f, (float)0.0f, (float)0.0f));
        PartDefinition rightLegDown = rightLeg.m_171599_("rightLegDown", CubeListBuilder.m_171558_().m_171514_(64, 40).m_171488_(-2.5f, 0.0f, -1.5f, 5.0f, 6.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)4.0f, (float)-1.0f, (float)0.3927f, (float)0.0f, (float)0.0f));
        PartDefinition ridingPos = body.m_171599_("ridingPos", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)7.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)128, (int)128);
    }

    public void m_7695_(PoseStack poseStack, VertexConsumer buffer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.model.getMainPart().render(poseStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.model.resetPoses();
        float partialTicks = ClientHandlers.getPartialTicks();
        if (((EntityRaccoon)entity).f_20919_ <= 0 && !((BaseMonster)entity).playDeath()) {
            this.head.yRot = (float)((double)this.head.yRot + (double)(netHeadYaw % 360.0f * ((float)Math.PI / 180)) * 0.8);
            this.head.xRot += headPitch * ((float)Math.PI / 180);
            this.anim.doAnimation((ExtendedModel)this, "idle", ((EntityRaccoon)entity).f_19797_, partialTicks);
            if (((BaseMonster)entity).moveTick() > 0) {
                this.anim.doAnimation((ExtendedModel)this, "walk", ((EntityRaccoon)entity).f_19797_, partialTicks, ((BaseMonster)entity).interpolatedMoveTick(partialTicks));
            }
        }
        this.anim.doAnimation((ExtendedModel)this, ((EntityRaccoon)entity).getAnimationHandler(), partialTicks);
    }

    public ModelPartHandler getHandler() {
        return this.model;
    }

    public boolean transform(T entity, EntityRenderer<T> entityRenderer, Entity rider, EntityRenderer<?> ridingEntityRenderer, PoseStack poseStack, int riderNum) {
        LivingEntityRenderer lR;
        EntityModel model;
        if (ridingEntityRenderer instanceof LivingEntityRenderer && ((model = (lR = (LivingEntityRenderer)ridingEntityRenderer).m_7200_()) instanceof HumanoidModel || model instanceof IllagerModel || model instanceof SittingModel)) {
            this.body.translateAndRotate(poseStack);
            this.ridingPosition.translateAndRotate(poseStack);
            if (((EntityRaccoon)entity).isBerserk()) {
                poseStack.m_85841_(0.71428573f, 0.71428573f, 0.71428573f);
            }
            ClientHandlers.translateRider(entityRenderer, rider, model, poseStack);
            if (((EntityRaccoon)entity).isBerserk()) {
                poseStack.m_85841_(1.4f, 1.4f, 1.4f);
            }
            return true;
        }
        return false;
    }
}

