/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.client.model.monster;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import io.github.flemmli97.runecraftory.client.ClientHandlers;
import io.github.flemmli97.runecraftory.client.model.SittingModel;
import io.github.flemmli97.runecraftory.common.entities.BaseMonster;
import io.github.flemmli97.runecraftory.common.entities.monster.boss.rafflesia.EntityRafflesia;
import io.github.flemmli97.runecraftory.common.entities.monster.boss.rafflesia.EntityRafflesiaPart;
import io.github.flemmli97.tenshilib.api.entity.AnimatedAction;
import io.github.flemmli97.tenshilib.client.AnimationManager;
import io.github.flemmli97.tenshilib.client.model.BlockBenchAnimations;
import io.github.flemmli97.tenshilib.client.model.ExtendedModel;
import io.github.flemmli97.tenshilib.client.model.ModelPartHandler;
import io.github.flemmli97.tenshilib.client.model.RideableModel;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.IllagerModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;

public class ModelRafflesia<T extends EntityRafflesia>
extends EntityModel<T>
implements ExtendedModel,
RideableModel<T> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(new ResourceLocation("runecraftory", "rafflesia"), "main");
    protected final ModelPartHandler model;
    protected final BlockBenchAnimations anim;
    public ModelPartHandler.ModelPartExtended main;
    public ModelPartHandler.ModelPartExtended mainRoot;
    public ModelPartHandler.ModelPartExtended mainStem;
    public ModelPartHandler.ModelPartExtended mainStem2;
    public ModelPartHandler.ModelPartExtended mainStem3;
    public ModelPartHandler.ModelPartExtended mainStem4;
    public ModelPartHandler.ModelPartExtended head;
    public ModelPartHandler.ModelPartExtended horseTail;
    public ModelPartHandler.ModelPartExtended pitcher;
    public ModelPartHandler.ModelPartExtended flower;
    public ModelPartHandler.ModelPartExtended ridingPosition;

    public ModelRafflesia(ModelPart root) {
        this.model = new ModelPartHandler(root, "root");
        this.anim = AnimationManager.getInstance().getAnimation(new ResourceLocation("runecraftory", "rafflesia"));
        this.main = this.model.getPart("main");
        this.mainRoot = this.model.getPart("mainRoot");
        this.mainStem = this.model.getPart("mainStem");
        this.mainStem2 = this.model.getPart("mainStem2");
        this.mainStem3 = this.model.getPart("mainStem3");
        this.mainStem4 = this.model.getPart("mainStem4");
        this.head = this.model.getPart("head");
        this.horseTail = this.model.getPart("leftStem");
        this.pitcher = this.model.getPart("rightStem");
        this.flower = this.model.getPart("frontStem");
        this.ridingPosition = this.model.getPart("ridingPos");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition main = partdefinition.m_171599_("main", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-7.5f, -3.0f, -7.5f, 15.0f, 3.0f, 15.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition mainRoot = main.m_171599_("mainRoot", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition mainStem = mainRoot.m_171599_("mainStem", CubeListBuilder.m_171558_().m_171514_(0, 31).m_171488_(-1.0f, -12.0f, -2.0f, 3.0f, 10.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-0.5f, (float)-1.0f, (float)0.5f));
        PartDefinition mainStem2 = mainStem.m_171599_("mainStem2", CubeListBuilder.m_171558_().m_171514_(0, 18).m_171488_(-1.5f, -10.0f, -1.5f, 3.0f, 10.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.5f, (float)-12.0f, (float)-0.5f));
        PartDefinition mainStem3 = mainStem2.m_171599_("mainStem3", CubeListBuilder.m_171558_().m_171514_(87, 66).m_171488_(-1.5f, -9.0f, -1.5f, 3.0f, 9.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-10.0f, (float)0.0f));
        PartDefinition mainStem4 = mainStem3.m_171599_("mainStem4", CubeListBuilder.m_171558_().m_171514_(0, 44).m_171488_(-1.5f, -10.0f, -1.5f, 3.0f, 9.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-8.0f, (float)0.0f));
        PartDefinition head = mainStem4.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(46, 48).m_171488_(-5.5f, -5.5f, -11.0f, 11.0f, 11.0f, 10.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-7.0f, (float)-0.5f));
        PartDefinition mouthUpper = head.m_171599_("mouthUpper", CubeListBuilder.m_171558_().m_171514_(0, 62).m_171488_(-3.5f, -5.0f, -9.0f, 7.0f, 5.0f, 9.0f, new CubeDeformation(0.0f)).m_171514_(78, 28).m_171488_(-3.5f, -0.25f, -9.0f, 7.0f, 1.0f, 9.0f, new CubeDeformation(-0.025f)), PartPose.m_171423_((float)0.0f, (float)1.0f, (float)-11.0f, (float)-0.1309f, (float)0.0f, (float)0.0f));
        PartDefinition mouthLower = head.m_171599_("mouthLower", CubeListBuilder.m_171558_().m_171514_(64, 69).m_171488_(-4.0f, 0.0f, -9.0f, 7.0f, 3.0f, 9.0f, new CubeDeformation(0.0f)).m_171514_(77, 0).m_171488_(-4.0f, -0.75f, -9.0f, 7.0f, 1.0f, 9.0f, new CubeDeformation(-0.025f)), PartPose.m_171423_((float)0.5f, (float)1.0f, (float)-11.0f, (float)0.0436f, (float)0.0f, (float)0.0f));
        PartDefinition flowerBase = head.m_171599_("flowerBase", CubeListBuilder.m_171558_(), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.7854f));
        PartDefinition flower = flowerBase.m_171599_("flower", CubeListBuilder.m_171558_().m_171514_(0, 76).m_171488_(-6.5f, -17.0f, 0.0f, 13.0f, 16.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0873f, (float)0.0f, (float)0.0f));
        PartDefinition flower2 = flowerBase.m_171599_("flower2", CubeListBuilder.m_171558_().m_171514_(32, 69).m_171488_(1.0f, -6.5f, 0.0f, 16.0f, 13.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0873f, (float)0.0f));
        PartDefinition flower4 = flowerBase.m_171599_("flower4", CubeListBuilder.m_171558_().m_171514_(0, 76).m_171488_(-6.5f, -17.0f, 0.0f, 13.0f, 16.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0873f, (float)0.0f, (float)-3.1416f));
        PartDefinition flower3 = flowerBase.m_171599_("flower3", CubeListBuilder.m_171558_().m_171514_(32, 69).m_171488_(1.0f, -6.5f, 0.0f, 16.0f, 13.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0873f, (float)-3.1416f));
        PartDefinition flowerBase2 = head.m_171599_("flowerBase2", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition flower5 = flowerBase2.m_171599_("flower5", CubeListBuilder.m_171558_().m_171514_(0, 76).m_171488_(-6.5f, -17.0f, 0.0f, 13.0f, 16.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0873f, (float)0.0f, (float)0.0f));
        PartDefinition flower6 = flowerBase2.m_171599_("flower6", CubeListBuilder.m_171558_().m_171514_(32, 69).m_171488_(1.0f, -6.5f, 0.0f, 16.0f, 13.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0873f, (float)0.0f));
        PartDefinition flower8 = flowerBase2.m_171599_("flower8", CubeListBuilder.m_171558_().m_171514_(32, 69).m_171488_(1.0f, -6.5f, 0.0f, 16.0f, 13.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0873f, (float)-3.1416f));
        PartDefinition ridingPos = head.m_171599_("ridingPos", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)-5.0f, (float)-3.0f));
        PartDefinition leafSetBottom = mainStem.m_171599_("leafSetBottom", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.5f, (float)-2.0f, (float)-0.5f));
        PartDefinition leafBottom = leafSetBottom.m_171599_("leafBottom", CubeListBuilder.m_171558_().m_171514_(58, 14).m_171488_(-4.0f, 0.0f, 0.0f, 8.0f, 0.0f, 14.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-1.0f, (float)0.0f, (float)1.0f, (float)0.4363f, (float)-0.7854f, (float)0.0f));
        PartDefinition leafBottom2 = leafSetBottom.m_171599_("leafBottom2", CubeListBuilder.m_171558_().m_171514_(58, 14).m_171488_(-4.0f, 0.0f, 0.0f, 8.0f, 0.0f, 14.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)1.0f, (float)0.0f, (float)1.0f, (float)0.4363f, (float)0.7854f, (float)0.0f));
        PartDefinition leafBottom3 = leafSetBottom.m_171599_("leafBottom3", CubeListBuilder.m_171558_().m_171514_(58, 14).m_171480_().m_171488_(-4.0f, 0.0f, 0.0f, 8.0f, 0.0f, 14.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)1.0f, (float)0.0f, (float)-1.0f, (float)0.4363f, (float)2.3562f, (float)0.0f));
        PartDefinition leafBottom4 = leafSetBottom.m_171599_("leafBottom4", CubeListBuilder.m_171558_().m_171514_(58, 14).m_171488_(-4.0f, 0.0f, 0.0f, 8.0f, 0.0f, 14.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-1.0f, (float)0.0f, (float)-1.0f, (float)0.4363f, (float)-2.3562f, (float)0.0f));
        PartDefinition leftStem = main.m_171599_("leftStem", CubeListBuilder.m_171558_().m_171514_(82, 89).m_171488_(-2.0f, -10.0f, -1.0f, 2.0f, 10.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)7.5f, (float)0.0f, (float)-0.5f, (float)0.0f, (float)0.0f, (float)1.3526f));
        PartDefinition leftStem2 = leftStem.m_171599_("leftStem2", CubeListBuilder.m_171558_().m_171514_(0, 56).m_171488_(-1.0f, -11.0f, -1.0f, 2.0f, 11.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-1.0f, (float)-10.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-1.3526f));
        PartDefinition leftStem3 = leftStem2.m_171599_("leftStem3", CubeListBuilder.m_171558_().m_171514_(32, 90).m_171488_(-1.0f, -8.0f, -1.0f, 2.0f, 8.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-11.0f, (float)0.0f));
        PartDefinition leftStem4 = leftStem3.m_171599_("leftStem4", CubeListBuilder.m_171558_().m_171514_(35, 62).m_171488_(-1.0f, -2.0f, -1.0f, 2.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-8.0f, (float)0.0f));
        PartDefinition horseTail = leftStem4.m_171599_("horseTail", CubeListBuilder.m_171558_().m_171514_(78, 38).m_171488_(-2.5f, -9.0f, -3.0f, 6.0f, 9.0f, 6.0f, new CubeDeformation(0.0f)).m_171514_(78, 53).m_171488_(-1.5f, -10.0f, -2.0f, 4.0f, 1.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-0.5f, (float)-2.0f, (float)0.0f));
        PartDefinition rightStem = main.m_171599_("rightStem", CubeListBuilder.m_171558_().m_171514_(88, 10).m_171488_(0.0f, -10.0f, -1.0f, 2.0f, 10.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-7.5f, (float)0.0f, (float)-0.5f, (float)0.0f, (float)0.0f, (float)-1.3526f));
        PartDefinition rightStem2 = rightStem.m_171599_("rightStem2", CubeListBuilder.m_171558_().m_171514_(24, 90).m_171488_(-1.0f, -9.0f, -1.0f, 2.0f, 9.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)1.0f, (float)-10.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)1.3526f));
        PartDefinition rightStem4 = rightStem2.m_171599_("rightStem4", CubeListBuilder.m_171558_().m_171514_(46, 48).m_171488_(-1.0f, -8.0f, -1.0f, 2.0f, 8.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-9.0f, (float)0.0f));
        PartDefinition rightStem3 = rightStem4.m_171599_("rightStem3", CubeListBuilder.m_171558_().m_171514_(60, 14).m_171488_(-1.0f, -2.0f, -1.0f, 2.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-8.0f, (float)0.0f));
        PartDefinition pitcher = rightStem3.m_171599_("pitcher", CubeListBuilder.m_171558_().m_171514_(82, 81).m_171488_(-2.5f, -1.0f, -6.0f, 6.0f, 2.0f, 6.0f, new CubeDeformation(0.0f)).m_171514_(58, 81).m_171488_(-2.5f, -6.0f, -6.0f, 6.0f, 5.0f, 6.0f, new CubeDeformation(0.0f)).m_171514_(0, 0).m_171488_(-1.5f, -9.0f, -2.0f, 4.0f, 3.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-0.5f, (float)-1.25f, (float)0.0f));
        PartDefinition frontStem = main.m_171599_("frontStem", CubeListBuilder.m_171558_().m_171514_(50, 82).m_171488_(-1.0f, -10.0f, 0.0f, 2.0f, 10.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-0.5f, (float)0.0f, (float)-7.5f, (float)1.3526f, (float)0.0f, (float)0.0f));
        PartDefinition frontStem2 = frontStem.m_171599_("frontStem2", CubeListBuilder.m_171558_().m_171514_(64, 69).m_171488_(-1.0f, -6.0f, -1.0f, 2.0f, 6.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-10.0f, (float)1.0f, (float)-1.3526f, (float)0.0f, (float)0.0f));
        PartDefinition frontFlower = frontStem2.m_171599_("frontFlower", CubeListBuilder.m_171558_().m_171514_(26, 82).m_171488_(-3.0f, -1.25f, -3.0f, 6.0f, 2.0f, 6.0f, new CubeDeformation(0.0f)).m_171514_(23, 62).m_171488_(-2.0f, -2.25f, -2.0f, 4.0f, 1.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-6.75f, (float)0.0f));
        PartDefinition frontFlowerPetal = frontFlower.m_171599_("frontFlowerPetal", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(0.0f, -7.0f, -3.0f, 0.0f, 7.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)3.0f, (float)-1.25f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.3054f));
        PartDefinition frontFlowerPetal2 = frontFlower.m_171599_("frontFlowerPetal2", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171480_().m_171488_(0.0f, -7.0f, -3.0f, 0.0f, 7.0f, 6.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)-3.0f, (float)-1.25f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.3054f));
        PartDefinition frontFlowerPetal3 = frontFlower.m_171599_("frontFlowerPetal3", CubeListBuilder.m_171558_().m_171514_(88, 58).m_171488_(-3.0f, -7.0f, 0.0f, 6.0f, 7.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-1.25f, (float)-3.0f, (float)-0.3054f, (float)0.0f, (float)0.0f));
        PartDefinition frontFlowerPetal4 = frontFlower.m_171599_("frontFlowerPetal4", CubeListBuilder.m_171558_().m_171514_(88, 58).m_171480_().m_171488_(-3.0f, -7.0f, 0.0f, 6.0f, 7.0f, 0.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)0.0f, (float)-1.25f, (float)3.0f, (float)0.3054f, (float)0.0f, (float)0.0f));
        PartDefinition basePetalSet = main.m_171599_("basePetalSet", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition basePetal = basePetalSet.m_171599_("basePetal", CubeListBuilder.m_171558_().m_171514_(28, 18).m_171488_(0.0f, 0.0f, -8.0f, 14.0f, 0.0f, 16.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)4.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.5236f));
        PartDefinition basePetalTip = basePetal.m_171599_("basePetalTip", CubeListBuilder.m_171558_().m_171514_(0, 18).m_171488_(0.0f, 0.0f, -8.0f, 14.0f, 0.0f, 16.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)14.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)1.0472f));
        PartDefinition basePetal2 = basePetalSet.m_171599_("basePetal2", CubeListBuilder.m_171558_().m_171514_(28, 18).m_171480_().m_171488_(-14.0f, 0.0f, -8.0f, 14.0f, 0.0f, 16.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)-4.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.5236f));
        PartDefinition basePetalTip2 = basePetal2.m_171599_("basePetalTip2", CubeListBuilder.m_171558_().m_171514_(0, 18).m_171480_().m_171488_(-14.0f, 0.0f, -8.0f, 14.0f, 0.0f, 16.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)-14.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-1.0472f));
        PartDefinition basePetal3 = basePetalSet.m_171599_("basePetal3", CubeListBuilder.m_171558_().m_171514_(0, 48).m_171488_(-8.0f, 0.0f, -14.0f, 16.0f, 0.0f, 14.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-3.0f, (float)0.0f, (float)-3.0f, (float)-0.5236f, (float)0.7854f, (float)0.0f));
        PartDefinition basePetalTip3 = basePetal3.m_171599_("basePetalTip3", CubeListBuilder.m_171558_().m_171514_(32, 34).m_171488_(-8.0f, 0.0f, -14.0f, 16.0f, 0.0f, 14.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)-14.0f, (float)1.0472f, (float)0.0f, (float)0.0f));
        PartDefinition basePetal4 = basePetalSet.m_171599_("basePetal4", CubeListBuilder.m_171558_().m_171514_(0, 48).m_171488_(-8.0f, 0.0f, -14.0f, 16.0f, 0.0f, 14.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)-4.0f, (float)-0.5236f, (float)0.0f, (float)0.0f));
        PartDefinition basePetalTip4 = basePetal4.m_171599_("basePetalTip4", CubeListBuilder.m_171558_().m_171514_(32, 34).m_171488_(-8.0f, 0.0f, -14.0f, 16.0f, 0.0f, 14.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)-14.0f, (float)1.0472f, (float)0.0f, (float)0.0f));
        PartDefinition basePetal5 = basePetalSet.m_171599_("basePetal5", CubeListBuilder.m_171558_().m_171514_(0, 48).m_171488_(-8.0f, 0.0f, -14.0f, 16.0f, 0.0f, 14.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)3.0f, (float)0.0f, (float)-3.0f, (float)-0.5236f, (float)-0.7854f, (float)0.0f));
        PartDefinition basePetalTip5 = basePetal5.m_171599_("basePetalTip5", CubeListBuilder.m_171558_().m_171514_(32, 34).m_171488_(-8.0f, 0.0f, -14.0f, 16.0f, 0.0f, 14.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)-14.0f, (float)1.0472f, (float)0.0f, (float)0.0f));
        PartDefinition basePetal6 = basePetalSet.m_171599_("basePetal6", CubeListBuilder.m_171558_().m_171514_(0, 34).m_171488_(-8.0f, 0.0f, 0.0f, 16.0f, 0.0f, 14.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-3.0f, (float)0.0f, (float)3.0f, (float)0.5236f, (float)-0.7854f, (float)0.0f));
        PartDefinition basePetalTip6 = basePetal6.m_171599_("basePetalTip6", CubeListBuilder.m_171558_().m_171514_(31, 0).m_171488_(-8.0f, 0.0f, 0.0f, 16.0f, 0.0f, 14.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)14.0f, (float)-1.0472f, (float)0.0f, (float)0.0f));
        PartDefinition basePetal7 = basePetalSet.m_171599_("basePetal7", CubeListBuilder.m_171558_().m_171514_(0, 34).m_171488_(-8.0f, 0.0f, 0.0f, 16.0f, 0.0f, 14.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)4.0f, (float)0.5236f, (float)0.0f, (float)0.0f));
        PartDefinition basePetalTip7 = basePetal7.m_171599_("basePetalTip7", CubeListBuilder.m_171558_().m_171514_(31, 0).m_171488_(-8.0f, 0.0f, 0.0f, 16.0f, 0.0f, 14.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)14.0f, (float)-1.0472f, (float)0.0f, (float)0.0f));
        PartDefinition basePetal8 = basePetalSet.m_171599_("basePetal8", CubeListBuilder.m_171558_().m_171514_(0, 34).m_171488_(-8.0f, 0.0f, 0.0f, 16.0f, 0.0f, 14.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)3.0f, (float)0.0f, (float)3.0f, (float)0.5236f, (float)0.7854f, (float)0.0f));
        PartDefinition basePetalTip8 = basePetal8.m_171599_("basePetalTip8", CubeListBuilder.m_171558_().m_171514_(31, 0).m_171488_(-8.0f, 0.0f, 0.0f, 16.0f, 0.0f, 14.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)14.0f, (float)-1.0472f, (float)0.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)128, (int)128);
    }

    public void m_7695_(PoseStack poseStack, VertexConsumer buffer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.model.getMainPart().render(poseStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        EntityRafflesiaPart horseTail;
        this.model.resetPoses();
        float partialTicks = ClientHandlers.getPartialTicks();
        this.mainRoot.yRot = (Mth.m_14179_((float)partialTicks, (float)((EntityRafflesia)entity).f_20886_, (float)((EntityRafflesia)entity).f_20885_) - ((EntityRafflesia)entity).getSpawnDirection().m_122435_()) * ((float)Math.PI / 180);
        this.head.yRot += netHeadYaw % 360.0f * ((float)Math.PI / 180) * 0.3f;
        AnimatedAction current = ((EntityRafflesia)entity).getAnimationHandler().getAnimation();
        if (!(((EntityRafflesia)entity).f_20919_ > 0 || ((BaseMonster)entity).playDeath() || current != null && current.getClientIdentifier().equals("breath"))) {
            this.anim.doAnimation((ExtendedModel)this, "idle", ((EntityRafflesia)entity).f_19797_, partialTicks);
        }
        this.anim.doAnimation((ExtendedModel)this, ((EntityRafflesia)entity).getAnimationHandler(), partialTicks, EntityRafflesia::isMirrorAttack, null);
        if (current == null || current.getClientIdentifier().equals("breath")) {
            this.head.xRot += headPitch * ((float)Math.PI / 180) * 1.0f;
        }
        if ((horseTail = ((EntityRafflesia)entity).getHorseTail()) != null) {
            this.horseTail.visible = true;
            this.anim.doAnimation((ExtendedModel)this, horseTail.getAnimationHandler(), partialTicks);
        } else {
            this.horseTail.visible = false;
        }
        EntityRafflesiaPart flower = ((EntityRafflesia)entity).getFlower();
        if (flower != null) {
            this.flower.visible = true;
            this.anim.doAnimation((ExtendedModel)this, flower.getAnimationHandler(), partialTicks);
        } else {
            this.flower.visible = false;
        }
        EntityRafflesiaPart pitcher = ((EntityRafflesia)entity).getPitcher();
        if (pitcher != null) {
            this.pitcher.visible = true;
            this.anim.doAnimation((ExtendedModel)this, pitcher.getAnimationHandler(), partialTicks);
        } else {
            this.pitcher.visible = false;
        }
    }

    public ModelPartHandler getHandler() {
        return this.model;
    }

    public boolean transform(T entity, EntityRenderer<T> entityRenderer, Entity rider, EntityRenderer<?> ridingEntityRenderer, PoseStack poseStack, int riderNum) {
        LivingEntityRenderer lR;
        EntityModel model;
        if (ridingEntityRenderer instanceof LivingEntityRenderer && ((model = (lR = (LivingEntityRenderer)ridingEntityRenderer).m_7200_()) instanceof HumanoidModel || model instanceof IllagerModel || model instanceof SittingModel)) {
            this.main.translateAndRotate(poseStack);
            this.mainRoot.translateAndRotate(poseStack);
            this.mainStem.translateAndRotate(poseStack);
            this.mainStem2.translateAndRotate(poseStack);
            this.mainStem3.translateAndRotate(poseStack);
            this.mainStem4.translateAndRotate(poseStack);
            this.head.translateAndRotate(poseStack);
            this.ridingPosition.translateAndRotate(poseStack);
            ClientHandlers.translateRider(entityRenderer, rider, model, poseStack);
            return true;
        }
        return false;
    }
}

