/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.client.model.monster;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import io.github.flemmli97.runecraftory.client.ClientHandlers;
import io.github.flemmli97.runecraftory.client.model.SittingModel;
import io.github.flemmli97.runecraftory.common.entities.BaseMonster;
import io.github.flemmli97.runecraftory.common.entities.monster.boss.EntitySarcophagus;
import io.github.flemmli97.tenshilib.client.AnimationManager;
import io.github.flemmli97.tenshilib.client.model.BlockBenchAnimations;
import io.github.flemmli97.tenshilib.client.model.ExtendedModel;
import io.github.flemmli97.tenshilib.client.model.ModelPartHandler;
import io.github.flemmli97.tenshilib.client.model.RideableModel;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.IllagerModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;

public class ModelSarcophagus<T extends EntitySarcophagus>
extends EntityModel<T>
implements ExtendedModel,
RideableModel<T> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(new ResourceLocation("runecraftory", "sarcophagus"), "main");
    protected final ModelPartHandler model;
    protected final BlockBenchAnimations anim;
    public ModelPartHandler.ModelPartExtended body;
    public ModelPartHandler.ModelPartExtended ridingPosition;

    public ModelSarcophagus(ModelPart root) {
        this.model = new ModelPartHandler(root, "root");
        this.anim = AnimationManager.getInstance().getAnimation(new ResourceLocation("runecraftory", "sarcophagus"));
        this.body = this.model.getPart("body");
        this.ridingPosition = this.model.getPart("ridingPos");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition body = partdefinition.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(52, 21).m_171488_(-5.0f, 23.5f, -6.0f, 10.0f, 4.0f, 12.0f, new CubeDeformation(0.0f)).m_171514_(0, 33).m_171488_(-6.0f, 8.5f, -7.0f, 12.0f, 15.0f, 14.0f, new CubeDeformation(0.0f)).m_171514_(0, 0).m_171488_(-8.0f, -8.5f, -8.0f, 16.0f, 17.0f, 16.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-5.5f, (float)0.0f));
        PartDefinition neck = body.m_171599_("neck", CubeListBuilder.m_171558_().m_171514_(48, 0).m_171488_(-7.0f, -4.0f, -6.0f, 14.0f, 4.0f, 12.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-8.5f, (float)0.0f));
        PartDefinition head = neck.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(41, 51).m_171488_(-6.0f, -11.0f, -5.5f, 12.0f, 11.0f, 11.0f, new CubeDeformation(0.0f)).m_171514_(55, 73).m_171488_(4.001f, -2.0f, -6.5f, 3.0f, 6.0f, 5.0f, new CubeDeformation(0.0f)).m_171514_(48, 0).m_171488_(5.0f, -8.0f, -5.0f, 2.0f, 6.0f, 4.0f, new CubeDeformation(0.0f)).m_171514_(48, 0).m_171480_().m_171488_(-7.0f, -8.0f, -5.0f, 2.0f, 6.0f, 4.0f, new CubeDeformation(0.0f)).m_171555_(false).m_171514_(55, 73).m_171480_().m_171488_(-7.001f, -2.0f, -6.5f, 3.0f, 6.0f, 5.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)0.0f, (float)-4.0f, (float)0.0f));
        PartDefinition snout = head.m_171599_("snout", CubeListBuilder.m_171558_().m_171514_(33, 73).m_171488_(-2.5f, -2.75f, -6.5f, 5.0f, 3.0f, 6.0f, new CubeDeformation(0.0f)).m_171514_(88, 6).m_171488_(-2.0f, 0.25f, -4.5f, 4.0f, 2.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-2.25f, (float)-5.0f));
        PartDefinition earLeft = head.m_171599_("earLeft", CubeListBuilder.m_171558_().m_171514_(28, 88).m_171488_(0.0f, -5.0f, -0.5f, 3.0f, 5.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)3.0f, (float)-11.0f, (float)-2.5f, (float)0.2182f, (float)0.0f, (float)0.2182f));
        PartDefinition earRight = head.m_171599_("earRight", CubeListBuilder.m_171558_().m_171514_(28, 88).m_171480_().m_171488_(-3.0f, -5.0f, -0.5f, 3.0f, 5.0f, 2.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)-3.0f, (float)-11.0f, (float)-2.5f, (float)0.2182f, (float)0.0f, (float)-0.2182f));
        PartDefinition ring = body.m_171599_("ring", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)-1.5f, (float)9.0f));
        PartDefinition ringLeft = ring.m_171599_("ringLeft", CubeListBuilder.m_171558_().m_171514_(84, 70).m_171488_(-3.0f, -1.0f, 0.0f, 6.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)).m_171514_(87, 55).m_171488_(-2.0f, 2.0f, 0.0f, 4.0f, 7.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)17.0f, (float)-3.0f, (float)0.0f));
        PartDefinition leftFox = ringLeft.m_171599_("leftFox", CubeListBuilder.m_171558_().m_171514_(0, 73).m_171488_(-2.0f, -5.0f, -2.0f, 4.0f, 4.0f, 7.0f, new CubeDeformation(0.0f)).m_171514_(66, 73).m_171488_(-2.0f, -1.0f, 3.0f, 4.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(49, 73).m_171488_(-2.0f, -1.0f, -1.0f, 4.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(12, 14).m_171488_(2.0f, -7.0f, -4.0f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(8, 14).m_171488_(-3.0f, -7.0f, -4.0f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(74, 37).m_171488_(-2.0f, -7.0f, -5.0f, 4.0f, 4.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition leftFoxTail = leftFox.m_171599_("leftFoxTail", CubeListBuilder.m_171558_().m_171514_(39, 103).m_171480_().m_171488_(-7.0f, -7.0f, 0.0f, 14.0f, 8.0f, 0.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)0.0f, (float)-4.0f, (float)5.0f, (float)0.0873f, (float)0.0f, (float)0.0f));
        PartDefinition leftFoxTail2 = leftFox.m_171599_("leftFoxTail2", CubeListBuilder.m_171558_().m_171514_(39, 110).m_171480_().m_171488_(-7.0f, 0.0f, 0.001f, 14.0f, 8.0f, 0.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)0.0f, (float)-4.0f, (float)5.0f, (float)-0.0873f, (float)0.0f, (float)0.0f));
        PartDefinition ringLeft2 = ringLeft.m_171599_("ringLeft2", CubeListBuilder.m_171558_().m_171514_(85, 85).m_171488_(-2.0f, -1.0f, 0.0f, 4.0f, 7.0f, 3.0f, new CubeDeformation(-0.001f)).m_171514_(0, 62).m_171488_(2.0f, -3.0f, 1.5f, 12.0f, 11.0f, 0.0f, new CubeDeformation(-0.001f)), PartPose.m_171423_((float)0.0f, (float)9.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.3054f));
        PartDefinition ringLeft3 = ringLeft2.m_171599_("ringLeft3", CubeListBuilder.m_171558_().m_171514_(67, 88).m_171488_(-2.0f, -1.0f, 0.0f, 4.0f, 6.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)6.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.3054f));
        PartDefinition ringLeft4 = ringLeft3.m_171599_("ringLeft4", CubeListBuilder.m_171558_().m_171514_(76, 46).m_171488_(-2.0f, -1.0f, 0.0f, 4.0f, 9.0f, 3.0f, new CubeDeformation(-0.001f)).m_171514_(52, 37).m_171488_(2.0f, -4.0f, 1.5f, 11.0f, 13.0f, 0.0f, new CubeDeformation(-0.001f)), PartPose.m_171423_((float)0.0f, (float)5.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.3491f));
        PartDefinition ringLeft5 = ringLeft4.m_171599_("ringLeft5", CubeListBuilder.m_171558_().m_171514_(0, 84).m_171488_(-2.0f, -1.0f, 0.0f, 4.0f, 8.0f, 3.0f, new CubeDeformation(-0.001f)), PartPose.m_171423_((float)0.0f, (float)7.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.4363f));
        PartDefinition ringRight = ring.m_171599_("ringRight", CubeListBuilder.m_171558_().m_171514_(84, 26).m_171488_(-3.0f, -1.0f, 0.0f, 6.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)).m_171514_(53, 84).m_171488_(-2.0f, 2.0f, 0.0f, 4.0f, 7.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-17.0f, (float)-3.0f, (float)0.0f));
        PartDefinition rightFox = ringRight.m_171599_("rightFox", CubeListBuilder.m_171558_().m_171514_(17, 66).m_171488_(-2.0f, -5.0f, -2.0f, 4.0f, 4.0f, 7.0f, new CubeDeformation(0.0f)).m_171514_(64, 16).m_171488_(-2.0f, -1.0f, 3.0f, 4.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(24, 62).m_171488_(-2.0f, -1.0f, -1.0f, 4.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(4, 14).m_171488_(-3.0f, -7.0f, -4.0f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(0, 14).m_171488_(2.0f, -7.0f, -4.0f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(71, 73).m_171488_(-2.0f, -7.0f, -5.0f, 4.0f, 4.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition rightFoxTail = rightFox.m_171599_("rightFoxTail", CubeListBuilder.m_171558_().m_171514_(72, 102).m_171480_().m_171488_(-7.0f, -7.0f, 0.0f, 14.0f, 8.0f, 0.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)0.0f, (float)-4.0f, (float)5.0f, (float)0.0873f, (float)0.0f, (float)0.0f));
        PartDefinition rightFoxTail2 = rightFox.m_171599_("rightFoxTail2", CubeListBuilder.m_171558_().m_171514_(72, 109).m_171480_().m_171488_(-7.0f, 0.0f, 0.0f, 14.0f, 8.0f, 0.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)0.0f, (float)-4.0f, (float)5.0f, (float)-0.0873f, (float)0.0f, (float)0.0f));
        PartDefinition ringRight2 = ringRight.m_171599_("ringRight2", CubeListBuilder.m_171558_().m_171514_(84, 16).m_171488_(-2.0f, -1.0f, 0.0f, 4.0f, 7.0f, 3.0f, new CubeDeformation(-0.001f)).m_171514_(0, 62).m_171480_().m_171488_(-14.0f, -3.0f, 1.5f, 12.0f, 11.0f, 0.0f, new CubeDeformation(-0.001f)).m_171555_(false), PartPose.m_171423_((float)0.0f, (float)9.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.3054f));
        PartDefinition ringRight3 = ringRight2.m_171599_("ringRight3", CubeListBuilder.m_171558_().m_171514_(14, 88).m_171488_(-2.0f, -1.0f, 0.0f, 4.0f, 6.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)6.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.3054f));
        PartDefinition ringRight4 = ringRight3.m_171599_("ringRight4", CubeListBuilder.m_171558_().m_171514_(38, 33).m_171488_(-2.0f, -1.0f, 0.0f, 4.0f, 9.0f, 3.0f, new CubeDeformation(-0.001f)).m_171514_(52, 37).m_171480_().m_171488_(-13.0f, -4.0f, 1.5f, 11.0f, 13.0f, 0.0f, new CubeDeformation(-0.001f)).m_171555_(false), PartPose.m_171423_((float)0.0f, (float)5.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.3491f));
        PartDefinition ringRight5 = ringRight4.m_171599_("ringRight5", CubeListBuilder.m_171558_().m_171514_(39, 82).m_171488_(-2.0f, -1.0f, 0.0f, 4.0f, 8.0f, 3.0f, new CubeDeformation(-0.001f)), PartPose.m_171423_((float)0.0f, (float)7.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.4363f));
        PartDefinition armRight = body.m_171599_("armRight", CubeListBuilder.m_171558_().m_171514_(68, 82).m_171488_(0.0f, -1.5f, -1.5f, 7.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-8.0f, (float)0.0f, (float)-8.0f, (float)0.1745f, (float)0.3054f, (float)0.7418f));
        PartDefinition armRight2 = armRight.m_171599_("armRight2", CubeListBuilder.m_171558_().m_171514_(88, 0).m_171488_(0.0f, -1.5f, -1.5f, 6.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)7.0f, (float)0.0f, (float)0.0f, (float)0.0873f, (float)-0.3054f, (float)-0.7418f));
        PartDefinition armLeft = body.m_171599_("armLeft", CubeListBuilder.m_171558_().m_171514_(19, 82).m_171488_(-7.0f, -1.5f, -1.5f, 7.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)8.0f, (float)0.0f, (float)-8.0f, (float)-0.1745f, (float)-0.3054f, (float)0.7418f));
        PartDefinition armLeft2 = armLeft.m_171599_("armLeft2", CubeListBuilder.m_171558_().m_171514_(86, 79).m_171488_(-6.0f, -1.5f, -1.5f, 6.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-7.0f, (float)0.0f, (float)0.0f, (float)-0.0873f, (float)0.3054f, (float)-0.7418f));
        PartDefinition ridingPos = body.m_171599_("ridingPos", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)8.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)128, (int)128);
    }

    public void m_7695_(PoseStack poseStack, VertexConsumer buffer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.model.getMainPart().render(poseStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.model.resetPoses();
        this.body.yRot += netHeadYaw % 360.0f * ((float)Math.PI / 180) * 0.5f;
        float partialTicks = ClientHandlers.getPartialTicks();
        if (((EntitySarcophagus)entity).f_20919_ <= 0 && !((BaseMonster)entity).playDeath()) {
            this.anim.doAnimation((ExtendedModel)this, "idle", ((EntitySarcophagus)entity).f_19797_, partialTicks);
        }
        this.anim.doAnimation((ExtendedModel)this, ((EntitySarcophagus)entity).getAnimationHandler(), partialTicks);
    }

    public ModelPartHandler getHandler() {
        return this.model;
    }

    public boolean transform(T entity, EntityRenderer<T> entityRenderer, Entity rider, EntityRenderer<?> ridingEntityRenderer, PoseStack poseStack, int riderNum) {
        LivingEntityRenderer lR;
        EntityModel model;
        if (ridingEntityRenderer instanceof LivingEntityRenderer && ((model = (lR = (LivingEntityRenderer)ridingEntityRenderer).m_7200_()) instanceof HumanoidModel || model instanceof IllagerModel || model instanceof SittingModel)) {
            this.body.translateAndRotate(poseStack);
            this.ridingPosition.translateAndRotate(poseStack);
            ClientHandlers.translateRider(entityRenderer, rider, model, poseStack);
            return true;
        }
        return false;
    }
}

