/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.client.model.monster;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import io.github.flemmli97.runecraftory.client.ClientHandlers;
import io.github.flemmli97.runecraftory.client.model.SittingModel;
import io.github.flemmli97.runecraftory.common.entities.BaseMonster;
import io.github.flemmli97.runecraftory.common.entities.monster.EntityScorpion;
import io.github.flemmli97.tenshilib.client.AnimationManager;
import io.github.flemmli97.tenshilib.client.model.BlockBenchAnimations;
import io.github.flemmli97.tenshilib.client.model.ExtendedModel;
import io.github.flemmli97.tenshilib.client.model.ModelPartHandler;
import io.github.flemmli97.tenshilib.client.model.RideableModel;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.IllagerModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;

public class ModelScorpion<T extends EntityScorpion>
extends EntityModel<T>
implements ExtendedModel,
RideableModel<T> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(new ResourceLocation("runecraftory", "scorpion"), "main");
    protected final ModelPartHandler model;
    protected final BlockBenchAnimations anim;
    public ModelPartHandler.ModelPartExtended body;
    public ModelPartHandler.ModelPartExtended ridingPosition;

    public ModelScorpion(ModelPart root) {
        this.model = new ModelPartHandler(root, "root");
        this.anim = AnimationManager.getInstance().getAnimation(new ResourceLocation("runecraftory", "scorpion"));
        this.body = this.model.getPart("body");
        this.ridingPosition = this.model.getPart("ridingPos");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition body = partdefinition.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(34, 0).m_171488_(-4.0f, -3.0f, -5.0f, 9.0f, 5.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)21.0f, (float)3.0f));
        PartDefinition bodyBack = body.m_171599_("bodyBack", CubeListBuilder.m_171558_().m_171514_(66, 0).m_171488_(-3.0f, -1.75f, 0.0f, 7.0f, 4.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-0.5f, (float)2.0f));
        PartDefinition tail = bodyBack.m_171599_("tail", CubeListBuilder.m_171558_().m_171514_(0, 13).m_171488_(-2.0f, -4.0f, 0.0f, 5.0f, 4.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)2.0f, (float)6.0f, (float)0.7854f, (float)0.0f, (float)0.0f));
        PartDefinition bone = tail.m_171599_("bone", CubeListBuilder.m_171558_().m_171514_(38, 13).m_171488_(-1.5f, -3.0f, 0.0f, 4.0f, 3.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-1.0f, (float)5.0f, (float)0.6545f, (float)0.0f, (float)0.0f));
        PartDefinition bone2 = bone.m_171599_("bone2", CubeListBuilder.m_171558_().m_171514_(20, 13).m_171488_(-1.5f, -3.0f, 0.0f, 4.0f, 3.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-1.0f, (float)5.0f, (float)0.5236f, (float)0.0f, (float)0.0f));
        PartDefinition bone3 = bone2.m_171599_("bone3", CubeListBuilder.m_171558_().m_171514_(34, 22).m_171488_(-1.0f, -3.0f, 0.0f, 3.0f, 3.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-1.0f, (float)5.0f, (float)0.6545f, (float)0.0f, (float)0.0f));
        PartDefinition bone4 = bone3.m_171599_("bone4", CubeListBuilder.m_171558_().m_171514_(18, 22).m_171488_(-1.0f, -3.0f, 0.0f, 3.0f, 3.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-1.0f, (float)4.0f, (float)0.6545f, (float)0.0f, (float)0.0f));
        PartDefinition bone5 = bone4.m_171599_("bone5", CubeListBuilder.m_171558_().m_171514_(40, 42).m_171488_(-1.0f, -3.0f, 0.0f, 3.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)).m_171514_(20, 48).m_171488_(0.0f, -2.0f, 3.0f, 1.0f, 1.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-1.0f, (float)5.0f, (float)0.2182f, (float)0.0f, (float)0.0f));
        PartDefinition head = body.m_171599_("head", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)-0.5f, (float)-5.0f));
        PartDefinition headFront = head.m_171599_("headFront", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-4.5f, -3.5f, -7.0f, 10.0f, 6.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.5f, (float)0.0f));
        PartDefinition rightLegUp1 = body.m_171599_("rightLegUp1", CubeListBuilder.m_171558_().m_171514_(0, 34).m_171488_(-6.0f, -1.0f, -1.0f, 6.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-3.0f, (float)1.0f, (float)-3.5f, (float)0.0f, (float)-0.5236f, (float)0.3491f));
        PartDefinition rightLegDown1 = rightLegUp1.m_171599_("rightLegDown1", CubeListBuilder.m_171558_().m_171514_(0, 42).m_171488_(-7.0f, -1.0f, -0.5f, 7.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-5.5f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.0873f, (float)-0.7854f));
        PartDefinition rightLegUp2 = body.m_171599_("rightLegUp2", CubeListBuilder.m_171558_().m_171514_(64, 30).m_171488_(-6.0f, -1.0f, -1.0f, 6.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-3.0f, (float)1.0f, (float)-1.5f, (float)0.0f, (float)-0.2618f, (float)0.3491f));
        PartDefinition rightLegDown2 = rightLegUp2.m_171599_("rightLegDown2", CubeListBuilder.m_171558_().m_171514_(64, 39).m_171488_(-7.0f, -1.0f, -0.5f, 7.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-5.5f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.0873f, (float)-0.7854f));
        PartDefinition rightLegUp3 = body.m_171599_("rightLegUp3", CubeListBuilder.m_171558_().m_171514_(48, 30).m_171488_(-6.0f, -1.0f, -1.0f, 6.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-3.0f, (float)1.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.2618f));
        PartDefinition rightLegDown3 = rightLegUp3.m_171599_("rightLegDown3", CubeListBuilder.m_171558_().m_171514_(48, 39).m_171488_(-7.0f, -1.0f, -0.5f, 7.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-5.5f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.1745f, (float)-0.6981f));
        PartDefinition rightLegUp4 = body.m_171599_("rightLegUp4", CubeListBuilder.m_171558_().m_171514_(32, 30).m_171488_(-6.0f, -1.0f, -1.0f, 6.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-3.0f, (float)1.0f, (float)1.5f, (float)0.0f, (float)0.6109f, (float)0.2618f));
        PartDefinition rightLegDown4 = rightLegUp4.m_171599_("rightLegDown4", CubeListBuilder.m_171558_().m_171514_(32, 39).m_171488_(-7.0f, -1.0f, -0.5f, 7.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-5.5f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.4363f, (float)-0.6981f));
        PartDefinition leftLegUp1 = body.m_171599_("leftLegUp1", CubeListBuilder.m_171558_().m_171514_(16, 30).m_171488_(0.0f, -1.0f, -1.0f, 6.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)4.0f, (float)1.0f, (float)-3.5f, (float)0.0f, (float)0.5236f, (float)-0.3491f));
        PartDefinition leftLegDown1 = leftLegUp1.m_171599_("leftLegDown1", CubeListBuilder.m_171558_().m_171514_(16, 39).m_171488_(0.0f, -1.0f, -0.5f, 7.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)5.5f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.0873f, (float)0.7854f));
        PartDefinition leftLegUp2 = body.m_171599_("leftLegUp2", CubeListBuilder.m_171558_().m_171514_(0, 30).m_171488_(0.0f, -1.0f, -1.0f, 6.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)4.0f, (float)1.0f, (float)-1.5f, (float)0.0f, (float)0.2618f, (float)-0.3491f));
        PartDefinition leftLegDown2 = leftLegUp2.m_171599_("leftLegDown2", CubeListBuilder.m_171558_().m_171514_(0, 39).m_171488_(0.0f, -1.0f, -0.5f, 7.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)5.5f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.0873f, (float)0.7854f));
        PartDefinition leftLegUp3 = body.m_171599_("leftLegUp3", CubeListBuilder.m_171558_().m_171514_(48, 26).m_171488_(0.0f, -1.0f, -1.0f, 6.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)3.0f, (float)1.0f, (float)1.0f, (float)0.0f, (float)0.0f, (float)-0.2618f));
        PartDefinition leftLegDown3 = leftLegUp3.m_171599_("leftLegDown3", CubeListBuilder.m_171558_().m_171514_(60, 34).m_171488_(0.0f, -1.0f, -0.5f, 7.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)5.5f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.1745f, (float)0.6981f));
        PartDefinition leftLegUp4 = body.m_171599_("leftLegUp4", CubeListBuilder.m_171558_().m_171514_(48, 22).m_171488_(0.0f, -1.0f, -1.0f, 6.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)3.0f, (float)1.0f, (float)1.5f, (float)0.0f, (float)-0.6109f, (float)-0.2618f));
        PartDefinition leftLegDown4 = leftLegUp4.m_171599_("leftLegDown4", CubeListBuilder.m_171558_().m_171514_(44, 34).m_171488_(0.0f, -1.0f, -0.5f, 7.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)5.5f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.4363f, (float)0.6981f));
        PartDefinition shearsLeftBase = body.m_171599_("shearsLeftBase", CubeListBuilder.m_171558_().m_171514_(28, 42).m_171488_(0.0f, -1.5f, -2.0f, 3.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)5.0f, (float)0.5f, (float)-8.5f));
        PartDefinition leg1Down9 = shearsLeftBase.m_171599_("leg1Down9", CubeListBuilder.m_171558_().m_171514_(64, 42).m_171488_(0.0f, -1.0f, -2.0f, 4.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)3.0f, (float)0.0f, (float)0.5f, (float)0.0f, (float)1.0472f, (float)0.0f));
        PartDefinition leg1Down10 = leg1Down9.m_171599_("leg1Down10", CubeListBuilder.m_171558_().m_171514_(0, 22).m_171488_(0.0f, -2.0f, -2.5f, 5.0f, 3.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)4.0f, (float)0.0f, (float)-0.5f, (float)0.0f, (float)0.829f, (float)0.0f));
        PartDefinition leg1Down11 = leg1Down10.m_171599_("leg1Down11", CubeListBuilder.m_171558_().m_171514_(30, 34).m_171488_(-0.5f, -1.5f, -1.25f, 5.0f, 3.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)5.0f, (float)-0.5f, (float)0.0f, (float)0.0f, (float)0.4363f, (float)0.0f));
        PartDefinition leg1Down12 = leg1Down10.m_171599_("leg1Down12", CubeListBuilder.m_171558_().m_171514_(10, 48).m_171488_(0.0f, -1.0f, -1.0f, 4.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)4.0f, (float)-0.5f, (float)-1.5f, (float)0.0f, (float)0.4363f, (float)0.0f));
        PartDefinition shearsRightBase = body.m_171599_("shearsRightBase", CubeListBuilder.m_171558_().m_171514_(16, 42).m_171488_(-3.0f, -1.5f, -2.0f, 3.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-4.0f, (float)0.5f, (float)-8.5f));
        PartDefinition leg1Down13 = shearsRightBase.m_171599_("leg1Down13", CubeListBuilder.m_171558_().m_171514_(52, 42).m_171488_(-4.0f, -1.0f, -2.0f, 4.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-3.0f, (float)0.0f, (float)0.5f, (float)0.0f, (float)-1.0472f, (float)0.0f));
        PartDefinition leg1Down14 = leg1Down13.m_171599_("leg1Down14", CubeListBuilder.m_171558_().m_171514_(56, 13).m_171488_(-5.0f, -2.0f, -2.5f, 5.0f, 3.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-4.0f, (float)0.0f, (float)-0.5f, (float)0.0f, (float)-0.829f, (float)0.0f));
        PartDefinition leg1Down15 = leg1Down14.m_171599_("leg1Down15", CubeListBuilder.m_171558_().m_171514_(16, 34).m_171488_(-5.0f, -1.5f, -1.5f, 5.0f, 3.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-4.75f, (float)-0.5f, (float)0.25f, (float)0.0f, (float)-0.4363f, (float)0.0f));
        PartDefinition leg1Down16 = leg1Down14.m_171599_("leg1Down16", CubeListBuilder.m_171558_().m_171514_(0, 48).m_171488_(-4.0f, -1.0f, -1.0f, 4.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-4.0f, (float)-0.5f, (float)-1.5f, (float)0.0f, (float)-0.4363f, (float)0.0f));
        PartDefinition riderPos = body.m_171599_("ridingPos", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)-3.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)128, (int)128);
    }

    public void m_7695_(PoseStack poseStack, VertexConsumer buffer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.model.getMainPart().render(poseStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.model.resetPoses();
        float partialTicks = ClientHandlers.getPartialTicks();
        if (((EntityScorpion)entity).f_20919_ <= 0 && !((BaseMonster)entity).playDeath()) {
            this.anim.doAnimation((ExtendedModel)this, "idle", ((EntityScorpion)entity).f_19797_, partialTicks);
            if (((BaseMonster)entity).moveTick() > 0) {
                this.anim.doAnimation((ExtendedModel)this, "walk", ((EntityScorpion)entity).f_19797_, partialTicks, ((BaseMonster)entity).interpolatedMoveTick(partialTicks));
            }
        }
        this.anim.doAnimation((ExtendedModel)this, ((EntityScorpion)entity).getAnimationHandler(), partialTicks);
    }

    public ModelPartHandler getHandler() {
        return this.model;
    }

    public boolean transform(T entity, EntityRenderer<T> entityRenderer, Entity rider, EntityRenderer<?> ridingEntityRenderer, PoseStack poseStack, int riderNum) {
        LivingEntityRenderer lR;
        EntityModel model;
        if (ridingEntityRenderer instanceof LivingEntityRenderer && ((model = (lR = (LivingEntityRenderer)ridingEntityRenderer).m_7200_()) instanceof HumanoidModel || model instanceof IllagerModel || model instanceof SittingModel)) {
            this.body.translateAndRotate(poseStack);
            this.ridingPosition.translateAndRotate(poseStack);
            ClientHandlers.translateRider(entityRenderer, rider, model, poseStack);
            return true;
        }
        return false;
    }
}

