/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.client.model.monster;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import io.github.flemmli97.runecraftory.client.ClientHandlers;
import io.github.flemmli97.runecraftory.client.model.SittingModel;
import io.github.flemmli97.runecraftory.common.entities.BaseMonster;
import io.github.flemmli97.runecraftory.common.entities.monster.boss.EntitySkelefang;
import io.github.flemmli97.runecraftory.common.particles.SkelefangParticleData;
import io.github.flemmli97.tenshilib.api.entity.AnimatedAction;
import io.github.flemmli97.tenshilib.client.AnimationManager;
import io.github.flemmli97.tenshilib.client.model.BlockBenchAnimations;
import io.github.flemmli97.tenshilib.client.model.ExtendedModel;
import io.github.flemmli97.tenshilib.client.model.ModelPartHandler;
import io.github.flemmli97.tenshilib.client.model.RideableModel;
import java.util.function.Function;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.IllagerModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;

public class ModelSkelefang<T extends EntitySkelefang>
extends EntityModel<T>
implements ExtendedModel,
RideableModel<T> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(new ResourceLocation("runecraftory", "skelefang"), "main");
    protected final ModelPartHandler model;
    protected final BlockBenchAnimations anim;
    public ModelPartHandler.ModelPartExtended head;
    public ModelPartHandler.ModelPartExtended neck;
    public ModelPartHandler.ModelPartExtended body;
    public ModelPartHandler.ModelPartExtended spineFront;
    public ModelPartHandler.ModelPartExtended ribsBody;
    public ModelPartHandler.ModelPartExtended spineBack;
    public ModelPartHandler.ModelPartExtended ribsSpine;
    public ModelPartHandler.ModelPartExtended leftLegBase;
    public ModelPartHandler.ModelPartExtended rightLegBase;
    public ModelPartHandler.ModelPartExtended tailBase;
    public ModelPartHandler.ModelPartExtended tail;
    public ModelPartHandler.ModelPartExtended bone1;
    public ModelPartHandler.ModelPartExtended bone2;
    public ModelPartHandler.ModelPartExtended heart;
    public ModelPartHandler.ModelPartExtended ridingPositionBones;
    public ModelPartHandler.ModelPartExtended ridingPositionHeart;
    private float restoreProgress = -1.0f;
    private float entityTick;
    private boolean translucentTail;
    private boolean translucentTailBase;
    private boolean translucentSpineBack;
    private boolean translucentSpineFront;
    private boolean translucentBackRibs;
    private boolean translucentFrontRibs;

    public ModelSkelefang(ModelPart root, Function<ResourceLocation, RenderType> function) {
        super(function);
        this.model = new ModelPartHandler(root, "root");
        this.anim = AnimationManager.getInstance().getAnimation(new ResourceLocation("runecraftory", "skelefang"));
        this.head = this.model.getPart("head");
        this.neck = this.model.getPart("neckSpine");
        this.body = this.model.getPart("body");
        this.spineFront = this.model.getPart("spineFront");
        this.ribsBody = this.model.getPart("ribsBody");
        this.spineBack = this.model.getPart("spineBack");
        this.ribsSpine = this.model.getPart("ribsSpine");
        this.leftLegBase = this.model.getPart("legLeftConnectorBase");
        this.rightLegBase = this.model.getPart("legRightConnectorBase");
        this.tailBase = this.model.getPart("tailBase");
        this.tail = this.model.getPart("tail");
        this.bone1 = this.model.getPart("randomBone");
        this.bone2 = this.model.getPart("randomBone2");
        this.heart = this.model.getPart("heartYAxis");
        this.ridingPositionBones = this.model.getPart("ridingPosBones");
        this.ridingPositionHeart = this.model.getPart("ridingPosHeart");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition body = partdefinition.m_171599_("body", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)-15.5f, (float)-13.0f));
        PartDefinition spineFront = body.m_171599_("spineFront", CubeListBuilder.m_171558_().m_171514_(40, 39).m_171488_(-4.0f, -4.5f, -10.0f, 8.0f, 8.0f, 24.0f, new CubeDeformation(0.0f)).m_171514_(0, 0).m_171488_(-1.5f, -12.5f, 0.0f, 3.0f, 8.0f, 3.0f, new CubeDeformation(0.0f)).m_171514_(84, 85).m_171488_(-1.0f, -9.5f, -7.0f, 2.0f, 5.0f, 2.0f, new CubeDeformation(0.0f)).m_171514_(0, 63).m_171488_(-2.0f, -14.5f, 8.0f, 4.0f, 10.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition ribsBody = spineFront.m_171599_("ribsBody", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition ribBaseLeft = ribsBody.m_171599_("ribBaseLeft", CubeListBuilder.m_171558_().m_171514_(80, 187).m_171488_(-0.5f, 0.0f, -2.0f, 16.0f, 4.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)4.0f, (float)-3.5f, (float)-7.0f, (float)0.0f, (float)0.0f, (float)0.7418f));
        PartDefinition ribOtherLeft = ribBaseLeft.m_171599_("ribOtherLeft", CubeListBuilder.m_171558_().m_171514_(183, 65).m_171488_(0.0f, 0.0f, -2.0f, 17.0f, 4.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)15.5f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)1.3963f));
        PartDefinition ribBaseLeft2 = ribsBody.m_171599_("ribBaseLeft2", CubeListBuilder.m_171558_().m_171514_(96, 138).m_171488_(-0.5f, 0.0f, -3.0f, 23.0f, 6.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)4.0f, (float)-3.5f, (float)0.5f, (float)0.0f, (float)0.0f, (float)0.5672f));
        PartDefinition legLeftConnectorBase = ribBaseLeft2.m_171599_("legLeftConnectorBase", CubeListBuilder.m_171558_().m_171514_(179, 26).m_171488_(0.0f, 0.0f, -3.0f, 16.0f, 5.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)6.5f, (float)0.0f, (float)0.0f, (float)-0.0873f, (float)0.0f, (float)-0.7418f));
        PartDefinition legLeftConnector = legLeftConnectorBase.m_171599_("legLeftConnector", CubeListBuilder.m_171558_().m_171514_(42, 173).m_171488_(0.0f, 0.0f, -3.0f, 17.0f, 5.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)16.0f, (float)1.0f, (float)0.0f, (float)0.0f, (float)-0.0873f, (float)1.0908f));
        PartDefinition legLeftBase = legLeftConnector.m_171599_("legLeftBase", CubeListBuilder.m_171558_().m_171514_(78, 0).m_171488_(-1.0f, -3.5f, 0.0f, 27.0f, 7.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)6.0f, (float)2.5f, (float)3.0f, (float)0.1222f, (float)-0.5061f, (float)0.5585f));
        PartDefinition leftLeg = legLeftBase.m_171599_("leftLeg", CubeListBuilder.m_171558_().m_171514_(0, 63).m_171488_(0.0f, -3.0f, -11.5f, 6.0f, 6.0f, 22.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)26.0f, (float)0.0f, (float)-0.5f, (float)0.1745f, (float)-0.0873f, (float)-0.0873f));
        PartDefinition leftClaws = leftLeg.m_171599_("leftClaws", CubeListBuilder.m_171558_(), PartPose.m_171423_((float)3.0f, (float)0.0f, (float)-11.5f, (float)0.0f, (float)-1.0036f, (float)0.0f));
        PartDefinition leftClaw = leftClaws.m_171599_("leftClaw", CubeListBuilder.m_171558_().m_171514_(82, 172).m_171488_(-14.0f, -2.0f, -1.5f, 14.0f, 4.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)1.5f, (float)-0.5f, (float)-1.5f, (float)0.0f, (float)0.0f, (float)-0.8727f));
        PartDefinition leftClaw2 = leftClaws.m_171599_("leftClaw2", CubeListBuilder.m_171558_().m_171514_(82, 172).m_171488_(-14.0f, -2.0f, -1.5f, 14.0f, 4.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)1.5f, (float)-0.5f, (float)-1.5f));
        PartDefinition leftClaw3 = leftClaws.m_171599_("leftClaw3", CubeListBuilder.m_171558_().m_171514_(82, 172).m_171488_(-14.0f, -2.0f, -1.5f, 14.0f, 4.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)1.5f, (float)-0.5f, (float)-1.5f, (float)0.0f, (float)0.0f, (float)0.8727f));
        PartDefinition ribOtherLeft2 = ribBaseLeft2.m_171599_("ribOtherLeft2", CubeListBuilder.m_171558_().m_171514_(142, 109).m_171488_(0.0f, 0.0f, -3.0f, 22.0f, 6.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)22.5f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)1.1345f));
        PartDefinition ribBaseLeft3 = ribsBody.m_171599_("ribBaseLeft3", CubeListBuilder.m_171558_().m_171514_(129, 71).m_171488_(-0.5f, 0.0f, -3.0f, 24.0f, 6.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)4.0f, (float)-3.5f, (float)9.5f, (float)0.0f, (float)0.0f, (float)0.48f));
        PartDefinition ribOtherLeft3 = ribBaseLeft3.m_171599_("ribOtherLeft3", CubeListBuilder.m_171558_().m_171514_(123, 31).m_171488_(0.0f, 0.0f, -3.0f, 25.0f, 6.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)23.5f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)1.0472f));
        PartDefinition ribBaseRight = ribsBody.m_171599_("ribBaseRight", CubeListBuilder.m_171558_().m_171514_(187, 18).m_171488_(-15.5f, 0.0f, -2.0f, 16.0f, 4.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-4.0f, (float)-3.5f, (float)-7.0f, (float)0.0f, (float)0.0f, (float)-0.7418f));
        PartDefinition ribOtherRight = ribBaseRight.m_171599_("ribOtherRight", CubeListBuilder.m_171558_().m_171514_(181, 10).m_171488_(-17.0f, 0.0f, -2.0f, 17.0f, 4.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-15.5f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-1.3963f));
        PartDefinition ribBaseRight2 = ribsBody.m_171599_("ribBaseRight2", CubeListBuilder.m_171558_().m_171514_(138, 43).m_171488_(-22.5f, 0.0f, -3.0f, 23.0f, 6.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-4.0f, (float)-3.5f, (float)0.5f, (float)0.0f, (float)0.0f, (float)-0.5672f));
        PartDefinition legRightConnectorBase = ribBaseRight2.m_171599_("legRightConnectorBase", CubeListBuilder.m_171558_().m_171514_(178, 131).m_171488_(-16.0f, 0.0f, -3.0f, 16.0f, 5.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-6.5f, (float)0.0f, (float)0.0f, (float)-0.0873f, (float)0.0f, (float)0.7418f));
        PartDefinition legRightConnector = legRightConnectorBase.m_171599_("legRightConnector", CubeListBuilder.m_171558_().m_171514_(134, 171).m_171488_(-17.0f, 0.0f, -3.0f, 17.0f, 5.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-16.0f, (float)1.0f, (float)0.0f, (float)0.0f, (float)0.0873f, (float)-1.0908f));
        PartDefinition legRightBase = legRightConnector.m_171599_("legRightBase", CubeListBuilder.m_171558_().m_171514_(34, 71).m_171488_(-26.0f, -3.5f, 0.0f, 27.0f, 7.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-6.0f, (float)2.5f, (float)3.0f, (float)0.1222f, (float)0.5061f, (float)-0.5585f));
        PartDefinition rightLeg = legRightBase.m_171599_("rightLeg", CubeListBuilder.m_171558_().m_171514_(44, 9).m_171488_(-6.0f, -3.0f, -11.5f, 6.0f, 6.0f, 22.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-26.0f, (float)0.0f, (float)-0.5f, (float)0.1745f, (float)0.0873f, (float)0.0873f));
        PartDefinition rightClaws = rightLeg.m_171599_("rightClaws", CubeListBuilder.m_171558_(), PartPose.m_171423_((float)-3.0f, (float)0.0f, (float)-11.5f, (float)0.0f, (float)1.0036f, (float)0.0f));
        PartDefinition rightClaw = rightClaws.m_171599_("rightClaw", CubeListBuilder.m_171558_().m_171514_(51, 0).m_171488_(0.0f, -2.0f, -1.5f, 14.0f, 4.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-1.5f, (float)-0.5f, (float)-1.5f, (float)0.0f, (float)0.0f, (float)0.8727f));
        PartDefinition rightClaw2 = rightClaws.m_171599_("rightClaw2", CubeListBuilder.m_171558_().m_171514_(51, 0).m_171488_(0.0f, -2.0f, -1.5f, 14.0f, 4.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-1.5f, (float)-0.5f, (float)-1.5f));
        PartDefinition rightClaw3 = rightClaws.m_171599_("rightClaw3", CubeListBuilder.m_171558_().m_171514_(51, 0).m_171488_(0.0f, -2.0f, -1.5f, 14.0f, 4.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-1.5f, (float)-0.5f, (float)-1.5f, (float)0.0f, (float)0.0f, (float)-0.8727f));
        PartDefinition ribOtherRight2 = ribBaseRight2.m_171599_("ribOtherRight2", CubeListBuilder.m_171558_().m_171514_(142, 83).m_171488_(-22.0f, 0.0f, -3.0f, 22.0f, 6.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-22.5f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-1.1345f));
        PartDefinition ribBaseRight3 = ribsBody.m_171599_("ribBaseRight3", CubeListBuilder.m_171558_().m_171514_(0, 129).m_171488_(-23.5f, 0.0f, -3.0f, 24.0f, 6.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-4.0f, (float)-3.5f, (float)9.5f, (float)0.0f, (float)0.0f, (float)-0.48f));
        PartDefinition ribOtherRight3 = ribBaseRight3.m_171599_("ribOtherRight3", CubeListBuilder.m_171558_().m_171514_(62, 122).m_171488_(-25.0f, 0.0f, -3.0f, 25.0f, 6.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-23.5f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-1.0472f));
        PartDefinition neckSpine = spineFront.m_171599_("neckSpine", CubeListBuilder.m_171558_().m_171514_(92, 97).m_171488_(-3.0f, -3.0f, -19.0f, 6.0f, 6.0f, 19.0f, new CubeDeformation(0.0f)).m_171514_(80, 37).m_171488_(-1.5f, -9.0f, -5.5f, 3.0f, 6.0f, 3.0f, new CubeDeformation(0.0f)).m_171514_(123, 43).m_171488_(-1.0f, -10.0f, -10.5f, 2.0f, 7.0f, 2.0f, new CubeDeformation(0.0f)).m_171514_(92, 109).m_171488_(-7.0f, -1.0f, -11.0f, 4.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)).m_171514_(92, 103).m_171488_(-9.0f, -1.5f, -6.0f, 6.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)).m_171514_(27, 102).m_171488_(3.0f, -1.5f, -6.0f, 6.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)).m_171514_(98, 59).m_171488_(3.0f, -1.0f, -11.0f, 4.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-0.5f, (float)-9.5f, (float)0.0873f, (float)0.0f, (float)0.0f));
        PartDefinition head = neckSpine.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(48, 85).m_171488_(-7.5f, -18.0f, -8.0f, 14.0f, 24.0f, 8.0f, new CubeDeformation(0.0f)).m_171514_(0, 0).m_171488_(-9.5f, -17.0f, -23.0f, 18.0f, 16.0f, 15.0f, new CubeDeformation(0.0f)).m_171514_(92, 72).m_171488_(-6.5f, -13.0f, -36.0f, 12.0f, 12.0f, 13.0f, new CubeDeformation(0.0f)).m_171514_(56, 117).m_171488_(-6.5f, -15.0f, -36.0f, 12.0f, 2.0f, 3.0f, new CubeDeformation(0.0f)).m_171514_(165, 157).m_171488_(-6.5f, -1.0f, -36.0f, 12.0f, 1.0f, 13.0f, new CubeDeformation(-0.025f)).m_171514_(78, 14).m_171488_(-9.0f, -1.0f, -23.0f, 17.0f, 2.0f, 15.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)0.5f, (float)-15.0f, (float)-0.1745f, (float)0.0f, (float)0.0f));
        PartDefinition headBack = head.m_171599_("headBack", CubeListBuilder.m_171558_().m_171514_(170, 172).m_171488_(-5.5f, -7.0f, 0.0f, 10.0f, 7.0f, 10.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-11.0f, (float)0.0f, (float)0.4363f, (float)0.0f, (float)0.0f));
        PartDefinition horn = head.m_171599_("horn", CubeListBuilder.m_171558_().m_171514_(0, 31).m_171488_(-3.5f, -17.0f, -6.0f, 6.0f, 17.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-17.0f, (float)-11.0f, (float)0.7418f, (float)0.0f, (float)0.0f));
        PartDefinition jaw = head.m_171599_("jaw", CubeListBuilder.m_171558_().m_171514_(80, 37).m_171488_(-7.5f, 0.0f, -15.0f, 14.0f, 7.0f, 15.0f, new CubeDeformation(0.0f)).m_171514_(109, 122).m_171488_(-7.5f, -1.0f, -15.0f, 14.0f, 1.0f, 15.0f, new CubeDeformation(-0.025f)).m_171514_(141, 138).m_171488_(-6.5f, 0.0f, -28.0f, 12.0f, 6.0f, 13.0f, new CubeDeformation(0.0f)).m_171514_(31, 159).m_171488_(-6.5f, -1.0f, -28.0f, 12.0f, 1.0f, 13.0f, new CubeDeformation(-0.025f)), PartPose.m_171423_((float)0.0f, (float)-1.0f, (float)-8.0f, (float)0.1309f, (float)0.0f, (float)0.0f));
        PartDefinition ridingPosBones = spineFront.m_171599_("ridingPosBones", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)-4.0f, (float)6.0f));
        PartDefinition heartYAxis = body.m_171599_("heartYAxis", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)9.5f, (float)13.0f));
        PartDefinition heartZAxis = heartYAxis.m_171599_("heartZAxis", CubeListBuilder.m_171558_(), PartPose.m_171423_((float)0.0f, (float)7.0f, (float)0.0f, (float)-0.6109f, (float)0.0f, (float)0.0f));
        PartDefinition heartXAxis = heartZAxis.m_171599_("heartXAxis", CubeListBuilder.m_171558_().m_171514_(48, 134).m_171488_(-6.0f, -6.0f, -6.0f, 12.0f, 12.0f, 12.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.7854f));
        PartDefinition ridingPosHeart = heartYAxis.m_171599_("ridingPosHeart", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)3.0f));
        PartDefinition spineBack = body.m_171599_("spineBack", CubeListBuilder.m_171558_().m_171514_(0, 31).m_171488_(-4.0f, -4.0f, 0.0f, 8.0f, 8.0f, 24.0f, new CubeDeformation(0.0f)).m_171514_(0, 91).m_171488_(-2.0f, -13.0f, 2.0f, 4.0f, 9.0f, 4.0f, new CubeDeformation(0.0f)).m_171514_(27, 91).m_171488_(-2.0f, -11.0f, 10.0f, 4.0f, 7.0f, 4.0f, new CubeDeformation(0.0f)).m_171514_(78, 14).m_171488_(-1.5f, -10.0f, 18.0f, 3.0f, 6.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-0.5f, (float)14.0f, (float)-0.0873f, (float)0.0f, (float)0.0f));
        PartDefinition ribsSpine = spineBack.m_171599_("ribsSpine", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition ribBaseLeft4 = ribsSpine.m_171599_("ribBaseLeft4", CubeListBuilder.m_171558_().m_171514_(127, 14).m_171488_(-0.5f, 0.0f, -3.0f, 24.0f, 6.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)4.0f, (float)-3.0f, (float)5.0f, (float)0.0f, (float)0.0f, (float)0.5236f));
        PartDefinition ribOtherLeft4 = ribBaseLeft4.m_171599_("ribOtherLeft4", CubeListBuilder.m_171558_().m_171514_(0, 117).m_171488_(0.0f, 0.0f, -3.0f, 25.0f, 6.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)23.5f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)1.2217f));
        PartDefinition ribBaseLeft5 = ribsSpine.m_171599_("ribBaseLeft5", CubeListBuilder.m_171558_().m_171514_(160, 55).m_171488_(-0.5f, 0.0f, -2.5f, 22.0f, 5.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)4.0f, (float)-3.0f, (float)13.75f, (float)0.0f, (float)0.0f, (float)0.5672f));
        PartDefinition ribOtherLeft5 = ribBaseLeft5.m_171599_("ribOtherLeft5", CubeListBuilder.m_171558_().m_171514_(124, 157).m_171488_(0.0f, 0.0f, -2.5f, 22.0f, 5.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)21.5f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)1.3526f));
        PartDefinition ribBaseLeft6 = ribsSpine.m_171599_("ribBaseLeft6", CubeListBuilder.m_171558_().m_171514_(178, 142).m_171488_(-0.5f, 0.0f, -2.0f, 17.0f, 4.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)4.0f, (float)-3.0f, (float)21.5f, (float)0.0f, (float)0.0f, (float)0.6545f));
        PartDefinition ribOtherLeft6 = ribBaseLeft6.m_171599_("ribOtherLeft6", CubeListBuilder.m_171558_().m_171514_(40, 184).m_171488_(0.0f, 0.0f, -2.0f, 16.0f, 4.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)16.5f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)1.3526f));
        PartDefinition ribBaseRight4 = ribsSpine.m_171599_("ribBaseRight4", CubeListBuilder.m_171558_().m_171514_(123, 97).m_171488_(-23.5f, 0.0f, -3.0f, 24.0f, 6.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-4.0f, (float)-3.0f, (float)5.0f, (float)0.0f, (float)0.0f, (float)-0.5236f));
        PartDefinition ribOtherRight4 = ribBaseRight4.m_171599_("ribOtherRight4", CubeListBuilder.m_171558_().m_171514_(104, 59).m_171488_(-25.0f, 0.0f, -3.0f, 25.0f, 6.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-23.5f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-1.2217f));
        PartDefinition ribBaseRight5 = ribsSpine.m_171599_("ribBaseRight5", CubeListBuilder.m_171558_().m_171514_(152, 121).m_171488_(-21.5f, 0.0f, -2.5f, 22.0f, 5.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-4.0f, (float)-3.0f, (float)13.75f, (float)0.0f, (float)0.0f, (float)-0.5672f));
        PartDefinition ribOtherRight5 = ribBaseRight5.m_171599_("ribOtherRight5", CubeListBuilder.m_171558_().m_171514_(146, 0).m_171488_(-22.0f, 0.0f, -2.5f, 22.0f, 5.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-21.5f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-1.3526f));
        PartDefinition ribBaseRight6 = ribsSpine.m_171599_("ribBaseRight6", CubeListBuilder.m_171558_().m_171514_(177, 95).m_171488_(-16.5f, 0.0f, -2.0f, 17.0f, 4.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-4.0f, (float)-3.0f, (float)21.5f, (float)0.0f, (float)0.0f, (float)-0.6545f));
        PartDefinition ribOtherRight6 = ribBaseRight6.m_171599_("ribOtherRight6", CubeListBuilder.m_171558_().m_171514_(0, 184).m_171488_(-16.0f, 0.0f, -2.0f, 16.0f, 4.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-16.5f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-1.3526f));
        PartDefinition tailBase = spineBack.m_171599_("tailBase", CubeListBuilder.m_171558_().m_171514_(80, 150).m_171488_(-3.0f, -3.5f, 0.0f, 6.0f, 6.0f, 16.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)0.5f, (float)23.5f, (float)-0.1745f, (float)0.0f, (float)0.0f));
        PartDefinition tail = tailBase.m_171599_("tail", CubeListBuilder.m_171558_().m_171514_(109, 167).m_171488_(-2.5f, -2.5f, 0.0f, 5.0f, 5.0f, 15.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-0.5f, (float)15.5f, (float)-0.2618f, (float)0.0f, (float)0.0f));
        PartDefinition tail2 = tail.m_171599_("tail2", CubeListBuilder.m_171558_().m_171514_(0, 141).m_171488_(-2.5f, -2.5f, 0.0f, 5.0f, 5.0f, 17.0f, new CubeDeformation(0.0f)).m_171514_(78, 23).m_171488_(-6.5f, -1.5f, 4.0f, 4.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)).m_171514_(100, 31).m_171488_(-8.5f, -1.5f, 12.0f, 6.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)).m_171514_(51, 7).m_171488_(2.5f, -1.5f, 4.0f, 4.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)).m_171514_(92, 97).m_171488_(2.5f, -1.5f, 12.0f, 6.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)15.0f, (float)0.3491f, (float)0.0f, (float)0.0f));
        PartDefinition tail3 = tail2.m_171599_("tail3", CubeListBuilder.m_171558_().m_171514_(0, 163).m_171488_(-2.0f, -2.0f, 0.0f, 4.0f, 4.0f, 17.0f, new CubeDeformation(0.0f)).m_171514_(40, 43).m_171488_(-10.5f, -1.5f, 4.0f, 9.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)).m_171514_(40, 37).m_171488_(1.5f, -1.5f, 4.0f, 9.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)).m_171514_(0, 77).m_171488_(-8.5f, -1.5f, 11.0f, 7.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)).m_171514_(40, 49).m_171488_(1.5f, -1.5f, 11.0f, 7.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)17.0f, (float)0.1745f, (float)0.0f, (float)0.0f));
        PartDefinition tail4 = tail3.m_171599_("tail4", CubeListBuilder.m_171558_().m_171514_(0, 91).m_171488_(-1.5f, -1.5f, 0.0f, 3.0f, 3.0f, 21.0f, new CubeDeformation(0.0f)).m_171514_(80, 46).m_171488_(-6.5f, -1.0f, 12.0f, 5.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)).m_171514_(27, 108).m_171488_(-7.5f, -1.0f, 7.0f, 6.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)).m_171514_(0, 104).m_171488_(-8.5f, -1.0f, 2.0f, 7.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)).m_171514_(0, 11).m_171488_(1.5f, -1.0f, 12.0f, 5.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)).m_171514_(0, 108).m_171488_(1.5f, -1.0f, 7.0f, 6.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)).m_171514_(80, 59).m_171488_(1.5f, -1.0f, 2.0f, 7.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)17.0f, (float)0.3054f, (float)0.0f, (float)0.0f));
        PartDefinition randomBone = partdefinition.m_171599_("randomBone", CubeListBuilder.m_171558_().m_171514_(40, 39).m_171488_(-4.0f, -4.0f, -12.0f, 8.0f, 8.0f, 24.0f, new CubeDeformation(-2.75f)), PartPose.m_171419_((float)0.0f, (float)22.75f, (float)0.0f));
        PartDefinition randomBone2 = partdefinition.m_171599_("randomBone2", CubeListBuilder.m_171558_().m_171514_(187, 18).m_171488_(-8.0f, -2.0f, -2.0f, 16.0f, 4.0f, 4.0f, new CubeDeformation(-1.5f)), PartPose.m_171423_((float)0.0f, (float)23.5f, (float)0.0f, (float)0.0f, (float)-1.5708f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)256, (int)256);
    }

    public void m_7695_(PoseStack poseStack, VertexConsumer buffer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        if (this.restoreProgress != -1.0f) {
            float newAlpha = Math.min(1.0f, this.restoreProgress);
            this.translateTo(poseStack, this.body);
            this.heart.render(poseStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
            this.spineBack.render(poseStack, buffer, packedLight, packedOverlay, red, green, blue, newAlpha);
            this.spineFront.render(poseStack, buffer, packedLight, packedOverlay, red, green, blue, newAlpha);
        } else {
            this.body.render(poseStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
        }
        float translucent = 0.4f + Mth.m_14031_((float)(this.entityTick * 0.3f)) * 0.2f;
        poseStack.m_85836_();
        if (this.translucentSpineBack) {
            this.spineBack.visible = true;
            this.tail.visible = true;
            this.tailBase.visible = true;
            this.ribsSpine.visible = true;
            this.translateTo(poseStack, this.body);
            this.spineBack.render(poseStack, buffer, packedLight, packedOverlay, red, green, blue, translucent);
            this.spineBack.visible = false;
            this.tail.visible = false;
            this.tailBase.visible = false;
            this.ribsSpine.visible = false;
        } else {
            if (this.translucentBackRibs) {
                this.ribsSpine.visible = true;
                poseStack.m_85836_();
                this.translateTo(poseStack, this.body, this.spineBack);
                this.ribsSpine.render(poseStack, buffer, packedLight, packedOverlay, red, green, blue, translucent);
                poseStack.m_85849_();
                this.ribsSpine.visible = false;
            }
            if (this.translucentTailBase) {
                this.tail.visible = true;
                this.tailBase.visible = true;
                this.translateTo(poseStack, this.body, this.spineBack);
                this.tailBase.render(poseStack, buffer, packedLight, packedOverlay, red, green, blue, translucent);
                this.tail.visible = false;
                this.tailBase.visible = false;
            } else if (this.translucentTail) {
                this.tail.visible = true;
                this.translateTo(poseStack, this.body, this.spineBack, this.tailBase);
                this.tail.render(poseStack, buffer, packedLight, packedOverlay, red, green, blue, translucent);
                this.tail.visible = false;
            }
        }
        poseStack.m_85849_();
        poseStack.m_85836_();
        if (this.translucentSpineFront) {
            this.spineFront.visible = true;
            this.ribsBody.visible = true;
            this.translateTo(poseStack, this.body);
            this.spineFront.render(poseStack, buffer, packedLight, packedOverlay, red, green, blue, translucent);
            this.ribsBody.visible = false;
            this.spineFront.visible = false;
        } else if (this.translucentFrontRibs) {
            this.ribsBody.visible = true;
            this.translateTo(poseStack, this.body, this.spineFront);
            this.ribsBody.render(poseStack, buffer, packedLight, packedOverlay, red, green, blue, translucent);
            this.ribsBody.visible = false;
        }
        poseStack.m_85849_();
    }

    private void translateTo(PoseStack stack, ModelPartHandler.ModelPartExtended ... parts) {
        for (ModelPartHandler.ModelPartExtended part : parts) {
            part.translateAndRotate(stack);
        }
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.model.resetPoses();
        this.body.setAllVisible(true);
        this.updateFromBones((EntitySkelefang)entity);
        this.entityTick = ((EntitySkelefang)entity).f_19797_;
        AnimatedAction anim = ((EntitySkelefang)entity).getAnimationHandler().getAnimation();
        float partialTicks = ClientHandlers.getPartialTicks();
        if (((EntitySkelefang)entity).f_20919_ <= 0 && !((BaseMonster)entity).playDeath()) {
            this.neck.yRot = (float)((double)this.neck.yRot + (double)(netHeadYaw % 360.0f * ((float)Math.PI / 180)) * 0.2);
            this.neck.xRot = (float)((double)this.neck.xRot + (double)(headPitch * ((float)Math.PI / 180)) * 0.2);
            this.head.yRot = (float)((double)this.head.yRot + (double)(netHeadYaw % 360.0f * ((float)Math.PI / 180)) * 0.4);
            this.head.xRot = (float)((double)this.head.xRot + (double)(headPitch * ((float)Math.PI / 180)) * 0.4);
            this.anim.doAnimation((ExtendedModel)this, "idle", ((EntitySkelefang)entity).f_19797_, partialTicks);
            if (((BaseMonster)entity).moveTick() > 0) {
                this.anim.doAnimation((ExtendedModel)this, "walk", ((EntitySkelefang)entity).f_19797_, partialTicks, ((BaseMonster)entity).interpolatedMoveTick(partialTicks));
            }
        }
        this.anim.doAnimation((ExtendedModel)this, ((EntitySkelefang)entity).getAnimationHandler(), partialTicks);
        this.restoreProgress = anim != null && anim.is(new AnimatedAction[]{EntitySkelefang.BEAM}) ? anim.progress((float)anim.getMarker("restore_start", 0) * 20.0f, (float)anim.getMarker("restore_end", 0) * 20.0f, partialTicks, 0) : -1.0f;
    }

    public ModelPartHandler getHandler() {
        return this.model;
    }

    public boolean transform(T entity, EntityRenderer<T> entityRenderer, Entity rider, EntityRenderer<?> ridingEntityRenderer, PoseStack poseStack, int riderNum) {
        LivingEntityRenderer lR;
        EntityModel model;
        if (ridingEntityRenderer instanceof LivingEntityRenderer && ((model = (lR = (LivingEntityRenderer)ridingEntityRenderer).m_7200_()) instanceof HumanoidModel || model instanceof IllagerModel || model instanceof SittingModel)) {
            this.body.translateAndRotate(poseStack);
            if (((EntitySkelefang)entity).hasBones()) {
                this.spineFront.translateAndRotate(poseStack);
                this.ridingPositionBones.translateAndRotate(poseStack);
            } else {
                this.heart.translateAndRotate(poseStack);
                this.ridingPositionHeart.translateAndRotate(poseStack);
            }
            ClientHandlers.translateRider(entityRenderer, rider, model, poseStack);
            return true;
        }
        return false;
    }

    public void updateFromBones(EntitySkelefang skelefang) {
        if (skelefang.m_21224_()) {
            this.spineFront.visible = false;
            this.spineBack.visible = false;
            this.translucentTail = false;
            this.translucentTailBase = false;
            this.translucentSpineFront = false;
            this.translucentSpineBack = false;
            this.translucentBackRibs = false;
            this.translucentFrontRibs = false;
        } else {
            this.head.visible = skelefang.remainingHeadBones() > 10;
            this.neck.visible = skelefang.remainingHeadBones() > 0;
            this.spineFront.visible = skelefang.remainingBodyBones() > 0;
            this.ribsBody.visible = skelefang.remainingBodyBones() > 5;
            this.leftLegBase.visible = skelefang.remainingLeftLegBones() > 0;
            this.rightLegBase.visible = skelefang.remainingRightLegBones() > 0;
            this.ribsSpine.visible = skelefang.remainingBodyBones() > 15;
            this.spineBack.visible = skelefang.remainingBodyBones() > 10;
            this.tailBase.visible = skelefang.remainingTailBones() > 0;
            this.tail.visible = skelefang.remainingTailBones() > 10;
            this.translucentTail = skelefang.hasBones() && skelefang.isEnraged() && !this.tail.visible;
            this.translucentTailBase = skelefang.hasBones() && skelefang.isEnraged() && !this.tailBase.visible;
            this.translucentSpineFront = skelefang.hasBones() && skelefang.isEnraged() && !this.spineFront.visible;
            this.translucentSpineBack = skelefang.hasBones() && skelefang.isEnraged() && !this.spineBack.visible;
            this.translucentBackRibs = skelefang.hasBones() && skelefang.isEnraged() && !this.ribsSpine.visible;
            this.translucentFrontRibs = skelefang.hasBones() && skelefang.isEnraged() && !this.ribsBody.visible;
        }
    }

    public void renderAsParticle(PoseStack poseStack, VertexConsumer buffer, SkelefangParticleData.SkelefangBoneType boneType, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.model.resetPoses();
        this.body.setAllVisible(true);
        switch (boneType) {
            case TAIL: {
                this.tail.setPos(0.0f, 22.75f, 0.0f);
                this.tail.render(poseStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
                break;
            }
            case TAIL_BASE: {
                this.tail.visible = false;
                this.tailBase.setPos(0.0f, 22.75f, 0.0f);
                this.tailBase.render(poseStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
                break;
            }
            case LEFT_LEG: {
                this.leftLegBase.setPos(0.0f, 22.75f, 0.0f);
                this.leftLegBase.render(poseStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
                break;
            }
            case RIGHT_LEG: {
                this.rightLegBase.setPos(0.0f, 22.75f, 0.0f);
                this.rightLegBase.render(poseStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
                break;
            }
            case HEAD: {
                this.head.setPos(0.0f, 22.75f, 0.0f);
                this.head.render(poseStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
                break;
            }
            case NECK: {
                this.head.visible = false;
                this.neck.setPos(0.0f, 22.75f, 0.0f);
                this.neck.render(poseStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
                break;
            }
            case BACK_RIBS: {
                this.tailBase.visible = false;
                this.ribsSpine.setPos(0.0f, 22.75f, 0.0f);
                this.ribsSpine.render(poseStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
                break;
            }
            case BACK: {
                this.tailBase.visible = false;
                this.ribsSpine.visible = false;
                this.spineBack.setPos(0.0f, 22.75f, 0.0f);
                this.spineBack.render(poseStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
                break;
            }
            case FRONT_RIBS: {
                this.leftLegBase.visible = false;
                this.rightLegBase.visible = false;
                this.ribsBody.setPos(0.0f, 22.75f, 0.0f);
                this.ribsBody.render(poseStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
                break;
            }
            case FRONT: {
                this.neck.visible = false;
                this.ribsBody.visible = false;
                this.spineFront.setPos(0.0f, 22.75f, 0.0f);
                this.spineFront.render(poseStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
                break;
            }
            case GENERIC: {
                this.bone1.render(poseStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
                break;
            }
            case GENERIC2: {
                this.bone2.render(poseStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
            }
        }
    }
}

