/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.client.model.monster;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import io.github.flemmli97.runecraftory.client.ClientHandlers;
import io.github.flemmli97.runecraftory.client.model.SittingModel;
import io.github.flemmli97.runecraftory.common.entities.BaseMonster;
import io.github.flemmli97.runecraftory.common.entities.monster.EntitySkyFish;
import io.github.flemmli97.tenshilib.client.AnimationManager;
import io.github.flemmli97.tenshilib.client.model.BlockBenchAnimations;
import io.github.flemmli97.tenshilib.client.model.ExtendedModel;
import io.github.flemmli97.tenshilib.client.model.ModelPartHandler;
import io.github.flemmli97.tenshilib.client.model.RideableModel;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.IllagerModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;

public class ModelSkyFish<T extends EntitySkyFish>
extends EntityModel<T>
implements ExtendedModel,
RideableModel<T> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(new ResourceLocation("runecraftory", "sky_fish"), "main");
    protected final ModelPartHandler model;
    protected final BlockBenchAnimations anim;
    public ModelPartHandler.ModelPartExtended body;
    public ModelPartHandler.ModelPartExtended ridingPosition;

    public ModelSkyFish(ModelPart root) {
        this.model = new ModelPartHandler(root, "root");
        this.anim = AnimationManager.getInstance().getAnimation(new ResourceLocation("runecraftory", "sky_fish"));
        this.body = this.model.getPart("body");
        this.ridingPosition = this.model.getPart("ridingPos");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition body = partdefinition.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-3.5f, -5.0f, -9.0f, 6.0f, 10.0f, 17.0f, new CubeDeformation(0.0f)).m_171514_(2, 28).m_171488_(2.5f, -3.0f, -7.0f, 1.0f, 6.0f, 15.0f, new CubeDeformation(0.0f)).m_171514_(46, 1).m_171488_(-4.5f, -3.0f, -7.0f, 1.0f, 6.0f, 15.0f, new CubeDeformation(0.0f)).m_171514_(34, 27).m_171488_(-2.5f, -6.0f, -7.0f, 4.0f, 1.0f, 14.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.5f, (float)18.0f, (float)1.0f));
        PartDefinition head = body.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(44, 72).m_171488_(-2.0f, -0.5f, -3.0f, 4.0f, 5.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(0, 72).m_171488_(-2.5f, -2.0f, -2.0f, 5.0f, 8.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-0.5f, (float)-2.0f, (float)-8.5f));
        PartDefinition tail = body.m_171599_("tail", CubeListBuilder.m_171558_().m_171514_(18, 49).m_171488_(-2.5f, -2.0f, 0.0f, 5.0f, 7.0f, 5.0f, new CubeDeformation(0.0f)).m_171514_(34, 72).m_171488_(2.5f, -0.5f, 0.0f, 1.0f, 4.0f, 4.0f, new CubeDeformation(0.0f)).m_171514_(24, 72).m_171488_(-3.5f, -0.5f, 0.0f, 1.0f, 4.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-0.5f, (float)-1.5f, (float)7.0f));
        PartDefinition tailTip = tail.m_171599_("tailTip", CubeListBuilder.m_171558_().m_171514_(18, 61).m_171488_(-2.0f, 0.0f, 0.0f, 4.0f, 4.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)4.0f));
        PartDefinition caudalFin = tailTip.m_171599_("caudalFin", CubeListBuilder.m_171558_().m_171514_(0, 49).m_171488_(0.0f, -6.0f, 0.0f, 0.0f, 14.0f, 9.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)5.0f));
        PartDefinition dorsalFin = body.m_171599_("dorsalFin", CubeListBuilder.m_171558_().m_171514_(14, 72).m_171488_(-0.5f, -1.0f, 0.0f, 0.0f, 3.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-8.0f, (float)-7.0f));
        PartDefinition adiposeFin = body.m_171599_("adiposeFin", CubeListBuilder.m_171558_().m_171514_(0, 82).m_171488_(0.0f, -1.0f, 0.0f, 0.0f, 3.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-0.5f, (float)-8.0f, (float)3.0f));
        PartDefinition leftPectoralFin = body.m_171599_("leftPectoralFin", CubeListBuilder.m_171558_().m_171514_(16, 82).m_171488_(-0.25f, 1.0f, 0.5f, 0.0f, 2.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)3.5f, (float)0.0f, (float)-5.0f, (float)-0.3054f, (float)0.4363f, (float)-0.1309f));
        PartDefinition rightPectoralFin = body.m_171599_("rightPectoralFin", CubeListBuilder.m_171558_().m_171514_(16, 82).m_171480_().m_171488_(0.25f, 1.0f, 0.5f, 0.0f, 2.0f, 4.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)-4.5f, (float)0.0f, (float)-5.0f, (float)-0.3054f, (float)-0.4363f, (float)0.1309f));
        PartDefinition leftPelvicFin = body.m_171599_("leftPelvicFin", CubeListBuilder.m_171558_().m_171514_(8, 82).m_171488_(0.0f, 1.0f, 0.0f, 0.0f, 2.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)2.5f, (float)2.0f, (float)4.0f, (float)-0.1745f, (float)0.3927f, (float)0.0f));
        PartDefinition rightPelvicFin = body.m_171599_("rightPelvicFin", CubeListBuilder.m_171558_().m_171514_(8, 82).m_171480_().m_171488_(0.0f, 1.0f, 0.0f, 0.0f, 2.0f, 4.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)-3.5f, (float)2.0f, (float)4.0f, (float)-0.1745f, (float)-0.3927f, (float)0.0f));
        PartDefinition riderPos = body.m_171599_("ridingPos", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)-6.0f, (float)1.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)128, (int)128);
    }

    public void m_7695_(PoseStack poseStack, VertexConsumer buffer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.model.getMainPart().render(poseStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.model.resetPoses();
        float partialTicks = ClientHandlers.getPartialTicks();
        if (((EntitySkyFish)entity).f_20919_ <= 0 && !((BaseMonster)entity).playDeath()) {
            this.anim.doAnimation((ExtendedModel)this, "idle", ((EntitySkyFish)entity).f_19797_, partialTicks);
            if (((BaseMonster)entity).moveTick() > 0) {
                this.anim.doAnimation((ExtendedModel)this, "swim", ((EntitySkyFish)entity).f_19797_, partialTicks, ((BaseMonster)entity).interpolatedMoveTick(partialTicks));
            }
        }
        this.anim.doAnimation((ExtendedModel)this, ((EntitySkyFish)entity).getAnimationHandler(), partialTicks);
    }

    public ModelPartHandler getHandler() {
        return this.model;
    }

    public boolean transform(T entity, EntityRenderer<T> entityRenderer, Entity rider, EntityRenderer<?> ridingEntityRenderer, PoseStack poseStack, int riderNum) {
        LivingEntityRenderer lR;
        EntityModel model;
        if (ridingEntityRenderer instanceof LivingEntityRenderer && ((model = (lR = (LivingEntityRenderer)ridingEntityRenderer).m_7200_()) instanceof HumanoidModel || model instanceof IllagerModel || model instanceof SittingModel)) {
            this.body.translateAndRotate(poseStack);
            this.ridingPosition.translateAndRotate(poseStack);
            ClientHandlers.translateRider(entityRenderer, rider, model, poseStack);
            return true;
        }
        return false;
    }
}

