/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.client.model.monster;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import io.github.flemmli97.runecraftory.client.ClientHandlers;
import io.github.flemmli97.runecraftory.client.model.SittingModel;
import io.github.flemmli97.runecraftory.common.entities.BaseMonster;
import io.github.flemmli97.runecraftory.common.entities.monster.boss.EntityThunderbolt;
import io.github.flemmli97.tenshilib.client.AnimationManager;
import io.github.flemmli97.tenshilib.client.model.BlockBenchAnimations;
import io.github.flemmli97.tenshilib.client.model.ExtendedModel;
import io.github.flemmli97.tenshilib.client.model.ModelPartHandler;
import io.github.flemmli97.tenshilib.client.model.RideableModel;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.IllagerModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;

public class ModelThunderbolt<T extends EntityThunderbolt>
extends EntityModel<T>
implements ExtendedModel,
RideableModel<T> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(new ResourceLocation("runecraftory", "thunderbolt"), "main");
    protected final ModelPartHandler model;
    protected final BlockBenchAnimations anim;
    public ModelPartHandler.ModelPartExtended body;
    public ModelPartHandler.ModelPartExtended head;
    public ModelPartHandler.ModelPartExtended neck;
    public ModelPartHandler.ModelPartExtended ridingPosition;

    public ModelThunderbolt(ModelPart root) {
        this.model = new ModelPartHandler(root, "root");
        this.anim = AnimationManager.getInstance().getAnimation(new ResourceLocation("runecraftory", "thunderbolt"));
        this.body = this.model.getPart("body");
        this.head = this.model.getPart("head");
        this.neck = this.model.getPart("neck");
        this.ridingPosition = this.model.getPart("ridingPos");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition body = partdefinition.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-6.5f, -7.0f, -13.0f, 13.0f, 13.0f, 26.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)4.0f, (float)0.0f));
        PartDefinition backFur = body.m_171599_("backFur", CubeListBuilder.m_171558_().m_171514_(0, 39).m_171488_(-0.5f, -2.0f, -12.0f, 1.0f, 3.0f, 24.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-7.0f, (float)3.0f));
        PartDefinition neck = body.m_171599_("neck", CubeListBuilder.m_171558_().m_171514_(52, 0).m_171488_(-2.5f, -12.0f, 0.0f, 7.0f, 12.0f, 9.0f, new CubeDeformation(0.0f)).m_171514_(20, 66).m_171488_(0.5f, -12.0f, 8.0f, 1.0f, 12.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-1.0f, (float)0.0f, (float)-13.0f, (float)0.5236f, (float)0.0f, (float)0.0f));
        PartDefinition head = neck.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(26, 39).m_171488_(-5.0f, -9.0f, -2.5f, 10.0f, 10.0f, 13.0f, new CubeDeformation(0.0f)).m_171514_(0, 0).m_171488_(-0.5f, -12.0f, 3.5f, 1.0f, 13.0f, 10.0f, new CubeDeformation(0.0f)).m_171514_(59, 39).m_171488_(-3.5f, -8.0f, -6.5f, 7.0f, 9.0f, 4.0f, new CubeDeformation(0.0f)).m_171514_(0, 66).m_171488_(-2.5f, -7.5f, -11.5f, 5.0f, 8.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)1.0f, (float)-13.0f, (float)0.0f));
        PartDefinition horn = head.m_171599_("horn", CubeListBuilder.m_171558_().m_171514_(82, 49).m_171488_(-1.5f, 0.0f, 0.5f, 3.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)).m_171514_(52, 0).m_171488_(-1.0f, -5.0f, 1.0f, 2.0f, 5.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-12.0f, (float)-2.0f));
        PartDefinition leftFrontLegBase = body.m_171599_("leftFrontLegBase", CubeListBuilder.m_171558_().m_171514_(75, 0).m_171488_(-1.5f, -1.0f, -0.5f, 4.0f, 4.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)4.5f, (float)4.0f, (float)-13.0f));
        PartDefinition leftFrontLeg = leftFrontLegBase.m_171599_("leftFrontLeg", CubeListBuilder.m_171558_().m_171514_(54, 82).m_171488_(-1.0f, 0.0f, -3.0f, 3.0f, 5.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)3.0f, (float)3.0f));
        PartDefinition leftFrontLegDown = leftFrontLeg.m_171599_("leftFrontLegDown", CubeListBuilder.m_171558_().m_171514_(0, 79).m_171488_(-1.5f, 0.0f, 0.0f, 3.0f, 7.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.5f, (float)5.0f, (float)-3.0f));
        PartDefinition leftFrontLegFur = leftFrontLegDown.m_171599_("leftFrontLegFur", CubeListBuilder.m_171558_().m_171514_(12, 48).m_171488_(0.0f, -1.0f, 0.0f, 0.0f, 4.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)3.0f));
        PartDefinition leftFrontHoove = leftFrontLegDown.m_171599_("leftFrontHoove", CubeListBuilder.m_171558_().m_171514_(77, 68).m_171488_(-2.0f, 0.0f, -2.0f, 4.0f, 2.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)6.0f, (float)1.5f));
        PartDefinition rightFrontLegBase = body.m_171599_("rightFrontLegBase", CubeListBuilder.m_171558_().m_171514_(73, 74).m_171488_(-1.5f, -1.0f, -0.5f, 4.0f, 4.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-5.5f, (float)4.0f, (float)-13.0f));
        PartDefinition rightFrontLeg = rightFrontLegBase.m_171599_("rightFrontLeg", CubeListBuilder.m_171558_().m_171514_(81, 41).m_171488_(-1.0f, 0.0f, -3.0f, 3.0f, 5.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)3.0f, (float)3.0f));
        PartDefinition rightFrontLegDown = rightFrontLeg.m_171599_("rightFrontLegDown", CubeListBuilder.m_171558_().m_171514_(78, 21).m_171488_(-1.5f, 0.0f, 0.0f, 3.0f, 7.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.5f, (float)5.0f, (float)-3.0f));
        PartDefinition rightFrontLegFur = rightFrontLegDown.m_171599_("rightFrontLegFur", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(0.0f, -1.0f, 0.0f, 0.0f, 4.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)3.0f));
        PartDefinition rightFrontHoove = rightFrontLegDown.m_171599_("rightFrontHoove", CubeListBuilder.m_171558_().m_171514_(77, 62).m_171488_(-2.0f, 0.0f, -2.0f, 4.0f, 2.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)6.0f, (float)1.5f));
        PartDefinition leftBackLegBase = body.m_171599_("leftBackLegBase", CubeListBuilder.m_171558_().m_171514_(43, 62).m_171488_(-2.5f, -4.0f, -3.5f, 5.0f, 7.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)4.5f, (float)4.0f, (float)9.6f));
        PartDefinition leftBackLeg = leftBackLegBase.m_171599_("leftBackLeg", CubeListBuilder.m_171558_().m_171514_(72, 52).m_171488_(-1.5f, 0.0f, 0.0f, 3.0f, 6.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)3.0f, (float)-1.5f, (float)0.3927f, (float)0.0f, (float)0.0f));
        PartDefinition leftBackLegDown = leftBackLeg.m_171599_("leftBackLegDown", CubeListBuilder.m_171558_().m_171514_(42, 76).m_171488_(-1.5f, 0.0f, -3.0f, 3.0f, 8.0f, 3.0f, new CubeDeformation(0.0f)).m_171514_(12, 17).m_171488_(0.0f, 0.0f, -1.0f, 0.0f, 3.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)6.0f, (float)4.0f, (float)-0.3927f, (float)0.0f, (float)0.0f));
        PartDefinition leftBackHoove = leftBackLegDown.m_171599_("leftBackHoove", CubeListBuilder.m_171558_().m_171514_(77, 35).m_171488_(-1.5f, -0.3007f, -1.9537f, 4.0f, 2.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-0.5f, (float)7.3007f, (float)-1.5463f));
        PartDefinition rightBackLegBase = body.m_171599_("rightBackLegBase", CubeListBuilder.m_171558_().m_171514_(0, 39).m_171488_(-2.5f, -4.0f, -3.5f, 5.0f, 7.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-4.5f, (float)4.0f, (float)9.6f));
        PartDefinition rightBackLeg = rightBackLegBase.m_171599_("rightBackLeg", CubeListBuilder.m_171558_().m_171514_(12, 0).m_171488_(-1.5f, 0.0f, 0.0f, 3.0f, 6.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)3.0f, (float)-1.5f, (float)0.3927f, (float)0.0f, (float)0.0f));
        PartDefinition rightBackLegDown = rightBackLeg.m_171599_("rightBackLegDown", CubeListBuilder.m_171558_().m_171514_(26, 39).m_171488_(-1.5f, 0.0f, -3.0f, 3.0f, 8.0f, 3.0f, new CubeDeformation(0.0f)).m_171514_(0, 17).m_171488_(0.0f, 0.0f, -1.0f, 0.0f, 3.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)6.0f, (float)4.0f, (float)-0.3927f, (float)0.0f, (float)0.0f));
        PartDefinition rightBackHoove = rightBackLegDown.m_171599_("rightBackHoove", CubeListBuilder.m_171558_().m_171514_(54, 76).m_171488_(-2.0f, 0.0f, -2.0f, 4.0f, 2.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)7.0f, (float)-1.5f));
        PartDefinition tail = body.m_171599_("tail", CubeListBuilder.m_171558_().m_171514_(0, 53).m_171488_(-2.5f, 0.0f, -1.0f, 4.0f, 6.0f, 4.0f, new CubeDeformation(0.0f)).m_171514_(66, 78).m_171488_(-1.0f, -1.0f, 0.0f, 1.0f, 7.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.5f, (float)-5.5f, (float)13.0f, (float)0.6545f, (float)0.0f, (float)0.0f));
        PartDefinition tailTip = tail.m_171599_("tailTip", CubeListBuilder.m_171558_().m_171514_(67, 62).m_171488_(-1.5f, 0.0f, -3.5f, 2.0f, 13.0f, 3.0f, new CubeDeformation(0.0f)).m_171514_(32, 66).m_171488_(-1.0f, -1.0f, -3.5f, 1.0f, 14.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)6.0f, (float)3.0f, (float)-0.5236f, (float)0.0f, (float)0.0f));
        PartDefinition riderPos = body.m_171599_("ridingPos", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)-7.0f, (float)4.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)128, (int)128);
    }

    public void m_7695_(PoseStack poseStack, VertexConsumer buffer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.model.getMainPart().render(poseStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.model.resetPoses();
        this.head.yRot += netHeadYaw % 360.0f * ((float)Math.PI / 180) * 0.15f;
        this.head.xRot += headPitch * ((float)Math.PI / 180) * 0.15f;
        this.neck.yRot += netHeadYaw % 360.0f * ((float)Math.PI / 180) * 0.15f;
        this.neck.xRot += headPitch * ((float)Math.PI / 180) * 0.15f;
        float partialTicks = ClientHandlers.getPartialTicks();
        if (((EntityThunderbolt)entity).f_20919_ <= 0 && !((BaseMonster)entity).playDeath()) {
            if (((BaseMonster)entity).getMoveFlag() == BaseMonster.MoveType.RUN) {
                this.anim.doAnimation((ExtendedModel)this, "run", ((EntityThunderbolt)entity).f_19797_, partialTicks, ((BaseMonster)entity).interpolatedMoveTick(partialTicks));
            } else if (((BaseMonster)entity).moveTick() > 0) {
                this.anim.doAnimation((ExtendedModel)this, "walk", ((EntityThunderbolt)entity).f_19797_, partialTicks, ((BaseMonster)entity).interpolatedMoveTick(partialTicks));
            }
        }
        this.anim.doAnimation((ExtendedModel)this, ((EntityThunderbolt)entity).getAnimationHandler(), partialTicks);
    }

    public ModelPartHandler getHandler() {
        return this.model;
    }

    public boolean transform(T entity, EntityRenderer<T> entityRenderer, Entity rider, EntityRenderer<?> ridingEntityRenderer, PoseStack poseStack, int riderNum) {
        LivingEntityRenderer lR;
        EntityModel model;
        if (ridingEntityRenderer instanceof LivingEntityRenderer && ((model = (lR = (LivingEntityRenderer)ridingEntityRenderer).m_7200_()) instanceof HumanoidModel || model instanceof IllagerModel || model instanceof SittingModel)) {
            this.body.translateAndRotate(poseStack);
            this.ridingPosition.translateAndRotate(poseStack);
            ClientHandlers.translateRider(entityRenderer, rider, model, poseStack);
            return true;
        }
        return false;
    }
}

