/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.client.model.monster;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import io.github.flemmli97.runecraftory.client.ClientHandlers;
import io.github.flemmli97.runecraftory.client.model.SittingModel;
import io.github.flemmli97.runecraftory.common.entities.BaseMonster;
import io.github.flemmli97.runecraftory.common.entities.monster.EntityTortas;
import io.github.flemmli97.tenshilib.client.AnimationManager;
import io.github.flemmli97.tenshilib.client.model.BlockBenchAnimations;
import io.github.flemmli97.tenshilib.client.model.ExtendedModel;
import io.github.flemmli97.tenshilib.client.model.ModelPartHandler;
import io.github.flemmli97.tenshilib.client.model.RideableModel;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.IllagerModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;

public class ModelTortas<T extends EntityTortas>
extends EntityModel<T>
implements ExtendedModel,
RideableModel<T> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(new ResourceLocation("runecraftory", "tortas"), "main");
    protected final ModelPartHandler model;
    protected final BlockBenchAnimations anim;
    public ModelPartHandler.ModelPartExtended body;
    public ModelPartHandler.ModelPartExtended neck;
    public ModelPartHandler.ModelPartExtended ridingPosition;

    public ModelTortas(ModelPart root) {
        this.model = new ModelPartHandler(root, "root");
        this.anim = AnimationManager.getInstance().getAnimation(new ResourceLocation("runecraftory", "tortas"));
        this.body = this.model.getPart("body");
        this.neck = this.model.getPart("neck");
        this.ridingPosition = this.model.getPart("ridingPos");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition body = partdefinition.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-9.0f, -6.0f, -11.0f, 18.0f, 4.0f, 24.0f, new CubeDeformation(0.0f)).m_171514_(84, 4).m_171488_(9.0f, -6.0f, -9.0f, 2.0f, 4.0f, 20.0f, new CubeDeformation(0.0f)).m_171514_(84, 4).m_171480_().m_171488_(-11.0f, -6.0f, -9.0f, 2.0f, 4.0f, 20.0f, new CubeDeformation(0.0f)).m_171555_(false).m_171514_(0, 28).m_171488_(-8.0f, -9.0f, -10.0f, 16.0f, 3.0f, 22.0f, new CubeDeformation(0.0f)).m_171514_(76, 32).m_171488_(8.0f, -9.0f, -8.0f, 2.0f, 3.0f, 18.0f, new CubeDeformation(0.0f)).m_171514_(76, 32).m_171480_().m_171488_(-10.0f, -9.0f, -8.0f, 2.0f, 3.0f, 18.0f, new CubeDeformation(0.0f)).m_171555_(false).m_171514_(0, 53).m_171488_(-7.0f, -11.0f, -9.0f, 14.0f, 2.0f, 20.0f, new CubeDeformation(0.0f)).m_171514_(68, 57).m_171488_(7.0f, -11.0f, -7.0f, 2.0f, 2.0f, 16.0f, new CubeDeformation(0.0f)).m_171514_(68, 57).m_171480_().m_171488_(-9.0f, -11.0f, -7.0f, 2.0f, 2.0f, 16.0f, new CubeDeformation(0.0f)).m_171555_(false).m_171514_(0, 75).m_171488_(-8.0f, -2.0f, -10.0f, 16.0f, 2.0f, 21.0f, new CubeDeformation(0.0f)).m_171514_(105, 61).m_171488_(0.0f, -14.0f, -7.0f, 0.0f, 3.0f, 4.0f, new CubeDeformation(0.0f)).m_171514_(113, 61).m_171488_(0.0f, -14.0f, -1.0f, 0.0f, 3.0f, 4.0f, new CubeDeformation(0.0f)).m_171514_(105, 68).m_171488_(0.0f, -14.0f, 5.0f, 0.0f, 3.0f, 4.0f, new CubeDeformation(0.0f)).m_171514_(113, 68).m_171488_(0.0f, -11.0f, 11.0f, 0.0f, 4.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition neck = body.m_171599_("neck", CubeListBuilder.m_171558_().m_171514_(75, 76).m_171488_(-3.0f, -2.0f, -2.0f, 6.0f, 2.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)-11.0f));
        PartDefinition head = neck.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(75, 81).m_171488_(-3.0f, -3.0f, -3.0f, 6.0f, 4.0f, 6.0f, new CubeDeformation(0.0f)).m_171514_(75, 91).m_171488_(-3.0f, -4.0f, -2.0f, 6.0f, 1.0f, 3.0f, new CubeDeformation(0.0f)).m_171514_(93, 76).m_171488_(-2.0f, -2.5f, -3.25f, 4.0f, 4.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-2.0f, (float)-2.0f));
        PartDefinition jaw = head.m_171599_("jaw", CubeListBuilder.m_171558_().m_171514_(93, 91).m_171488_(-2.0f, -0.5f, -4.1f, 4.0f, 1.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)1.45f, (float)1.8f));
        PartDefinition leftLegFrontBase = body.m_171599_("leftLegFrontBase", CubeListBuilder.m_171558_().m_171514_(0, 99).m_171488_(-5.0f, 0.0f, -7.0f, 5.0f, 2.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)8.0f, (float)-2.0f, (float)-7.0f, (float)0.0f, (float)-0.6545f, (float)0.0436f));
        PartDefinition leftLegFront = leftLegFrontBase.m_171599_("leftLegFront", CubeListBuilder.m_171558_().m_171514_(24, 102).m_171488_(0.0f, 0.0f, 0.0f, 8.0f, 2.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)-7.0f, (float)0.0f, (float)-0.3054f, (float)0.0f));
        PartDefinition leftLegBackBase = body.m_171599_("leftLegBackBase", CubeListBuilder.m_171558_().m_171514_(48, 102).m_171488_(0.0f, 0.0f, 0.0f, 4.0f, 2.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)8.0f, (float)-2.0f, (float)7.0f, (float)0.0f, (float)-0.829f, (float)0.0436f));
        PartDefinition leftLegBack = leftLegBackBase.m_171599_("leftLegBack", CubeListBuilder.m_171558_().m_171514_(64, 102).m_171488_(0.0f, 0.0f, 0.0f, 8.0f, 2.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)4.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.5672f, (float)0.0f));
        PartDefinition rightLegFrontBase = body.m_171599_("rightLegFrontBase", CubeListBuilder.m_171558_().m_171514_(0, 99).m_171480_().m_171488_(0.0f, 0.0f, -7.0f, 5.0f, 2.0f, 7.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)-8.0f, (float)-2.0f, (float)-7.0f, (float)0.0f, (float)0.6545f, (float)-0.0436f));
        PartDefinition rightLegFront = rightLegFrontBase.m_171599_("rightLegFront", CubeListBuilder.m_171558_().m_171514_(24, 102).m_171480_().m_171488_(-8.0f, 0.0f, 0.0f, 8.0f, 2.0f, 4.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)-7.0f, (float)0.0f, (float)0.3054f, (float)0.0f));
        PartDefinition rightLegBackBase = body.m_171599_("rightLegBackBase", CubeListBuilder.m_171558_().m_171514_(48, 102).m_171480_().m_171488_(-4.0f, 0.0f, 0.0f, 4.0f, 2.0f, 4.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)-8.0f, (float)-2.0f, (float)7.0f, (float)0.0f, (float)0.829f, (float)-0.0436f));
        PartDefinition rightLegBack = rightLegBackBase.m_171599_("rightLegBack", CubeListBuilder.m_171558_().m_171514_(64, 102).m_171480_().m_171488_(-8.0f, 0.0f, 0.0f, 8.0f, 2.0f, 4.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)-4.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.5672f, (float)0.0f));
        PartDefinition tail = body.m_171599_("tail", CubeListBuilder.m_171558_().m_171514_(114, 76).m_171488_(-1.5f, -2.0f, 0.0f, 3.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-1.0f, (float)11.0f));
        PartDefinition tail2 = tail.m_171599_("tail2", CubeListBuilder.m_171558_().m_171514_(114, 82).m_171488_(-1.0f, 0.0f, 0.0f, 2.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-1.0f, (float)3.0f));
        PartDefinition tail3 = tail2.m_171599_("tail3", CubeListBuilder.m_171558_().m_171514_(114, 86).m_171488_(-0.5f, 1.0f, 0.0f, 1.0f, 1.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)2.0f));
        PartDefinition ridingPos = body.m_171599_("ridingPos", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)-11.0f, (float)4.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)128, (int)108);
    }

    public void m_7695_(PoseStack poseStack, VertexConsumer buffer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.model.getMainPart().render(poseStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.model.resetPoses();
        this.neck.yRot += netHeadYaw % 360.0f * ((float)Math.PI / 180) * 0.1f;
        this.neck.xRot += headPitch * ((float)Math.PI / 180) * 0.1f;
        float partialTicks = ClientHandlers.getPartialTicks();
        if (((EntityTortas)entity).f_20919_ <= 0 && !((BaseMonster)entity).playDeath()) {
            this.anim.doAnimation((ExtendedModel)this, "idle", ((EntityTortas)entity).f_19797_, partialTicks);
            if (((BaseMonster)entity).moveTick() > 0) {
                if (entity.m_6069_()) {
                    this.anim.doAnimation((ExtendedModel)this, "swim", ((EntityTortas)entity).f_19797_, partialTicks, ((BaseMonster)entity).interpolatedMoveTick(partialTicks));
                } else {
                    this.anim.doAnimation((ExtendedModel)this, "walk", ((EntityTortas)entity).f_19797_, partialTicks, ((BaseMonster)entity).interpolatedMoveTick(partialTicks));
                }
            }
        }
        this.anim.doAnimation((ExtendedModel)this, ((EntityTortas)entity).getAnimationHandler(), partialTicks);
    }

    public ModelPartHandler getHandler() {
        return this.model;
    }

    public boolean transform(T entity, EntityRenderer<T> entityRenderer, Entity rider, EntityRenderer<?> ridingEntityRenderer, PoseStack poseStack, int riderNum) {
        LivingEntityRenderer lR;
        EntityModel model;
        if (ridingEntityRenderer instanceof LivingEntityRenderer && ((model = (lR = (LivingEntityRenderer)ridingEntityRenderer).m_7200_()) instanceof HumanoidModel || model instanceof IllagerModel || model instanceof SittingModel)) {
            this.body.translateAndRotate(poseStack);
            this.ridingPosition.translateAndRotate(poseStack);
            ClientHandlers.translateRider(entityRenderer, rider, model, poseStack);
            return true;
        }
        return false;
    }
}

