/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.client.model.monster;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import io.github.flemmli97.runecraftory.client.ClientHandlers;
import io.github.flemmli97.runecraftory.client.model.SittingModel;
import io.github.flemmli97.runecraftory.common.entities.BaseMonster;
import io.github.flemmli97.runecraftory.common.entities.monster.EntityTroll;
import io.github.flemmli97.tenshilib.api.entity.AnimatedAction;
import io.github.flemmli97.tenshilib.client.AnimationManager;
import io.github.flemmli97.tenshilib.client.model.BlockBenchAnimations;
import io.github.flemmli97.tenshilib.client.model.ExtendedModel;
import io.github.flemmli97.tenshilib.client.model.ModelPartHandler;
import io.github.flemmli97.tenshilib.client.model.RideableModel;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.IllagerModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;

public class ModelTroll<T extends EntityTroll>
extends EntityModel<T>
implements ExtendedModel,
RideableModel<T> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(new ResourceLocation("runecraftory", "troll"), "main");
    protected final ModelPartHandler model;
    protected final BlockBenchAnimations anim;
    public ModelPartHandler.ModelPartExtended body;
    public ModelPartHandler.ModelPartExtended upperBody;
    public ModelPartHandler.ModelPartExtended head;
    public ModelPartHandler.ModelPartExtended ridingPosition;

    public ModelTroll(ModelPart root) {
        this.model = new ModelPartHandler(root, "root");
        this.anim = AnimationManager.getInstance().getAnimation(new ResourceLocation("runecraftory", "troll"));
        this.body = this.model.getPart("body");
        this.upperBody = this.model.getPart("upperBody");
        this.head = this.model.getPart("head");
        this.ridingPosition = this.model.getPart("ridingPos");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition body = partdefinition.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(54, 0).m_171488_(-7.5f, -3.5f, -4.0f, 15.0f, 7.0f, 9.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)2.5f, (float)0.0f));
        PartDefinition clothFront = body.m_171599_("clothFront", CubeListBuilder.m_171558_().m_171514_(0, 90).m_171488_(-6.5f, 0.0f, 0.0f, 13.0f, 6.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)3.5f, (float)-4.0f));
        PartDefinition clothBack = body.m_171599_("clothBack", CubeListBuilder.m_171558_().m_171514_(84, 76).m_171488_(-6.5f, 0.0f, 0.0f, 13.0f, 6.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)3.5f, (float)5.0f));
        PartDefinition upperBody = body.m_171599_("upperBody", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-8.5f, -12.0f, -4.5f, 17.0f, 12.0f, 10.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-3.5f, (float)0.0f));
        PartDefinition head = upperBody.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(0, 22).m_171488_(-5.0f, -8.75f, -5.0f, 10.0f, 10.0f, 10.0f, new CubeDeformation(0.0f)).m_171514_(0, 76).m_171488_(-2.0f, -9.75f, -6.0f, 4.0f, 4.0f, 10.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-12.25f, (float)-1.0f));
        PartDefinition earLeft = head.m_171599_("earLeft", CubeListBuilder.m_171558_().m_171514_(40, 90).m_171488_(0.0f, -2.5f, -0.5f, 1.0f, 3.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)5.0f, (float)-5.25f, (float)-2.5f, (float)0.2182f, (float)0.3054f, (float)0.0f));
        PartDefinition earRight = head.m_171599_("earRight", CubeListBuilder.m_171558_().m_171514_(26, 90).m_171488_(-1.0f, -2.5f, -0.5f, 1.0f, 3.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-5.0f, (float)-5.25f, (float)-2.5f, (float)0.2182f, (float)-0.3054f, (float)0.0f));
        PartDefinition hornLeft = head.m_171599_("hornLeft", CubeListBuilder.m_171558_().m_171514_(64, 90).m_171488_(-1.0f, -4.0f, -1.0f, 2.0f, 4.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-4.0f, (float)-8.75f, (float)-2.0f));
        PartDefinition hornRight = head.m_171599_("hornRight", CubeListBuilder.m_171558_().m_171514_(54, 90).m_171488_(-1.0f, -4.0f, -1.0f, 2.0f, 4.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)4.0f, (float)-8.75f, (float)-2.0f));
        PartDefinition leftArmUp = upperBody.m_171599_("leftArmUp", CubeListBuilder.m_171558_().m_171514_(28, 42).m_171488_(0.0f, -3.0f, -3.0f, 7.0f, 11.0f, 7.0f, new CubeDeformation(0.0f)).m_171514_(56, 76).m_171488_(0.0f, -3.0f, -3.0f, 7.0f, 5.0f, 7.0f, new CubeDeformation(0.25f)), PartPose.m_171419_((float)8.5f, (float)-7.0f, (float)0.0f));
        PartDefinition leftArmDown = leftArmUp.m_171599_("leftArmDown", CubeListBuilder.m_171558_().m_171514_(0, 42).m_171488_(-3.0f, 0.0f, -3.0f, 7.0f, 11.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)3.0f, (float)8.0f, (float)0.0f));
        PartDefinition rightArmUp = upperBody.m_171599_("rightArmUp", CubeListBuilder.m_171558_().m_171514_(68, 22).m_171488_(-7.0f, -3.0f, -3.0f, 7.0f, 11.0f, 7.0f, new CubeDeformation(0.0f)).m_171514_(28, 76).m_171488_(-7.0f, -3.0f, -3.0f, 7.0f, 5.0f, 7.0f, new CubeDeformation(0.25f)), PartPose.m_171419_((float)-8.5f, (float)-7.0f, (float)0.0f));
        PartDefinition rightArmDown = rightArmUp.m_171599_("rightArmDown", CubeListBuilder.m_171558_().m_171514_(40, 22).m_171488_(-4.0f, 0.0f, -3.0f, 7.0f, 11.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-3.0f, (float)8.0f, (float)0.0f));
        PartDefinition ridingPos = upperBody.m_171599_("ridingPos", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)-12.0f, (float)6.0f));
        PartDefinition leftLegUp = body.m_171599_("leftLegUp", CubeListBuilder.m_171558_().m_171514_(56, 60).m_171488_(-3.0f, 0.0f, -3.0f, 7.0f, 9.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)3.0f, (float)3.5f, (float)0.0f));
        PartDefinition leftLegDown = leftLegUp.m_171599_("leftLegDown", CubeListBuilder.m_171558_().m_171514_(28, 60).m_171488_(-3.0f, 0.0f, 0.0f, 7.0f, 9.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)9.0f, (float)-3.0f));
        PartDefinition rightLegUp = body.m_171599_("rightLegUp", CubeListBuilder.m_171558_().m_171514_(0, 60).m_171488_(-4.0f, 0.0f, -3.0f, 7.0f, 9.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-3.0f, (float)3.5f, (float)0.0f));
        PartDefinition rightLegDown = rightLegUp.m_171599_("rightLegDown", CubeListBuilder.m_171558_().m_171514_(56, 42).m_171488_(-4.0f, 0.0f, 0.0f, 7.0f, 9.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)9.0f, (float)-3.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)128, (int)128);
    }

    public void m_7695_(PoseStack poseStack, VertexConsumer buffer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.model.getMainPart().render(poseStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.model.resetPoses();
        AnimatedAction anim = ((EntityTroll)entity).getAnimationHandler().getAnimation();
        this.head.yRot += netHeadYaw % 360.0f * ((float)Math.PI / 180) * 0.5f;
        this.head.xRot += headPitch * ((float)Math.PI / 180) * 0.5f;
        float partialTicks = ClientHandlers.getPartialTicks();
        if (((EntityTroll)entity).f_20919_ <= 0 && !((BaseMonster)entity).playDeath()) {
            if (!EntityTroll.SLEEP.is(new AnimatedAction[]{anim})) {
                this.anim.doAnimation((ExtendedModel)this, "idle", ((EntityTroll)entity).f_19797_, partialTicks);
            }
            if (((BaseMonster)entity).moveTick() > 0) {
                this.anim.doAnimation((ExtendedModel)this, "walk", ((EntityTroll)entity).f_19797_, partialTicks, ((BaseMonster)entity).interpolatedMoveTick(partialTicks));
            }
        }
        this.anim.doAnimation((ExtendedModel)this, ((EntityTroll)entity).getAnimationHandler(), partialTicks);
    }

    public ModelPartHandler getHandler() {
        return this.model;
    }

    public boolean transform(T entity, EntityRenderer<T> entityRenderer, Entity rider, EntityRenderer<?> ridingEntityRenderer, PoseStack poseStack, int riderNum) {
        LivingEntityRenderer lR;
        EntityModel model;
        if (ridingEntityRenderer instanceof LivingEntityRenderer && ((model = (lR = (LivingEntityRenderer)ridingEntityRenderer).m_7200_()) instanceof HumanoidModel || model instanceof IllagerModel || model instanceof SittingModel)) {
            this.body.translateAndRotate(poseStack);
            this.upperBody.translateAndRotate(poseStack);
            this.ridingPosition.translateAndRotate(poseStack);
            ClientHandlers.translateRider(entityRenderer, rider, model, poseStack);
            return true;
        }
        return false;
    }
}

