/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.client.model.monster;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import io.github.flemmli97.runecraftory.client.ClientHandlers;
import io.github.flemmli97.runecraftory.client.model.SittingModel;
import io.github.flemmli97.runecraftory.client.render.monster.RenderVeggieGhost;
import io.github.flemmli97.runecraftory.common.entities.BaseMonster;
import io.github.flemmli97.runecraftory.common.entities.monster.EntityVeggieGhost;
import io.github.flemmli97.tenshilib.client.AnimationManager;
import io.github.flemmli97.tenshilib.client.model.BlockBenchAnimations;
import io.github.flemmli97.tenshilib.client.model.ExtendedModel;
import io.github.flemmli97.tenshilib.client.model.ModelPartHandler;
import io.github.flemmli97.tenshilib.client.model.RideableModel;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.IllagerModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;

public class ModelVeggieGhost<T extends EntityVeggieGhost>
extends EntityModel<T>
implements ExtendedModel,
RideableModel<T> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(new ResourceLocation("runecraftory", "veggie_ghost"), "main");
    protected final ModelPartHandler model;
    protected final BlockBenchAnimations anim;
    public ModelPartHandler.ModelPartExtended body;
    public ModelPartHandler.ModelPartExtended head;
    public ModelPartHandler.ModelPartExtended ridingPosition;

    public ModelVeggieGhost(ModelPart root) {
        super(RenderType::m_110470_);
        this.model = new ModelPartHandler(root, "root");
        this.anim = AnimationManager.getInstance().getAnimation(new ResourceLocation("runecraftory", "veggie_ghost"));
        this.body = this.model.getPart("body");
        this.head = this.model.getPart("head");
        this.ridingPosition = this.model.getPart("ridingPos");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition body = partdefinition.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(0, 14).m_171488_(-4.0f, -4.0f, -2.0f, 8.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)9.0f, (float)0.0f));
        PartDefinition bodyLower = body.m_171599_("bodyLower", CubeListBuilder.m_171558_().m_171514_(24, 10).m_171488_(-3.0f, 0.0f, -2.0f, 6.0f, 6.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)8.0f, (float)0.0f));
        PartDefinition head = body.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-3.5f, -7.0f, -3.5f, 7.0f, 7.0f, 7.0f, new CubeDeformation(0.0f)).m_171514_(32, 28).m_171488_(-1.5f, -8.0f, -1.5f, 3.0f, 1.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-4.0f, (float)0.0f));
        PartDefinition leftArm = body.m_171599_("leftArm", CubeListBuilder.m_171558_().m_171514_(28, 0).m_171488_(0.0f, -1.0f, -1.5f, 7.0f, 5.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)4.0f, (float)-2.0f, (float)0.0f));
        PartDefinition rightArm = body.m_171599_("rightArm", CubeListBuilder.m_171558_().m_171514_(24, 20).m_171488_(-7.0f, -1.0f, -1.5f, 7.0f, 5.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-4.0f, (float)-2.0f, (float)0.0f));
        PartDefinition lamp = rightArm.m_171599_("lamp", CubeListBuilder.m_171558_().m_171514_(8, 35).m_171488_(-1.0f, -0.8333f, -1.0f, 2.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)).m_171514_(0, 30).m_171488_(-2.0f, 1.1667f, -2.0f, 4.0f, 1.0f, 4.0f, new CubeDeformation(0.25f)).m_171514_(20, 28).m_171488_(-2.0f, 1.1667f, -2.0f, 4.0f, 5.0f, 4.0f, new CubeDeformation(0.0f)).m_171514_(0, 35).m_171488_(-1.0f, 1.1667f, -1.0f, 2.0f, 4.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-5.0f, (float)2.8333f, (float)-1.5f, (float)-0.2182f, (float)0.0f, (float)0.0f));
        PartDefinition ridingPos = body.m_171599_("ridingPos", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)3.0f, (float)4.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public void m_7695_(PoseStack poseStack, VertexConsumer buffer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.model.getMainPart().render(poseStack, buffer, packedLight, packedOverlay, red, green, blue, 0.9f);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.model.resetPoses();
        this.head.yRot += netHeadYaw % 360.0f * ((float)Math.PI / 180) * 0.5f;
        this.head.xRot += headPitch * ((float)Math.PI / 180) * 0.5f;
        this.model.getMainPart().visible = true;
        float partialTicks = ClientHandlers.getPartialTicks();
        if (((EntityVeggieGhost)entity).f_20919_ <= 0 && !((BaseMonster)entity).playDeath()) {
            this.anim.doAnimation((ExtendedModel)this, "idle", ((EntityVeggieGhost)entity).f_19797_, partialTicks);
        }
        this.anim.doAnimation((ExtendedModel)this, ((EntityVeggieGhost)entity).getAnimationHandler(), partialTicks);
    }

    public ModelPartHandler getHandler() {
        return this.model;
    }

    public boolean transform(T entity, EntityRenderer<T> entityRenderer, Entity rider, EntityRenderer<?> ridingEntityRenderer, PoseStack poseStack, int riderNum) {
        if (ridingEntityRenderer instanceof LivingEntityRenderer) {
            LivingEntityRenderer lR = (LivingEntityRenderer)ridingEntityRenderer;
            if (entityRenderer instanceof RenderVeggieGhost) {
                RenderVeggieGhost scaledRender = (RenderVeggieGhost)entityRenderer;
                EntityModel model = lR.m_7200_();
                if (model instanceof HumanoidModel || model instanceof IllagerModel || model instanceof SittingModel) {
                    this.body.translateAndRotate(poseStack);
                    this.ridingPosition.translateAndRotate(poseStack);
                    ClientHandlers.translateRider(entityRenderer, rider, model, poseStack);
                    return true;
                }
            }
        }
        return false;
    }
}

