/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.client.model.monster;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import io.github.flemmli97.runecraftory.client.ClientHandlers;
import io.github.flemmli97.runecraftory.client.model.SittingModel;
import io.github.flemmli97.runecraftory.common.entities.BaseMonster;
import io.github.flemmli97.runecraftory.common.entities.monster.EntityWeagle;
import io.github.flemmli97.tenshilib.api.entity.AnimatedAction;
import io.github.flemmli97.tenshilib.client.AnimationManager;
import io.github.flemmli97.tenshilib.client.model.BlockBenchAnimations;
import io.github.flemmli97.tenshilib.client.model.ExtendedModel;
import io.github.flemmli97.tenshilib.client.model.ModelPartHandler;
import io.github.flemmli97.tenshilib.client.model.RideableModel;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.IllagerModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;

public class ModelWeagle<T extends EntityWeagle>
extends EntityModel<T>
implements ExtendedModel,
RideableModel<T> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(new ResourceLocation("runecraftory", "weagle"), "main");
    protected final ModelPartHandler model;
    protected final BlockBenchAnimations anim;
    public ModelPartHandler.ModelPartExtended body;
    public ModelPartHandler.ModelPartExtended head;
    public ModelPartHandler.ModelPartExtended ridingPosition;

    public ModelWeagle(ModelPart root) {
        this.model = new ModelPartHandler(root, "root");
        this.anim = AnimationManager.getInstance().getAnimation(new ResourceLocation("runecraftory", "weagle"));
        this.body = this.model.getPart("body");
        this.head = this.model.getPart("head");
        this.ridingPosition = this.model.getPart("ridingPos");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition body = partdefinition.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-4.0f, -1.0f, -4.0f, 8.0f, 8.0f, 14.0f, new CubeDeformation(0.0f)).m_171514_(60, 22).m_171488_(4.0f, 0.0f, -3.0f, 1.0f, 6.0f, 11.0f, new CubeDeformation(0.0f)).m_171514_(36, 22).m_171488_(-5.0f, 0.0f, -3.0f, 1.0f, 6.0f, 11.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)9.0f, (float)0.0f));
        PartDefinition head = body.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(0, 39).m_171488_(-3.0f, -2.0f, -6.0f, 6.0f, 6.0f, 7.0f, new CubeDeformation(0.0f)).m_171514_(42, 52).m_171488_(0.0f, -5.0f, -6.0f, 0.0f, 3.0f, 6.0f, new CubeDeformation(0.0f)).m_171514_(12, 61).m_171488_(0.0f, 4.0f, -5.0f, 0.0f, 2.0f, 5.0f, new CubeDeformation(0.0f)).m_171514_(22, 63).m_171488_(-2.0f, -1.0f, -7.0f, 4.0f, 4.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(46, 61).m_171488_(-1.0f, 0.25f, -8.5f, 2.0f, 3.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)2.0f, (float)-4.0f));
        PartDefinition leftWing = body.m_171599_("leftWing", CubeListBuilder.m_171558_().m_171514_(46, 66).m_171488_(0.0f, -0.5f, -0.5f, 4.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(20, 52).m_171488_(0.0f, 0.0f, 0.0f, 4.0f, 0.0f, 6.0f, new CubeDeformation(0.0f)).m_171514_(0, 52).m_171488_(0.0f, 0.2f, 0.0f, 4.0f, 0.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)4.7f, (float)2.5f, (float)-1.5f));
        PartDefinition leftWing2 = leftWing.m_171599_("leftWing2", CubeListBuilder.m_171558_().m_171514_(22, 61).m_171488_(0.0f, -1.0f, 0.0f, 6.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(54, 39).m_171488_(0.0f, -0.505f, 0.5f, 6.0f, 0.0f, 8.0f, new CubeDeformation(0.0f)).m_171514_(54, 39).m_171488_(0.0f, -0.305f, 0.5f, 6.0f, 0.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)3.7f, (float)0.5f, (float)-0.5f));
        PartDefinition leftWing3 = leftWing2.m_171599_("leftWing3", CubeListBuilder.m_171558_().m_171514_(20, 58).m_171488_(0.0f, 0.0f, 0.0f, 10.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(0, 22).m_171488_(0.0f, 0.49f, 0.5f, 10.0f, 0.0f, 8.0f, new CubeDeformation(0.0f)).m_171514_(44, 0).m_171488_(0.0f, 0.69f, 0.5f, 10.0f, 0.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)5.7f, (float)-1.0f, (float)0.0f));
        PartDefinition rightWing = body.m_171599_("rightWing", CubeListBuilder.m_171558_().m_171514_(46, 66).m_171480_().m_171488_(-4.0f, -0.5f, -0.5f, 4.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).m_171555_(false).m_171514_(20, 52).m_171480_().m_171488_(-4.0f, 0.0f, 0.0f, 4.0f, 0.0f, 6.0f, new CubeDeformation(0.0f)).m_171555_(false).m_171514_(0, 52).m_171480_().m_171488_(-4.0f, 0.2f, 0.0f, 4.0f, 0.0f, 6.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)-4.7f, (float)2.5f, (float)-1.5f));
        PartDefinition rightWing2 = rightWing.m_171599_("rightWing2", CubeListBuilder.m_171558_().m_171514_(22, 61).m_171480_().m_171488_(-6.0f, -1.0f, 0.0f, 6.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).m_171555_(false).m_171514_(54, 39).m_171480_().m_171488_(-6.0f, -0.505f, 0.5f, 6.0f, 0.0f, 8.0f, new CubeDeformation(0.0f)).m_171555_(false).m_171514_(26, 39).m_171488_(-6.0f, -0.305f, 0.5f, 6.0f, 0.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-3.7f, (float)0.5f, (float)-0.5f));
        PartDefinition rightWing3 = rightWing2.m_171599_("rightWing3", CubeListBuilder.m_171558_().m_171514_(20, 58).m_171480_().m_171488_(-10.0f, 0.0f, 0.0f, 10.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).m_171555_(false).m_171514_(0, 22).m_171480_().m_171488_(-10.0f, 0.49f, 0.5f, 10.0f, 0.0f, 8.0f, new CubeDeformation(0.0f)).m_171555_(false).m_171514_(44, 0).m_171480_().m_171488_(-10.0f, 0.69f, 0.5f, 10.0f, 0.0f, 8.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)-5.7f, (float)-1.0f, (float)0.0f));
        PartDefinition leftLeg = body.m_171599_("leftLeg", CubeListBuilder.m_171558_().m_171514_(0, 61).m_171488_(-1.0f, -1.0f, -0.5f, 2.0f, 2.0f, 4.0f, new CubeDeformation(0.0f)).m_171514_(36, 61).m_171488_(-2.5f, -1.0f, 3.5f, 5.0f, 4.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)3.5f, (float)6.0f, (float)8.5f));
        PartDefinition rightLeg = body.m_171599_("rightLeg", CubeListBuilder.m_171558_().m_171514_(54, 52).m_171488_(-1.0f, -1.0f, -0.5f, 2.0f, 2.0f, 4.0f, new CubeDeformation(0.0f)).m_171514_(36, 61).m_171480_().m_171488_(-2.5f, -1.0f, 3.5f, 5.0f, 4.0f, 0.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)-3.5f, (float)6.0f, (float)8.5f));
        PartDefinition ridingPos = body.m_171599_("ridingPos", CubeListBuilder.m_171558_(), PartPose.m_171423_((float)0.0f, (float)-1.0f, (float)6.0f, (float)1.2217f, (float)0.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)128, (int)128);
    }

    public void m_7695_(PoseStack poseStack, VertexConsumer buffer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.model.getMainPart().render(poseStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.model.resetPoses();
        this.head.yRot += netHeadYaw % 360.0f * ((float)Math.PI / 180) * 0.3f;
        this.head.xRot += headPitch * ((float)Math.PI / 180) * 0.1f;
        float partialTicks = ClientHandlers.getPartialTicks();
        if (((EntityWeagle)entity).f_20919_ <= 0 && !((BaseMonster)entity).playDeath()) {
            if (((BaseMonster)entity).moveTick() > 0) {
                this.anim.doAnimation((ExtendedModel)this, "fly", ((EntityWeagle)entity).f_19797_, partialTicks, ((BaseMonster)entity).interpolatedMoveTick(partialTicks));
            } else if (!EntityWeagle.SLEEP.is(new AnimatedAction[]{((EntityWeagle)entity).getAnimationHandler().getAnimation()})) {
                this.anim.doAnimation((ExtendedModel)this, "idle", ((EntityWeagle)entity).f_19797_, partialTicks);
            }
        }
        this.anim.doAnimation((ExtendedModel)this, ((EntityWeagle)entity).getAnimationHandler(), partialTicks);
    }

    public ModelPartHandler getHandler() {
        return this.model;
    }

    public boolean transform(T entity, EntityRenderer<T> entityRenderer, Entity rider, EntityRenderer<?> ridingEntityRenderer, PoseStack poseStack, int riderNum) {
        LivingEntityRenderer lR;
        EntityModel model;
        if (ridingEntityRenderer instanceof LivingEntityRenderer && ((model = (lR = (LivingEntityRenderer)ridingEntityRenderer).m_7200_()) instanceof HumanoidModel || model instanceof IllagerModel || model instanceof SittingModel)) {
            this.body.translateAndRotate(poseStack);
            this.ridingPosition.translateAndRotate(poseStack);
            ClientHandlers.translateRider(entityRenderer, rider, model, poseStack);
            return true;
        }
        return false;
    }
}

