/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.client.model.monster;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import io.github.flemmli97.runecraftory.client.ClientHandlers;
import io.github.flemmli97.runecraftory.client.model.SittingModel;
import io.github.flemmli97.runecraftory.common.entities.BaseMonster;
import io.github.flemmli97.runecraftory.common.entities.monster.EntityWooly;
import io.github.flemmli97.tenshilib.client.AnimationManager;
import io.github.flemmli97.tenshilib.client.model.BlockBenchAnimations;
import io.github.flemmli97.tenshilib.client.model.ExtendedModel;
import io.github.flemmli97.tenshilib.client.model.ModelPartHandler;
import io.github.flemmli97.tenshilib.client.model.RideableModel;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.IllagerModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;

public class ModelWooly<T extends EntityWooly>
extends EntityModel<T>
implements ExtendedModel,
RideableModel<T> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(new ResourceLocation("runecraftory", "wooly"), "main");
    protected final ModelPartHandler model;
    protected final BlockBenchAnimations anim;
    public ModelPartHandler.ModelPartExtended bodyCenter;
    public ModelPartHandler.ModelPartExtended head;
    public ModelPartHandler.ModelPartExtended body;
    public ModelPartHandler.ModelPartExtended bodyUp;
    public ModelPartHandler.ModelPartExtended armLeftBase;
    public ModelPartHandler.ModelPartExtended armRightBase;
    public ModelPartHandler.ModelPartExtended feetLeftBase;
    public ModelPartHandler.ModelPartExtended feetRightBase;
    public ModelPartHandler.ModelPartExtended ridingPosition;

    public ModelWooly(ModelPart root) {
        this.model = new ModelPartHandler(root.m_171324_("bodyCenter"), "bodyCenter");
        this.anim = AnimationManager.getInstance().getAnimation(new ResourceLocation("runecraftory", "wooly"));
        this.bodyCenter = this.model.getMainPart();
        this.head = this.model.getPart("head");
        this.body = this.model.getPart("body");
        this.bodyUp = this.model.getPart("bodyUp");
        this.armLeftBase = this.model.getPart("armLeftBase");
        this.armRightBase = this.model.getPart("armRightBase");
        this.feetLeftBase = this.model.getPart("feetLeftBase");
        this.feetRightBase = this.model.getPart("feetRightBase");
        this.ridingPosition = this.model.getPart("ridingPos");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition bodyCenter = partdefinition.m_171599_("bodyCenter", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)17.75f, (float)0.0f));
        PartDefinition body = bodyCenter.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-3.5f, -7.0f, -4.5f, 7.0f, 13.0f, 9.0f, new CubeDeformation(0.0f)).m_171514_(32, 0).m_171488_(-4.5f, -7.0f, -3.5f, 1.0f, 13.0f, 7.0f, new CubeDeformation(0.0f)).m_171514_(32, 20).m_171488_(3.5f, -7.0f, -3.5f, 1.0f, 13.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition bodyUp = body.m_171599_("bodyUp", CubeListBuilder.m_171558_().m_171514_(28, 40).m_171488_(-2.5f, -1.0f, -3.5f, 5.0f, 2.0f, 7.0f, new CubeDeformation(0.0f)).m_171514_(54, 53).m_171488_(2.5f, -1.0f, -2.5f, 1.0f, 2.0f, 5.0f, new CubeDeformation(0.0f)).m_171514_(54, 46).m_171488_(-3.5f, -1.0f, -2.5f, 1.0f, 2.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-8.0f, (float)0.0f));
        PartDefinition neck = bodyUp.m_171599_("neck", CubeListBuilder.m_171558_().m_171514_(16, 49).m_171488_(-2.5f, -1.0f, -2.5f, 5.0f, 2.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-1.5f, (float)0.0f));
        PartDefinition head = neck.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(0, 22).m_171488_(-3.5f, -7.0f, -4.5f, 7.0f, 7.0f, 9.0f, new CubeDeformation(0.0f)).m_171514_(0, 46).m_171488_(-4.5f, -7.0f, -3.0f, 1.0f, 7.0f, 7.0f, new CubeDeformation(0.0f)).m_171514_(48, 0).m_171488_(3.5f, -7.0f, -3.5f, 1.0f, 7.0f, 7.0f, new CubeDeformation(0.0f)).m_171514_(0, 38).m_171488_(-3.5f, -8.0f, -3.5f, 7.0f, 1.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-1.0f, (float)0.0f));
        PartDefinition earLeft = head.m_171599_("earLeft", CubeListBuilder.m_171558_().m_171514_(28, 57).m_171488_(0.0f, -0.5f, -1.0f, 5.0f, 1.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)4.0f, (float)-4.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.3491f));
        PartDefinition earRight = head.m_171599_("earRight", CubeListBuilder.m_171558_().m_171514_(0, 60).m_171488_(-5.0f, -0.5f, -1.0f, 5.0f, 1.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-3.5f, (float)-4.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.3491f));
        PartDefinition armLeftBase = body.m_171599_("armLeftBase", CubeListBuilder.m_171558_().m_171514_(62, 60).m_171488_(0.25f, -1.0f, -1.0f, 2.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)3.75f, (float)-3.0f, (float)0.0f, (float)0.1745f, (float)0.0f, (float)0.0f));
        PartDefinition armLeftUp = armLeftBase.m_171599_("armLeftUp", CubeListBuilder.m_171558_().m_171514_(14, 62).m_171488_(-0.25f, -0.5f, -4.0f, 1.0f, 1.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)1.0f, (float)0.0f, (float)-0.5f, (float)0.1745f, (float)0.1745f, (float)0.0f));
        PartDefinition armLeftDown = armLeftUp.m_171599_("armLeftDown", CubeListBuilder.m_171558_().m_171514_(28, 60).m_171488_(-1.0f, -0.5f, -4.0f, 1.0f, 1.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.75f, (float)0.0f, (float)-4.0f, (float)0.4363f, (float)0.5236f, (float)0.0f));
        PartDefinition armRightBase = body.m_171599_("armRightBase", CubeListBuilder.m_171558_().m_171514_(38, 62).m_171488_(-2.25f, -1.0f, -1.0f, 2.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-3.75f, (float)-3.0f, (float)0.0f, (float)0.1745f, (float)0.0f, (float)0.0f));
        PartDefinition armRightUp = armRightBase.m_171599_("armRightUp", CubeListBuilder.m_171558_().m_171514_(52, 60).m_171488_(-0.75f, -0.5f, -4.0f, 1.0f, 1.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-1.0f, (float)0.0f, (float)-0.5f, (float)0.1745f, (float)-0.1745f, (float)0.0f));
        PartDefinition armRightDown = armRightUp.m_171599_("armRightDown", CubeListBuilder.m_171558_().m_171514_(42, 57).m_171488_(0.0f, -0.5f, -4.0f, 1.0f, 1.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-0.75f, (float)0.0f, (float)-4.0f, (float)0.4363f, (float)-0.5236f, (float)0.0f));
        PartDefinition feetLeftBase = body.m_171599_("feetLeftBase", CubeListBuilder.m_171558_().m_171514_(48, 26).m_171488_(-1.5f, -5.5f, -2.5f, 3.0f, 7.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)4.0f, (float)4.75f, (float)0.0f));
        PartDefinition feetLeft = feetLeftBase.m_171599_("feetLeft", CubeListBuilder.m_171558_().m_171514_(52, 38).m_171488_(-1.0f, 0.0f, -7.0f, 2.0f, 1.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.5f, (float)0.0f));
        PartDefinition feetRightBase = body.m_171599_("feetRightBase", CubeListBuilder.m_171558_().m_171514_(48, 14).m_171488_(-1.5f, -5.5f, -2.5f, 3.0f, 7.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-4.0f, (float)4.75f, (float)0.0f));
        PartDefinition feetRight = feetRightBase.m_171599_("feetRight", CubeListBuilder.m_171558_().m_171514_(36, 49).m_171488_(-1.0f, 0.0f, -7.0f, 2.0f, 1.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.5f, (float)0.0f));
        PartDefinition tail = body.m_171599_("tail", CubeListBuilder.m_171558_().m_171514_(16, 56).m_171488_(-1.5f, -1.5f, 0.0f, 3.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)3.0f, (float)4.0f));
        PartDefinition ridingPos = body.m_171599_("ridingPos", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)-7.0f, (float)6.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)128, (int)128);
    }

    public void m_7695_(PoseStack poseStack, VertexConsumer buffer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.model.getMainPart().render(poseStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.model.resetPoses();
        this.head.yRot += netHeadYaw % 360.0f * ((float)Math.PI / 180) * 0.5f;
        this.head.xRot += headPitch * ((float)Math.PI / 180) * 0.5f;
        float partialTicks = ClientHandlers.getPartialTicks();
        if (((EntityWooly)entity).f_20919_ <= 0 && !((BaseMonster)entity).playDeath()) {
            this.anim.doAnimation((ExtendedModel)this, "idle", ((EntityWooly)entity).f_19797_, partialTicks);
            if (((BaseMonster)entity).moveTick() > 0) {
                this.anim.doAnimation((ExtendedModel)this, "walk", ((EntityWooly)entity).f_19797_, partialTicks, ((BaseMonster)entity).interpolatedMoveTick(partialTicks));
            }
        }
        this.anim.doAnimation((ExtendedModel)this, ((EntityWooly)entity).getAnimationHandler(), partialTicks);
    }

    public ModelPartHandler getHandler() {
        return this.model;
    }

    public boolean transform(T entity, EntityRenderer<T> entityRenderer, Entity rider, EntityRenderer<?> ridingEntityRenderer, PoseStack poseStack, int riderNum) {
        LivingEntityRenderer lR;
        EntityModel model;
        if (ridingEntityRenderer instanceof LivingEntityRenderer && ((model = (lR = (LivingEntityRenderer)ridingEntityRenderer).m_7200_()) instanceof HumanoidModel || model instanceof IllagerModel || model instanceof SittingModel)) {
            this.bodyCenter.translateAndRotate(poseStack);
            this.body.translateAndRotate(poseStack);
            this.ridingPosition.translateAndRotate(poseStack);
            ClientHandlers.translateRider(entityRenderer, rider, model, poseStack);
            return true;
        }
        return false;
    }
}

