/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.client.npc;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import io.github.flemmli97.runecraftory.api.registry.NPCFeature;
import io.github.flemmli97.runecraftory.api.registry.NPCFeatureType;
import io.github.flemmli97.runecraftory.client.npc.RenderNPC;
import io.github.flemmli97.runecraftory.common.entities.npc.EntityNPCBase;
import io.github.flemmli97.runecraftory.common.entities.npc.features.BlushFeatureType;
import io.github.flemmli97.runecraftory.common.entities.npc.features.FaceFeaturesType;
import io.github.flemmli97.runecraftory.common.entities.npc.features.HairFeatureType;
import io.github.flemmli97.runecraftory.common.entities.npc.features.IndexedColorSettingType;
import io.github.flemmli97.runecraftory.common.entities.npc.features.NPCFeatureContainer;
import io.github.flemmli97.runecraftory.common.registry.ModNPCLooks;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.Nullable;

public class NPCTextureLayer<T extends EntityNPCBase, M extends HumanoidModel<T>, A extends PlayerModel<T>>
extends RenderLayer<T, M> {
    private final A model;
    private final A slimModel;
    protected LayerType layer;

    public NPCTextureLayer(RenderLayerParent<T, M> renderer, A model, A slimModel, LayerType layer) {
        super(renderer);
        this.model = model;
        this.slimModel = slimModel;
        this.layer = layer;
    }

    public static int color(NPCFeatureContainer features, LayerType layer) {
        int color = switch (layer) {
            case LayerType.SKIN_LAYER -> {
                NPCFeature feat = (IndexedColorSettingType.IndexedColorFeature)features.getFeature((NPCFeatureType)((Object)ModNPCLooks.SKIN.get()));
                if (feat == null) {
                    yield 14008231;
                }
                yield feat.color;
            }
            case LayerType.IRIS_LAYER -> {
                NPCFeature feat = (FaceFeaturesType.FaceFeatures)features.getFeature((NPCFeatureType)((Object)ModNPCLooks.FACE.get()));
                if (feat == null || ((FaceFeaturesType.FaceFeatures)feat).iris == null) {
                    yield 0;
                }
                yield ((FaceFeaturesType.FaceFeatures)feat).iris.color();
            }
            case LayerType.SCLERA_LAYER -> {
                NPCFeature feat = (FaceFeaturesType.FaceFeatures)features.getFeature((NPCFeatureType)((Object)ModNPCLooks.FACE.get()));
                if (feat == null || ((FaceFeaturesType.FaceFeatures)feat).sclera == null) {
                    yield 0;
                }
                yield ((FaceFeaturesType.FaceFeatures)feat).sclera.color();
            }
            case LayerType.EYEBROWS_LAYER -> {
                NPCFeature feat = (FaceFeaturesType.FaceFeatures)features.getFeature((NPCFeatureType)((Object)ModNPCLooks.FACE.get()));
                if (feat == null || ((FaceFeaturesType.FaceFeatures)feat).eyebrow == null) {
                    yield 0;
                }
                yield ((FaceFeaturesType.FaceFeatures)feat).eyebrow.color();
            }
            case LayerType.BLUSH_LAYER -> {
                NPCFeature feat = (BlushFeatureType.BlushFeature)features.getFeature((NPCFeatureType)((Object)ModNPCLooks.BLUSH.get()));
                if (feat == null) {
                    yield 0xFFFFFF;
                }
                yield ((BlushFeatureType.BlushFeature)feat).color;
            }
            case LayerType.HAIR_LAYER -> {
                NPCFeature feat = (HairFeatureType.HairFeature)features.getFeature((NPCFeatureType)((Object)ModNPCLooks.HAIR.get()));
                if (feat == null) {
                    yield 0xFFFFFF;
                }
                yield ((HairFeatureType.HairFeature)feat).color;
            }
            default -> 0xFFFFFF;
        };
        int a = 255;
        if (layer == LayerType.BLUSH_LAYER) {
            a = 88;
        }
        return a << 24 | color;
    }

    public void render(PoseStack poseStack, MultiBufferSource buffer, int packedLight, T npc, float limbSwing, float limbSwingAmount, float partialTick, float ageInTicks, float netHeadYaw, float headPitch) {
        A layerModel = this.getModel(npc);
        this.setup(layerModel);
        this.actualRender(poseStack, buffer, packedLight, npc, layerModel);
    }

    protected A getModel(T npc) {
        return RenderNPC.isSlim(npc) ? this.slimModel : this.model;
    }

    protected void setup(A layerModel) {
        ((HumanoidModel)this.m_117386_()).m_102872_(layerModel);
        ((PlayerModel)layerModel).f_103376_.m_104315_(((HumanoidModel)this.m_117386_()).f_102814_);
        ((PlayerModel)layerModel).f_103377_.m_104315_(((HumanoidModel)this.m_117386_()).f_102813_);
        ((PlayerModel)layerModel).f_103374_.m_104315_(((HumanoidModel)this.m_117386_()).f_102812_);
        ((PlayerModel)layerModel).f_103375_.m_104315_(((HumanoidModel)this.m_117386_()).f_102811_);
        ((PlayerModel)layerModel).f_103378_.m_104315_(((HumanoidModel)this.m_117386_()).f_102810_);
        this.setPartVisibility(layerModel);
    }

    protected void actualRender(PoseStack poseStack, MultiBufferSource buffer, int packedLight, T npc, A layerModel) {
        boolean bl3;
        boolean bl2;
        Minecraft mc = Minecraft.m_91087_();
        boolean bl = !npc.m_20145_();
        RenderType renderType = this.getRenderType(npc, layerModel, bl, bl2 = !bl && !npc.m_20177_((Player)mc.f_91074_), bl3 = mc.m_91314_(npc));
        if (renderType != null) {
            VertexConsumer vertexConsumer = buffer.m_6299_(renderType);
            int m = LivingEntityRenderer.m_115338_(npc, (float)0.0f);
            int color = this.color(npc);
            float a = (float)(color >> 24 & 0xFF) / 255.0f;
            float r = (float)(color >> 16 & 0xFF) / 255.0f;
            float g = (float)(color >> 8 & 0xFF) / 255.0f;
            float b = (float)(color & 0xFF) / 255.0f;
            layerModel.m_7695_(poseStack, vertexConsumer, packedLight, m, r, g, b, a * (bl2 ? 0.15f : 1.0f));
        }
    }

    @Nullable
    protected RenderType getRenderType(T entity, A model, boolean bodyVisible, boolean translucent, boolean glowing) {
        ResourceLocation resourceLocation;
        if (((EntityNPCBase)entity).getPlayDeathTick() > 0 && !((EntityNPCBase)entity).playDeath()) {
            if (((EntityNPCBase)entity).getPlayDeathTick() > 8 && ((EntityNPCBase)entity).getPlayDeathTick() % 2 == 0) {
                return null;
            }
            if (((EntityNPCBase)entity).getPlayDeathTick() % 3 == 0) {
                return null;
            }
        }
        if ((resourceLocation = this.getTexture(entity)).equals((Object)RenderNPC.EMPTY)) {
            return null;
        }
        if (translucent) {
            return RenderType.m_110467_((ResourceLocation)resourceLocation);
        }
        if (bodyVisible) {
            return model.m_103119_(resourceLocation);
        }
        if (glowing) {
            return RenderType.m_110491_((ResourceLocation)resourceLocation);
        }
        return null;
    }

    protected int color(T entity) {
        return NPCTextureLayer.color(((EntityNPCBase)entity).lookFeatures, this.layer);
    }

    protected ResourceLocation getTexture(T entity) {
        return RenderNPC.getTextureFromLook(entity, this.layer, null);
    }

    protected void setPartVisibility(A model) {
        model.m_8009_(false);
        ((PlayerModel)model).f_102808_.f_104207_ = true;
        ((PlayerModel)model).f_102809_.f_104207_ = true;
        switch (this.layer) {
            case SKIN_LAYER: 
            case OUTFIT_LAYER: {
                model.m_8009_(true);
            }
            case HAIR_LAYER: {
                ((PlayerModel)model).f_102810_.f_104207_ = true;
                ((PlayerModel)model).f_103378_.f_104207_ = true;
                ((PlayerModel)model).f_102811_.f_104207_ = true;
                ((PlayerModel)model).f_103375_.f_104207_ = true;
                ((PlayerModel)model).f_102812_.f_104207_ = true;
                ((PlayerModel)model).f_103374_.f_104207_ = true;
            }
        }
    }

    public static enum LayerType {
        SKIN_LAYER("skin", 0.0f),
        OUTFIT_LAYER("outft", 0.005f),
        IRIS_LAYER("eyes", 0.006f),
        SCLERA_LAYER(null, 0.007f),
        EYEBROWS_LAYER(null, 0.008f),
        BLUSH_LAYER("blush", 0.009f),
        HAIR_LAYER("hair", 0.5f),
        HAT_LAYER("hats", 0.8f);

        public final ModelLayerLocation location;
        public final ModelLayerLocation slimLocation;
        public final float expand;

        private LayerType(String name, float expand) {
            this.location = name == null ? null : new ModelLayerLocation(new ResourceLocation("runecraftory", "npc_" + name), "main");
            this.slimLocation = name == null ? null : new ModelLayerLocation(new ResourceLocation("runecraftory", "npc_slim_" + name), "main");
            this.expand = expand;
        }
    }
}

