/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.client.npc;

import com.mojang.authlib.GameProfile;
import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.datafixers.util.Pair;
import com.mojang.math.Vector3f;
import io.github.flemmli97.runecraftory.api.datapack.npc.NPCLook;
import io.github.flemmli97.runecraftory.api.registry.NPCFeature;
import io.github.flemmli97.runecraftory.api.registry.NPCFeatureType;
import io.github.flemmli97.runecraftory.client.npc.NPCArmorLayer;
import io.github.flemmli97.runecraftory.client.npc.NPCFaceLayer;
import io.github.flemmli97.runecraftory.client.npc.NPCFeatureRenderers;
import io.github.flemmli97.runecraftory.client.npc.NPCTextureLayer;
import io.github.flemmli97.runecraftory.common.entities.npc.EntityNPCBase;
import io.github.flemmli97.runecraftory.common.entities.npc.features.BlushFeatureType;
import io.github.flemmli97.runecraftory.common.entities.npc.features.FaceFeaturesType;
import io.github.flemmli97.runecraftory.common.entities.npc.features.HairFeatureType;
import io.github.flemmli97.runecraftory.common.entities.npc.features.IndexedColorSettingType;
import io.github.flemmli97.runecraftory.common.entities.npc.features.NPCFeatureContainer;
import io.github.flemmli97.runecraftory.common.entities.npc.features.OutfitFeatureType;
import io.github.flemmli97.runecraftory.common.entities.npc.features.SimpleHatFeatureType;
import io.github.flemmli97.runecraftory.common.registry.ModNPCLooks;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.ItemInHandLayer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.resources.DefaultPlayerSkin;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.block.entity.SkullBlockEntity;
import org.jetbrains.annotations.Nullable;

public class RenderNPC<T extends EntityNPCBase>
extends MobRenderer<T, PlayerModel<T>> {
    private static final Map<String, PlayerSkin> PLAYER_SKIN_TEXTURE_LOCATIONS = new HashMap<String, PlayerSkin>();
    private static final Map<String, ResourceLocation> TEXTURE_LAYERS_LOCATIONS = new HashMap<String, ResourceLocation>();
    public static final ResourceLocation EMPTY = new ResourceLocation("runecraftory", "textures/entity/npc/empty.png");
    public final NPCArmorLayer<T, PlayerModel<T>, HumanoidModel<T>> armorLayer;
    public final NPCArmorLayer<T, PlayerModel<T>, HumanoidModel<T>> armorLayerSlim;
    public final List<NPCTextureLayer<T, PlayerModel<T>, PlayerModel<T>>> textureLayers = new ArrayList<NPCTextureLayer<T, PlayerModel<T>, PlayerModel<T>>>();

    public RenderNPC(EntityRendererProvider.Context ctx) {
        super(ctx, (EntityModel)new PlayerModel(ctx.m_174023_(ModelLayers.f_171162_), false), 0.5f);
        this.armorLayer = new NPCArmorLayer(this, new HumanoidModel(ctx.m_174023_(ModelLayers.f_171164_)), new HumanoidModel(ctx.m_174023_(ModelLayers.f_171165_)));
        this.m_115326_((RenderLayer)this.armorLayer);
        this.armorLayerSlim = new NPCArmorLayer(this, new HumanoidModel(ctx.m_174023_(ModelLayers.f_171167_)), new HumanoidModel(ctx.m_174023_(ModelLayers.f_171168_)));
        this.m_115326_((RenderLayer)this.armorLayerSlim);
        this.m_115326_((RenderLayer)new ItemInHandLayer((RenderLayerParent)this));
        for (NPCTextureLayer.LayerType layerType : NPCTextureLayer.LayerType.values()) {
            if (layerType.location == null) continue;
            if (layerType == NPCTextureLayer.LayerType.SKIN_LAYER) {
                this.textureLayers.add(new NPCTextureLayer(this, (PlayerModel)this.f_115290_, new PlayerModel(ctx.m_174023_(ModelLayers.f_171166_), true), layerType));
                continue;
            }
            if (layerType == NPCTextureLayer.LayerType.IRIS_LAYER) {
                this.textureLayers.add(new NPCFaceLayer(this, new PlayerModel(ctx.m_174023_(layerType.location), false), new PlayerModel(ctx.m_174023_(layerType.slimLocation), true)));
                continue;
            }
            this.textureLayers.add(new NPCTextureLayer(this, new PlayerModel(ctx.m_174023_(layerType.location), false), new PlayerModel(ctx.m_174023_(layerType.slimLocation), true), layerType));
        }
        this.textureLayers.forEach(x$0 -> this.m_115326_((RenderLayer)x$0));
    }

    public static boolean isSlim(EntityNPCBase npc) {
        String skin = npc.getLook().playerSkin();
        if (skin != null) {
            String skinMeta = PLAYER_SKIN_TEXTURE_LOCATIONS.computeIfAbsent(skin, s -> new PlayerSkin(skin)).getSkinMeta();
            return skinMeta.equals("slim");
        }
        return npc.lookFeatures.view.containsKey(ModNPCLooks.SLIM.get());
    }

    public static ResourceLocation getTextureFromLook(EntityNPCBase npc, NPCTextureLayer.LayerType type, @Nullable String subType) {
        NPCLook look = npc.getLook();
        if (type == NPCTextureLayer.LayerType.SKIN_LAYER) {
            if (look == NPCLook.DEFAULT_LOOK) {
                return DefaultPlayerSkin.m_118627_((UUID)npc.m_142081_());
            }
            String skin = look.playerSkin();
            if (skin != null) {
                return PLAYER_SKIN_TEXTURE_LOCATIONS.computeIfAbsent(skin, s -> new PlayerSkin(skin)).getLocation();
            }
        } else if (look.playerSkin() != null || look == NPCLook.DEFAULT_LOOK) {
            return EMPTY;
        }
        boolean slim = RenderNPC.isSlim(npc);
        if (type == NPCTextureLayer.LayerType.HAT_LAYER && npc.m_21033_(EquipmentSlot.HEAD)) {
            return EMPTY;
        }
        return RenderNPC.getTextureFromLook(npc.lookFeatures, slim, type, subType);
    }

    public static ResourceLocation getTextureFromLook(NPCFeatureContainer features, boolean slim, NPCTextureLayer.LayerType type, @Nullable String subType) {
        ResourceLocation texture = switch (type) {
            default -> throw new IncompatibleClassChangeError();
            case NPCTextureLayer.LayerType.SKIN_LAYER -> {
                NPCFeature feat = (IndexedColorSettingType.IndexedColorFeature)features.getFeature((NPCFeatureType)((Object)ModNPCLooks.SKIN.get()));
                int num = 0;
                if (feat != null) {
                    num = ((IndexedColorSettingType.IndexedColorFeature)feat).index;
                }
                String location = String.format("textures/entity/npc/skin/%s%s.png", slim ? "slim_" : "", num);
                yield TEXTURE_LAYERS_LOCATIONS.computeIfAbsent(location, RenderNPC::modLoc);
            }
            case NPCTextureLayer.LayerType.IRIS_LAYER -> {
                NPCFeature feat = (FaceFeaturesType.FaceFeatures)features.getFeature((NPCFeatureType)((Object)ModNPCLooks.FACE.get()));
                int num = 0;
                if (feat != null) {
                    num = ((FaceFeaturesType.FaceFeatures)feat).iris.index();
                    if (subType != null) {
                        subType = ((FaceFeaturesType.FaceFeatures)feat).expressionTexture(features, subType, FaceFeaturesType.ExpressionType.IRIS);
                    }
                }
                String location = String.format("textures/entity/npc/eye/iris_%s%s.png", num, subType != null ? "_" + subType : "");
                yield TEXTURE_LAYERS_LOCATIONS.computeIfAbsent(location, RenderNPC::modLoc);
            }
            case NPCTextureLayer.LayerType.SCLERA_LAYER -> {
                NPCFeature feat = (FaceFeaturesType.FaceFeatures)features.getFeature((NPCFeatureType)((Object)ModNPCLooks.FACE.get()));
                int num = 0;
                if (feat != null) {
                    num = ((FaceFeaturesType.FaceFeatures)feat).sclera.index();
                    if (subType != null) {
                        subType = ((FaceFeaturesType.FaceFeatures)feat).expressionTexture(features, subType, FaceFeaturesType.ExpressionType.SCLERA);
                    }
                }
                String location = String.format("textures/entity/npc/eye/sclera_%s%s.png", num, subType != null ? "_" + subType : "");
                yield TEXTURE_LAYERS_LOCATIONS.computeIfAbsent(location, RenderNPC::modLoc);
            }
            case NPCTextureLayer.LayerType.EYEBROWS_LAYER -> {
                NPCFeature feat = (FaceFeaturesType.FaceFeatures)features.getFeature((NPCFeatureType)((Object)ModNPCLooks.FACE.get()));
                int num = 0;
                if (feat != null) {
                    num = ((FaceFeaturesType.FaceFeatures)feat).eyebrow.index();
                    if (subType != null) {
                        subType = ((FaceFeaturesType.FaceFeatures)feat).expressionTexture(features, subType, FaceFeaturesType.ExpressionType.EYEBROWS);
                    }
                }
                String location = String.format("textures/entity/npc/eye/eyebrows_%s%s.png", num, subType != null ? "_" + subType : "");
                yield TEXTURE_LAYERS_LOCATIONS.computeIfAbsent(location, RenderNPC::modLoc);
            }
            case NPCTextureLayer.LayerType.BLUSH_LAYER -> {
                NPCFeature feat = (BlushFeatureType.BlushFeature)features.getFeature((NPCFeatureType)((Object)ModNPCLooks.BLUSH.get()));
                if (feat == null || !((BlushFeatureType.BlushFeature)feat).blush) {
                    yield null;
                }
                String location = "textures/entity/npc/misc/blush.png";
                yield TEXTURE_LAYERS_LOCATIONS.computeIfAbsent(location, RenderNPC::modLoc);
            }
            case NPCTextureLayer.LayerType.OUTFIT_LAYER -> {
                NPCFeature feat = (OutfitFeatureType.OutfitFeature)features.getFeature((NPCFeatureType)((Object)ModNPCLooks.OUTFIT.get()));
                String location = String.format("textures/entity/npc/outfit/generic%s_0.png", slim ? "_slim" : "");
                if (feat != null) {
                    location = String.format("textures/entity/npc/outfit/%s%s_%s.png", ((OutfitFeatureType.OutfitFeature)feat).type, slim ? "_slim" : "", ((OutfitFeatureType.OutfitFeature)feat).index);
                }
                yield TEXTURE_LAYERS_LOCATIONS.computeIfAbsent(location, RenderNPC::modLoc);
            }
            case NPCTextureLayer.LayerType.HAIR_LAYER -> {
                NPCFeature feat = (HairFeatureType.HairFeature)features.getFeature((NPCFeatureType)((Object)ModNPCLooks.HAIR.get()));
                if (feat == null) {
                    yield null;
                }
                String location = String.format("textures/entity/npc/hair/%s_%s.png", ((HairFeatureType.HairFeature)feat).type, ((HairFeatureType.HairFeature)feat).index);
                yield TEXTURE_LAYERS_LOCATIONS.computeIfAbsent(location, RenderNPC::modLoc);
            }
            case NPCTextureLayer.LayerType.HAT_LAYER -> {
                NPCFeature feat = (SimpleHatFeatureType.SimpleHatFeature)features.getFeature((NPCFeatureType)((Object)ModNPCLooks.HAT.get()));
                if (feat == null || ((SimpleHatFeatureType.SimpleHatFeature)feat).hat.isEmpty()) {
                    yield null;
                }
                String location = String.format("textures/entity/npc/misc/%s.png", ((SimpleHatFeatureType.SimpleHatFeature)feat).hat);
                yield TEXTURE_LAYERS_LOCATIONS.computeIfAbsent(location, RenderNPC::modLoc);
            }
        };
        return texture == null ? EMPTY : texture;
    }

    private static ResourceLocation modLoc(String s) {
        return new ResourceLocation("runecraftory", s);
    }

    public static boolean renderForTooltip(PoseStack stack, int x, int y, @Nullable String skin, List<Pair<Integer, ResourceLocation>> textures) {
        if (skin == null && textures == null) {
            return false;
        }
        int sizeX = 16;
        int sizeY = 16;
        if (skin != null) {
            ResourceLocation res = PLAYER_SKIN_TEXTURE_LOCATIONS.computeIfAbsent(skin, s -> new PlayerSkin(skin)).getLocation();
            RenderSystem.m_157456_((int)0, (ResourceLocation)res);
            GuiComponent.m_93160_((PoseStack)stack, (int)x, (int)y, (int)sizeX, (int)sizeY, (float)8.0f, (float)8.0f, (int)8, (int)8, (int)64, (int)64);
            RenderSystem.m_69478_();
            GuiComponent.m_93160_((PoseStack)stack, (int)x, (int)y, (int)sizeX, (int)sizeY, (float)40.0f, (float)8.0f, (int)8, (int)8, (int)64, (int)64);
            RenderSystem.m_69461_();
        } else {
            for (Pair<Integer, ResourceLocation> layer : textures) {
                int color = (Integer)layer.getFirst();
                float a = (float)(color >> 24 & 0xFF) / 255.0f;
                float r = (float)(color >> 16 & 0xFF) / 255.0f;
                float g = (float)(color >> 8 & 0xFF) / 255.0f;
                float b = (float)(color & 0xFF) / 255.0f;
                RenderSystem.m_157429_((float)r, (float)g, (float)b, (float)a);
                RenderSystem.m_157456_((int)0, (ResourceLocation)((ResourceLocation)layer.getSecond()));
                GuiComponent.m_93160_((PoseStack)stack, (int)x, (int)y, (int)sizeX, (int)sizeY, (float)8.0f, (float)8.0f, (int)8, (int)8, (int)64, (int)64);
                RenderSystem.m_69478_();
                GuiComponent.m_93160_((PoseStack)stack, (int)x, (int)y, (int)sizeX, (int)sizeY, (float)40.0f, (float)8.0f, (int)8, (int)8, (int)64, (int)64);
                RenderSystem.m_69461_();
            }
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
        return true;
    }

    protected boolean shouldShowName(T entity) {
        return false;
    }

    public void render(T entity, float entityYaw, float partialTicks, PoseStack stack, MultiBufferSource buffer, int packedLight) {
        boolean slim = RenderNPC.isSlim(entity);
        this.armorLayer.setRender(!slim);
        this.armorLayerSlim.setRender(slim);
        for (NPCFeature feature : ((EntityNPCBase)entity).lookFeatures.view.values()) {
            NPCFeatureRenderers.get(feature).onSetup(feature, this, entity, stack);
        }
        this.setModelProperties((EntityNPCBase)entity);
        super.m_7392_(entity, entityYaw, partialTicks, stack, buffer, packedLight);
        for (NPCFeature feature : ((EntityNPCBase)entity).lookFeatures.view.values()) {
            NPCFeatureRenderers.get(feature).render(feature, (EntityNPCBase)entity, entityYaw, partialTicks, stack, buffer, packedLight);
        }
    }

    private void setModelProperties(EntityNPCBase npc) {
        PlayerModel playerModel = (PlayerModel)this.m_7200_();
        playerModel.m_8009_(true);
        playerModel.f_102817_ = npc.m_6047_();
        HumanoidModel.ArmPose main = RenderNPC.getArmPose(npc, InteractionHand.MAIN_HAND);
        HumanoidModel.ArmPose off = RenderNPC.getArmPose(npc, InteractionHand.OFF_HAND);
        if (npc.m_5737_() == HumanoidArm.RIGHT) {
            playerModel.f_102816_ = main;
            playerModel.f_102815_ = off;
        } else {
            playerModel.f_102816_ = off;
            playerModel.f_102815_ = main;
        }
    }

    private static HumanoidModel.ArmPose getArmPose(EntityNPCBase npc, InteractionHand hand) {
        ItemStack itemStack = npc.m_21120_(hand);
        if (itemStack.m_41619_()) {
            return HumanoidModel.ArmPose.EMPTY;
        }
        if (npc.m_7655_() == hand && npc.m_21212_() > 0) {
            UseAnim useAnim = itemStack.m_41780_();
            if (useAnim == UseAnim.BLOCK) {
                return HumanoidModel.ArmPose.BLOCK;
            }
            if (useAnim == UseAnim.BOW) {
                return HumanoidModel.ArmPose.BOW_AND_ARROW;
            }
            if (useAnim == UseAnim.SPEAR) {
                return HumanoidModel.ArmPose.THROW_SPEAR;
            }
            if (useAnim == UseAnim.CROSSBOW && hand == npc.m_7655_()) {
                return HumanoidModel.ArmPose.CROSSBOW_CHARGE;
            }
            if (useAnim == UseAnim.SPYGLASS) {
                return HumanoidModel.ArmPose.SPYGLASS;
            }
        } else if (!npc.f_20911_ && itemStack.m_150930_(Items.f_42717_) && CrossbowItem.m_40932_((ItemStack)itemStack)) {
            return HumanoidModel.ArmPose.CROSSBOW_HOLD;
        }
        return HumanoidModel.ArmPose.ITEM;
    }

    public ResourceLocation getTextureLocation(T entity) {
        return RenderNPC.getTextureFromLook(entity, NPCTextureLayer.LayerType.SKIN_LAYER, null);
    }

    protected void setupRotations(T entity, PoseStack stack, float ageInTicks, float rotationYaw, float partialTicks) {
        super.m_7523_(entity, stack, ageInTicks, rotationYaw, partialTicks);
        if (((EntityNPCBase)entity).getPlayDeathTick() > 0) {
            float f;
            float partial = partialTicks - 1.0f;
            float f2 = ((float)((EntityNPCBase)entity).getPlayDeathTick() + (((EntityNPCBase)entity).playDeath() ? partial : -partial)) / 20.0f * 1.6f;
            f2 = Mth.m_14116_((float)f2);
            if (f > 1.0f) {
                f2 = 1.0f;
            }
            stack.m_85837_(0.0, (double)f2 * 0.1, (double)(-f2 * entity.m_20206_()) * 0.5);
            stack.m_85845_(Vector3f.f_122223_.m_122240_(f2 * this.m_6441_((LivingEntity)entity)));
        }
        for (NPCFeature feature : ((EntityNPCBase)entity).lookFeatures.view.values()) {
            NPCFeatureRenderers.get(feature).transformStack(feature, this, entity, stack, partialTicks);
        }
    }

    protected void scale(T livingEntity, PoseStack matrixStack, float partialTickTime) {
        matrixStack.m_85841_(0.9375f, 0.9375f, 0.9375f);
    }

    @Nullable
    protected RenderType getRenderType(T entity, boolean invis, boolean translucent, boolean glowing) {
        return null;
    }

    static class PlayerSkin {
        private GameProfile gameProfile;
        private ResourceLocation location = DefaultPlayerSkin.m_118626_();
        private String skinMeta = "";
        private boolean pendingTextures;

        public PlayerSkin(String name) {
            SkullBlockEntity.m_155738_((GameProfile)new GameProfile(null, name), prof -> {
                this.gameProfile = prof;
            });
        }

        public ResourceLocation getLocation() {
            this.registerTextures();
            return this.location;
        }

        public String getSkinMeta() {
            this.registerTextures();
            return this.skinMeta;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void registerTextures() {
            PlayerSkin playerSkin = this;
            synchronized (playerSkin) {
                if (!this.pendingTextures && this.gameProfile != null) {
                    this.pendingTextures = true;
                    Minecraft.m_91087_().m_91109_().m_118817_(this.gameProfile, (type, resourceLocation, minecraftProfileTexture) -> {
                        if (type == MinecraftProfileTexture.Type.SKIN) {
                            String metadata = minecraftProfileTexture.getMetadata("model");
                            if (metadata == null) {
                                metadata = "default";
                            }
                            this.location = resourceLocation;
                            this.skinMeta = metadata;
                        }
                    }, true);
                }
            }
        }
    }
}

