/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.client.particles;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Vector3f;
import io.github.flemmli97.runecraftory.RuneCraftory;
import io.github.flemmli97.runecraftory.client.particles.CustomParticleRenderTypes;
import io.github.flemmli97.runecraftory.common.particles.BlockStateParticleData;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public class BlockParticle
extends Particle {
    private final BlockRenderDispatcher dispatcher = Minecraft.m_91087_().m_91289_();
    private final BlockState state;
    private final float yaw;
    private final float pitch;
    private float cameraLastPitch;
    private float cameraLastYaw;
    private boolean first = true;

    public BlockParticle(ClientLevel level, double x, double y, double z, double motionX, double motionY, double motionZ, BlockState state, float yaw, float pitch, int duration) {
        super(level, x, y, z);
        this.f_107215_ = motionX;
        this.f_107216_ = motionY;
        this.f_107217_ = motionZ;
        this.state = state;
        this.yaw = yaw;
        this.pitch = pitch;
        this.f_107225_ = duration;
        this.f_107226_ = 0.3f;
    }

    public void m_5744_(VertexConsumer buffer, Camera renderInfo, float partialTicks) {
        if (this.state.m_60799_() != RenderShape.MODEL) {
            return;
        }
        if (this.first) {
            this.cameraLastPitch = renderInfo.m_90589_();
            this.cameraLastYaw = renderInfo.m_90590_() - 180.0f;
            this.first = false;
        }
        Vec3 vec3 = renderInfo.m_90583_();
        float x = (float)(Mth.m_14139_((double)partialTicks, (double)this.f_107209_, (double)this.f_107212_) - vec3.m_7096_());
        float y = (float)(Mth.m_14139_((double)partialTicks, (double)this.f_107210_, (double)this.f_107213_) - vec3.m_7098_());
        float z = (float)(Mth.m_14139_((double)partialTicks, (double)this.f_107211_, (double)this.f_107214_) - vec3.m_7094_());
        PoseStack stack = new PoseStack();
        this.irisFix(stack, renderInfo, partialTicks);
        stack.m_85837_((double)x, (double)y, (double)z);
        stack.m_85845_(Vector3f.f_122225_.m_122240_(180.0f - this.yaw));
        stack.m_85845_(Vector3f.f_122223_.m_122240_(this.pitch));
        BlockPos pos = new BlockPos(this.f_107212_, this.f_107213_, this.f_107214_);
        if (this.f_107208_.m_8055_(pos).m_60815_()) {
            pos = pos.m_7494_();
        }
        int block = this.f_107208_.m_45517_(LightLayer.BLOCK, pos);
        int light = this.f_107208_.m_45517_(LightLayer.SKY, pos);
        stack.m_85837_(-0.5, 0.0, -0.5);
        CustomParticleRenderTypes.batchType(ItemBlockRenderTypes.m_109284_((BlockState)this.state, (boolean)false));
        this.dispatcher.m_110912_(this.state, stack, (MultiBufferSource)Minecraft.m_91087_().m_91269_().m_110104_(), LightTexture.m_109885_((int)block, (int)light), OverlayTexture.f_118083_);
    }

    private void irisFix(PoseStack stack, Camera renderInfo, float partialTicks) {
        if (!RuneCraftory.iris) {
            return;
        }
        stack.m_85845_(Vector3f.f_122223_.m_122240_(Mth.m_14179_((float)partialTicks, (float)this.cameraLastPitch, (float)renderInfo.m_90589_())));
        stack.m_85845_(Vector3f.f_122225_.m_122240_(Mth.m_14179_((float)partialTicks, (float)this.cameraLastYaw, (float)(renderInfo.m_90590_() - 180.0f))));
        this.cameraLastPitch = renderInfo.m_90589_();
        this.cameraLastYaw = renderInfo.m_90590_() - 180.0f;
    }

    public ParticleRenderType m_7556_() {
        return CustomParticleRenderTypes.ENTITY_MODEL_TYPE;
    }

    public record Factory(SpriteSet sprite) implements ParticleProvider<BlockStateParticleData>
    {
        public Particle createParticle(BlockStateParticleData data, ClientLevel level, double x, double y, double z, double motionX, double motionY, double motionZ) {
            return new BlockParticle(level, x, y, z, motionX, motionY, motionZ, data.getState(), data.getYaw(), data.getPitch(), data.getDuration());
        }
    }
}

