/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.client.particles;

import io.github.flemmli97.runecraftory.common.particles.ColoredParticleData4f;
import io.github.flemmli97.tenshilib.client.particles.ColoredParticle;
import io.github.flemmli97.tenshilib.common.particle.ColoredParticleData;
import io.github.flemmli97.tenshilib.common.utils.MathUtils;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.world.phys.Vec3;

public class CirclingParticle
extends ColoredParticle {
    private final double motionAX;
    private final double motionAY;
    private final double motionAZ;
    private final double speedMod;
    private final float radInc;
    private final float expansion;
    private double[] point;

    public CirclingParticle(ClientLevel world, double x, double y, double z, double dirX, double dirY, double dirZ, ColoredParticleData colorData, SpriteSet sprite, int maxAge, float minAgeRand, float maxAgeRand, double radius, double speedMod, float radAdd, float radInc, float expansion) {
        super(world, x, y, z, 0.0, 0.0, 0.0, colorData, sprite, maxAge, minAgeRand, maxAgeRand, false, false, false);
        if (dirX == 0.0 && dirY == 0.0 && dirZ == 0.0) {
            dirY = 1.0;
        }
        double len = Math.sqrt(dirX * dirX + dirY * dirY + dirZ * dirZ);
        this.motionAX = dirX / len;
        this.motionAY = dirY / len;
        this.motionAZ = dirZ / len;
        this.speedMod = speedMod;
        len = Math.sqrt(dirX * dirX + dirY * dirY);
        this.point = new double[]{-dirY / len * radius, dirX / len * radius, 0.0};
        this.point = MathUtils.rotate((double)this.motionAX, (double)this.motionAY, (double)this.motionAZ, (double)this.point[0], (double)this.point[1], (double)this.point[2], (float)MathUtils.degToRad((float)radAdd));
        this.m_107264_(this.f_107212_ + this.point[0] * 0.5, this.f_107213_ + this.point[1] * 0.5, this.f_107214_);
        this.f_107209_ = this.f_107212_;
        this.f_107210_ = this.f_107213_;
        this.f_107211_ = this.f_107214_;
        this.radInc = MathUtils.degToRad((float)radInc);
        this.expansion = expansion;
    }

    public void m_5989_() {
        this.f_107209_ = this.f_107212_;
        this.f_107210_ = this.f_107213_;
        this.f_107211_ = this.f_107214_;
        if (this.f_107224_++ >= this.f_107225_) {
            this.m_107274_();
        } else {
            double[] prev = this.point;
            Vec3 dir = this.expansion == 0.0f ? Vec3.f_82478_ : new Vec3(this.point[0], this.point[1], this.point[2]).m_82541_().m_82490_((double)this.expansion);
            this.point = MathUtils.rotate((double)this.motionAX, (double)this.motionAY, (double)this.motionAZ, (double)(this.point[0] + dir.f_82479_), (double)(this.point[1] + dir.f_82480_), (double)(this.point[2] + dir.f_82481_), (float)this.radInc);
            this.m_108339_(this.spriteProvider);
            this.m_6257_(this.point[0] - prev[0] + this.motionAX * this.speedMod, this.point[1] - prev[1] + this.motionAY * this.speedMod, this.point[2] - prev[2] + this.motionAZ * this.speedMod);
        }
    }

    public record CirclingFactoryBase(SpriteSet sprite) implements ParticleProvider<ColoredParticleData4f>
    {
        public Particle createParticle(ColoredParticleData4f data, ClientLevel level, double x, double y, double z, double motionX, double motionY, double motionZ) {
            return new CirclingParticle(level, x, y, z, motionX, motionY, motionZ, data, this.sprite, 25, 0.9f, 1.1f, data.getRadius(), data.getSpeed(), data.getOffset(), data.getAngleIncrease(), data.getExpansion()).setScale(data.getScale());
        }
    }
}

