/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.client.particles;

import com.google.common.base.Suppliers;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Vector3f;
import io.github.flemmli97.runecraftory.RuneCraftory;
import io.github.flemmli97.runecraftory.client.model.monster.ModelSkelefang;
import io.github.flemmli97.runecraftory.client.particles.CustomParticleRenderTypes;
import io.github.flemmli97.runecraftory.client.render.monster.RenderSkelefang;
import io.github.flemmli97.runecraftory.common.entities.monster.boss.EntitySkelefang;
import io.github.flemmli97.runecraftory.common.particles.SkelefangParticleData;
import io.github.flemmli97.tenshilib.client.model.ModelPartHandler;
import io.github.flemmli97.tenshilib.client.model.PoseExtended;
import io.github.flemmli97.tenshilib.common.utils.MathUtils;
import java.util.function.Supplier;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.phys.Vec3;

public class SkelefangParticle
extends Particle {
    private static final Supplier<ModelSkelefang<EntitySkelefang>> MODEL = Suppliers.memoize(() -> {
        ModelSkelefang model = new ModelSkelefang(Minecraft.m_91087_().m_167973_().m_171103_(ModelSkelefang.LAYER_LOCATION), RenderType::m_110470_);
        model.body.loadPoseRecursive(PoseExtended.ZERO);
        return model;
    });
    private static final Supplier<RenderType> RENDER_TYPE = Suppliers.memoize(() -> MODEL.get().m_103119_(RenderSkelefang.TEXTURE));
    private final SkelefangParticleData.SkelefangBoneType boneType;
    private final float initialRotX;
    private final float initialRotY;
    private final float pitchSpin;
    private final float yawSpin;
    private int groundTick;
    private float cameraLastPitch;
    private float cameraLastYaw;
    private boolean first = true;

    public SkelefangParticle(ClientLevel world, double x, double y, double z, double dirX, double dirY, double dirZ, SkelefangParticleData data) {
        super(world, x, y, z);
        ModelPartHandler.ModelPartExtended[] parts;
        this.m_172260_(dirX, dirY, dirZ);
        if (data.hasGravity()) {
            this.f_107226_ = 1.0f;
        }
        this.f_172259_ = false;
        this.boneType = data.getBoneType();
        this.initialRotX = data.getInitialRotX();
        this.initialRotY = data.getInitialRotY();
        this.pitchSpin = data.getPitchSpin();
        this.yawSpin = data.getYawSpin();
        this.f_107225_ = data.getMaxTime();
        switch (this.boneType) {
            case TAIL: {
                ModelPartHandler.ModelPartExtended[] modelPartExtendedArray = new ModelPartHandler.ModelPartExtended[4];
                modelPartExtendedArray[0] = SkelefangParticle.MODEL.get().body;
                modelPartExtendedArray[1] = SkelefangParticle.MODEL.get().spineBack;
                modelPartExtendedArray[2] = SkelefangParticle.MODEL.get().tailBase;
                ModelPartHandler.ModelPartExtended[] modelPartExtendedArray2 = modelPartExtendedArray;
                modelPartExtendedArray[3] = SkelefangParticle.MODEL.get().tail;
                break;
            }
            case TAIL_BASE: {
                ModelPartHandler.ModelPartExtended[] modelPartExtendedArray = new ModelPartHandler.ModelPartExtended[3];
                modelPartExtendedArray[0] = SkelefangParticle.MODEL.get().body;
                modelPartExtendedArray[1] = SkelefangParticle.MODEL.get().spineBack;
                ModelPartHandler.ModelPartExtended[] modelPartExtendedArray2 = modelPartExtendedArray;
                modelPartExtendedArray[2] = SkelefangParticle.MODEL.get().tailBase;
                break;
            }
            case LEFT_LEG: {
                ModelPartHandler.ModelPartExtended[] modelPartExtendedArray = new ModelPartHandler.ModelPartExtended[3];
                modelPartExtendedArray[0] = SkelefangParticle.MODEL.get().body;
                modelPartExtendedArray[1] = SkelefangParticle.MODEL.get().spineBack;
                ModelPartHandler.ModelPartExtended[] modelPartExtendedArray2 = modelPartExtendedArray;
                modelPartExtendedArray[2] = SkelefangParticle.MODEL.get().leftLegBase;
                break;
            }
            case RIGHT_LEG: {
                ModelPartHandler.ModelPartExtended[] modelPartExtendedArray = new ModelPartHandler.ModelPartExtended[3];
                modelPartExtendedArray[0] = SkelefangParticle.MODEL.get().body;
                modelPartExtendedArray[1] = SkelefangParticle.MODEL.get().spineBack;
                ModelPartHandler.ModelPartExtended[] modelPartExtendedArray2 = modelPartExtendedArray;
                modelPartExtendedArray[2] = SkelefangParticle.MODEL.get().rightLegBase;
                break;
            }
            case HEAD: {
                ModelPartHandler.ModelPartExtended[] modelPartExtendedArray = new ModelPartHandler.ModelPartExtended[4];
                modelPartExtendedArray[0] = SkelefangParticle.MODEL.get().body;
                modelPartExtendedArray[1] = SkelefangParticle.MODEL.get().spineFront;
                modelPartExtendedArray[2] = SkelefangParticle.MODEL.get().neck;
                ModelPartHandler.ModelPartExtended[] modelPartExtendedArray2 = modelPartExtendedArray;
                modelPartExtendedArray[3] = SkelefangParticle.MODEL.get().head;
                break;
            }
            case NECK: {
                ModelPartHandler.ModelPartExtended[] modelPartExtendedArray = new ModelPartHandler.ModelPartExtended[3];
                modelPartExtendedArray[0] = SkelefangParticle.MODEL.get().body;
                modelPartExtendedArray[1] = SkelefangParticle.MODEL.get().spineFront;
                ModelPartHandler.ModelPartExtended[] modelPartExtendedArray2 = modelPartExtendedArray;
                modelPartExtendedArray[2] = SkelefangParticle.MODEL.get().neck;
                break;
            }
            case BACK: {
                ModelPartHandler.ModelPartExtended[] modelPartExtendedArray = new ModelPartHandler.ModelPartExtended[2];
                modelPartExtendedArray[0] = SkelefangParticle.MODEL.get().body;
                ModelPartHandler.ModelPartExtended[] modelPartExtendedArray2 = modelPartExtendedArray;
                modelPartExtendedArray[1] = SkelefangParticle.MODEL.get().spineBack;
                break;
            }
            case BACK_RIBS: {
                ModelPartHandler.ModelPartExtended[] modelPartExtendedArray = new ModelPartHandler.ModelPartExtended[3];
                modelPartExtendedArray[0] = SkelefangParticle.MODEL.get().body;
                modelPartExtendedArray[1] = SkelefangParticle.MODEL.get().spineBack;
                ModelPartHandler.ModelPartExtended[] modelPartExtendedArray2 = modelPartExtendedArray;
                modelPartExtendedArray[2] = SkelefangParticle.MODEL.get().ribsSpine;
                break;
            }
            case FRONT: {
                ModelPartHandler.ModelPartExtended[] modelPartExtendedArray = new ModelPartHandler.ModelPartExtended[2];
                modelPartExtendedArray[0] = SkelefangParticle.MODEL.get().body;
                ModelPartHandler.ModelPartExtended[] modelPartExtendedArray2 = modelPartExtendedArray;
                modelPartExtendedArray[1] = SkelefangParticle.MODEL.get().spineFront;
                break;
            }
            case FRONT_RIBS: {
                ModelPartHandler.ModelPartExtended[] modelPartExtendedArray = new ModelPartHandler.ModelPartExtended[3];
                modelPartExtendedArray[0] = SkelefangParticle.MODEL.get().body;
                modelPartExtendedArray[1] = SkelefangParticle.MODEL.get().spineFront;
                ModelPartHandler.ModelPartExtended[] modelPartExtendedArray2 = modelPartExtendedArray;
                modelPartExtendedArray[2] = SkelefangParticle.MODEL.get().ribsBody;
                break;
            }
            default: {
                ModelPartHandler.ModelPartExtended[] modelPartExtendedArray2 = parts = null;
            }
        }
        if (parts != null) {
            double mX = 0.0;
            double mY = 0.0;
            double mZ = 0.0;
            for (ModelPartHandler.ModelPartExtended part : parts) {
                mX += (double)part.x;
                mY += (double)part.y;
                mZ += (double)part.z;
            }
            double[] offset = MathUtils.rotate((double)0.0, (double)1.0, (double)0.0, (double)mX, (double)(mY - 22.75), (double)mZ, (float)((float)Math.PI / 180 * Mth.m_14177_((float)this.initialRotY)));
            this.m_107264_(this.f_107212_ + offset[0] * 1.0 / 16.0, this.f_107213_ - offset[1] * 1.0 / 16.0, this.f_107214_ - offset[2] * 1.0 / 16.0);
            this.f_107209_ = this.f_107212_;
            this.f_107210_ = this.f_107213_;
            this.f_107211_ = this.f_107214_;
        }
    }

    public void m_5989_() {
        super.m_5989_();
        if (this.f_107218_ && this.groundTick == 0) {
            this.groundTick = this.f_107224_;
        }
    }

    public void m_5744_(VertexConsumer buffer, Camera renderInfo, float partialTicks) {
        int spinAge;
        int next;
        if (this.first) {
            this.cameraLastPitch = renderInfo.m_90589_();
            this.cameraLastYaw = renderInfo.m_90590_() - 180.0f;
            this.first = false;
        }
        Vec3 vec3 = renderInfo.m_90583_();
        float x = (float)(Mth.m_14139_((double)partialTicks, (double)this.f_107209_, (double)this.f_107212_) - vec3.m_7096_());
        float y = (float)(Mth.m_14139_((double)partialTicks, (double)this.f_107210_, (double)this.f_107213_) - vec3.m_7098_());
        float z = (float)(Mth.m_14139_((double)partialTicks, (double)this.f_107211_, (double)this.f_107214_) - vec3.m_7094_());
        PoseStack stack = new PoseStack();
        this.irisFix(stack, renderInfo, partialTicks);
        stack.m_85837_((double)x, (double)y, (double)z);
        if (this.groundTick > 0 && this.f_107224_ > this.groundTick) {
            next = this.groundTick;
            spinAge = this.groundTick;
        } else {
            next = this.f_107224_ + 1;
            spinAge = this.f_107224_;
        }
        float yaw = Mth.m_14179_((float)partialTicks, (float)(this.initialRotY + this.yawSpin * (float)spinAge), (float)(this.initialRotY + this.yawSpin * (float)next));
        float pitch = Mth.m_14179_((float)partialTicks, (float)(this.initialRotX + this.pitchSpin * (float)spinAge), (float)(this.initialRotX + this.pitchSpin * (float)next));
        stack.m_85845_(Vector3f.f_122225_.m_122240_(180.0f - yaw));
        stack.m_85845_(Vector3f.f_122223_.m_122240_(pitch));
        stack.m_85841_(-1.0f, -1.0f, 1.0f);
        stack.m_85837_(0.0, -1.5, 0.0);
        RenderType type = RENDER_TYPE.get();
        CustomParticleRenderTypes.batchType(type);
        VertexConsumer consumer = Minecraft.m_91087_().m_91269_().m_110104_().m_6299_(type);
        float alpha = 0.9f - (float)this.f_107224_ * 7.0f / (float)this.f_107225_;
        BlockPos pos = new BlockPos(this.f_107212_, this.f_107213_, this.f_107214_);
        int block = this.f_107208_.m_45517_(LightLayer.BLOCK, pos);
        int light = this.f_107208_.m_45517_(LightLayer.SKY, pos);
        MODEL.get().renderAsParticle(stack, consumer, this.boneType, LightTexture.m_109885_((int)block, (int)light), OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, alpha);
    }

    private void irisFix(PoseStack stack, Camera renderInfo, float partialTicks) {
        if (!RuneCraftory.iris) {
            return;
        }
        stack.m_85845_(Vector3f.f_122223_.m_122240_(Mth.m_14179_((float)partialTicks, (float)this.cameraLastPitch, (float)renderInfo.m_90589_())));
        stack.m_85845_(Vector3f.f_122225_.m_122240_(Mth.m_14179_((float)partialTicks, (float)this.cameraLastYaw, (float)(renderInfo.m_90590_() - 180.0f))));
        this.cameraLastPitch = renderInfo.m_90589_();
        this.cameraLastYaw = renderInfo.m_90590_() - 180.0f;
    }

    public ParticleRenderType m_7556_() {
        return CustomParticleRenderTypes.ENTITY_MODEL_TYPE;
    }

    public record SkelefangParticleFactoryBase(SpriteSet sprite) implements ParticleProvider<SkelefangParticleData>
    {
        public Particle createParticle(SkelefangParticleData data, ClientLevel level, double x, double y, double z, double motionX, double motionY, double motionZ) {
            return new SkelefangParticle(level, x, y, z, motionX, motionY, motionZ, data);
        }
    }
}

