/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.client.particles;

import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Quaternion;
import com.mojang.math.Vector3f;
import io.github.flemmli97.runecraftory.common.particles.ColoredParticleData4f;
import io.github.flemmli97.tenshilib.client.particles.ParticleRenderTypes;
import io.github.flemmli97.tenshilib.common.particle.ColoredParticleData;
import io.github.flemmli97.tenshilib.common.utils.MathUtils;
import java.util.Random;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;

public class VortexParticle
extends TextureSheetParticle {
    public final SpriteSet spriteProvider;
    private final float[][] points;
    private final float angleInc;
    private final float radInc;
    private float currentRadius;
    private float currentAngle;
    private final float subOffset;
    private final boolean renderOpposite;

    public VortexParticle(ClientLevel world, double x, double y, double z, float radius, float radiusInc, float angleOffset, float angleInc, ColoredParticleData colorData, SpriteSet sprite, int maxAge, float minAgeRand, float maxAgeRand, boolean renderOpposite, int amount) {
        super(world, x, y, z);
        if (amount < 1) {
            amount = 1;
        }
        this.m_107253_(colorData.getRed(), colorData.getGreen(), colorData.getBlue());
        this.m_107271_(colorData.getAlpha());
        float mult = Mth.m_14068_((Random)world.f_46441_, (float)minAgeRand, (float)maxAgeRand);
        this.f_107225_ = (int)((float)maxAge * mult);
        this.spriteProvider = sprite;
        this.m_108339_(this.spriteProvider);
        this.f_107663_ *= colorData.getScale();
        this.angleInc = angleInc;
        this.currentAngle = this.angleInc + angleOffset;
        this.points = new float[amount][];
        this.subOffset = 360.0f / (float)(amount * (renderOpposite ? 2 : 1));
        for (int i = 0; i < this.points.length; ++i) {
            this.points[i] = MathUtils.rotate((float)0.0f, (float)0.0f, (float)1.0f, (float)radius, (float)radius, (float)0.0f, (float)MathUtils.degToRad((float)(this.currentAngle + this.subOffset * (float)i)));
        }
        this.currentRadius = radius;
        this.radInc = radiusInc;
        this.renderOpposite = renderOpposite;
    }

    public void m_5989_() {
        if (this.f_107224_++ >= this.f_107225_) {
            this.m_107274_();
        } else {
            this.m_108339_(this.spriteProvider);
            this.currentAngle += this.angleInc;
            this.currentRadius += this.radInc;
            for (int i = 0; i < this.points.length; ++i) {
                this.points[i] = MathUtils.rotate((float)0.0f, (float)0.0f, (float)1.0f, (float)this.currentRadius, (float)this.currentRadius, (float)0.0f, (float)MathUtils.degToRad((float)(this.currentAngle + this.subOffset * (float)i)));
            }
        }
    }

    public ParticleRenderType m_7556_() {
        return ParticleRenderTypes.TRANSLUCENTADD;
    }

    protected float m_5970_() {
        float u0 = super.m_5970_();
        float u1 = super.m_5952_();
        return u0 + (u1 - u0) * 0.125f;
    }

    protected float m_5952_() {
        float u0 = super.m_5970_();
        float u1 = super.m_5952_();
        return u1 - (u1 - u0) * 0.125f;
    }

    protected float m_5951_() {
        float v0 = super.m_5951_();
        float v1 = super.m_5950_();
        return v0 + (v1 - v0) * 0.125f;
    }

    protected float m_5950_() {
        float v0 = super.m_5951_();
        float v1 = super.m_5950_();
        return v1 - (v1 - v0) * 0.125f;
    }

    public void m_5744_(VertexConsumer buffer, Camera renderInfo, float partialTicks) {
        Quaternion quaternion;
        Vec3 vector3d = renderInfo.m_90583_();
        float f = (float)(Mth.m_14139_((double)partialTicks, (double)this.f_107209_, (double)this.f_107212_) - vector3d.m_7096_());
        float f1 = (float)(Mth.m_14139_((double)partialTicks, (double)this.f_107210_, (double)this.f_107213_) - vector3d.m_7098_());
        float f2 = (float)(Mth.m_14139_((double)partialTicks, (double)this.f_107211_, (double)this.f_107214_) - vector3d.m_7094_());
        if (this.f_107231_ == 0.0f) {
            quaternion = renderInfo.m_90591_();
        } else {
            quaternion = new Quaternion(renderInfo.m_90591_());
            float f3 = Mth.m_14179_((float)partialTicks, (float)this.f_107204_, (float)this.f_107231_);
            quaternion.m_80148_(Vector3f.f_122227_.m_122270_(f3));
        }
        float f4 = this.m_5902_(partialTicks);
        for (float[] floats : this.points) {
            Vector3f[] avector3f = new Vector3f[]{new Vector3f(-1.0f, -1.0f, 0.0f), new Vector3f(-1.0f, 1.0f, 0.0f), new Vector3f(1.0f, 1.0f, 0.0f), new Vector3f(1.0f, -1.0f, 0.0f)};
            Vector3f offset = new Vector3f(floats[0], floats[1], floats[2]);
            offset.m_122251_(quaternion);
            Vector3f[] opposite = new Vector3f[4];
            Vector3f offSetOpp = offset.m_122281_();
            offSetOpp.m_122261_(-1.0f);
            for (int i = 0; i < 4; ++i) {
                Vector3f vector3f = avector3f[i];
                vector3f.m_122251_(quaternion);
                vector3f.m_122261_(f4);
                vector3f.m_122272_(f, f1, f2);
                opposite[i] = vector3f.m_122281_();
                vector3f.m_122253_(offset);
                opposite[i].m_122253_(offSetOpp);
            }
            float f7 = this.m_5970_();
            float f8 = this.m_5952_();
            float f5 = this.m_5951_();
            float f6 = this.m_5950_();
            int j = 0x500050;
            buffer.m_5483_((double)avector3f[0].m_122239_(), (double)avector3f[0].m_122260_(), (double)avector3f[0].m_122269_()).m_7421_(f8, f6).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, this.f_107230_).m_85969_(j).m_5752_();
            buffer.m_5483_((double)avector3f[1].m_122239_(), (double)avector3f[1].m_122260_(), (double)avector3f[1].m_122269_()).m_7421_(f8, f5).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, this.f_107230_).m_85969_(j).m_5752_();
            buffer.m_5483_((double)avector3f[2].m_122239_(), (double)avector3f[2].m_122260_(), (double)avector3f[2].m_122269_()).m_7421_(f7, f5).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, this.f_107230_).m_85969_(j).m_5752_();
            buffer.m_5483_((double)avector3f[3].m_122239_(), (double)avector3f[3].m_122260_(), (double)avector3f[3].m_122269_()).m_7421_(f7, f6).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, this.f_107230_).m_85969_(j).m_5752_();
            if (!this.renderOpposite) continue;
            buffer.m_5483_((double)opposite[0].m_122239_(), (double)opposite[0].m_122260_(), (double)opposite[0].m_122269_()).m_7421_(f8, f6).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, this.f_107230_).m_85969_(j).m_5752_();
            buffer.m_5483_((double)opposite[1].m_122239_(), (double)opposite[1].m_122260_(), (double)opposite[1].m_122269_()).m_7421_(f8, f5).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, this.f_107230_).m_85969_(j).m_5752_();
            buffer.m_5483_((double)opposite[2].m_122239_(), (double)opposite[2].m_122260_(), (double)opposite[2].m_122269_()).m_7421_(f7, f5).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, this.f_107230_).m_85969_(j).m_5752_();
            buffer.m_5483_((double)opposite[3].m_122239_(), (double)opposite[3].m_122260_(), (double)opposite[3].m_122269_()).m_7421_(f7, f6).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, this.f_107230_).m_85969_(j).m_5752_();
        }
    }

    public float m_5902_(float partialTicks) {
        return this.f_107663_ * Mth.m_14031_((float)(((float)this.f_107224_ + partialTicks) * (float)(Math.PI / (double)this.f_107225_ * 2.0)));
    }

    public record VortexFactoryBase(SpriteSet sprite) implements ParticleProvider<ColoredParticleData4f>
    {
        public Particle createParticle(ColoredParticleData4f data, ClientLevel level, double x, double y, double z, double motX, double motY, double motZ) {
            return new VortexParticle(level, x, y, z, data.getRadius(), data.getSpeed(), data.getOffset(), data.getAngleIncrease(), data, this.sprite, 40, 0.9f, 1.1f, true, 4);
        }
    }
}

