/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Matrix4f;
import com.mojang.math.Vector3f;
import io.github.flemmli97.runecraftory.api.enums.EnumElement;
import io.github.flemmli97.runecraftory.client.ClientHandlers;
import io.github.flemmli97.runecraftory.client.model.ModelGate;
import io.github.flemmli97.runecraftory.client.render.RunecraftoryShaders;
import io.github.flemmli97.runecraftory.client.render.VertexHelper;
import io.github.flemmli97.runecraftory.common.entities.GateEntity;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;

public class RenderGate
extends LivingEntityRenderer<GateEntity, ModelGate> {
    private static final float[][] NONE = new float[][]{{0.31f, 0.47f, 0.298f}, {0.414f, 0.083f, 0.495f}};
    private static final float[][] FIRE = new float[][]{{0.98f, 0.038f, 0.019f}, {0.97f, 0.613f, 0.12f}};
    private static final float[][] WATER = new float[][]{{0.0f, 0.15f, 0.57f}, {0.54f, 0.924f, 0.97f}};
    private static final float[][] EARTH = new float[][]{{0.45f, 0.316f, 0.094f}, {0.689f, 0.775f, 0.149f}};
    private static final float[][] WIND = new float[][]{{0.161f, 0.715f, 0.052f}, {0.533f, 0.88f, 0.305f}};
    private static final float[][] LIGHT = new float[][]{{0.48f, 0.428f, 0.024f}, {0.606f, 0.88f, 0.728f}};
    private static final float[][] DARK = new float[][]{{0.075f, 0.042f, 0.325f}, {0.405f, 0.064f, 0.328f}};
    private static final float[][] LOVE = new float[][]{{0.295f, 0.155f, 0.258f}, {0.92f, 0.846f, 0.723f}};

    public RenderGate(EntityRendererProvider.Context ctx) {
        super(ctx, (EntityModel)new ModelGate(ctx.m_174023_(ModelGate.LAYER_LOCATION)), 0.0f);
        ClientHandlers.initNonRendererModels(ctx);
    }

    public void render(GateEntity entity, float entityYaw, float partialTicks, PoseStack stack, MultiBufferSource bufferIn, int packedLightIn) {
        stack.m_85836_();
        float scale = 1.2f + Mth.m_14031_((float)((float)entity.f_19797_ * 0.1f)) * 0.04f;
        stack.m_85841_(scale, scale, scale);
        stack.m_85837_(0.0, (double)entity.m_20206_() * 0.5 - 0.1, 0.0);
        stack.m_85845_(this.f_114476_.m_114470_());
        stack.m_85845_(Vector3f.f_122225_.m_122240_(180.0f));
        stack.m_85845_(Vector3f.f_122227_.m_122240_((float)entity.clientRenderTick * 0.1f));
        float xSize = 0.75f;
        float ySize = 0.75f;
        Matrix4f matrix4f = stack.m_85850_().m_85861_();
        float[][] colors = this.getColor(entity);
        VertexConsumer builder = bufferIn.m_6299_(RunecraftoryShaders.GATE_RENDER);
        VertexHelper.time(builder.m_85982_(matrix4f, -xSize, -ySize, 0.0f).m_85950_(colors[0][0], colors[0][1], colors[0][2], 1.0f).m_85950_(colors[1][0], colors[1][1], colors[1][2], 1.0f).m_7421_(0.0f, 1.0f).m_86008_(RenderGate.m_115338_((LivingEntity)entity, (float)this.m_6931_((LivingEntity)entity, partialTicks))), entity.f_19797_, partialTicks).m_5752_();
        VertexHelper.time(builder.m_85982_(matrix4f, xSize, -ySize, 0.0f).m_85950_(colors[0][0], colors[0][1], colors[0][2], 1.0f).m_85950_(colors[1][0], colors[1][1], colors[1][2], 1.0f).m_7421_(1.0f, 1.0f).m_86008_(RenderGate.m_115338_((LivingEntity)entity, (float)this.m_6931_((LivingEntity)entity, partialTicks))), entity.f_19797_, partialTicks).m_5752_();
        VertexHelper.time(builder.m_85982_(matrix4f, xSize, ySize, 0.0f).m_85950_(colors[0][0], colors[0][1], colors[0][2], 1.0f).m_85950_(colors[1][0], colors[1][1], colors[1][2], 1.0f).m_7421_(1.0f, 0.0f).m_86008_(RenderGate.m_115338_((LivingEntity)entity, (float)this.m_6931_((LivingEntity)entity, partialTicks))), entity.f_19797_, partialTicks).m_5752_();
        VertexHelper.time(builder.m_85982_(matrix4f, -xSize, ySize, 0.0f).m_85950_(colors[0][0], colors[0][1], colors[0][2], 1.0f).m_85950_(colors[1][0], colors[1][1], colors[1][2], 1.0f).m_7421_(0.0f, 0.0f).m_86008_(RenderGate.m_115338_((LivingEntity)entity, (float)this.m_6931_((LivingEntity)entity, partialTicks))), entity.f_19797_, partialTicks).m_5752_();
        stack.m_85849_();
    }

    protected float getFlipDegrees(GateEntity entityLivingBaseIn) {
        return 0.0f;
    }

    protected boolean shouldShowName(GateEntity entity) {
        return false;
    }

    protected int getBlockLightLevel(GateEntity entityIn, BlockPos pos) {
        return 15;
    }

    public ResourceLocation getTextureLocation(GateEntity entity) {
        return null;
    }

    private float[][] getColor(GateEntity entity) {
        return switch (entity.getElement()) {
            default -> throw new IncompatibleClassChangeError();
            case EnumElement.NONE -> NONE;
            case EnumElement.WATER -> WATER;
            case EnumElement.EARTH -> EARTH;
            case EnumElement.WIND -> WIND;
            case EnumElement.FIRE -> FIRE;
            case EnumElement.LIGHT -> LIGHT;
            case EnumElement.DARK -> DARK;
            case EnumElement.LOVE -> LOVE;
        };
    }
}

