/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Vector3f;
import io.github.flemmli97.runecraftory.common.entities.BaseMonster;
import io.github.flemmli97.tenshilib.client.render.RiderLayerRenderer;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;

public class RenderMonster<T extends BaseMonster, M extends EntityModel<T>>
extends MobRenderer<T, M> {
    private final ResourceLocation tex;

    public RenderMonster(EntityRendererProvider.Context ctx, M model, ResourceLocation texture, float shadow) {
        this(ctx, model, texture, shadow, true);
    }

    public RenderMonster(EntityRendererProvider.Context ctx, M model, ResourceLocation texture, float shadow, boolean withDefaultRiderLayer) {
        super(ctx, model, shadow);
        this.tex = texture;
        if (withDefaultRiderLayer) {
            this.f_115291_.add(new RiderLayerRenderer((LivingEntityRenderer)this));
        }
    }

    public ResourceLocation getTextureLocation(T entity) {
        return this.tex;
    }

    protected void setupRotations(T entity, PoseStack stack, float ageInTicks, float rotationYaw, float partialTicks) {
        super.m_7523_(entity, stack, ageInTicks, rotationYaw, partialTicks);
        if (((BaseMonster)entity).getPlayDeathTick() > 0 && ((BaseMonster)entity).getDeathAnimation() == null) {
            float f;
            float f2 = ((float)((BaseMonster)entity).getPlayDeathTick() + (((BaseMonster)entity).playDeath() ? partialTicks : -partialTicks)) / 20.0f * 1.6f;
            f2 = Mth.m_14116_((float)f2);
            if (f > 1.0f) {
                f2 = 1.0f;
            }
            stack.m_85837_(0.0, (double)f2 * 0.1, (double)(-f2 * entity.m_20206_()) * 0.5);
            stack.m_85845_(Vector3f.f_122223_.m_122240_(f2 * this.getFlipDegrees(entity)));
        }
    }

    public boolean shouldRender(T entity, Frustum camera, double camX, double camY, double camZ) {
        if (((BaseMonster)entity).getPlayDeathTick() > 0 && !((BaseMonster)entity).playDeath()) {
            if (((BaseMonster)entity).getPlayDeathTick() > 8 && ((BaseMonster)entity).getPlayDeathTick() % 2 == 0) {
                return false;
            }
            if (((BaseMonster)entity).getPlayDeathTick() % 3 == 0) {
                return false;
            }
        }
        return super.m_5523_(entity, camera, camX, camY, camZ);
    }

    protected float getFlipDegrees(T entity) {
        return ((BaseMonster)entity).getDeathAnimation() != null ? 0.0f : super.m_6441_(entity);
    }
}

