/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Vector3f;
import io.github.flemmli97.runecraftory.client.model.misc.ModelChest;
import io.github.flemmli97.runecraftory.common.entities.misc.EntityTreasureChest;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;

public class RenderTreasureChest
extends EntityRenderer<EntityTreasureChest> {
    protected static final ResourceLocation COMMON = new ResourceLocation("runecraftory", "textures/entity/chest.png");
    protected static final ResourceLocation RARE = new ResourceLocation("runecraftory", "textures/entity/rare_chest.png");
    protected static final ResourceLocation QUEST = new ResourceLocation("runecraftory", "textures/entity/quest_chest.png");
    protected final EntityModel<EntityTreasureChest> model;

    public RenderTreasureChest(EntityRendererProvider.Context ctx) {
        super(ctx);
        this.f_114477_ = 0.6f;
        this.model = new ModelChest<EntityTreasureChest>(ctx.m_174023_(ModelChest.LAYER_LOCATION));
    }

    public void render(EntityTreasureChest entity, float rotation, float partialTicks, PoseStack stack, MultiBufferSource buffer, int packedLight) {
        stack.m_85836_();
        float yaw = Mth.m_14179_((float)partialTicks, (float)entity.f_19859_, (float)entity.m_146908_());
        float pitch = Mth.m_14179_((float)partialTicks, (float)entity.f_19860_, (float)entity.m_146909_());
        float partialLivingTicks = (float)entity.f_19797_ + partialTicks;
        this.translate(entity, stack, pitch, yaw, partialTicks);
        stack.m_85841_(-1.0f, -1.0f, 1.0f);
        stack.m_85837_(0.0, (double)-1.501f, 0.0);
        this.model.m_6839_((Entity)entity, 0.0f, 0.0f, partialTicks);
        this.model.m_6973_((Entity)entity, 0.0f, 0.0f, partialLivingTicks, yaw, pitch);
        VertexConsumer ivertexbuilder = buffer.m_6299_(this.model.m_103119_(this.getTextureLocation(entity)));
        this.model.m_7695_(stack, ivertexbuilder, packedLight, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        stack.m_85849_();
        super.m_7392_((Entity)entity, rotation, partialTicks, stack, buffer, packedLight);
    }

    public ResourceLocation getTextureLocation(EntityTreasureChest entity) {
        int tier = entity.tier();
        if (tier == 2 || tier == 3) {
            return RARE;
        }
        if (tier == 4) {
            return QUEST;
        }
        return COMMON;
    }

    public void translate(EntityTreasureChest entity, PoseStack stack, float pitch, float yaw, float partialTicks) {
        stack.m_85845_(Vector3f.f_122225_.m_122240_(180.0f + yaw));
        stack.m_85845_(Vector3f.f_122223_.m_122240_(pitch));
    }
}

