/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.client.render.monster;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Vector3f;
import io.github.flemmli97.runecraftory.client.model.monster.ModelRaccoon;
import io.github.flemmli97.runecraftory.client.model.monster.ModelRaccoonBase;
import io.github.flemmli97.runecraftory.client.model.monster.ModelRaccoonBerserk;
import io.github.flemmli97.runecraftory.client.render.RenderMonster;
import io.github.flemmli97.runecraftory.client.render.layer.RiderLayerRendererExt;
import io.github.flemmli97.runecraftory.common.entities.monster.boss.EntityRaccoon;
import io.github.flemmli97.tenshilib.api.entity.AnimatedAction;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;

public class RenderRaccoon<T extends EntityRaccoon>
extends RenderMonster<T, ModelRaccoonBase<T>> {
    private static final ResourceLocation BERSERK_TEXTURE = new ResourceLocation("runecraftory", "textures/entity/monsters/raccoon_berserk.png");
    public static final float BERSERK_SCALE = 1.4f;
    private final ModelRaccoonBase<T> normalModel;
    private final ModelRaccoonBase<T> berserkModel;
    private boolean clone;

    public RenderRaccoon(EntityRendererProvider.Context ctx) {
        super(ctx, new ModelRaccoon(ctx.m_174023_(ModelRaccoon.LAYER_LOCATION)), new ResourceLocation("runecraftory", "textures/entity/monsters/raccoon.png"), 0.5f, false);
        this.normalModel = (ModelRaccoonBase)this.f_115290_;
        this.berserkModel = new ModelRaccoonBerserk(ctx.m_174023_(ModelRaccoonBerserk.LAYER_LOCATION));
        this.f_115291_.add(new RiderLayerRendererExt(this, (stack, entity) -> {
            if (entity.isBerserk()) {
                stack.m_85841_(0.71428573f, 0.71428573f, 0.71428573f);
            }
        }));
    }

    @Override
    public ResourceLocation getTextureLocation(T entity) {
        return this.f_115290_ == this.berserkModel ? BERSERK_TEXTURE : super.getTextureLocation(entity);
    }

    public void render(T entity, float entityYaw, float partialTicks, PoseStack stack, MultiBufferSource buffer, int packedLight) {
        this.f_114477_ = ((EntityRaccoon)entity).isBerserk() ? 1.2f : 0.5f;
        AnimatedAction anim = ((EntityRaccoon)entity).getAnimationHandler().getAnimation();
        if (anim != null && (anim.is(new AnimatedAction[]{EntityRaccoon.TRANSFORM}) || anim.is(new AnimatedAction[]{EntityRaccoon.UNTRANSFORM}))) {
            int tick = (int)anim.getTick(1.0f);
            if (tick < 10) {
                this.f_115290_ = tick % 3 == 0 ? this.berserkModel : this.normalModel;
            } else if (tick < 20) {
                this.f_115290_ = tick % 4 <= 1 ? this.berserkModel : this.normalModel;
            } else if (tick < 30) {
                ModelRaccoonBase<T> modelRaccoonBase = this.f_115290_ = tick % 5 <= 3 ? this.berserkModel : this.normalModel;
            }
            if (anim.is(new AnimatedAction[]{EntityRaccoon.UNTRANSFORM})) {
                this.f_115290_ = this.f_115290_ == this.berserkModel || tick > 30 ? this.normalModel : this.berserkModel;
            }
        } else {
            ModelRaccoonBase<T> modelRaccoonBase = this.f_115290_ = ((EntityRaccoon)entity).isBerserk() ? this.berserkModel : this.normalModel;
        }
        if (!this.clone && EntityRaccoon.CLONE.is(new AnimatedAction[]{anim}) && ((EntityRaccoon)entity).cloneCenter().isPresent()) {
            Vec3 center = ((EntityRaccoon)entity).cloneCenter().get();
            double dx = Mth.m_14139_((double)partialTicks, (double)entity.m_20185_(), (double)((EntityRaccoon)entity).f_19790_) - center.m_7096_();
            double dy = Mth.m_14139_((double)partialTicks, (double)entity.m_20186_(), (double)((EntityRaccoon)entity).f_19791_) - center.m_7098_();
            double dz = Mth.m_14139_((double)partialTicks, (double)entity.m_20189_(), (double)((EntityRaccoon)entity).f_19792_) - center.m_7094_();
            stack.m_85836_();
            stack.m_85837_(-dx, -dy, -dz);
            float tick = Mth.m_14179_((float)partialTicks, (float)((EntityRaccoon)entity).f_19797_, (float)(((EntityRaccoon)entity).f_19797_ + 1));
            this.clone = true;
            for (int i = 0; i < EntityRaccoon.CLONE_POS.length; ++i) {
                Vec3 vec3 = EntityRaccoon.CLONE_POS[i];
                if ((tick + (float)(i * 2)) % 8.0f <= 4.0f) continue;
                stack.m_85836_();
                stack.m_85837_(vec3.m_7096_(), vec3.m_7098_(), vec3.m_7094_());
                int rotAmount = i - ((EntityRaccoon)entity).cloneIndex();
                stack.m_85845_(Vector3f.f_122225_.m_122240_((float)(-rotAmount * 90)));
                Minecraft.m_91087_().m_91290_().m_114384_(entity, 0.0, 0.0, 0.0, entityYaw, partialTicks, stack, buffer, packedLight);
                stack.m_85849_();
            }
            this.clone = false;
            stack.m_85849_();
        } else {
            super.m_7392_(entity, entityYaw, partialTicks, stack, buffer, packedLight);
        }
    }

    protected void scale(T entity, PoseStack stack, float partialTick) {
        super.m_7546_(entity, stack, partialTick);
        if (((EntityRaccoon)entity).isBerserk()) {
            stack.m_85841_(1.4f, 1.4f, 1.4f);
        }
    }
}

