/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.client.render.projectiles;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Vector3f;
import io.github.flemmli97.runecraftory.api.enums.EnumElement;
import io.github.flemmli97.runecraftory.client.render.AnimatedTexture;
import io.github.flemmli97.runecraftory.common.entities.misc.EntityElementalBall;
import io.github.flemmli97.tenshilib.client.render.RenderUtils;
import java.util.Objects;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;

public class RenderElementBall
extends EntityRenderer<EntityElementalBall> {
    private static final ResourceLocation FIRE = new ResourceLocation("runecraftory", "textures/entity/projectile/fireball_n.png");
    private static final ResourceLocation WATER = new ResourceLocation("runecraftory", "textures/entity/projectile/bubble.png");
    private static final ResourceLocation WATER_2 = new ResourceLocation("runecraftory", "textures/entity/projectile/ice_ball.png");
    private static final ResourceLocation EARTH = new ResourceLocation("runecraftory", "textures/entity/projectile/earth_ball.png");
    private static final ResourceLocation LOVE = new ResourceLocation("runecraftory", "textures/entity/projectile/love_ball.png");
    private static final ResourceLocation WIND = new ResourceLocation("runecraftory", "textures/entity/projectile/wind_blade.png");
    private static final ResourceLocation BLOB = new ResourceLocation("runecraftory", "textures/particle/light.png");
    public final float xSize = 1.0f;
    public final float ySize = 1.0f;
    protected final RenderUtils.TextureBuilder textureBuilder = new RenderUtils.TextureBuilder();
    protected final AnimatedTexture fireTexAnim = new AnimatedTexture(6, 1);
    protected final AnimatedTexture windTexAnim = new AnimatedTexture(8, 1);

    public RenderElementBall(EntityRendererProvider.Context ctx) {
        super(ctx);
    }

    public void render(EntityElementalBall entity, float rotation, float partialTicks, PoseStack stack, MultiBufferSource buffer, int packedLight) {
        stack.m_85845_(this.f_114476_.m_114470_());
        stack.m_85845_(Vector3f.f_122225_.m_122240_(180.0f));
        AnimatedTexture text = null;
        switch (entity.getElement()) {
            case FIRE: {
                text = this.fireTexAnim;
                break;
            }
            case WIND: {
                text = this.windTexAnim;
                break;
            }
            case DARK: {
                this.textureBuilder.setColor(-10676317);
                break;
            }
            case LIGHT: {
                this.textureBuilder.setColor(-723064);
            }
        }
        if (text != null) {
            float[] uvOffset = text.uvOffset((int)((double)(entity.f_19797_ + entity.m_142049_()) * 0.5));
            this.textureBuilder.setUV(uvOffset[0], uvOffset[1]);
            this.textureBuilder.setUVLength(text.uLength, text.vLength);
        } else {
            this.textureBuilder.setUV(0.0f, 0.0f);
            this.textureBuilder.setUVLength(1.0f, 1.0f);
        }
        this.textureBuilder.setLight(packedLight);
        VertexConsumer vertexConsumer = buffer.m_6299_(this.getRenderType(entity, this.getTextureLocation(entity)));
        Objects.requireNonNull(this);
        Objects.requireNonNull(this);
        RenderUtils.renderTexture((PoseStack)stack, (VertexConsumer)vertexConsumer, (float)1.0f, (float)1.0f, (RenderUtils.TextureBuilder)this.textureBuilder);
        super.m_7392_((Entity)entity, rotation, partialTicks, stack, buffer, packedLight);
    }

    public ResourceLocation getTextureLocation(EntityElementalBall entity) {
        return switch (entity.getElement()) {
            case EnumElement.WATER -> {
                if (entity.getVariant() == 1) {
                    yield WATER_2;
                }
                yield WATER;
            }
            case EnumElement.LOVE -> LOVE;
            case EnumElement.EARTH -> EARTH;
            case EnumElement.WIND -> WIND;
            case EnumElement.DARK, EnumElement.LIGHT -> BLOB;
            default -> FIRE;
        };
    }

    protected RenderType getRenderType(EntityElementalBall entity, ResourceLocation loc) {
        if (entity.getElement() == EnumElement.DARK || entity.getElement() == EnumElement.LIGHT) {
            return RenderType.m_110473_((ResourceLocation)loc);
        }
        return RenderType.m_110458_((ResourceLocation)loc);
    }
}

