/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.client.render.projectiles;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Matrix3f;
import com.mojang.math.Matrix4f;
import com.mojang.math.Vector3f;
import io.github.flemmli97.runecraftory.client.model.misc.ModelEnergyOrb;
import io.github.flemmli97.runecraftory.client.render.layer.EnergyOrbSwirlLayer;
import io.github.flemmli97.runecraftory.common.entities.misc.EntityHomingEnergyOrb;
import io.github.flemmli97.tenshilib.client.render.RenderProjectileModel;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;

public class RenderEnergyOrb
extends RenderProjectileModel<EntityHomingEnergyOrb>
implements RenderLayerParent<EntityHomingEnergyOrb, EntityModel<EntityHomingEnergyOrb>> {
    public static final ResourceLocation TEXTURE = new ResourceLocation("runecraftory", "textures/entity/projectile/energy_orb.png");
    private static final RenderType BEAM_RENDER_TYPE = RenderType.m_110458_((ResourceLocation)new ResourceLocation("textures/entity/guardian_beam.png"));
    private final EnergyOrbSwirlLayer layer;

    public RenderEnergyOrb(EntityRendererProvider.Context ctx) {
        super(ctx, new ModelEnergyOrb(ctx.m_174023_(ModelEnergyOrb.LAYER_LOCATION)));
        this.layer = new EnergyOrbSwirlLayer(this, ctx.m_174027_());
        this.alpha = 0.8f;
    }

    public void render(EntityHomingEnergyOrb entity, float rotation, float partialTicks, PoseStack stack, MultiBufferSource buffer, int packedLight) {
        stack.m_85836_();
        super.m_7392_((Entity)entity, rotation, partialTicks, stack, buffer, packedLight);
        stack.m_85849_();
        Vec3 start = entity.rootPosition(partialTicks);
        if (start == null) {
            return;
        }
        Vec3 vec32 = this.getPositionLerped((Entity)entity, partialTicks);
        Vec3 dir = start.m_82546_(vec32);
        float len = (float)(dir.m_82553_() + 1.0);
        dir = dir.m_82541_();
        float beamPitch = (float)Math.acos(dir.f_82480_);
        float beamYaw = (float)Math.atan2(dir.f_82481_, dir.f_82479_);
        stack.m_85836_();
        stack.m_85837_(0.0, (double)entity.m_20206_() * 0.5, 0.0);
        stack.m_85845_(Vector3f.f_122225_.m_122240_(90.0f - beamYaw * 57.295776f));
        stack.m_85845_(Vector3f.f_122223_.m_122240_(beamPitch * 57.295776f));
        float colorScale = Mth.m_14031_((float)entity.f_19797_) * 0.5f + 0.5f;
        int red = 66 + (int)(colorScale * 100.0f);
        int green = 154 + (int)(colorScale * 56.0f);
        int blue = 207 - (int)(colorScale * 30.0f);
        float tick = (float)entity.f_19797_ + partialTicks;
        float h = tick * 0.5f % 1.0f;
        float n = tick * 0.05f * -1.5f;
        float u = Mth.m_14089_((float)(n + 2.3561945f)) * 0.282f;
        float v = Mth.m_14031_((float)(n + 2.3561945f)) * 0.282f;
        float w = Mth.m_14089_((float)(n + 0.7853982f)) * 0.282f;
        float x = Mth.m_14031_((float)(n + 0.7853982f)) * 0.282f;
        float y = Mth.m_14089_((float)(n + 3.926991f)) * 0.282f;
        float z = Mth.m_14031_((float)(n + 3.926991f)) * 0.282f;
        float aa = Mth.m_14089_((float)(n + 5.4977875f)) * 0.282f;
        float ab = Mth.m_14031_((float)(n + 5.4977875f)) * 0.282f;
        float ac = Mth.m_14089_((float)(n + (float)Math.PI)) * 0.2f;
        float ad = Mth.m_14031_((float)(n + (float)Math.PI)) * 0.2f;
        float ae = Mth.m_14089_((float)(n + 0.0f)) * 0.2f;
        float af = Mth.m_14031_((float)(n + 0.0f)) * 0.2f;
        float ag = Mth.m_14089_((float)(n + 1.5707964f)) * 0.2f;
        float ah = Mth.m_14031_((float)(n + 1.5707964f)) * 0.2f;
        float ai = Mth.m_14089_((float)(n + 4.712389f)) * 0.2f;
        float aj = Mth.m_14031_((float)(n + 4.712389f)) * 0.2f;
        float an = -1.0f + h;
        float ao = len * 2.5f + an;
        VertexConsumer vertexConsumer = buffer.m_6299_(BEAM_RENDER_TYPE);
        PoseStack.Pose pose = stack.m_85850_();
        Matrix4f matrix4f = pose.m_85861_();
        Matrix3f matrix3f = pose.m_85864_();
        RenderEnergyOrb.vertex(vertexConsumer, matrix4f, matrix3f, ac, len, ad, red, green, blue, 0.4999f, ao);
        RenderEnergyOrb.vertex(vertexConsumer, matrix4f, matrix3f, ac, 0.0f, ad, red, green, blue, 0.4999f, an);
        RenderEnergyOrb.vertex(vertexConsumer, matrix4f, matrix3f, ae, 0.0f, af, red, green, blue, 0.0f, an);
        RenderEnergyOrb.vertex(vertexConsumer, matrix4f, matrix3f, ae, len, af, red, green, blue, 0.0f, ao);
        RenderEnergyOrb.vertex(vertexConsumer, matrix4f, matrix3f, ag, len, ah, red, green, blue, 0.4999f, ao);
        RenderEnergyOrb.vertex(vertexConsumer, matrix4f, matrix3f, ag, 0.0f, ah, red, green, blue, 0.4999f, an);
        RenderEnergyOrb.vertex(vertexConsumer, matrix4f, matrix3f, ai, 0.0f, aj, red, green, blue, 0.0f, an);
        RenderEnergyOrb.vertex(vertexConsumer, matrix4f, matrix3f, ai, len, aj, red, green, blue, 0.0f, ao);
        float ap = 0.0f;
        if (entity.f_19797_ % 2 == 0) {
            ap = 0.5f;
        }
        RenderEnergyOrb.vertex(vertexConsumer, matrix4f, matrix3f, u, len, v, red, green, blue, 0.5f, ap + 0.5f);
        RenderEnergyOrb.vertex(vertexConsumer, matrix4f, matrix3f, w, len, x, red, green, blue, 1.0f, ap + 0.5f);
        RenderEnergyOrb.vertex(vertexConsumer, matrix4f, matrix3f, aa, len, ab, red, green, blue, 1.0f, ap);
        RenderEnergyOrb.vertex(vertexConsumer, matrix4f, matrix3f, y, len, z, red, green, blue, 0.5f, ap);
        stack.m_85849_();
    }

    private Vec3 getPositionLerped(Entity livingEntity, float partialTick) {
        double x = Mth.m_14139_((double)partialTick, (double)livingEntity.f_19790_, (double)livingEntity.m_20185_());
        double y = Mth.m_14139_((double)partialTick, (double)livingEntity.f_19791_, (double)livingEntity.m_20186_()) + (double)livingEntity.m_20206_() * 0.5;
        double z = Mth.m_14139_((double)partialTick, (double)livingEntity.f_19792_, (double)livingEntity.m_20189_());
        return new Vec3(x, y, z);
    }

    public void translate(EntityHomingEnergyOrb entity, PoseStack stack, float pitch, float yaw, float partialTicks) {
        super.translate((Entity)entity, stack, 0.0f, 0.0f, partialTicks);
        stack.m_85837_(0.0, 0.0625, 0.0);
    }

    public void afterModelRender(EntityHomingEnergyOrb entity, float rotation, float partialTicks, PoseStack stack, MultiBufferSource buffer, int packedLight) {
        float yaw = Mth.m_14179_((float)partialTicks, (float)entity.f_19859_, (float)entity.m_146908_()) + this.yawOffset();
        float pitch = Mth.m_14179_((float)partialTicks, (float)entity.f_19860_, (float)entity.m_146909_()) + this.pitchOffset();
        this.layer.m_6494_(stack, buffer, packedLight, (Entity)entity, 0.0f, 0.0f, partialTicks, entity.f_19797_, yaw, pitch);
    }

    private static void vertex(VertexConsumer vertexConsumer, Matrix4f matrix4f, Matrix3f matrix3f, float x, float y, float z, int r, int g, int b, float u, float v) {
        vertexConsumer.m_85982_(matrix4f, x, y, z).m_6122_(r, g, b, 200).m_7421_(u, v).m_86008_(OverlayTexture.f_118083_).m_85969_(0xF000F0).m_85977_(matrix3f, 0.0f, 1.0f, 0.0f).m_5752_();
    }

    public EntityModel<EntityHomingEnergyOrb> m_7200_() {
        return this.model;
    }

    public ResourceLocation getTextureLocation(EntityHomingEnergyOrb entity) {
        return TEXTURE;
    }
}

