/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.client.render.projectiles;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Vector3f;
import io.github.flemmli97.runecraftory.common.entities.misc.EntityFurniture;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;

public class RenderFurnitures
extends EntityRenderer<EntityFurniture> {
    public static final ModelLayerLocation LOC_CHAIR = new ModelLayerLocation(new ResourceLocation("runecraftory", "chair"), "main");
    public static final ModelLayerLocation LOC_CHIPSQUEEK_PLUSH = new ModelLayerLocation(new ResourceLocation("runecraftory", "chipsqueek_plush"), "main");
    public static final ModelLayerLocation LOC_WOOLY_PLUSH = new ModelLayerLocation(new ResourceLocation("runecraftory", "wooly_plush"), "main");
    private static final ResourceLocation TEX_CHAIR = new ResourceLocation("runecraftory", "textures/entity/projectile/chair.png");
    private static final ResourceLocation TEX_WOOLY = new ResourceLocation("runecraftory", "textures/entity/projectile/wooly_plush.png");
    private static final ResourceLocation TEX_CHIPSQUEEK = new ResourceLocation("runecraftory", "textures/entity/projectile/chipsqueek_plush.png");
    private final BlockState barrel = Blocks.f_50618_.m_49966_();
    private final BlockState anvil = Blocks.f_50322_.m_49966_();
    private final ModelPart chestLid;
    private final ModelPart chestBottom;
    private final ModelPart chestLock;
    private final ModelPart chair;
    private final ModelPart woolyPlush;
    private final ModelPart chipSqueekPlush;

    public RenderFurnitures(EntityRendererProvider.Context ctx) {
        super(ctx);
        ModelPart modelPart = ctx.m_174023_(ModelLayers.f_171275_);
        this.chestLid = modelPart.m_171324_("bottom");
        this.chestBottom = modelPart.m_171324_("lid");
        this.chestLock = modelPart.m_171324_("lock");
        this.chair = ctx.m_174023_(LOC_CHAIR);
        this.woolyPlush = ctx.m_174023_(LOC_WOOLY_PLUSH);
        this.chipSqueekPlush = ctx.m_174023_(LOC_CHIPSQUEEK_PLUSH);
    }

    public static LayerDefinition chairLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition bone = partdefinition.m_171599_("bone", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-6.0f, -3.1667f, -6.8333f, 12.0f, 2.0f, 12.0f, new CubeDeformation(0.0f)).m_171514_(16, 28).m_171488_(3.0f, -1.1667f, -5.8333f, 2.0f, 8.0f, 2.0f, new CubeDeformation(0.0f)).m_171514_(8, 28).m_171488_(-5.0f, -1.1667f, -5.8333f, 2.0f, 8.0f, 2.0f, new CubeDeformation(0.0f)).m_171514_(0, 28).m_171488_(3.0f, -1.1667f, 2.1667f, 2.0f, 8.0f, 2.0f, new CubeDeformation(0.0f)).m_171514_(28, 14).m_171488_(-5.0f, -1.1667f, 2.1667f, 2.0f, 8.0f, 2.0f, new CubeDeformation(0.0f)).m_171514_(0, 14).m_171488_(-6.0f, -15.1667f, 3.1667f, 12.0f, 12.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)17.1667f, (float)0.8333f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public static LayerDefinition chipSqueekPlushLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition bone = partdefinition.m_171599_("bone", CubeListBuilder.m_171558_().m_171514_(0, 10).m_171488_(-2.0f, -5.0f, -2.0f, 4.0f, 5.0f, 4.0f, new CubeDeformation(0.0f)).m_171514_(18, 19).m_171488_(-2.0f, -4.0f, -4.0f, 1.0f, 1.0f, 2.0f, new CubeDeformation(0.0f)).m_171514_(12, 19).m_171488_(1.0f, -4.0f, -4.0f, 1.0f, 1.0f, 2.0f, new CubeDeformation(0.0f)).m_171514_(6, 19).m_171488_(1.0f, -1.0f, -4.0f, 1.0f, 1.0f, 2.0f, new CubeDeformation(0.0f)).m_171514_(0, 19).m_171488_(-2.0f, -1.0f, -4.0f, 1.0f, 1.0f, 2.0f, new CubeDeformation(0.0f)).m_171514_(0, 0).m_171488_(-2.5f, -10.0f, -2.5f, 5.0f, 5.0f, 5.0f, new CubeDeformation(0.0f)).m_171514_(4, 22).m_171488_(-2.0f, -11.0f, 0.0f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(0, 22).m_171488_(1.0f, -11.0f, 0.0f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition bone2 = bone.m_171599_("bone2", CubeListBuilder.m_171558_().m_171514_(16, 10).m_171488_(-1.0f, -2.0f, 0.0f, 2.0f, 2.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)2.0f, (float)0.6545f, (float)0.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)32, (int)32);
    }

    public static LayerDefinition woolyPlushLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition bone = partdefinition.m_171599_("bone", CubeListBuilder.m_171558_().m_171514_(0, 10).m_171488_(-2.0f, -5.0f, -2.0f, 4.0f, 5.0f, 4.0f, new CubeDeformation(0.0f)).m_171514_(12, 22).m_171488_(-2.0f, -4.0f, -4.0f, 1.0f, 1.0f, 2.0f, new CubeDeformation(0.0f)).m_171514_(6, 22).m_171488_(1.0f, -4.0f, -4.0f, 1.0f, 1.0f, 2.0f, new CubeDeformation(0.0f)).m_171514_(0, 22).m_171488_(1.0f, -1.0f, -4.0f, 1.0f, 1.0f, 2.0f, new CubeDeformation(0.0f)).m_171514_(16, 19).m_171488_(-2.0f, -1.0f, -4.0f, 1.0f, 1.0f, 2.0f, new CubeDeformation(0.0f)).m_171514_(0, 0).m_171488_(-2.5f, -10.0f, -2.5f, 5.0f, 5.0f, 5.0f, new CubeDeformation(0.0f)).m_171514_(10, 19).m_171488_(-1.0f, -2.0f, 2.0f, 2.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition bone2 = bone.m_171599_("bone2", CubeListBuilder.m_171558_().m_171514_(0, 19).m_171488_(0.0f, 0.0f, -1.0f, 3.0f, 1.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)2.5f, (float)-9.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.5236f));
        PartDefinition bone3 = bone.m_171599_("bone3", CubeListBuilder.m_171558_().m_171514_(16, 10).m_171488_(-3.0f, 0.0f, -1.0f, 3.0f, 1.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-2.5f, (float)-9.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.5236f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)32, (int)32);
    }

    public void render(EntityFurniture entity, float rotation, float partialTicks, PoseStack stack, MultiBufferSource buffer, int packedLight) {
        stack.m_85836_();
        stack.m_85841_(1.2f, 1.2f, 1.2f);
        stack.m_85845_(Vector3f.f_122225_.m_122240_(entity.getRandomRotationOffset()));
        switch (entity.getFurnitureType()) {
            case BARREL: {
                this.renderBlockModel(this.barrel, stack, buffer, packedLight);
                break;
            }
            case ANVIL: {
                this.renderBlockModel(this.anvil, stack, buffer, packedLight);
                break;
            }
            case CHEST: {
                stack.m_85841_(-1.0f, -1.0f, 1.0f);
                stack.m_85837_(0.5, (double)-1.501f, -0.5);
                this.renderModel(stack, Sheets.f_110751_.m_119194_(buffer, RenderType::m_110452_), packedLight, this.chestBottom, this.chestLid, this.chestLock);
                break;
            }
            case CHAIR: {
                this.renderModel(stack, this.simpleConsumer(buffer, TEX_CHAIR), packedLight, this.chair);
                break;
            }
            case WOOLYPLUSH: {
                this.renderModel(stack, this.simpleConsumer(buffer, TEX_WOOLY), packedLight, this.woolyPlush);
                break;
            }
            case CHIPSQUEEKPLUSH: {
                this.renderModel(stack, this.simpleConsumer(buffer, TEX_CHIPSQUEEK), packedLight, this.chipSqueekPlush);
            }
        }
        stack.m_85849_();
        super.m_7392_((Entity)entity, rotation, partialTicks, stack, buffer, packedLight);
    }

    public ResourceLocation getTextureLocation(EntityFurniture entity) {
        return null;
    }

    private void renderBlockModel(BlockState state, PoseStack stack, MultiBufferSource buffer, int packedLight) {
        stack.m_85837_(-0.5, 0.0, -0.5);
        BlockRenderDispatcher dispatcher = Minecraft.m_91087_().m_91289_();
        dispatcher.m_110912_(state, stack, buffer, packedLight, OverlayTexture.f_118083_);
    }

    private VertexConsumer simpleConsumer(MultiBufferSource buffer, ResourceLocation tex) {
        return buffer.m_6299_(RenderType.m_110452_((ResourceLocation)tex));
    }

    private void renderModel(PoseStack stack, VertexConsumer ivertexbuilder, int packedLight, ModelPart ... parts) {
        stack.m_85841_(-1.0f, -1.0f, 1.0f);
        stack.m_85837_(0.0, (double)-1.501f, 0.0);
        for (ModelPart part : parts) {
            part.m_104306_(stack, ivertexbuilder, packedLight, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        }
    }
}

