/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.client.render.projectiles;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Vector3f;
import io.github.flemmli97.runecraftory.common.entities.misc.EntityRockSpear;
import io.github.flemmli97.tenshilib.client.render.RenderUtils;
import net.minecraft.client.CameraType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;

public class RenderRockSpear
extends EntityRenderer<EntityRockSpear> {
    private static final ResourceLocation BIG = new ResourceLocation("runecraftory", "textures/entity/projectile/avenger_rock_entity.png");
    private static final ResourceLocation SMALL = new ResourceLocation("runecraftory", "textures/entity/projectile/screw_rock_entity.png");
    protected final RenderUtils.TextureBuilder textureBuilder = new RenderUtils.TextureBuilder();

    public RenderRockSpear(EntityRendererProvider.Context ctx) {
        super(ctx);
    }

    public void render(EntityRockSpear entity, float rotation, float partialTicks, PoseStack stack, MultiBufferSource buffer, int packedLight) {
        float size = entity.getRange() + 0.5f;
        float yaw = -(entity.f_19859_ + (entity.m_146908_() - entity.f_19859_) * partialTicks) - 90.0f;
        float pitch = -(entity.f_19860_ + (entity.m_146909_() - entity.f_19860_) * partialTicks);
        RenderUtils.applyYawPitch((PoseStack)stack, (float)yaw, (float)pitch);
        this.textureBuilder.setLight(packedLight);
        stack.m_85836_();
        boolean playerView = entity.m_142480_() == Minecraft.m_91087_().f_91074_ && Minecraft.m_91087_().f_91066_.m_92176_() != CameraType.THIRD_PERSON_BACK;
        float scale = Mth.m_14179_((float)partialTicks, (float)((float)entity.f_19797_ * 0.22222222f), (float)((float)(entity.f_19797_ + 1) * 0.22222222f));
        stack.m_85841_(Math.min(1.0f, scale), 1.0f, 1.0f);
        stack.m_85837_((double)size * 0.5, 0.0, 0.0);
        if (playerView) {
            stack.m_85845_(Vector3f.f_122223_.m_122240_(-90.0f));
            float height = (float)((double)(entity.bigRock() ? 2.5f : 1.5f) * Math.sin(Math.sqrt((float)entity.f_19797_ / (float)entity.livingTickMax()) * Math.PI) + (double)0.2f);
            RenderUtils.renderTexture((PoseStack)stack, (VertexConsumer)buffer.m_6299_(RenderType.m_110458_((ResourceLocation)this.getTextureLocation(entity))), (float)size, (float)height, (RenderUtils.TextureBuilder)this.textureBuilder);
        } else {
            stack.m_85845_(Vector3f.f_122223_.m_122240_(45.0f));
            float height = (float)((double)(entity.bigRock() ? 2.5f : 1.5f) * Math.sin(Math.sqrt((float)entity.f_19797_ / (float)entity.livingTickMax()) * Math.PI) + (double)0.2f);
            RenderUtils.renderTexture((PoseStack)stack, (VertexConsumer)buffer.m_6299_(RenderType.m_110458_((ResourceLocation)this.getTextureLocation(entity))), (float)size, (float)height, (RenderUtils.TextureBuilder)this.textureBuilder);
            stack.m_85845_(Vector3f.f_122223_.m_122240_(90.0f));
            RenderUtils.renderTexture((PoseStack)stack, (VertexConsumer)buffer.m_6299_(RenderType.m_110458_((ResourceLocation)this.getTextureLocation(entity))), (float)size, (float)height, (RenderUtils.TextureBuilder)this.textureBuilder);
        }
        stack.m_85849_();
        super.m_7392_((Entity)entity, rotation, partialTicks, stack, buffer, packedLight);
    }

    public ResourceLocation getTextureLocation(EntityRockSpear entity) {
        return entity.bigRock() ? BIG : SMALL;
    }
}

