/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.client.tooltips;

import com.google.common.base.Suppliers;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import io.github.flemmli97.runecraftory.api.enums.EnumElement;
import io.github.flemmli97.runecraftory.common.registry.ModItems;
import io.github.flemmli97.runecraftory.common.utils.ItemNBT;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class UpgradeTooltipComponent
implements ClientTooltipComponent {
    private static final Supplier<ItemStack> MAGNIFYING_GLASS = Suppliers.memoize(() -> new ItemStack((ItemLike)ModItems.GLASS.get()));
    private static final Supplier<ItemStack> SCRAP_PLUS = Suppliers.memoize(() -> new ItemStack((ItemLike)ModItems.SCRAP_PLUS.get()));
    private static final Supplier<ItemStack> QUESTION = Suppliers.memoize(() -> new ItemStack((ItemLike)ModItems.UNKNOWN.get()));
    private final List<ItemStack> stacks = new ArrayList<ItemStack>();

    public UpgradeTooltipComponent(UpgradeComponent comp) {
        ItemStack originItem;
        EnumElement element;
        ItemStack stack = comp.stack;
        if (ItemNBT.isWeapon(stack) && (element = ItemNBT.getElement(stack)) != EnumElement.NONE) {
            this.stacks.add(element.icon.get());
        }
        if (ItemNBT.doesFixedOneDamage(stack)) {
            this.stacks.add(SCRAP_PLUS.get());
        }
        if (ItemNBT.isInvis(stack)) {
            this.stacks.add(QUESTION.get());
        }
        if (ItemNBT.canBeUsedAsMagnifyingGlass(stack) && stack.m_41720_() != ModItems.GLASS.get()) {
            this.stacks.add(MAGNIFYING_GLASS.get());
        }
        if (!this.stacks.isEmpty()) {
            this.stacks.add(ItemStack.f_41583_);
        }
        if (!(originItem = ItemNBT.getOriginItem(stack)).m_41619_()) {
            this.stacks.add(originItem);
        }
    }

    public static boolean shouldAdd(ItemStack stack) {
        return ItemNBT.canBeUsedAsMagnifyingGlass(stack) && stack.m_41720_() != ModItems.GLASS.get() || ItemNBT.isWeapon(stack) && ItemNBT.getElement(stack) != EnumElement.NONE || ItemNBT.doesFixedOneDamage(stack) || ItemNBT.isInvis(stack) || !ItemNBT.getOriginItem(stack).m_41619_();
    }

    public int m_142103_() {
        return 16;
    }

    public int m_142069_(Font font) {
        return this.stacks.size() * 16 + 2;
    }

    public void m_183452_(Font font, int mouseX, int mouseY, PoseStack poseStack, ItemRenderer itemRenderer, int blitOffset) {
        if (this.stacks.isEmpty()) {
            return;
        }
        PoseStack modelViewStack = RenderSystem.m_157191_();
        modelViewStack.m_85836_();
        float scale = 0.8f;
        modelViewStack.m_85841_(scale, scale, 1.0f);
        int x = (int)((float)mouseX / scale);
        int y = (int)((float)mouseY / scale);
        for (ItemStack stack : this.stacks) {
            if (!stack.m_41619_()) {
                this.renderItem(stack, itemRenderer, x, y);
            }
            x += 16;
        }
        modelViewStack.m_85849_();
        RenderSystem.m_157182_();
    }

    private void renderItem(ItemStack stack, ItemRenderer renderer, int x, int y) {
        renderer.m_115203_(stack, x, y);
    }

    public record UpgradeComponent(ItemStack stack) implements TooltipComponent
    {
    }
}

