/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.advancements;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import net.minecraft.advancements.critereon.AbstractCriterionTriggerInstance;
import net.minecraft.advancements.critereon.DeserializationContext;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.SerializationContext;
import net.minecraft.advancements.critereon.SimpleCriterionTrigger;
import net.minecraft.advancements.critereon.StatePropertiesPredicate;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.TagKey;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class CropHarvestTrigger
extends SimpleCriterionTrigger<TriggerInstance> {
    public static final ResourceLocation ID = new ResourceLocation("runecraftory", "crop_harvest");

    protected TriggerInstance createInstance(JsonObject json, EntityPredicate.Composite player, DeserializationContext context) {
        Block block;
        TagKey tag = null;
        if (json.has("tag")) {
            tag = TagKey.m_203882_((ResourceKey)Registry.f_122901_, (ResourceLocation)new ResourceLocation(GsonHelper.m_13906_((JsonObject)json, (String)"tag")));
        }
        StatePropertiesPredicate state = StatePropertiesPredicate.m_67679_((JsonElement)json.get("state"));
        if (json.has("block")) {
            ResourceLocation resourceLocation = new ResourceLocation(GsonHelper.m_13906_((JsonObject)json, (String)"block"));
            block = (Block)Registry.f_122824_.m_6612_(resourceLocation).orElseThrow(() -> new JsonSyntaxException("Unknown block type '" + String.valueOf(resourceLocation) + "'"));
            state.m_67672_(block.m_49965_(), string -> {
                throw new JsonSyntaxException("Block " + String.valueOf(block) + " has no property " + string);
            });
        } else {
            block = null;
        }
        return new TriggerInstance(player, block, (TagKey<Block>)tag, state);
    }

    public void trigger(ServerPlayer player, BlockState state) {
        this.m_66234_(player, inst -> inst.matches(state));
    }

    public ResourceLocation m_7295_() {
        return ID;
    }

    public static class TriggerInstance
    extends AbstractCriterionTriggerInstance {
        @Nullable
        private final Block block;
        @Nullable
        private final TagKey<Block> tag;
        private final StatePropertiesPredicate state;

        public TriggerInstance(EntityPredicate.Composite composite, @Nullable Block block, @Nullable TagKey<Block> tag, StatePropertiesPredicate state) {
            super(ID, composite);
            this.block = block;
            this.tag = tag;
            this.state = state;
        }

        public static TriggerInstance harvest(TagKey<Block> tag) {
            return new TriggerInstance(EntityPredicate.Composite.f_36667_, null, tag, StatePropertiesPredicate.f_67658_);
        }

        public static TriggerInstance harvest(TagKey<Block> tag, StatePropertiesPredicate.Builder builder) {
            return new TriggerInstance(EntityPredicate.Composite.f_36667_, null, tag, builder.m_67706_());
        }

        public static TriggerInstance harvest(Block block, StatePropertiesPredicate.Builder builder) {
            return new TriggerInstance(EntityPredicate.Composite.f_36667_, block, null, builder.m_67706_());
        }

        public boolean matches(BlockState state) {
            CropBlock crop;
            Block block = state.m_60734_();
            if (!(block instanceof CropBlock) || !(crop = (CropBlock)block).m_52307_(state)) {
                return false;
            }
            if (this.tag != null && !state.m_204336_(this.tag)) {
                return false;
            }
            if (this.block != null && !state.m_60713_(this.block)) {
                return false;
            }
            return this.state.m_67667_(state);
        }

        public JsonObject m_7683_(SerializationContext context) {
            JsonObject obj = super.m_7683_(context);
            if (this.tag != null) {
                obj.addProperty("tag", this.tag.f_203868_().toString());
            }
            if (this.block != null) {
                obj.addProperty("block", Registry.f_122824_.m_7981_((Object)this.block).toString());
            }
            obj.add("state", this.state.m_67666_());
            return obj;
        }
    }
}

