/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.advancements;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.github.flemmli97.runecraftory.common.attachment.player.PlayerData;
import net.minecraft.advancements.critereon.AbstractCriterionTriggerInstance;
import net.minecraft.advancements.critereon.DeserializationContext;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.SerializationContext;
import net.minecraft.advancements.critereon.SimpleCriterionTrigger;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;

public class ShippingTrigger
extends SimpleCriterionTrigger<TriggerInstance> {
    public static final ResourceLocation ID = new ResourceLocation("runecraftory", "shipping");

    protected TriggerInstance createInstance(JsonObject json, EntityPredicate.Composite player, DeserializationContext context) {
        ItemPredicate itemPredicate = ItemPredicate.m_45051_((JsonElement)json.get("item"));
        return new TriggerInstance(player, itemPredicate, GsonHelper.m_13824_((JsonObject)json, (String)"amount", (int)1));
    }

    public void trigger(ServerPlayer player, PlayerData data, ItemStack stack) {
        this.m_66234_(player, inst -> inst.matches(data, stack));
    }

    public ResourceLocation m_7295_() {
        return ID;
    }

    public static class TriggerInstance
    extends AbstractCriterionTriggerInstance {
        private final ItemPredicate itemPredicate;
        private final int amount;

        public TriggerInstance(EntityPredicate.Composite composite, ItemPredicate itemPredicate, int amount) {
            super(ID, composite);
            this.itemPredicate = itemPredicate;
            this.amount = amount;
        }

        public static TriggerInstance shipAny(int amount) {
            return new TriggerInstance(EntityPredicate.Composite.f_36667_, ItemPredicate.f_45028_, amount);
        }

        public static TriggerInstance shipSpecific(ItemPredicate.Builder item, int amount) {
            return new TriggerInstance(EntityPredicate.Composite.f_36667_, item.m_45077_(), 1);
        }

        public boolean matches(PlayerData data, ItemStack stack) {
            if (this.itemPredicate != null && this.itemPredicate != ItemPredicate.f_45028_) {
                if (!this.itemPredicate.m_45049_(stack)) {
                    return false;
                }
                PlayerData.ShippedItemData shipped = data.shippedItemData(stack);
                return shipped != null && shipped.amount() >= this.amount;
            }
            return data.getShippedTypesAmount() >= this.amount;
        }

        public JsonObject m_7683_(SerializationContext context) {
            JsonObject obj = super.m_7683_(context);
            obj.add("item", this.itemPredicate.m_45048_());
            obj.addProperty("amount", (Number)this.amount);
            return obj;
        }
    }
}

