/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.advancements;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.github.flemmli97.runecraftory.common.entities.npc.EntityNPCBase;
import net.minecraft.advancements.critereon.AbstractCriterionTriggerInstance;
import net.minecraft.advancements.critereon.DeserializationContext;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.SerializationContext;
import net.minecraft.advancements.critereon.SimpleCriterionTrigger;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;

public class ShopTrigger
extends SimpleCriterionTrigger<TriggerInstance> {
    public static final ResourceLocation ID = new ResourceLocation("runecraftory", "shop_buy");

    protected TriggerInstance createInstance(JsonObject json, EntityPredicate.Composite player, DeserializationContext context) {
        EntityPredicate.Composite target = EntityPredicate.Composite.m_36677_((JsonObject)json, (String)"npc", (DeserializationContext)context);
        ItemPredicate itemPredicate = ItemPredicate.m_45051_((JsonElement)json.get("item"));
        return new TriggerInstance(player, target, itemPredicate);
    }

    public void trigger(ServerPlayer player, EntityNPCBase npc, ItemStack stack) {
        LootContext lootContext = EntityPredicate.m_36616_((ServerPlayer)player, (Entity)npc);
        this.m_66234_(player, inst -> inst.matches(lootContext, stack));
    }

    public ResourceLocation m_7295_() {
        return ID;
    }

    public static class TriggerInstance
    extends AbstractCriterionTriggerInstance {
        private final EntityPredicate.Composite target;
        private final ItemPredicate itemPredicate;

        public TriggerInstance(EntityPredicate.Composite composite, EntityPredicate.Composite target, ItemPredicate itemPredicate) {
            super(ID, composite);
            this.target = target;
            this.itemPredicate = itemPredicate;
        }

        public static TriggerInstance buyAny() {
            return new TriggerInstance(EntityPredicate.Composite.f_36667_, EntityPredicate.Composite.f_36667_, ItemPredicate.f_45028_);
        }

        public static TriggerInstance buyFromItem(EntityPredicate.Builder npc, ItemPredicate.Builder item) {
            return new TriggerInstance(EntityPredicate.Composite.f_36667_, EntityPredicate.Composite.m_36673_((EntityPredicate)npc.m_36662_()), item.m_45077_());
        }

        public boolean matches(LootContext context, ItemStack stack) {
            if (!this.target.m_36681_(context)) {
                return false;
            }
            return this.itemPredicate.m_45049_(stack);
        }

        public JsonObject m_7683_(SerializationContext context) {
            JsonObject obj = super.m_7683_(context);
            obj.add("item", this.itemPredicate.m_45048_());
            obj.add("npc", this.target.m_36675_(context));
            return obj;
        }
    }
}

