/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.advancements;

import com.google.gson.JsonObject;
import io.github.flemmli97.runecraftory.RuneCraftory;
import io.github.flemmli97.runecraftory.api.enums.EnumSkills;
import io.github.flemmli97.runecraftory.platform.Platform;
import net.minecraft.advancements.critereon.AbstractCriterionTriggerInstance;
import net.minecraft.advancements.critereon.DeserializationContext;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.SerializationContext;
import net.minecraft.advancements.critereon.SimpleCriterionTrigger;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.player.Player;

public class SkillLevelTrigger
extends SimpleCriterionTrigger<TriggerInstance> {
    public static final ResourceLocation ID = new ResourceLocation("runecraftory", "skill_level_trigger");

    protected TriggerInstance createInstance(JsonObject json, EntityPredicate.Composite player, DeserializationContext context) {
        String s = GsonHelper.m_13851_((JsonObject)json, (String)"skill", (String)"*");
        EnumSkills skill = null;
        if (!s.equals("*")) {
            try {
                skill = EnumSkills.valueOf(s);
            }
            catch (IllegalArgumentException e) {
                RuneCraftory.LOGGER.error("Error with skill level trigger. No such skill {}", (Object)s);
            }
        }
        return new TriggerInstance(player, GsonHelper.m_13824_((JsonObject)json, (String)"level", (int)1), skill);
    }

    public void trigger(ServerPlayer player, EnumSkills skill) {
        this.m_66234_(player, inst -> inst.matches(player, skill));
    }

    public ResourceLocation m_7295_() {
        return ID;
    }

    public static class TriggerInstance
    extends AbstractCriterionTriggerInstance {
        private final int level;
        private final EnumSkills skill;

        public TriggerInstance(EntityPredicate.Composite composite, int amount, EnumSkills skill) {
            super(ID, composite);
            this.level = Math.max(1, amount);
            this.skill = skill;
        }

        public static TriggerInstance of(int amount) {
            return new TriggerInstance(EntityPredicate.Composite.f_36667_, amount, null);
        }

        public static TriggerInstance of(int amount, EnumSkills skill) {
            return new TriggerInstance(EntityPredicate.Composite.f_36667_, amount, skill);
        }

        public boolean matches(ServerPlayer player, EnumSkills skill) {
            return Platform.INSTANCE.getPlayerData((Player)player).map(d -> (this.skill == null || skill == this.skill) && d.getSkillLevel(skill).getLevel() >= this.level).orElse(false);
        }

        public JsonObject m_7683_(SerializationContext context) {
            JsonObject obj = super.m_7683_(context);
            obj.addProperty("level", (Number)this.level);
            obj.addProperty("skill", this.skill == null ? "*" : this.skill.name());
            return obj;
        }
    }
}

