/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.advancements;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.github.flemmli97.runecraftory.common.attachment.player.EntityStatsTracker;
import io.github.flemmli97.runecraftory.common.entities.BaseMonster;
import io.github.flemmli97.runecraftory.common.lib.RunecraftoryTags;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.critereon.AbstractCriterionTriggerInstance;
import net.minecraft.advancements.critereon.DeserializationContext;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.SerializationContext;
import net.minecraft.advancements.critereon.SimpleCriterionTrigger;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.Entity;

public class TameMonsterTrigger
extends SimpleCriterionTrigger<TriggerInstance> {
    public static final ResourceLocation ID = new ResourceLocation("runecraftory", "tame_monster");

    protected TriggerInstance createInstance(JsonObject json, EntityPredicate.Composite player, DeserializationContext context) {
        return new TriggerInstance(player, EntityPredicate.m_36614_((JsonElement)json.get("entity")), GsonHelper.m_13824_((JsonObject)json, (String)"amount", (int)1), GsonHelper.m_13855_((JsonObject)json, (String)"bosses", (boolean)false));
    }

    public void trigger(ServerPlayer player, BaseMonster monster, EntityStatsTracker tracker) {
        this.m_66234_(player, inst -> inst.matches(player, monster, tracker));
    }

    public ResourceLocation m_7295_() {
        return ID;
    }

    public static class TriggerInstance
    extends AbstractCriterionTriggerInstance {
        private final int amount;
        private final boolean bossOnly;
        private final EntityPredicate entityPredicate;

        public TriggerInstance(EntityPredicate.Composite playerPredicate, EntityPredicate entityPredicate, int amount, boolean bossOnly) {
            super(ID, playerPredicate);
            this.amount = amount;
            this.bossOnly = bossOnly;
            this.entityPredicate = entityPredicate;
        }

        public static TriggerInstance of(int amount) {
            return new TriggerInstance(EntityPredicate.Composite.f_36667_, EntityPredicate.f_36550_, amount, false);
        }

        public static Advancement.Builder amountOfSteps(Advancement.Builder builder, String key, int amount, boolean boss) {
            for (int i = 0; i < amount; ++i) {
                builder.m_138386_(key + "_" + i, (CriterionTriggerInstance)(boss ? TriggerInstance.bossOf(i + 1) : TriggerInstance.of(i + 1)));
            }
            return builder;
        }

        public static TriggerInstance bossOf(int amount) {
            return new TriggerInstance(EntityPredicate.Composite.f_36667_, EntityPredicate.f_36550_, amount, true);
        }

        public boolean matches(ServerPlayer player, BaseMonster monster, EntityStatsTracker tracker) {
            if (this.entityPredicate != null && this.entityPredicate != EntityPredicate.f_36550_) {
                if (!this.entityPredicate.m_36611_(player, (Entity)monster)) {
                    return false;
                }
                return tracker.getTameCount(monster.m_6095_()) >= this.amount;
            }
            if (this.bossOnly) {
                if (!monster.m_6095_().m_204039_(RunecraftoryTags.BOSS_MONSTERS)) {
                    return false;
                }
                return tracker.getTotalTameCount(true) >= this.amount;
            }
            return tracker.getTotalTameCount(false) >= this.amount;
        }

        public JsonObject m_7683_(SerializationContext context) {
            JsonObject obj = super.m_7683_(context);
            obj.addProperty("amount", (Number)this.amount);
            obj.addProperty("bosses", Boolean.valueOf(this.bossOnly));
            obj.add("entity", this.entityPredicate.m_36606_());
            return obj;
        }
    }
}

