/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.attachment;

import io.github.flemmli97.runecraftory.api.datapack.ItemStat;
import io.github.flemmli97.runecraftory.api.registry.ArmorEffect;
import io.github.flemmli97.runecraftory.common.datapack.DataPackHandler;
import io.github.flemmli97.runecraftory.common.registry.ModArmorEffects;
import java.util.function.Consumer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;

public class ArmorEffectData {
    private final ArmorEffect[] effect = new ArmorEffect[3];
    private int appendingIndex;

    public void triggerEvent(ItemStack stack, Consumer<ArmorEffect> consumer) {
        if (this.effect[0] == null) {
            ArmorEffect defaultEffect = DataPackHandler.INSTANCE.itemStatManager().get(stack.m_41720_()).map(ItemStat::getArmorEffect).orElse(null);
            if (defaultEffect != null && defaultEffect.canBeAppliedTo(stack)) {
                consumer.accept(defaultEffect);
            }
        } else {
            for (ArmorEffect eff : this.effect) {
                if (eff == null) continue;
                consumer.accept(eff);
            }
        }
    }

    public void setArmorEffects(ArmorEffect first, ArmorEffect second, ArmorEffect third) {
        this.effect[0] = first;
        this.effect[1] = second;
        this.effect[2] = third;
    }

    public void addArmorEffects(ArmorEffect effect) {
        if (effect != null) {
            this.effect[this.appendingIndex] = effect;
            this.appendingIndex = (this.appendingIndex + 1) % 3;
        }
    }

    public void readFromNBT(CompoundTag nbt) {
        if (nbt.m_128441_("FirstEffect")) {
            this.effect[0] = (ArmorEffect)((Object)ModArmorEffects.ARMOR_EFFECT_REGISTRY.get().getFromId(new ResourceLocation(nbt.m_128461_("FirstEffect"))));
        }
        if (nbt.m_128441_("SecondEffect")) {
            this.effect[1] = (ArmorEffect)((Object)ModArmorEffects.ARMOR_EFFECT_REGISTRY.get().getFromId(new ResourceLocation(nbt.m_128461_("SecondEffect"))));
        }
        if (nbt.m_128441_("ThirdEffect")) {
            this.effect[2] = (ArmorEffect)((Object)ModArmorEffects.ARMOR_EFFECT_REGISTRY.get().getFromId(new ResourceLocation(nbt.m_128461_("ThirdEffect"))));
        }
        this.appendingIndex = nbt.m_128451_("Index");
    }

    public CompoundTag writeToNBT(CompoundTag nbt) {
        if (this.effect[0] != null) {
            nbt.m_128359_("FirstEffect", this.effect[0].getRegistryName().toString());
        }
        if (this.effect[1] != null) {
            nbt.m_128359_("SecondEffect", this.effect[1].getRegistryName().toString());
        }
        if (this.effect[2] != null) {
            nbt.m_128359_("ThirdEffect", this.effect[2].getRegistryName().toString());
        }
        nbt.m_128405_("Index", this.appendingIndex);
        return nbt;
    }
}

